/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.FluxSink;

final class LargeMessageSlicer
implements CoreSubscriber<ByteBuf> {
    private final ByteBufAllocator allocator;
    private final FluxSink<ByteBuf> sink;
    private int nowBytes = 0;
    private List<ByteBuf> now = null;

    LargeMessageSlicer(ByteBufAllocator allocator, FluxSink<ByteBuf> sink) {
        this.allocator = allocator;
        this.sink = sink;
    }

    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public void onNext(ByteBuf buf) {
        if (!buf.isReadable()) {
            buf.release();
            return;
        }
        if (this.now == null) {
            this.onNullNext(buf);
        } else {
            int needBytes = 0xFFFFFF - this.nowBytes;
            if (buf.readableBytes() < needBytes) {
                this.nowBytes += buf.readableBytes();
                this.now.add(buf);
            } else {
                this.now.add(buf.readRetainedSlice(needBytes));
                this.sink.next((Object)this.mergeNow());
                this.now = null;
                this.nowBytes = 0;
                this.onNullNext(buf);
            }
        }
    }

    public void onError(Throwable cause) {
        try {
            this.sink.error(cause);
        }
        finally {
            this.releaseNow();
        }
    }

    public void onComplete() {
        try {
            if (this.now == null) {
                this.sink.next((Object)this.allocator.buffer(0, 0));
            } else {
                this.sink.next((Object)this.mergeNow());
                this.now = null;
            }
            this.sink.complete();
        }
        finally {
            this.releaseNow();
        }
    }

    private void releaseNow() {
        if (this.now != null) {
            int size = this.now.size();
            for (int i = 0; i < size; ++i) {
                ReferenceCountUtil.safeRelease((Object)this.now.get(i));
            }
        }
    }

    private ByteBuf mergeNow() {
        int i;
        int size = this.now.size();
        if (size == 1) {
            return this.now.get(0);
        }
        CompositeByteBuf result = this.allocator.compositeBuffer(size);
        try {
            for (i = 0; i < size; ++i) {
                result.addComponent(true, this.now.get(i));
            }
            return result;
        }
        catch (Throwable e) {
            ReferenceCountUtil.safeRelease((Object)result);
            while (i < size) {
                ReferenceCountUtil.safeRelease((Object)this.now.get(i));
                ++i;
            }
            throw e;
        }
    }

    private void onNullNext(ByteBuf buf) {
        while (buf.readableBytes() >= 0xFFFFFF) {
            this.sink.next((Object)buf.readRetainedSlice(0xFFFFFF));
        }
        if (buf.isReadable()) {
            this.now = new ArrayList<ByteBuf>();
            this.nowBytes = buf.readableBytes();
            this.now.add(buf);
        } else {
            buf.release();
        }
    }
}

