/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import dev.miku.r2dbc.mysql.util.OperatorUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class ParameterWriter {
    private static final String COMMA = ",";
    private static final int SECONDS_OF_MINUTE = 60;
    private static final int SECONDS_OF_HOUR = 3600;
    private static final int SECONDS_OF_DAY = 86400;
    private static final int MIN_CAPACITY = 256;
    private final ByteBufAllocator allocator;
    private final List<ByteBuf> buffers;

    private ParameterWriter(ByteBuf buf) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        this.buffers = new ArrayList<ByteBuf>();
        this.buffers.add(buf);
        this.allocator = buf.alloc();
    }

    public void writeBoolean(boolean value) {
        this.writableBuffer(1).writeBoolean(value);
    }

    public void writeByte(byte value) {
        this.writableBuffer(1).writeByte((int)value);
    }

    public void writeShort(short value) {
        this.writableBuffer(2).writeShortLE((int)value);
    }

    public void writeInt(int value) {
        this.writableBuffer(4).writeIntLE(value);
    }

    public void writeLong(long value) {
        this.writableBuffer(8).writeLongLE(value);
    }

    public void writeFloat(float value) {
        this.writableBuffer(4).writeFloatLE(value);
    }

    public void writeDouble(double value) {
        this.writableBuffer(8).writeDoubleLE(value);
    }

    public void writeDate(LocalDate date) {
        this.writableBuffer(5).writeByte(4).writeShortLE(date.getYear()).writeByte(date.getMonthValue()).writeByte(date.getDayOfMonth());
    }

    public void writeDateTime(LocalDateTime dateTime) {
        LocalTime time = dateTime.toLocalTime();
        if (LocalTime.MIDNIGHT.equals(time)) {
            this.writeDate(dateTime.toLocalDate());
        } else {
            int nano = time.getNano();
            int bytes = nano > 0 ? 11 : 7;
            ByteBuf buf = this.writableBuffer(1 + bytes);
            buf.writeByte(bytes).writeShortLE(dateTime.getYear()).writeByte(dateTime.getMonthValue()).writeByte(dateTime.getDayOfMonth()).writeByte(time.getHour()).writeByte(time.getMinute()).writeByte(time.getSecond());
            if (nano > 0) {
                buf.writeIntLE((int)TimeUnit.NANOSECONDS.toMicros(nano));
            }
        }
    }

    public void writeDuration(Duration duration) {
        long seconds = duration.getSeconds();
        long nanos = duration.getNano();
        if (nanos <= 0L) {
            this.writeSeconds(seconds);
        } else {
            this.writeSecondNanos(seconds, nanos);
        }
    }

    public void writeTime(LocalTime time) {
        long hour = time.getHour();
        long minute = time.getMinute();
        long second = time.getSecond();
        long nanos = time.getNano();
        long totalSeconds = TimeUnit.HOURS.toSeconds(hour) + TimeUnit.MINUTES.toSeconds(minute) + second;
        if (nanos <= 0L) {
            this.writeSeconds(totalSeconds);
        } else {
            this.writeSecondNanos(totalSeconds, nanos);
        }
    }

    public void writeAsciiString(CharSequence sequence) {
        int bytes = sequence.length();
        ByteBuf buf = this.writableBuffer(CodecUtils.varIntBytes(bytes) + bytes);
        CodecUtils.writeVarInt(buf, bytes);
        buf.writeCharSequence(sequence, StandardCharsets.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCharSequence(CharSequence sequence, CharCollation collation) {
        int maxVarIntBytes;
        int minBytes = sequence.length();
        if (minBytes <= 0) {
            this.writableBuffer(1).writeByte(0);
            return;
        }
        long maxBytes = (long)sequence.length() * (long)collation.getByteSize();
        int minVarIntBytes = CodecUtils.varIntBytes(minBytes);
        if (minVarIntBytes == (maxVarIntBytes = CodecUtils.varIntBytes(maxBytes))) {
            ByteBuf varIntBuf = this.writableBuffer(maxVarIntBytes);
            int varIntWriter = varIntBuf.writerIndex();
            varIntBuf.writeZero(maxVarIntBytes);
            if (maxBytes > Integer.MAX_VALUE) {
                List<CharSequence> sliced = ParameterWriter.slicedSequence(sequence, Integer.MAX_VALUE / collation.getByteSize());
                long writtenBytes = this.writeOnlySliced(sliced, collation);
                CodecUtils.setVarInt(varIntBuf, varIntWriter, writtenBytes);
            } else {
                Charset charset = collation.getCharset();
                int writtenBytes = this.writableBuffer((int)maxBytes).writeCharSequence(sequence, charset);
                CodecUtils.setVarInt(varIntBuf, varIntWriter, writtenBytes);
            }
        } else if (maxBytes > Integer.MAX_VALUE) {
            List<CharSequence> sliced = ParameterWriter.slicedSequence(sequence, Integer.MAX_VALUE / collation.getByteSize());
            this.writeCopySlicedWithSize(sliced, collation);
        } else {
            Charset charset = collation.getCharset();
            ByteBuf strBuf = this.allocator.buffer(minBytes);
            try {
                int writtenBytes = strBuf.writeCharSequence(sequence, charset);
                ByteBuf varIntBuf = this.writableBuffer(CodecUtils.varIntBytes(writtenBytes));
                CodecUtils.writeVarInt(varIntBuf, writtenBytes);
                this.writableBuffer(writtenBytes).writeBytes(strBuf);
            }
            finally {
                strBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCharSequences(List<CharSequence> sequences, CharCollation collation) {
        int maxVarIntBytes;
        long minBytes = 0L;
        for (CharSequence sequence : sequences) {
            minBytes += (long)sequence.length();
        }
        if (minBytes <= 0L) {
            this.writableBuffer(1).writeByte(0);
            return;
        }
        long maxBytes = Math.multiplyExact(minBytes, (long)collation.getByteSize());
        int minVarIntBytes = CodecUtils.varIntBytes(minBytes);
        if (minVarIntBytes == (maxVarIntBytes = CodecUtils.varIntBytes(maxBytes))) {
            ByteBuf varIntBuf = this.writableBuffer(maxVarIntBytes);
            int varIntWriter = varIntBuf.writerIndex();
            varIntBuf.writeZero(maxVarIntBytes);
            if (maxBytes > Integer.MAX_VALUE) {
                int eachSize = Integer.MAX_VALUE / collation.getByteSize();
                ArrayList<CharSequence> sliced = new ArrayList<CharSequence>(sequences.size());
                for (CharSequence sequence : sequences) {
                    ParameterWriter.slicedSequenceTo(sliced, sequence, eachSize);
                }
                long writtenBytes = this.writeOnlySliced(sliced, collation);
                CodecUtils.setVarInt(varIntBuf, varIntWriter, writtenBytes);
            } else {
                Charset charset = collation.getCharset();
                ByteBuf buffer = this.writableBuffer((int)maxBytes);
                int writtenBytes = 0;
                for (CharSequence sequence : sequences) {
                    writtenBytes += buffer.writeCharSequence(sequence, charset);
                }
                CodecUtils.setVarInt(varIntBuf, varIntWriter, writtenBytes);
            }
        } else if (maxBytes > Integer.MAX_VALUE) {
            int eachSize = Integer.MAX_VALUE / collation.getByteSize();
            ArrayList<CharSequence> sliced = new ArrayList<CharSequence>(sequences.size());
            for (CharSequence sequence : sequences) {
                ParameterWriter.slicedSequenceTo(sliced, sequence, eachSize);
            }
            this.writeCopySlicedWithSize(sliced, collation);
        } else {
            int writtenBytes = 0;
            Charset charset = collation.getCharset();
            ByteBuf strBuf = this.allocator.buffer((int)minBytes);
            try {
                for (CharSequence sequence : sequences) {
                    writtenBytes += strBuf.writeCharSequence(sequence, charset);
                }
                ByteBuf varIntBuf = this.writableBuffer(CodecUtils.varIntBytes(writtenBytes));
                CodecUtils.writeVarInt(varIntBuf, writtenBytes);
                this.writableBuffer(writtenBytes).writeBytes(strBuf);
            }
            finally {
                strBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSet(List<CharSequence> elements, CharCollation collation) {
        int maxVarIntBytes;
        if (elements.isEmpty()) {
            this.writableBuffer(1).writeByte(0);
            return;
        }
        int size = elements.size();
        int byteSize = collation.getByteSize();
        long minBytes = elements.get(0).length();
        for (int i = 1; i < size; ++i) {
            minBytes += 1L + (long)elements.get(i).length();
        }
        long maxBytes = minBytes * (long)byteSize;
        int minVarIntBytes = CodecUtils.varIntBytes(minBytes);
        if (minVarIntBytes == (maxVarIntBytes = CodecUtils.varIntBytes(maxBytes))) {
            ByteBuf varIntBuf = this.writableBuffer(maxVarIntBytes);
            int varIntWriter = varIntBuf.writerIndex();
            varIntBuf.writeZero(maxVarIntBytes);
            if (maxBytes > Integer.MAX_VALUE) {
                List<CharSequence> sliced = ParameterWriter.slicedSet(elements, collation);
                long writtenBytes = this.writeOnlySliced(sliced, collation);
                CodecUtils.setVarInt(varIntBuf, varIntWriter, writtenBytes);
            } else {
                Charset charset = collation.getCharset();
                ByteBuf buffer = this.writableBuffer((int)maxBytes);
                int writtenBytes = buffer.writeCharSequence(elements.get(0), charset);
                for (int i = 1; i < size; ++i) {
                    writtenBytes += buffer.writeCharSequence((CharSequence)COMMA, charset);
                    writtenBytes += buffer.writeCharSequence(elements.get(i), charset);
                }
                CodecUtils.setVarInt(varIntBuf, varIntWriter, writtenBytes);
            }
        } else if (maxBytes > Integer.MAX_VALUE) {
            this.writeCopySlicedWithSize(ParameterWriter.slicedSet(elements, collation), collation);
        } else {
            Charset charset = collation.getCharset();
            ByteBuf strBuf = this.allocator.buffer((int)minBytes);
            try {
                int writtenBytes = strBuf.writeCharSequence(elements.get(0), charset);
                for (int i = 1; i < size; ++i) {
                    writtenBytes += strBuf.writeCharSequence((CharSequence)COMMA, charset);
                    writtenBytes += strBuf.writeCharSequence(elements.get(i), charset);
                }
                ByteBuf varIntBuf = this.writableBuffer(CodecUtils.varIntBytes(writtenBytes));
                CodecUtils.writeVarInt(varIntBuf, writtenBytes);
                this.writableBuffer(writtenBytes).writeBytes(strBuf);
            }
            finally {
                strBuf.release();
            }
        }
    }

    public void writeByteArray(byte[] bytes) {
        int bufferBytes = bytes.length;
        if (bufferBytes <= 0) {
            this.writableBuffer(1).writeByte(0);
        } else {
            int varIntBytes = CodecUtils.varIntBytes(bufferBytes);
            if (bufferBytes > Integer.MAX_VALUE - varIntBytes) {
                CodecUtils.writeVarInt(this.writableBuffer(varIntBytes), bufferBytes);
                this.writableBuffer(bufferBytes).writeBytes(bytes);
            } else {
                ByteBuf buf = this.writableBuffer(varIntBytes + bufferBytes);
                CodecUtils.writeVarInt(buf, bufferBytes);
                buf.writeBytes(bytes);
            }
        }
    }

    public void writeByteBuffer(ByteBuffer buffer) {
        int bufferBytes = buffer.remaining();
        if (bufferBytes <= 0) {
            this.writableBuffer(1).writeByte(0);
            return;
        }
        int varIntBytes = CodecUtils.varIntBytes(bufferBytes);
        if (bufferBytes > Integer.MAX_VALUE - varIntBytes) {
            CodecUtils.writeVarInt(this.writableBuffer(varIntBytes), bufferBytes);
            this.writableBuffer(buffer.remaining()).writeBytes(buffer);
        } else {
            ByteBuf buf = this.writableBuffer(bufferBytes + varIntBytes);
            CodecUtils.writeVarInt(buf, bufferBytes);
            buf.writeBytes(buffer);
        }
    }

    public void writeByteBuffers(List<ByteBuffer> buffers) {
        long bufferBytes = 0L;
        for (ByteBuffer buffer : buffers) {
            if (!buffer.hasRemaining()) continue;
            bufferBytes += (long)buffer.remaining();
        }
        if (bufferBytes <= 0L) {
            this.writableBuffer(1).writeByte(0);
            return;
        }
        int varIntBytes = CodecUtils.varIntBytes(bufferBytes);
        long totalBytes = (long)varIntBytes + bufferBytes;
        if (totalBytes > Integer.MAX_VALUE) {
            CodecUtils.writeVarInt(this.writableBuffer(varIntBytes), bufferBytes);
            for (ByteBuffer buffer : buffers) {
                if (!buffer.hasRemaining()) continue;
                this.writableBuffer(buffer.remaining()).writeBytes(buffer);
            }
        } else {
            ByteBuf buf = this.writableBuffer((int)totalBytes);
            CodecUtils.writeVarInt(buf, bufferBytes);
            for (ByteBuffer buffer : buffers) {
                if (!buffer.hasRemaining()) continue;
                buf.writeBytes(buffer);
            }
        }
    }

    private void dispose() {
        for (ByteBuf buffer : this.buffers) {
            ReferenceCountUtil.safeRelease((Object)buffer);
        }
    }

    private Publisher<ByteBuf> allBuffers() {
        return Flux.defer(() -> {
            if (this.buffers.size() == 1) {
                return Flux.just((Object)this.buffers.get(0));
            }
            return Flux.fromIterable(this.buffers);
        });
    }

    private ByteBuf writableBuffer(int bytes) {
        ByteBuf buf = this.buffers.get(this.buffers.size() - 1);
        if (buf.maxWritableBytes() < bytes) {
            buf = this.allocator.buffer(Math.max(bytes, 256));
            this.buffers.add(buf);
        }
        return buf;
    }

    private void writeSecondNanos(long seconds, long nanos) {
        boolean isNegative;
        if (seconds < 0L) {
            isNegative = true;
            seconds = -(seconds + 1L);
            nanos = TimeUnit.SECONDS.toNanos(1L) - nanos;
        } else {
            isNegative = false;
        }
        ByteBuf buf = this.writableBuffer(13).writeByte(12);
        ParameterWriter.writeSeconds0(buf, isNegative, seconds).writeIntLE((int)TimeUnit.NANOSECONDS.toMicros(nanos));
    }

    private void writeSeconds(long seconds) {
        boolean isNegative;
        if (seconds == 0L) {
            this.writableBuffer(1).writeByte(0);
            return;
        }
        if (seconds < 0L) {
            seconds = -seconds;
            isNegative = true;
        } else {
            isNegative = false;
        }
        ByteBuf buf = this.writableBuffer(9).writeByte(8);
        ParameterWriter.writeSeconds0(buf, isNegative, seconds);
    }

    private long writeOnlySliced(List<CharSequence> sliced, CharCollation collation) {
        Charset charset = collation.getCharset();
        int byteSize = collation.getByteSize();
        long writtenBytes = 0L;
        for (CharSequence slice : sliced) {
            writtenBytes += (long)this.writableBuffer(slice.length() * byteSize).writeCharSequence(slice, charset);
        }
        return writtenBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCopySlicedWithSize(List<CharSequence> sliced, CharCollation collation) {
        EncodedBuffers encoded = this.encodeSliced(sliced, collation);
        try {
            long writtenBytes = encoded.totalBytes;
            ByteBuf varIntBuf = this.writableBuffer(CodecUtils.varIntBytes(writtenBytes));
            CodecUtils.writeVarInt(varIntBuf, writtenBytes);
            for (ByteBuf strBuf : encoded.buffers) {
                this.writableBuffer(strBuf.readableBytes()).writeBytes(strBuf);
            }
        }
        finally {
            for (ByteBuf strBuf : encoded.buffers) {
                if (strBuf == null) continue;
                ReferenceCountUtil.safeRelease((Object)strBuf);
            }
        }
    }

    private EncodedBuffers encodeSliced(List<CharSequence> sliced, CharCollation collation) {
        Charset charset = collation.getCharset();
        int size = sliced.size();
        ByteBuf[] buffers = new ByteBuf[size];
        long written = 0L;
        try {
            for (int i = 0; i < size; ++i) {
                CharSequence slice = sliced.get(i);
                buffers[i] = this.allocator.buffer(slice.length());
                written += (long)buffers[i].writeCharSequence(slice, charset);
            }
            return new EncodedBuffers(written, buffers);
        }
        catch (Throwable e) {
            for (int i = 0; i < size; ++i) {
                if (buffers[i] == null) continue;
                ReferenceCountUtil.safeRelease((Object)buffers[i]);
            }
            throw e;
        }
    }

    static Publisher<ByteBuf> publish(ByteBuf prefix, ParameterValue[] values) {
        ParameterWriter writer = new ParameterWriter(prefix);
        return OperatorUtils.discardOnCancel(Flux.fromArray((Object[])values)).doOnDiscard(ParameterValue.class, ParameterValue.DISPOSE).concatMap(param -> param.writeTo(writer)).doOnError(ignored -> writer.dispose()).thenMany(writer.allBuffers());
    }

    private static ByteBuf writeSeconds0(ByteBuf buf, boolean isNegative, long seconds) {
        return buf.writeBoolean(isNegative).writeIntLE((int)(seconds / 86400L)).writeByte((int)(seconds % 86400L / 3600L)).writeByte((int)(seconds % 3600L / 60L)).writeByte((int)(seconds % 60L));
    }

    private static List<CharSequence> slicedSequence(CharSequence sequence, int eachSize) {
        int length = sequence.length();
        if (length <= 0) {
            return Collections.emptyList();
        }
        if (length <= eachSize) {
            return Collections.singletonList(sequence);
        }
        int r = length / eachSize;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>(r * eachSize == length ? r : r + 1);
        ParameterWriter.slicedSequenceTo0(result, sequence, eachSize, length);
        return result;
    }

    private static List<CharSequence> slicedSet(List<CharSequence> elements, CharCollation collation) {
        int size = elements.size();
        if (size <= 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(elements.get(0));
        }
        int eachLength = Integer.MAX_VALUE / collation.getByteSize();
        ArrayList<CharSequence> sliced = new ArrayList<CharSequence>((size << 1) - 1);
        ParameterWriter.slicedSequenceTo(sliced, elements.get(0), eachLength);
        for (int i = 1; i < size; ++i) {
            sliced.add(COMMA);
            ParameterWriter.slicedSequenceTo(sliced, elements.get(i), eachLength);
        }
        return sliced;
    }

    private static void slicedSequenceTo(List<CharSequence> result, CharSequence sequence, int eachSize) {
        int length = sequence.length();
        if (length <= 0) {
            return;
        }
        if (length <= eachSize) {
            result.add(sequence);
            return;
        }
        ParameterWriter.slicedSequenceTo0(result, sequence, eachSize, length);
    }

    private static void slicedSequenceTo0(List<CharSequence> result, CharSequence sequence, int eachSize, int length) {
        int read = 0;
        while (read < length) {
            int endIndex = read + eachSize;
            if (endIndex > length || endIndex <= read) {
                endIndex = length;
            }
            result.add(sequence.subSequence(read, endIndex));
            read = endIndex;
        }
    }

    private static final class EncodedBuffers {
        private final long totalBytes;
        private final ByteBuf[] buffers;

        private EncodedBuffers(long totalBytes, ByteBuf[] buffers) {
            this.totalBytes = totalBytes;
            this.buffers = buffers;
        }
    }
}

