/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.ExchangeableMessage;
import dev.miku.r2dbc.mysql.message.client.LargeClientMessage;
import dev.miku.r2dbc.mysql.message.client.ParameterWriter;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public final class PreparedExecuteMessage
extends LargeClientMessage
implements ExchangeableMessage,
Disposable {
    private static final int NO_PARAM_SIZE = 10;
    private static final int TIMES = 1;
    private static final byte EXECUTE_FLAG = 23;
    private final int statementId;
    private final boolean immediate;
    private final ParameterValue[] values;

    public PreparedExecuteMessage(int statementId, boolean immediate, ParameterValue[] values) {
        this.values = AssertUtils.requireNonNull(values, "values must not be null");
        this.statementId = statementId;
        this.immediate = immediate;
    }

    public void dispose() {
        for (ParameterValue value : this.values) {
            value.dispose();
        }
        Arrays.fill(this.values, null);
    }

    public String toString() {
        return String.format("PreparedExecuteMessage{statementId=%d, immediate=%b, has %d parameters}", this.statementId, this.immediate, this.values.length);
    }

    @Override
    protected Publisher<ByteBuf> fragments(ByteBufAllocator allocator, ConnectionContext context) {
        int size = this.values.length;
        ByteBuf buf = size == 0 ? allocator.buffer(10, 10) : allocator.buffer();
        try {
            buf.writeByte(23).writeIntLE(this.statementId).writeByte(this.immediate ? 0 : 1).writeIntLE(1);
            if (size == 0) {
                return Mono.just((Object)buf);
            }
            ArrayList<ParameterValue> nonNull = new ArrayList<ParameterValue>(size);
            byte[] nullMap = this.fillNullBitmap(size, nonNull);
            buf.writeBytes(nullMap);
            if (nonNull.isEmpty()) {
                buf.writeBoolean(false);
                return Mono.just((Object)buf);
            }
            buf.writeBoolean(true);
            this.writeTypes(buf, size);
            return ParameterWriter.publish(buf, this.values);
        }
        catch (Throwable e) {
            buf.release();
            this.cancelParameters();
            return Mono.error((Throwable)e);
        }
    }

    private byte[] fillNullBitmap(int size, List<ParameterValue> nonNull) {
        byte[] nullMap = new byte[PreparedExecuteMessage.ceilDiv8(size)];
        for (int i = 0; i < size; ++i) {
            ParameterValue value = this.values[i];
            if (value.isNull()) {
                int n = i >> 3;
                nullMap[n] = (byte)(nullMap[n] | 1 << (i & 7));
                continue;
            }
            nonNull.add(value);
        }
        return nullMap;
    }

    private void writeTypes(ByteBuf buf, int size) {
        for (int i = 0; i < size; ++i) {
            buf.writeShortLE((int)this.values[i].getType());
        }
    }

    private void cancelParameters() {
        for (ParameterValue value : this.values) {
            value.dispose();
        }
    }

    private static int ceilDiv8(int x) {
        int r = x >> 3;
        return r << 3 == x ? r : r + 1;
    }
}

