/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;

public final class AuthMoreDataMessage
implements ServerMessage {
    private final byte[] authMethodData;

    private AuthMoreDataMessage(byte[] authMethodData) {
        this.authMethodData = AssertUtils.requireNonNull(authMethodData, "authMethodData must not be null");
    }

    public byte[] getAuthMethodData() {
        return this.authMethodData;
    }

    static AuthMoreDataMessage decode(ByteBuf buf) {
        buf.skipBytes(1);
        return new AuthMoreDataMessage(ByteBufUtil.getBytes((ByteBuf)buf));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthMoreDataMessage)) {
            return false;
        }
        AuthMoreDataMessage that = (AuthMoreDataMessage)o;
        return Arrays.equals(this.authMethodData, that.authMethodData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.authMethodData);
    }

    public String toString() {
        return String.format("AuthMoreDataMessage{authMethodData=%s}", Arrays.toString(this.authMethodData));
    }
}

