/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class ChangeAuthMessage
implements ServerMessage {
    private final String authType;
    private final byte[] salt;

    private ChangeAuthMessage(String authType, byte[] salt) {
        this.authType = AssertUtils.requireNonNull(authType, "authType must not be null");
        this.salt = AssertUtils.requireNonNull(salt, "salt must not be null");
    }

    public String getAuthType() {
        return this.authType;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeAuthMessage)) {
            return false;
        }
        ChangeAuthMessage that = (ChangeAuthMessage)o;
        if (!this.authType.equals(that.authType)) {
            return false;
        }
        return Arrays.equals(this.salt, that.salt);
    }

    public int hashCode() {
        int result = this.authType.hashCode();
        result = 31 * result + Arrays.hashCode(this.salt);
        return result;
    }

    public String toString() {
        return String.format("ChangeAuthMessage{authType=%s, salt=REDACTED}", this.authType);
    }

    static ChangeAuthMessage decode(ByteBuf buf) {
        buf.skipBytes(1);
        String authType = CodecUtils.readCString(buf, StandardCharsets.US_ASCII);
        int bytes = buf.readableBytes();
        if (bytes > 0 && buf.getByte(buf.writerIndex() - 1) == 0) {
            return new ChangeAuthMessage(authType, ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)(bytes - 1)));
        }
        return new ChangeAuthMessage(authType, ByteBufUtil.getBytes((ByteBuf)buf));
    }
}

