/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.LargeFieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.message.server.FieldReader;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.CodecUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;

final class LargeFieldReader
extends AbstractReferenceCounted
implements FieldReader {
    private final ByteBuf[] buffers;
    private int currentBufIndex = 0;

    LargeFieldReader(ByteBuf[] buffers) {
        this.buffers = buffers;
    }

    @Override
    public short getUnsignedByte() {
        ByteBuf buf = this.nonEmptyBuffer();
        return buf.getUnsignedByte(buf.readerIndex());
    }

    @Override
    public void skipOneByte() {
        this.nonEmptyBuffer().skipBytes(1);
    }

    @Override
    public byte[] readSizeFixedBytes(int length) {
        AssertUtils.require(length > 0, "length must be a positive integer");
        ByteBuf buf = this.nonEmptyBuffer();
        if (buf.readableBytes() >= length) {
            return ByteBufUtil.getBytes((ByteBuf)buf.readSlice(length));
        }
        return this.readBytes(buf, length);
    }

    @Override
    public FieldValue readSizeFixedField(int length) {
        AssertUtils.require(length > 0, "length must be a positive integer");
        ByteBuf buf = this.nonEmptyBuffer();
        if (buf.readableBytes() >= length) {
            return new NormalFieldValue(buf.readRetainedSlice(length));
        }
        return new NormalFieldValue(LargeFieldReader.retainedMerge(buf.alloc(), this.readSlice(buf, length)));
    }

    @Override
    public FieldValue readVarIntSizedField() {
        long fieldSize;
        ByteBuf currentBuf = this.nonEmptyBuffer();
        if (CodecUtils.checkNextVarInt(currentBuf) < 0) {
            ByteBuf nextBuf = this.buffers[this.currentBufIndex + 1];
            fieldSize = CodecUtils.crossReadVarInt(currentBuf, nextBuf);
            ++this.currentBufIndex;
        } else {
            fieldSize = CodecUtils.readVarInt(currentBuf);
        }
        currentBuf = this.nonEmptyBuffer();
        List<ByteBuf> results = this.readSlice(currentBuf, fieldSize);
        if (fieldSize <= Integer.MAX_VALUE) {
            return new NormalFieldValue(LargeFieldReader.retainedMerge(currentBuf.alloc(), results));
        }
        return LargeFieldReader.retainedLargeField(results);
    }

    public LargeFieldReader touch(Object hint) {
        for (ByteBuf buffer : this.buffers) {
            buffer.touch(hint);
        }
        return this;
    }

    protected void deallocate() {
        for (ByteBuf buffer : this.buffers) {
            ReferenceCountUtil.safeRelease((Object)buffer);
        }
    }

    private List<ByteBuf> readSlice(ByteBuf buf, long length) {
        long totalSize;
        int bufReadable;
        ArrayList<ByteBuf> results = new ArrayList<ByteBuf>(Math.max((int)Math.min(length / 0xFFFFFFL + 2L, 127L), 10));
        for (totalSize = 0L; totalSize <= length - (long)(bufReadable = buf.readableBytes()); totalSize += (long)bufReadable) {
            results.add(buf);
            buf = this.buffers[++this.currentBufIndex];
        }
        if (length > totalSize) {
            results.add(buf.readSlice((int)(length - totalSize)));
        }
        return results;
    }

    private byte[] readBytes(ByteBuf buf, int length) {
        int resultSize;
        int bufReadable;
        byte[] result = new byte[length];
        for (resultSize = 0; resultSize <= length - (bufReadable = buf.readableBytes()); resultSize += bufReadable) {
            buf.readBytes(result, resultSize, bufReadable);
            buf = this.buffers[++this.currentBufIndex];
        }
        if (length > resultSize) {
            buf.readBytes(result, resultSize, length - resultSize);
        }
        return result;
    }

    private ByteBuf nonEmptyBuffer() {
        ByteBuf buf = this.buffers[this.currentBufIndex];
        while (!buf.isReadable()) {
            buf = this.buffers[++this.currentBufIndex];
        }
        return buf;
    }

    private static FieldValue retainedLargeField(List<ByteBuf> parts) {
        int successSentinel = 0;
        int size = parts.size();
        try {
            for (int i = 0; i < size; ++i) {
                parts.get(i).retain();
                successSentinel = i + 1;
            }
            return new LargeFieldValue(parts);
        }
        catch (Throwable e) {
            if (successSentinel < size) {
                for (int i = 0; i < successSentinel; ++i) {
                    ReferenceCountUtil.safeRelease((Object)parts.get(i));
                }
            }
            throw e;
        }
    }

    private static ByteBuf retainedMerge(ByteBufAllocator allocator, List<ByteBuf> parts) {
        int successSentinel = 0;
        int size = parts.size();
        CompositeByteBuf byteBuf = allocator.compositeBuffer(size);
        try {
            for (int i = 0; i < size; ++i) {
                parts.get(i).retain();
                successSentinel = i + 1;
            }
            return byteBuf.addComponents(true, parts);
        }
        catch (Throwable e) {
            ReferenceCountUtil.safeRelease((Object)byteBuf);
            if (successSentinel < size) {
                for (int i = 0; i < successSentinel; ++i) {
                    ReferenceCountUtil.safeRelease((Object)parts.get(i));
                }
            }
            throw e;
        }
    }
}

