/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.message.server.MetadataDecodeContext;
import dev.miku.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import java.util.concurrent.atomic.AtomicInteger;

final class PreparedMetadataDecodeContext
extends MetadataDecodeContext {
    private final DefinitionMetadataMessage[] paramMetadata;
    private final DefinitionMetadataMessage[] colMetadata;
    private final AtomicInteger columns = new AtomicInteger();
    private volatile boolean inMetadata = true;

    PreparedMetadataDecodeContext(boolean deprecateEof, int totalColumns, int totalParameters) {
        super(deprecateEof);
        this.paramMetadata = PreparedMetadataDecodeContext.createArray(totalParameters);
        this.colMetadata = PreparedMetadataDecodeContext.createArray(totalColumns);
    }

    public String toString() {
        return "DecodeContext-PreparedMetadata";
    }

    @Override
    boolean isInMetadata() {
        return this.inMetadata;
    }

    @Override
    protected SyntheticMetadataMessage checkComplete(int index) {
        if (index == this.paramMetadata.length) {
            if (this.colMetadata.length == 0) {
                this.inMetadata = false;
                return new SyntheticMetadataMessage(true, this.paramMetadata);
            }
            return new SyntheticMetadataMessage(false, this.paramMetadata);
        }
        if (index == this.paramMetadata.length + this.colMetadata.length) {
            this.inMetadata = false;
            return new SyntheticMetadataMessage(true, this.colMetadata);
        }
        return null;
    }

    @Override
    protected int putMetadata(DefinitionMetadataMessage metadata) {
        int colSize;
        int paramSize;
        int index = this.columns.getAndIncrement();
        if (index >= (paramSize = this.paramMetadata.length) + (colSize = this.colMetadata.length)) {
            throw new IllegalStateException(String.format("columns' metadata has filled up, now index: %d, param length: %d, column length: %d", index, paramSize, colSize));
        }
        if (index < paramSize) {
            this.paramMetadata[index] = metadata;
        } else {
            this.colMetadata[index - paramSize] = metadata;
        }
        return index + 1;
    }

    @Override
    protected int currentIndex() {
        return this.columns.get();
    }

    @Override
    protected Object loggingPoints() {
        int paramSize = this.paramMetadata.length;
        return String.format("[%d, %d]", paramSize, paramSize + this.colMetadata.length);
    }

    private static DefinitionMetadataMessage[] createArray(int size) {
        return size == 0 ? SyntheticMetadataMessage.EMPTY_METADATA : new DefinitionMetadataMessage[size];
    }
}

