/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.message.server.MetadataDecodeContext;
import dev.miku.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.util.concurrent.atomic.AtomicInteger;

final class ResultDecodeContext
extends MetadataDecodeContext {
    private final DefinitionMetadataMessage[] metadataMessages;
    private final AtomicInteger columns = new AtomicInteger();
    private boolean inMetadata = true;

    ResultDecodeContext(boolean deprecateEof, int totalColumns) {
        super(deprecateEof);
        AssertUtils.require(totalColumns > 0, "result must has least 1 column");
        this.metadataMessages = new DefinitionMetadataMessage[totalColumns];
    }

    public String toString() {
        return "DecodeContext-Result";
    }

    @Override
    boolean isInMetadata() {
        return this.inMetadata;
    }

    @Override
    protected SyntheticMetadataMessage checkComplete(int index) {
        if (index == this.metadataMessages.length) {
            this.inMetadata = false;
            return new SyntheticMetadataMessage(false, this.metadataMessages);
        }
        return null;
    }

    @Override
    protected int putMetadata(DefinitionMetadataMessage metadata) {
        int size;
        int index = this.columns.getAndIncrement();
        if (index >= (size = this.metadataMessages.length)) {
            throw new IllegalStateException(String.format("columns' metadata has filled up, now index: %d, array length: %d", index, size));
        }
        this.metadataMessages[index] = metadata;
        return index + 1;
    }

    @Override
    protected int currentIndex() {
        return this.columns.get();
    }

    @Override
    protected Object loggingPoints() {
        return this.metadataMessages.length;
    }

    short getType(int index) {
        return this.metadataMessages[index].getType();
    }

    int getTotalColumns() {
        return this.metadataMessages.length;
    }
}

