/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.server.FieldReader;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;

public final class RowMessage
implements ReferenceCounted,
ServerMessage {
    private static final byte BIT_MASK_INIT = 4;
    private final FieldReader reader;

    RowMessage(FieldReader reader) {
        this.reader = AssertUtils.requireNonNull(reader, "reader must not be null");
    }

    public final FieldValue[] decode(boolean isBinary, FieldInformation[] context) {
        if (isBinary) {
            return this.binary(context);
        }
        return this.text(context.length);
    }

    private FieldValue[] text(int size) {
        FieldValue[] fields = new FieldValue[size];
        try {
            for (int i = 0; i < size; ++i) {
                if (251 == this.reader.getUnsignedByte()) {
                    this.reader.skipOneByte();
                    fields[i] = FieldValue.nullField();
                    continue;
                }
                fields[i] = this.reader.readVarIntSizedField();
            }
            return fields;
        }
        catch (Throwable e) {
            RowMessage.clearFields(fields, size);
            throw e;
        }
    }

    private FieldValue[] binary(FieldInformation[] context) {
        this.reader.skipOneByte();
        int size = context.length;
        byte[] nullBitmap = this.reader.readSizeFixedBytes(size + 9 >> 3);
        int bitmapIndex = 0;
        int bitMask = 4;
        FieldValue[] fields = new FieldValue[size];
        try {
            for (int i = 0; i < size; ++i) {
                int bytes;
                fields[i] = (nullBitmap[bitmapIndex] & bitMask) != 0 ? FieldValue.nullField() : ((bytes = RowMessage.getFixedBinaryBytes(context[i].getType())) > 0 ? this.reader.readSizeFixedField(bytes) : this.reader.readVarIntSizedField());
                if (((bitMask = (int)((byte)(bitMask << 1))) & 0xFF) != 0) continue;
                bitMask = 1;
                ++bitmapIndex;
            }
            return fields;
        }
        catch (Throwable e) {
            RowMessage.clearFields(fields, size);
            throw e;
        }
    }

    public int refCnt() {
        return this.reader.refCnt();
    }

    public RowMessage retain() {
        this.reader.retain();
        return this;
    }

    public RowMessage retain(int increment) {
        this.reader.retain(increment);
        return this;
    }

    public RowMessage touch() {
        this.reader.touch();
        return this;
    }

    public final RowMessage touch(Object o) {
        this.reader.touch(o);
        return this;
    }

    public boolean release() {
        return this.reader.release();
    }

    public boolean release(int decrement) {
        return this.reader.release(decrement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowMessage)) {
            return false;
        }
        RowMessage that = (RowMessage)o;
        return this.reader.equals(that.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    public String toString() {
        return "RowMessage(encoded)";
    }

    private static int getFixedBinaryBytes(short type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: 
            case 13: {
                return 2;
            }
            case 3: 
            case 9: {
                return 4;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 8;
            }
        }
        return 0;
    }

    private static void clearFields(FieldValue[] fields, int size) {
        for (int i = 0; i < size; ++i) {
            FieldValue field = fields[i];
            if (field == null || field.isNull()) continue;
            ReferenceCountUtil.safeRelease((Object)field);
        }
    }
}

