/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.util;

import java.util.regex.Pattern;

public final class AddressUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.)(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private static final Pattern IPV6_COMPRESSED_PATTERN = Pattern.compile("^(([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){0,5})?)::(([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){0,5})?)$");
    private static final int IPV6_COLONS = 7;

    private AddressUtils() {
    }

    public static boolean isIpv4(String host) {
        return IPV4_PATTERN.matcher(host).matches();
    }

    public static boolean isIpv6(String host) {
        return IPV6_PATTERN.matcher(host).matches() || AddressUtils.isIpv6Compressed(host);
    }

    private static boolean isIpv6Compressed(String host) {
        int length = host.length();
        int colons = 0;
        for (int i = 0; i < length; ++i) {
            if (host.charAt(i) != ':') continue;
            ++colons;
        }
        return colons <= 7 && IPV6_COMPRESSED_PATTERN.matcher(host).matches();
    }
}

