/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.util;

import dev.miku.r2dbc.mysql.util.DiscardOnCancelConditionalSubscriber;
import dev.miku.r2dbc.mysql.util.DiscardOnCancelFuseableConditionalSubscriber;
import dev.miku.r2dbc.mysql.util.DiscardOnCancelFuseableSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

class DiscardOnCancelSubscriber<T, S extends Subscription, A extends CoreSubscriber<? super T>>
extends AtomicInteger
implements CoreSubscriber<T>,
Scannable,
Subscription {
    private static final int TERMINATED = 2;
    private static final int CANCELLED = 1;
    final A actual;
    final Context ctx;
    S s;

    DiscardOnCancelSubscriber(A actual) {
        this.actual = actual;
        this.ctx = actual.currentContext();
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.s, (Subscription)s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(T t) {
        if (this.get() == 0) {
            this.actual.onNext(t);
        } else {
            Operators.onDiscard(t, (Context)this.ctx);
        }
    }

    public void onError(Throwable t) {
        if (this.compareAndSet(0, 2)) {
            this.actual.onError(t);
        } else {
            Operators.onErrorDropped((Throwable)t, (Context)this.ctx);
        }
    }

    public void onComplete() {
        if (this.compareAndSet(0, 2)) {
            this.actual.onComplete();
        }
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        if (this.compareAndSet(0, 1)) {
            this.s.request(Long.MAX_VALUE);
        }
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        if (key == Scannable.Attr.ACTUAL) {
            return this.actual;
        }
        if (key == Scannable.Attr.TERMINATED) {
            return this.get() == 2;
        }
        if (key == Scannable.Attr.CANCELLED) {
            return this.get() == 1;
        }
        return null;
    }

    static <T> CoreSubscriber<T> create(CoreSubscriber<? super T> s, boolean fuseable) {
        if (fuseable) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                return new DiscardOnCancelFuseableConditionalSubscriber((Fuseable.ConditionalSubscriber)s);
            }
            return new DiscardOnCancelFuseableSubscriber(s);
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            return new DiscardOnCancelConditionalSubscriber((Fuseable.ConditionalSubscriber)s);
        }
        return new DiscardOnCancelSubscriber(s);
    }
}

