/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.util;

import dev.miku.r2dbc.mysql.util.FluxDiscardOnCancel;
import dev.miku.r2dbc.mysql.util.FluxDiscardOnCancelFuseable;
import java.util.Iterator;
import reactor.core.Fuseable;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;

public final class OperatorUtils {
    public static <T> Flux<T> discardOnCancel(Flux<? extends T> source) {
        if (source instanceof Fuseable) {
            return new FluxDiscardOnCancelFuseable<T>(source);
        }
        return new FluxDiscardOnCancel<T>(source);
    }

    public static <T> void emitIterator(EmitterProcessor<T> processor, Iterator<T> iterator) {
        if (processor.isCancelled() || processor.isTerminated()) {
            return;
        }
        try {
            if (iterator.hasNext()) {
                processor.onNext(iterator.next());
            } else {
                processor.onComplete();
            }
        }
        catch (Throwable e) {
            processor.onError(e);
        }
    }

    private OperatorUtils() {
    }
}

