/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.message.server.CompleteMessage;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.SynchronousSink;

abstract class BaseHandler
implements BiConsumer<ServerMessage, SynchronousSink<ServerMessage>>,
Predicate<ServerMessage> {
    protected final EmitterProcessor<ClientMessage> requests;

    protected BaseHandler(EmitterProcessor<ClientMessage> requests) {
        this.requests = requests;
    }

    @Override
    public final boolean test(ServerMessage message) {
        if (message instanceof ErrorMessage) {
            return true;
        }
        if (!(message instanceof CompleteMessage) || !((CompleteMessage)message).isDone()) {
            return false;
        }
        if (!this.requests.isTerminated() && this.hasNext()) {
            this.requests.onNext((Object)this.nextMessage());
            return false;
        }
        return true;
    }

    protected abstract boolean hasNext();

    protected abstract ClientMessage nextMessage();
}

