/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ColumnNameSet;
import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.MySqlNames;
import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.r2dbc.spi.RowMetadata;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

final class MySqlRowMetadata
implements RowMetadata {
    private static final Comparator<MySqlColumnMetadata> NAME_COMPARATOR = (left, right) -> MySqlNames.compare(left.getName(), right.getName());
    private final MySqlColumnMetadata[] idSorted;
    private final MySqlColumnMetadata[] nameSorted;
    private final String[] names;
    private final ColumnNameSet nameSet;

    private MySqlRowMetadata(MySqlColumnMetadata[] idSorted) {
        int size = idSorted.length;
        if (size <= 0) {
            throw new IllegalArgumentException("least 1 column metadata");
        }
        MySqlColumnMetadata[] nameSorted = new MySqlColumnMetadata[size];
        System.arraycopy(idSorted, 0, nameSorted, 0, size);
        Arrays.sort(nameSorted, NAME_COMPARATOR);
        this.idSorted = idSorted;
        this.nameSorted = nameSorted;
        this.names = MySqlRowMetadata.getNames(nameSorted);
        this.nameSet = new ColumnNameSet(this.names);
    }

    public MySqlColumnMetadata getColumnMetadata(int index) {
        if (index < 0 || index >= this.idSorted.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("column index %d is invalid, total %d", index, this.idSorted.length));
        }
        return this.idSorted[index];
    }

    public MySqlColumnMetadata getColumnMetadata(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        int index = MySqlNames.nameSearch(this.names, name);
        if (index < 0) {
            throw new NoSuchElementException(String.format("column name '%s' does not exist in %s", name, Arrays.toString(this.names)));
        }
        return this.nameSorted[index];
    }

    public List<MySqlColumnMetadata> getColumnMetadatas() {
        return InternalArrays.asImmutableList(this.idSorted);
    }

    public Set<String> getColumnNames() {
        return this.nameSet;
    }

    public String toString() {
        return String.format("MySqlRowMetadata{metadata=%s, sortedNames=%s}", Arrays.toString(this.idSorted), this.nameSet);
    }

    MySqlColumnMetadata[] unwrap() {
        return this.idSorted;
    }

    static MySqlRowMetadata create(DefinitionMetadataMessage[] columns) {
        int size = columns.length;
        MySqlColumnMetadata[] metadata = new MySqlColumnMetadata[size];
        for (int i = 0; i < size; ++i) {
            metadata[i] = MySqlColumnMetadata.create(i, columns[i]);
        }
        return new MySqlRowMetadata(metadata);
    }

    private static String[] getNames(MySqlColumnMetadata[] metadata) {
        int size = metadata.length;
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = metadata[i].getName();
        }
        return names;
    }
}

