/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Source;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

final class SourceSpec {
    private final ConnectionFactoryOptions options;
    private final Option<?> option;

    SourceSpec(ConnectionFactoryOptions options, Option<?> option) {
        this.options = options;
        this.option = option;
    }

    <T> Source<T> asInstance(Class<T> type) {
        Object value = this.options.getValue(this.option);
        if (value == null) {
            return Source.nilSource();
        }
        if (type.isInstance(value)) {
            return new Source.Impl<T>(type.cast(value));
        }
        if (value instanceof String) {
            try {
                Class<?> implementation = Class.forName((String)value);
                if (type.isAssignableFrom(implementation)) {
                    return new Source.Impl<T>(type.cast(implementation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot instantiate '" + value + "'", e);
            }
        }
        throw new IllegalArgumentException(SourceSpec.toMessage(this.option, value, type.getName()));
    }

    <T> Source<T> asInstance(Class<T> type, Function<String, T> mapping) {
        Object value = this.options.getValue(this.option);
        if (value == null) {
            return Source.nilSource();
        }
        if (type.isInstance(value)) {
            return new Source.Impl<T>(type.cast(value));
        }
        if (value instanceof String) {
            return new Source.Impl<T>(type.cast(mapping.apply((String)value)));
        }
        throw new IllegalArgumentException(SourceSpec.toMessage(this.option, value, type.getTypeName()));
    }

    Source<String[]> asStrings() {
        Object value = this.options.getValue(this.option);
        if (value == null) {
            return Source.nilSource();
        }
        if (value instanceof String[]) {
            return new Source.Impl<String[]>((String[])value);
        }
        if (value instanceof String) {
            return new Source.Impl<String[]>(((String)value).split(","));
        }
        if (value instanceof Collection) {
            return new Source.Impl<A[]>(((Collection)value).stream().map(String.class::cast).toArray(String[]::new));
        }
        throw new IllegalArgumentException(SourceSpec.toMessage(this.option, value, "String[]"));
    }

    Source<Boolean> asBoolean() {
        Object value = this.options.getValue(this.option);
        if (value == null) {
            return Source.nilSource();
        }
        if (value instanceof Boolean) {
            return new Source.Impl<Boolean>((Boolean)value);
        }
        if (value instanceof String) {
            return new Source.Impl<Boolean>(Boolean.parseBoolean((String)value));
        }
        throw new IllegalArgumentException(SourceSpec.toMessage(this.option, value, "Boolean"));
    }

    Source<Integer> asInt() {
        Object value = this.options.getValue(this.option);
        if (value == null) {
            return Source.nilSource();
        }
        if (value instanceof Integer) {
            return new Source.Impl<Integer>((Integer)value);
        }
        if (value instanceof Number) {
            return new Source.Impl<Integer>(((Number)value).intValue());
        }
        if (value instanceof String) {
            return new Source.Impl<Integer>(Integer.parseInt((String)value));
        }
        throw new IllegalArgumentException(SourceSpec.toMessage(this.option, value, "Integer"));
    }

    Source<String> asString() {
        Object value = this.options.getValue(this.option);
        if (value == null) {
            return Source.nilSource();
        }
        if (value instanceof String) {
            return new Source.Impl<String>((String)value);
        }
        throw new IllegalArgumentException(SourceSpec.toMessage(this.option, value, "String"));
    }

    void servePrepare(Consumer<Boolean> enables, Consumer<Predicate<String>> preferred) {
        Object value = this.options.getValue(this.option);
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            enables.accept((Boolean)value);
            return;
        }
        if (value instanceof Predicate) {
            preferred.accept((Predicate)value);
            return;
        }
        if (value instanceof String) {
            String serverPreparing = (String)value;
            if ("true".equalsIgnoreCase(serverPreparing) || "false".equalsIgnoreCase(serverPreparing)) {
                enables.accept(Boolean.parseBoolean(serverPreparing));
                return;
            }
            try {
                Class<?> implementation = Class.forName(serverPreparing);
                if (Predicate.class.isAssignableFrom(implementation)) {
                    preferred.accept((Predicate)implementation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    return;
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot instantiate '" + value + "'", e);
            }
        }
        throw new IllegalArgumentException(SourceSpec.toMessage(this.option, value, "Boolean or Predicate<String>"));
    }

    private static String toMessage(Option<?> option, Object value, String type) {
        return "Cannot convert value " + value + " of " + value.getClass() + " as " + type + " for option " + option.name();
    }
}

