/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ParameterIndex;
import dev.miku.r2dbc.mysql.Query;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class TextQuery
extends Query {
    private final Map<String, ParameterIndex> nameKeyedIndex;
    private final List<String> sqlParts;

    TextQuery(Map<String, ParameterIndex> nameKeyedIndex, List<String> sqlParts) {
        AssertUtils.requireNonNull(nameKeyedIndex, "named parameter map must not be null");
        AssertUtils.requireNonNull(sqlParts, "sql parts must not be null");
        AssertUtils.require(sqlParts.size() > 1, "sql parts need least 2 parts");
        this.nameKeyedIndex = nameKeyedIndex;
        this.sqlParts = sqlParts;
    }

    @Override
    int getParameters() {
        return this.sqlParts.size() - 1;
    }

    @Override
    ParameterIndex getIndexes(String identifier) {
        ParameterIndex index = this.nameKeyedIndex.get(identifier);
        if (index == null) {
            throw new IllegalArgumentException(String.format("No such parameter with identifier '%s'", identifier));
        }
        return index;
    }

    Set<String> getParameterNames() {
        return this.nameKeyedIndex.keySet();
    }

    List<String> getSqlParts() {
        return this.sqlParts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextQuery)) {
            return false;
        }
        TextQuery textQuery = (TextQuery)o;
        if (!this.nameKeyedIndex.equals(textQuery.nameKeyedIndex)) {
            return false;
        }
        return this.sqlParts.equals(textQuery.sqlParts);
    }

    public int hashCode() {
        return 31 * this.nameKeyedIndex.hashCode() + this.sqlParts.hashCode();
    }

    public String toString() {
        return String.format("TextQuery{nameKeyedIndex=%s, sqlParts=%s}", this.nameKeyedIndex, this.sqlParts);
    }
}

