/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.PrimitiveCodec;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBufAllocator;

abstract class AbstractPrimitiveCodec<T>
implements PrimitiveCodec<T> {
    protected final ByteBufAllocator allocator;
    private final Class<T> primitiveClass;
    private final Class<T> boxedClass;

    AbstractPrimitiveCodec(ByteBufAllocator allocator, Class<T> primitiveClass, Class<T> boxedClass) {
        AssertUtils.require(primitiveClass.isPrimitive() && !boxedClass.isPrimitive(), "primitiveClass must be primitive and boxedClass must not be primitive");
        this.allocator = allocator;
        this.primitiveClass = primitiveClass;
        this.boxedClass = boxedClass;
    }

    @Override
    public final boolean canDecode(FieldInformation info, Class<?> target) {
        return target.isAssignableFrom(this.boxedClass) && this.doCanDecode(info);
    }

    @Override
    public final boolean canPrimitiveDecode(FieldInformation info) {
        return this.doCanDecode(info);
    }

    @Override
    public final Class<T> getPrimitiveClass() {
        return this.primitiveClass;
    }

    protected abstract boolean doCanDecode(FieldInformation var1);
}

