/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class BooleanCodec
extends AbstractPrimitiveCodec<Boolean> {
    BooleanCodec(ByteBufAllocator allocator) {
        super(allocator, Boolean.TYPE, Boolean.class);
    }

    @Override
    public Boolean decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (!binary && 1 == info.getType()) {
            return value.readByte() != 48;
        }
        return value.readBoolean();
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new BooleanParameter(this.allocator, (Boolean)value);
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        return (16 == info.getType() || 1 == info.getType()) && info.getSize() == 1L;
    }

    private static final class BooleanParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final boolean value;

        private BooleanParameter(ByteBufAllocator allocator, boolean value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> this.allocator.buffer(1).writeByte(this.value ? 1 : 0));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeBinary(this.value));
        }

        @Override
        public short getType() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanParameter)) {
                return false;
            }
            BooleanParameter that = (BooleanParameter)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }
    }
}

