/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.codec.BigDecimalCodec;
import dev.miku.r2dbc.mysql.codec.BigIntegerCodec;
import dev.miku.r2dbc.mysql.codec.BitSetCodec;
import dev.miku.r2dbc.mysql.codec.BlobCodec;
import dev.miku.r2dbc.mysql.codec.BooleanCodec;
import dev.miku.r2dbc.mysql.codec.ByteArrayCodec;
import dev.miku.r2dbc.mysql.codec.ByteBufferCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.ClobCodec;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.codec.CodecsBuilder;
import dev.miku.r2dbc.mysql.codec.DoubleCodec;
import dev.miku.r2dbc.mysql.codec.DurationCodec;
import dev.miku.r2dbc.mysql.codec.EnumCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.FloatCodec;
import dev.miku.r2dbc.mysql.codec.InstantCodec;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.codec.LocalDateCodec;
import dev.miku.r2dbc.mysql.codec.LocalDateTimeCodec;
import dev.miku.r2dbc.mysql.codec.LocalTimeCodec;
import dev.miku.r2dbc.mysql.codec.LongCodec;
import dev.miku.r2dbc.mysql.codec.MassiveCodec;
import dev.miku.r2dbc.mysql.codec.MassiveParametrizedCodec;
import dev.miku.r2dbc.mysql.codec.NullParameter;
import dev.miku.r2dbc.mysql.codec.OffsetDateTimeCodec;
import dev.miku.r2dbc.mysql.codec.OffsetTimeCodec;
import dev.miku.r2dbc.mysql.codec.ParametrizedCodec;
import dev.miku.r2dbc.mysql.codec.PrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.SetCodec;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.codec.StringCodec;
import dev.miku.r2dbc.mysql.codec.YearCodec;
import dev.miku.r2dbc.mysql.codec.ZonedDateTimeCodec;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.LargeFieldValue;
import dev.miku.r2dbc.mysql.message.NormalFieldValue;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

final class DefaultCodecs
implements Codecs {
    private final Codec<?>[] codecs;
    private final ParametrizedCodec<?>[] parametrizedCodecs;
    private final MassiveCodec<?>[] massiveCodecs;
    private final MassiveParametrizedCodec<?>[] massiveParametrizedCodecs;
    private final Map<Type, PrimitiveCodec<?>> primitiveCodecs;

    private DefaultCodecs(Codec<?>[] codecs) {
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        HashMap primitiveCodecs = new HashMap();
        ArrayList<ParametrizedCodec> parametrizedCodecs = new ArrayList<ParametrizedCodec>();
        ArrayList<MassiveCodec> massiveCodecs = new ArrayList<MassiveCodec>();
        ArrayList<MassiveParametrizedCodec> massiveParametrizedCodecs = new ArrayList<MassiveParametrizedCodec>();
        for (Codec<?> codec : codecs) {
            if (codec instanceof PrimitiveCodec) {
                PrimitiveCodec c = (PrimitiveCodec)codec;
                primitiveCodecs.put(c.getPrimitiveClass(), c);
            } else if (codec instanceof ParametrizedCodec) {
                parametrizedCodecs.add((ParametrizedCodec)codec);
            }
            if (!(codec instanceof MassiveCodec)) continue;
            massiveCodecs.add((MassiveCodec)codec);
            if (!(codec instanceof MassiveParametrizedCodec)) continue;
            massiveParametrizedCodecs.add((MassiveParametrizedCodec)codec);
        }
        this.primitiveCodecs = primitiveCodecs;
        this.massiveCodecs = massiveCodecs.toArray(new MassiveCodec[0]);
        this.massiveParametrizedCodecs = massiveParametrizedCodecs.toArray(new MassiveParametrizedCodec[0]);
        this.parametrizedCodecs = parametrizedCodecs.toArray(new ParametrizedCodec[0]);
    }

    @Override
    public <T> T decode(FieldValue value, FieldInformation info, Class<?> type, boolean binary, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(info, "info must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        Class<?> target = DefaultCodecs.chooseClass(info, type);
        if (target.isPrimitive()) {
            return this.decodePrimitive(value, info, target, binary, context);
        }
        if (value.isNull()) {
            return null;
        }
        if (value instanceof NormalFieldValue) {
            return this.decodeNormal((NormalFieldValue)value, info, target, binary, context);
        }
        if (value instanceof LargeFieldValue) {
            return this.decodeMassive((LargeFieldValue)value, info, target, binary, context);
        }
        throw new IllegalArgumentException("Unknown value " + value.getClass().getSimpleName());
    }

    @Override
    public <T> T decode(FieldValue value, FieldInformation info, ParameterizedType type, boolean binary, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(info, "info must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        if (value.isNull()) {
            return null;
        }
        if (value instanceof NormalFieldValue) {
            return this.decodeNormal((NormalFieldValue)value, info, type, binary, context);
        }
        if (value instanceof LargeFieldValue) {
            return this.decodeMassive((LargeFieldValue)value, info, type, binary, context);
        }
        throw new IllegalArgumentException("Unknown value " + value.getClass().getSimpleName());
    }

    @Override
    public <T> T decodeLastInsertId(long value, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        if (Byte.TYPE == type || Byte.class == type) {
            return (T)Byte.valueOf((byte)value);
        }
        if (Short.TYPE == type || Short.class == type) {
            return (T)Short.valueOf((short)value);
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return (T)Integer.valueOf((int)value);
        }
        if (Long.TYPE == type || Long.class == type) {
            return (T)Long.valueOf(value);
        }
        if (BigInteger.class == type) {
            if (value < 0L) {
                return (T)BigIntegerCodec.unsignedBigInteger(value);
            }
            return (T)BigInteger.valueOf(value);
        }
        if (type.isAssignableFrom(Number.class)) {
            if (value < 0L) {
                return (T)BigIntegerCodec.unsignedBigInteger(value);
            }
            return (T)Long.valueOf(value);
        }
        String message = "Cannot decode value of type '%s' with last inserted ID %s";
        message = value < 0L ? String.format(message, type, Long.toUnsignedString(value)) : String.format(message, type, value);
        throw new IllegalArgumentException(message);
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncode(value)) continue;
            return codec.encode(value, context);
        }
        throw new IllegalArgumentException(String.format("Cannot encode value of type '%s'", value.getClass()));
    }

    @Override
    public Parameter encodeNull() {
        return NullParameter.INSTANCE;
    }

    private <T> T decodePrimitive(FieldValue value, FieldInformation info, Class<?> type, boolean binary, CodecContext context) {
        if (value.isNull()) {
            throw new IllegalArgumentException(String.format("Cannot decode null for type %d", info.getType()));
        }
        PrimitiveCodec<?> codec = this.primitiveCodecs.get(type);
        if (codec != null && value instanceof NormalFieldValue && codec.canPrimitiveDecode(info)) {
            return (T)codec.decode(((NormalFieldValue)value).getBufferSlice(), info, type, binary, context);
        }
        throw new IllegalArgumentException(String.format("Cannot decode %s of %s for type %d", value.getClass().getSimpleName(), type, info.getType()));
    }

    @Nullable
    private <T> T decodeNormal(NormalFieldValue value, FieldInformation info, Class<?> type, boolean binary, CodecContext context) {
        for (Codec<?> codec : this.codecs) {
            if (!codec.canDecode(info, type)) continue;
            Codec<?> c = codec;
            return (T)c.decode(value.getBufferSlice(), info, type, binary, context);
        }
        throw new IllegalArgumentException("Cannot decode value of type " + type + " for " + info.getType() + " with collation " + info.getCollationId());
    }

    @Nullable
    private <T> T decodeNormal(NormalFieldValue value, FieldInformation info, ParameterizedType type, boolean binary, CodecContext context) {
        for (ParametrizedCodec<?> codec : this.parametrizedCodecs) {
            if (!codec.canDecode(info, type)) continue;
            Object result = codec.decode(value.getBufferSlice(), info, type, binary, context);
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot decode value of type " + type + " for " + info.getType() + " with collation " + info.getCollationId());
    }

    @Nullable
    private <T> T decodeMassive(LargeFieldValue value, FieldInformation info, Class<?> type, boolean binary, CodecContext context) {
        for (MassiveCodec<?> codec : this.massiveCodecs) {
            if (!codec.canDecode(info, type)) continue;
            MassiveCodec<?> c = codec;
            return (T)c.decodeMassive(value.getBufferSlices(), info, type, binary, context);
        }
        throw new IllegalArgumentException("Cannot decode massive value of type " + type + " for " + info.getType() + " with collation " + info.getCollationId());
    }

    @Nullable
    private <T> T decodeMassive(LargeFieldValue value, FieldInformation info, ParameterizedType type, boolean binary, CodecContext context) {
        for (MassiveParametrizedCodec<?> codec : this.massiveParametrizedCodecs) {
            if (!codec.canDecode(info, type)) continue;
            Object result = codec.decodeMassive(value.getBufferSlices(), info, type, binary, context);
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot decode massive value of type " + type + " for " + info.getType() + " with collation " + info.getCollationId());
    }

    private static Class<?> chooseClass(FieldInformation info, Class<?> type) {
        Class<?> mainType;
        if (Object.class == type && (mainType = info.getJavaType()) != null) {
            return mainType;
        }
        return type;
    }

    private static Codec<?>[] defaultCodecs(ByteBufAllocator allocator) {
        return new Codec[]{new ByteCodec(allocator), new ShortCodec(allocator), new IntegerCodec(allocator), new LongCodec(allocator), new BigIntegerCodec(allocator), new BigDecimalCodec(allocator), new FloatCodec(allocator), new DoubleCodec(allocator), new BooleanCodec(allocator), new BitSetCodec(allocator), new ZonedDateTimeCodec(allocator), new LocalDateTimeCodec(allocator), new InstantCodec(allocator), new OffsetDateTimeCodec(allocator), new LocalDateCodec(allocator), new LocalTimeCodec(allocator), new DurationCodec(allocator), new OffsetTimeCodec(allocator), new YearCodec(allocator), new StringCodec(allocator), new EnumCodec(allocator), new SetCodec(allocator), new ClobCodec(allocator), new BlobCodec(allocator), new ByteBufferCodec(allocator), new ByteArrayCodec(allocator)};
    }

    static final class Builder
    extends ArrayList<Codec<?>>
    implements CodecsBuilder {
        private final ByteBufAllocator allocator;

        Builder(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CodecsBuilder addFirst(Codec<?> codec) {
            Builder builder = this;
            synchronized (builder) {
                if (this.isEmpty()) {
                    Codec[] codecs = DefaultCodecs.defaultCodecs(this.allocator);
                    this.ensureCapacity(codecs.length + 1);
                    this.add(codec);
                    this.addAll(InternalArrays.asImmutableList(codecs));
                } else {
                    this.add(0, codec);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CodecsBuilder addLast(Codec<?> codec) {
            Builder builder = this;
            synchronized (builder) {
                if (this.isEmpty()) {
                    this.addAll(InternalArrays.asImmutableList(DefaultCodecs.defaultCodecs(this.allocator)));
                }
                this.add(codec);
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Codecs build() {
            Builder builder = this;
            synchronized (builder) {
                try {
                    if (this.isEmpty()) {
                        DefaultCodecs defaultCodecs = new DefaultCodecs(DefaultCodecs.defaultCodecs(this.allocator));
                        return defaultCodecs;
                    }
                    DefaultCodecs defaultCodecs = new DefaultCodecs(this.toArray(new Codec[0]));
                    return defaultCodecs;
                }
                finally {
                    this.clear();
                    this.trimToSize();
                }
            }
        }
    }
}

