/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.DateTimes;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.LocalDateTimeCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Instant;
import java.time.LocalDateTime;
import reactor.core.publisher.Mono;

final class InstantCodec
implements Codec<Instant> {
    private final ByteBufAllocator allocator;

    InstantCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public Instant decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        LocalDateTime origin = LocalDateTimeCodec.decodeOrigin(value, binary, context);
        if (origin == null) {
            return null;
        }
        return origin.toInstant(context.getServerZoneId().getRules().getOffset(origin));
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new InstantParameter(this.allocator, (Instant)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Instant;
    }

    @Override
    public boolean canDecode(FieldInformation info, Class<?> target) {
        return DateTimes.canDecodeDateTime(info.getType(), target, Instant.class);
    }

    private static final class InstantParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final Instant value;
        private final CodecContext context;

        private InstantParameter(ByteBufAllocator allocator, Instant value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalDateTimeCodec.encodeBinary(this.allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateTimeCodec.encodeText(writer, this.serverValue()));
        }

        @Override
        public short getType() {
            return 7;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstantParameter that = (InstantParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalDateTime serverValue() {
            return LocalDateTime.ofInstant(this.value, this.context.getServerZoneId());
        }
    }
}

