/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec.lob;

import dev.miku.r2dbc.mysql.util.OperatorUtils;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class MultiLob<T> {
    private static final Consumer<ByteBuf> RELEASE = ReferenceCounted::release;
    private final AtomicReference<List<ByteBuf>> buffers;

    MultiLob(List<ByteBuf> buffers) {
        this.buffers = new AtomicReference<List<ByteBuf>>(buffers);
    }

    public final Flux<T> stream() {
        return Flux.defer(() -> {
            List buffers = this.buffers.getAndSet(null);
            if (buffers == null) {
                return Flux.error((Throwable)new IllegalStateException("Source has been released"));
            }
            return OperatorUtils.discardOnCancel(Flux.fromIterable((Iterable)buffers)).doOnDiscard(ByteBuf.class, RELEASE).map(this::consume);
        });
    }

    public final Mono<Void> discard() {
        return Mono.fromRunnable(() -> {
            List buffers = this.buffers.getAndSet(null);
            if (buffers != null) {
                for (ByteBuf buf : buffers) {
                    ReferenceCountUtil.safeRelease((Object)buf);
                }
            }
        });
    }

    protected abstract T convert(ByteBuf var1);

    private T consume(ByteBuf buf) {
        try {
            T t = this.convert(buf);
            return t;
        }
        finally {
            buf.release();
        }
    }
}

