/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.util;

import dev.miku.r2dbc.mysql.util.DiscardOnCancelConditionalSubscriber;
import dev.miku.r2dbc.mysql.util.DiscardOnCancelFuseableConditionalSubscriber;
import dev.miku.r2dbc.mysql.util.DiscardOnCancelFuseableSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class DiscardOnCancelSubscriber<T, S extends Subscription, A extends CoreSubscriber<? super T>>
extends AtomicInteger
implements CoreSubscriber<T>,
Scannable,
Subscription {
    private static final int TERMINATED = 2;
    private static final int CANCELLED = 1;
    final A actual;
    final Context ctx;
    @Nullable
    final Runnable onDone;
    S s;

    DiscardOnCancelSubscriber(A actual, @Nullable Runnable onDone) {
        this.actual = actual;
        this.ctx = actual.currentContext();
        this.onDone = onDone;
    }

    public final void onSubscribe(Subscription s) {
        if (Operators.validate(this.s, (Subscription)s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public final void onNext(T t) {
        if (this.get() == 0) {
            this.actual.onNext(t);
        } else {
            Operators.onDiscard(t, (Context)this.ctx);
        }
    }

    public final void onError(Throwable t) {
        if (this.compareAndSet(0, 2)) {
            Runnable onDone = this.onDone;
            if (onDone != null) {
                try {
                    onDone.run();
                }
                catch (Throwable e) {
                    Operators.onErrorDropped((Throwable)e, (Context)this.ctx);
                }
            }
            this.actual.onError(t);
        } else {
            Operators.onErrorDropped((Throwable)t, (Context)this.ctx);
        }
    }

    public final void onComplete() {
        if (this.compareAndSet(0, 2)) {
            Runnable onDone = this.onDone;
            if (onDone != null) {
                try {
                    onDone.run();
                }
                catch (Throwable e) {
                    Operators.onErrorDropped((Throwable)e, (Context)this.ctx);
                }
            }
            this.actual.onComplete();
        }
    }

    public final void request(long n) {
        this.s.request(n);
    }

    public final void cancel() {
        if (this.compareAndSet(0, 1)) {
            Runnable onDone = this.onDone;
            if (onDone != null) {
                try {
                    onDone.run();
                }
                catch (Throwable e) {
                    Operators.onErrorDropped((Throwable)e, (Context)this.ctx);
                }
            }
            this.s.request(Long.MAX_VALUE);
        }
    }

    public final Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        if (key == Scannable.Attr.ACTUAL) {
            return this.actual;
        }
        if (key == Scannable.Attr.TERMINATED) {
            return this.get() == 2;
        }
        if (key == Scannable.Attr.CANCELLED) {
            return this.get() == 1;
        }
        return null;
    }

    static <T> CoreSubscriber<T> create(CoreSubscriber<? super T> s, boolean fuseable, @Nullable Runnable onDone) {
        if (fuseable) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                return new DiscardOnCancelFuseableConditionalSubscriber((Fuseable.ConditionalSubscriber)s, onDone);
            }
            return new DiscardOnCancelFuseableSubscriber(s, onDone);
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            return new DiscardOnCancelConditionalSubscriber((Fuseable.ConditionalSubscriber)s, onDone);
        }
        return new DiscardOnCancelSubscriber(s, onDone);
    }
}

