/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbMessage;
import dadb.PKCS8;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Ldadb/AdbKeyPair;", "", "privateKey", "Ljava/security/PrivateKey;", "publicKeyBytes", "", "(Ljava/security/PrivateKey;[B)V", "getPublicKeyBytes$dadb", "()[B", "signPayload", "message", "Ldadb/AdbMessage;", "signPayload$dadb", "Companion", "dadb"})
public final class AdbKeyPair {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final byte[] publicKeyBytes;
    private static final int KEY_LENGTH_BITS = 2048;
    private static final int KEY_LENGTH_BYTES = 256;
    private static final int KEY_LENGTH_WORDS = 64;
    @NotNull
    private static final byte[] SIGNATURE_PADDING;

    public AdbKeyPair(@NotNull PrivateKey privateKey, @NotNull byte[] publicKeyBytes) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKeyBytes, (String)"publicKeyBytes");
        this.privateKey = privateKey;
        this.publicKeyBytes = publicKeyBytes;
    }

    @NotNull
    public final byte[] getPublicKeyBytes$dadb() {
        return this.publicKeyBytes;
    }

    @NotNull
    public final byte[] signPayload$dadb(@NotNull AdbMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(1, this.privateKey);
        cipher.update(SIGNATURE_PADDING);
        byte[] byArray = cipher.doFinal(message.getPayload(), 0, message.getPayloadLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(message.p\u20260, message.payloadLength)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final AdbKeyPair readDefault() {
        return Companion.readDefault();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AdbKeyPair read(@NotNull File privateKeyFile, @Nullable File publicKeyFile) {
        return Companion.read(privateKeyFile, publicKeyFile);
    }

    @JvmStatic
    public static final void generate(@NotNull File privateKeyFile, @NotNull File publicKeyFile) {
        Companion.generate(privateKeyFile, publicKeyFile);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AdbKeyPair read(@NotNull File privateKeyFile) {
        return Companion.read(privateKeyFile);
    }

    static {
        byte[] byArray = new byte[]{0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
        boolean bl = false;
        byte[] byArray2 = byArray;
        boolean bl2 = false;
        byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, size)");
        SIGNATURE_PADDING = byArray3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldadb/AdbKeyPair$Companion;", "", "()V", "KEY_LENGTH_BITS", "", "KEY_LENGTH_BYTES", "KEY_LENGTH_WORDS", "SIGNATURE_PADDING", "", "convertRsaPublicKeyToAdbFormat", "pubkey", "Ljava/security/interfaces/RSAPublicKey;", "generate", "", "privateKeyFile", "Ljava/io/File;", "publicKeyFile", "read", "Ldadb/AdbKeyPair;", "readAdbPublicKey", "file", "readDefault", "dadb"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AdbKeyPair readDefault() {
            File privateKeyFile = new File(System.getProperty("user.home"), ".android/adbkey");
            File publicKeyFile = new File(System.getProperty("user.home"), ".android/adbkey.pub");
            if (!privateKeyFile.exists()) {
                this.generate(privateKeyFile, publicKeyFile);
            }
            return this.read(privateKeyFile, publicKeyFile);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AdbKeyPair read(@NotNull File privateKeyFile, @Nullable File publicKeyFile) {
            Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
            PrivateKey privateKey = PKCS8.INSTANCE.parse(FilesKt.readBytes((File)privateKeyFile));
            File file = publicKeyFile;
            byte[] publicKeyBytes = (file == null ? false : file.exists()) ? this.readAdbPublicKey(publicKeyFile) : new byte[]{};
            return new AdbKeyPair(privateKey, publicKeyBytes);
        }

        public static /* synthetic */ AdbKeyPair read$default(Companion companion, File file, File file2, int n, Object object) {
            if ((n & 2) != 0) {
                file2 = null;
            }
            return companion.read(file, file2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void generate(@NotNull File privateKeyFile, @NotNull File publicKeyFile) {
            Object object;
            boolean bl;
            Object out2;
            Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
            Intrinsics.checkNotNullParameter((Object)publicKeyFile, (String)"publicKeyFile");
            Object object2 = KeyPairGenerator.getInstance("RSA");
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object2;
            boolean bl4 = false;
            ((KeyPairGenerator)it).initialize(2048);
            KeyPair keyPair = ((KeyPairGenerator)it).genKeyPair();
            object2 = privateKeyFile.getAbsoluteFile().getParentFile();
            if (object2 != null) {
                ((File)object2).mkdirs();
            }
            object2 = publicKeyFile.getAbsoluteFile().getParentFile();
            if (object2 != null) {
                ((File)object2).mkdirs();
            }
            object2 = privateKeyFile;
            Charset charset = Charsets.UTF_8;
            bl3 = false;
            it = object2;
            bl4 = false;
            it = new FileOutputStream((File)it);
            bl4 = false;
            object2 = new OutputStreamWriter((OutputStream)it, charset);
            boolean bl5 = false;
            bl3 = false;
            Throwable throwable = null;
            try {
                out2 = (OutputStreamWriter)object2;
                bl = false;
                String string = "\n";
                object = Charsets.UTF_8;
                boolean bl6 = false;
                byte[] byArray = string.getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                Base64.Encoder base64 = Base64.getMimeEncoder(64, byArray);
                ((Writer)out2).write("-----BEGIN PRIVATE KEY-----\n");
                ((Writer)out2).write(base64.encodeToString(keyPair.getPrivate().getEncoded()));
                ((Writer)out2).write("\n-----END PRIVATE KEY-----");
                out2 = Unit.INSTANCE;
            }
            catch (Throwable out2) {
                throwable = out2;
                throw out2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
            object2 = publicKeyFile;
            Charset charset2 = Charsets.UTF_8;
            boolean bl7 = false;
            out2 = object2;
            bl = false;
            out2 = new FileOutputStream((File)out2);
            bl = false;
            object2 = new OutputStreamWriter((OutputStream)out2, charset2);
            boolean bl8 = false;
            bl7 = false;
            Throwable throwable2 = null;
            try {
                out2 = (OutputStreamWriter)object2;
                boolean bl9 = false;
                Base64.Encoder base64 = Base64.getEncoder();
                object = keyPair.getPublic();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                }
                byte[] bytes = Companion.convertRsaPublicKeyToAdbFormat((RSAPublicKey)object);
                ((Writer)out2).write(base64.encodeToString(bytes));
                ((Writer)out2).write(" unknown@unknown");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
            }
        }

        private final byte[] readAdbPublicKey(File file) {
            byte[] bytes;
            byte[] byArray = bytes = FilesKt.readBytes((File)file);
            int n = bytes.length + 1;
            boolean bl = false;
            byte[] byArray2 = Arrays.copyOf(byArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            byte[] publicKeyBytes = byArray2;
            publicKeyBytes[bytes.length] = 0;
            return publicKeyBytes;
        }

        private final byte[] convertRsaPublicKeyToAdbFormat(RSAPublicKey pubkey) {
            BigInteger r32 = null;
            BigInteger r = null;
            BigInteger rr = null;
            BigInteger rem = null;
            BigInteger n = null;
            BigInteger n0inv = null;
            BigInteger bigInteger = BigInteger.ZERO.setBit(32);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO.setBit(32)");
            r32 = bigInteger;
            bigInteger = pubkey.getModulus();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pubkey.modulus");
            n = bigInteger;
            bigInteger = BigInteger.ZERO.setBit(2048);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO.setBit(KEY_LENGTH_WORDS * 32)");
            r = bigInteger;
            bigInteger = r.modPow(BigInteger.valueOf(2L), n);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"r.modPow(BigInteger.valueOf(2), n)");
            rr = bigInteger;
            bigInteger = n.remainder(r32);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"n.remainder(r32)");
            rem = bigInteger;
            bigInteger = rem.modInverse(r32);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"rem.modInverse(r32)");
            n0inv = bigInteger;
            int[] myN = new int[64];
            int[] myRr = new int[64];
            BigInteger[] res = null;
            int n2 = 0;
            do {
                int i = n2++;
                BigInteger[] bigIntegerArray = rr.divideAndRemainder(r32);
                Intrinsics.checkNotNullExpressionValue((Object)bigIntegerArray, (String)"rr.divideAndRemainder(r32)");
                res = bigIntegerArray;
                rr = res[0];
                rem = res[1];
                myRr[i] = rem.intValue();
                bigIntegerArray = n.divideAndRemainder(r32);
                Intrinsics.checkNotNullExpressionValue((Object)bigIntegerArray, (String)"n.divideAndRemainder(r32)");
                res = bigIntegerArray;
                n = res[0];
                rem = res[1];
                myN[i] = rem.intValue();
            } while (n2 < 64);
            Object object = ByteBuffer.allocate(524).order(ByteOrder.LITTLE_ENDIAN);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allocate(524).order(ByteOrder.LITTLE_ENDIAN)");
            ByteBuffer bbuf = object;
            bbuf.putInt(64);
            bbuf.putInt(n0inv.negate().intValue());
            for (Object i : (Object)myN) {
                bbuf.putInt((int)i);
            }
            for (Object i : (Object)myRr) {
                bbuf.putInt((int)i);
            }
            bbuf.putInt(pubkey.getPublicExponent().intValue());
            object = bbuf.array();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bbuf.array()");
            return object;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AdbKeyPair read(@NotNull File privateKeyFile) {
            Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
            return dadb.AdbKeyPair$Companion.read$default(this, privateKeyFile, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

