/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbMessage;
import dadb.AdbMessageQueue;
import dadb.AdbStream;
import dadb.AdbStreamImpl;
import dadb.AdbWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Ldadb/AdbStreamImpl;", "Ldadb/AdbStream;", "messageQueue", "Ldadb/AdbMessageQueue;", "adbWriter", "Ldadb/AdbWriter;", "maxPayloadSize", "", "localId", "remoteId", "(Ldadb/AdbMessageQueue;Ldadb/AdbWriter;III)V", "isClosed", "", "sink", "Lokio/BufferedSink;", "getSink", "()Lokio/BufferedSink;", "source", "Lokio/BufferedSource;", "getSource", "()Lokio/BufferedSource;", "close", "", "nextMessage", "Ldadb/AdbMessage;", "command", "dadb"})
public final class AdbStreamImpl
implements AdbStream {
    @NotNull
    private final AdbMessageQueue messageQueue;
    @NotNull
    private final AdbWriter adbWriter;
    private final int maxPayloadSize;
    private final int localId;
    private final int remoteId;
    private boolean isClosed;
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final BufferedSink sink;

    public AdbStreamImpl(@NotNull AdbMessageQueue messageQueue, @NotNull AdbWriter adbWriter, int maxPayloadSize, int localId, int remoteId) {
        Intrinsics.checkNotNullParameter((Object)messageQueue, (String)"messageQueue");
        Intrinsics.checkNotNullParameter((Object)adbWriter, (String)"adbWriter");
        this.messageQueue = messageQueue;
        this.adbWriter = adbWriter;
        this.maxPayloadSize = maxPayloadSize;
        this.localId = localId;
        this.remoteId = remoteId;
        this.source = Okio.buffer((Source)new Source(this){
            @Nullable
            private AdbMessage message;
            private int bytesRead;
            final /* synthetic */ AdbStreamImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public long read(@NotNull Buffer sink2, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
                AdbMessage adbMessage = this.message();
                if (adbMessage == null) {
                    return -1L;
                }
                AdbMessage message = adbMessage;
                int bytesRemaining = message.getPayloadLength() - this.bytesRead;
                int bytesToRead = Math.min((int)byteCount, bytesRemaining);
                sink2.write(message.getPayload(), this.bytesRead, bytesToRead);
                source.1 var7_7 = this;
                var7_7.bytesRead += bytesToRead;
                boolean bl = this.bytesRead <= message.getPayloadLength();
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (this.bytesRead == message.getPayloadLength()) {
                    this.message = null;
                    AdbStreamImpl.access$getAdbWriter$p(this.this$0).writeOkay(AdbStreamImpl.access$getLocalId$p(this.this$0), AdbStreamImpl.access$getRemoteId$p(this.this$0));
                }
                return bytesToRead;
            }

            private final AdbMessage message() {
                AdbMessage nextMessage;
                AdbMessage adbMessage = this.message;
                if (adbMessage != null) {
                    AdbMessage adbMessage2 = adbMessage;
                    boolean bl = false;
                    boolean bl2 = false;
                    AdbMessage it = adbMessage2;
                    boolean bl3 = false;
                    return it;
                }
                this.message = nextMessage = AdbStreamImpl.access$nextMessage(this.this$0, 1163154007);
                this.bytesRead = 0;
                return nextMessage;
            }

            public void close() {
            }

            @NotNull
            public Timeout timeout() {
                return Timeout.NONE;
            }
        });
        this.sink = Okio.buffer((Sink)new Sink(this){
            private final ByteBuffer buffer;
            final /* synthetic */ AdbStreamImpl this$0;
            {
                this.this$0 = $receiver;
                this.buffer = ByteBuffer.allocate(AdbStreamImpl.access$getMaxPayloadSize$p(this.this$0));
            }

            public void write(@NotNull Buffer source2, long byteCount) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                long remainingBytes = byteCount;
                do {
                    if ((remainingBytes -= (long)this.writeToBuffer((BufferedSource)source2, byteCount)) == 0L) {
                        return;
                    }
                    bl = remainingBytes > 0L;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    bl3 = false;
                    boolean bl4 = false;
                } while (bl);
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }

            private final int writeToBuffer(BufferedSource source2, long byteCount) {
                int bytesToWrite = Integer.min(this.buffer.remaining(), (int)byteCount);
                Object object = this.buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buffer.array()");
                int bytesWritten = source2.read(object, this.buffer.position(), bytesToWrite);
                object = this.buffer;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((java.nio.Buffer)object).position(this.buffer.position() + bytesWritten);
                if (this.buffer.remaining() == 0) {
                    this.flush();
                }
                return bytesWritten;
            }

            public void flush() {
                AdbWriter adbWriter = AdbStreamImpl.access$getAdbWriter$p(this.this$0);
                int n = AdbStreamImpl.access$getLocalId$p(this.this$0);
                int n2 = AdbStreamImpl.access$getRemoteId$p(this.this$0);
                Object object = this.buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buffer.array()");
                adbWriter.writeWrite(n, n2, (byte[])object, 0, this.buffer.position());
                object = this.buffer;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((java.nio.Buffer)object).clear();
            }

            public void close() {
            }

            @NotNull
            public Timeout timeout() {
                return Timeout.NONE;
            }
        });
    }

    @Override
    @NotNull
    public BufferedSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public BufferedSink getSink() {
        return this.sink;
    }

    private final AdbMessage nextMessage(int command) {
        AdbMessage adbMessage;
        try {
            adbMessage = (AdbMessage)this.messageQueue.take(this.localId, command);
        }
        catch (IOException e) {
            this.close();
            return null;
        }
        return adbMessage;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.adbWriter.writeClose(this.localId, this.remoteId);
        this.messageQueue.stopListening(this.localId);
    }

    public static final /* synthetic */ AdbWriter access$getAdbWriter$p(AdbStreamImpl $this) {
        return $this.adbWriter;
    }

    public static final /* synthetic */ int access$getLocalId$p(AdbStreamImpl $this) {
        return $this.localId;
    }

    public static final /* synthetic */ int access$getRemoteId$p(AdbStreamImpl $this) {
        return $this.remoteId;
    }

    public static final /* synthetic */ AdbMessage access$nextMessage(AdbStreamImpl $this, int command) {
        return $this.nextMessage(command);
    }

    public static final /* synthetic */ int access$getMaxPayloadSize$p(AdbStreamImpl $this) {
        return $this.maxPayloadSize;
    }
}

