/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbKeyPair;
import dadb.AdbShellResponse;
import dadb.AdbShellStream;
import dadb.AdbStream;
import dadb.AdbSyncStream;
import dadb.DadbImpl;
import dadb.adbserver.AdbServer;
import dadb.forwarding.TcpForwarder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\bf\u0018\u0000 52\u00020\u0001:\u00015J!\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J!\u0010\b\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000eJ1\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0006H&J\u0012\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0004\u001a\u00020\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J$\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0002J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0006H\u0016J,\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00062\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u0012H\u0016J(\u0010$\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0012H\u0016J\b\u0010)\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0006H&J\u0018\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020'H\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0006H\u0016J\b\u00104\u001a\u00020\nH\u0016\u00a8\u00066"}, d2={"Ldadb/Dadb;", "Ljava/lang/AutoCloseable;", "abbExec", "Ldadb/AdbStream;", "command", "", "", "([Ljava/lang/String;)Ldadb/AdbStream;", "execCmd", "install", "", "file", "Ljava/io/File;", "options", "(Ljava/io/File;[Ljava/lang/String;)V", "source", "Lokio/Source;", "size", "", "(Lokio/Source;J[Ljava/lang/String;)V", "installMultiple", "apks", "", "(Ljava/util/List;[Ljava/lang/String;)V", "open", "destination", "openShell", "Ldadb/AdbShellStream;", "openSync", "Ldadb/AdbSyncStream;", "pmInstall", "pull", "dst", "remotePath", "sink", "Lokio/Sink;", "push", "src", "mode", "", "lastModifiedMs", "root", "shell", "Ldadb/AdbShellResponse;", "supportsFeature", "", "feature", "tcpForward", "hostPort", "targetPort", "uninstall", "packageName", "unroot", "Companion", "dadb"})
public interface Dadb
extends AutoCloseable {
    @NotNull
    public static final Companion Companion = dadb.Dadb$Companion.$$INSTANCE;

    @NotNull
    public AdbStream open(@NotNull String var1) throws IOException;

    public boolean supportsFeature(@NotNull String var1);

    @NotNull
    public AdbShellResponse shell(@NotNull String var1) throws IOException;

    @NotNull
    public AdbShellStream openShell(@NotNull String var1) throws IOException;

    public void push(@NotNull File var1, @NotNull String var2, int var3, long var4) throws IOException;

    public void push(@NotNull Source var1, @NotNull String var2, int var3, long var4) throws IOException;

    public void pull(@NotNull File var1, @NotNull String var2) throws IOException;

    public void pull(@NotNull Sink var1, @NotNull String var2) throws IOException;

    @NotNull
    public AdbSyncStream openSync() throws IOException;

    public void install(@NotNull File var1, String ... var2) throws IOException;

    public void install(@NotNull Source var1, long var2, String ... var4) throws IOException;

    public void installMultiple(@NotNull List<? extends File> var1, String ... var2) throws IOException;

    public void uninstall(@NotNull String var1) throws IOException;

    @NotNull
    public AdbStream execCmd(String ... var1) throws IOException;

    @NotNull
    public AdbStream abbExec(String ... var1) throws IOException;

    public void root() throws IOException;

    public void unroot() throws IOException;

    @NotNull
    public AutoCloseable tcpForward(int var1, int var2) throws InterruptedException;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair, int connectTimeout, int socketTimeout) {
        return Companion.create(host, port, keyPair, connectTimeout, socketTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout, int socketTimeout) {
        return Companion.discover(host, keyPair, connectTimeout, socketTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Dadb> list(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout, int socketTimeout) {
        return Companion.list(host, keyPair, connectTimeout, socketTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair, int connectTimeout) {
        return Companion.create(host, port, keyPair, connectTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair) {
        return Companion.create(host, port, keyPair);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static Dadb create(@NotNull String host, int port) {
        return Companion.create(host, port);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout) {
        return Companion.discover(host, keyPair, connectTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair) {
        return Companion.discover(host, keyPair);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static Dadb discover(@NotNull String host) {
        return Companion.discover(host);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static Dadb discover() {
        return Companion.discover();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Dadb> list(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout) {
        return Companion.list(host, keyPair, connectTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Dadb> list(@NotNull String host, @Nullable AdbKeyPair keyPair) {
        return Companion.list(host, keyPair);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Dadb> list(@NotNull String host) {
        return Companion.list(host);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Dadb> list() {
        return Companion.list();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J4\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J8\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldadb/Dadb$Companion;", "", "()V", "MAX_EMULATOR_PORT", "", "MIN_EMULATOR_PORT", "create", "Ldadb/Dadb;", "host", "", "port", "keyPair", "Ldadb/AdbKeyPair;", "connectTimeout", "socketTimeout", "discover", "list", "", "readMode", "file", "Ljava/io/File;", "restartAdb", "dadb", "destination", "waitRootOrClose", "", "root", "", "readUntil", "Lokio/Buffer;", "Lokio/BufferedSource;", "endByte", ""})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int MIN_EMULATOR_PORT = 5555;
        private static final int MAX_EMULATOR_PORT = 5683;

        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair, int connectTimeout, int socketTimeout) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new DadbImpl(host, port, keyPair, connectTimeout, socketTimeout);
        }

        public static /* synthetic */ Dadb create$default(Companion companion, String string, int n, AdbKeyPair adbKeyPair, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                adbKeyPair = AdbKeyPair.Companion.readDefault();
            }
            if ((n4 & 8) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x10) != 0) {
                n3 = 0;
            }
            return companion.create(string, n, adbKeyPair, n2, n3);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout, int socketTimeout) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return (Dadb)CollectionsKt.firstOrNull(this.list(host, keyPair, connectTimeout, socketTimeout));
        }

        public static /* synthetic */ Dadb discover$default(Companion companion, String string, AdbKeyPair adbKeyPair, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = "localhost";
            }
            if ((n3 & 2) != 0) {
                adbKeyPair = AdbKeyPair.Companion.readDefault();
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            return companion.discover(string, adbKeyPair, n, n2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<Dadb> list(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout, int socketTimeout) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            List dadbs = AdbServer.listDadbs$default(host, 0, 2, null);
            Collection collection = dadbs;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return dadbs;
            }
            Iterable $this$mapNotNull$iv = (Iterable)new IntRange(5555, 5683);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Dadb dadb;
                String string;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                int port = element$iv$iv;
                boolean bl3 = false;
                Dadb dadb2 = $$INSTANCE.create(host, port, keyPair, socketTimeout, connectTimeout);
                try {
                    string = dadb2.shell("echo success").getAllOutput();
                }
                catch (Throwable ignore) {
                    string = null;
                }
                String response = string;
                if ((Intrinsics.areEqual((Object)response, (Object)"success\n") ? dadb2 : (Dadb)null) == null) continue;
                dadb = dadb;
                boolean bl4 = false;
                boolean bl5 = false;
                Dadb it$iv$iv = dadb;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List list$default(Companion companion, String string, AdbKeyPair adbKeyPair, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = "localhost";
            }
            if ((n3 & 2) != 0) {
                adbKeyPair = AdbKeyPair.Companion.readDefault();
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            return companion.list(string, adbKeyPair, n, n2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void waitRootOrClose(Dadb dadb, boolean root) {
            try {
                int propValue;
                AdbShellResponse response;
                do {
                    response = dadb.shell("getprop service.adb.root");
                    int n = propValue = root ? 1 : 0;
                } while (!Intrinsics.areEqual((Object)response.getOutput(), (Object)("" + propValue + '\n')));
                return;
            }
            catch (IOException e) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String restartAdb(Dadb dadb, String destination) {
            AutoCloseable autoCloseable = dadb.open(destination);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbStream stream = (AdbStream)autoCloseable;
                boolean bl3 = false;
                String string = $$INSTANCE.readUntil(stream.getSource(), (byte)10).readString(Charsets.UTF_8);
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final Buffer readUntil(BufferedSource $this$readUntil, byte endByte) {
            byte b;
            Buffer buffer = new Buffer();
            do {
                b = $this$readUntil.readByte();
                buffer.writeByte((int)b);
            } while (b != endByte);
            return buffer;
        }

        private final int readMode(File file) {
            Integer n;
            Object object = Files.getAttribute(file.toPath(), "unix:mode", new LinkOption[0]);
            Integer n2 = n = object instanceof Integer ? (Integer)object : null;
            if (n == null) {
                throw new RuntimeException("Unable to read file mode");
            }
            return n;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair, int connectTimeout) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.create$default(this, host, port, keyPair, connectTimeout, 0, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.create$default(this, host, port, keyPair, 0, 0, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Dadb create(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.create$default(this, host, port, null, 0, 0, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.discover$default(this, host, keyPair, connectTimeout, 0, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.discover$default(this, host, keyPair, 0, 0, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final Dadb discover(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.discover$default(this, host, null, 0, 0, 14, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final Dadb discover() {
            return dadb.Dadb$Companion.discover$default(this, null, null, 0, 0, 15, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<Dadb> list(@NotNull String host, @Nullable AdbKeyPair keyPair, int connectTimeout) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.list$default(this, host, keyPair, connectTimeout, 0, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<Dadb> list(@NotNull String host, @Nullable AdbKeyPair keyPair) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.list$default(this, host, keyPair, 0, 0, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<Dadb> list(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.list$default(this, host, null, 0, 0, 14, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<Dadb> list() {
            return dadb.Dadb$Companion.list$default(this, null, null, 0, 0, 15, null);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public static AdbShellResponse shell(@NotNull Dadb this_, @NotNull String command) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            AutoCloseable autoCloseable = this_.openShell(command);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbShellStream stream = (AdbShellStream)autoCloseable;
                boolean bl3 = false;
                AdbShellResponse adbShellResponse = stream.readAll();
                return adbShellResponse;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        @NotNull
        public static AdbShellStream openShell(@NotNull Dadb this_, @NotNull String command) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            AdbStream stream = this_.open(Intrinsics.stringPlus((String)"shell,v2,raw:", (Object)command));
            return new AdbShellStream(stream);
        }

        public static /* synthetic */ AdbShellStream openShell$default(Dadb dadb, String string, int n, Object object) throws IOException {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openShell");
            }
            if ((n & 1) != 0) {
                string = "";
            }
            return dadb.openShell(string);
        }

        public static void push(@NotNull Dadb this_, @NotNull File src, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            this_.push(Okio.source((File)src), remotePath, mode, lastModifiedMs);
        }

        public static /* synthetic */ void push$default(Dadb dadb, File file, String string, int n, long l, int n2, Object object) throws IOException {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: push");
            }
            if ((n2 & 4) != 0) {
                n = Companion.readMode(file);
            }
            if ((n2 & 8) != 0) {
                l = file.lastModified();
            }
            dadb.push(file, string, n, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void push(@NotNull Dadb this_, @NotNull Source source2, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            AutoCloseable autoCloseable = this_.openSync();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbSyncStream stream = (AdbSyncStream)autoCloseable;
                boolean bl3 = false;
                stream.send(source2, remotePath, mode, lastModifiedMs);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public static void pull(@NotNull Dadb this_, @NotNull File dst, @NotNull String remotePath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            this_.pull(Okio.sink((File)dst, (boolean)false), remotePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void pull(@NotNull Dadb this_, @NotNull Sink sink2, @NotNull String remotePath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            AutoCloseable autoCloseable = this_.openSync();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbSyncStream stream = (AdbSyncStream)autoCloseable;
                boolean bl3 = false;
                stream.recv(sink2, remotePath);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        @NotNull
        public static AdbSyncStream openSync(@NotNull Dadb this_) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            AdbStream stream = this_.open("sync:");
            return new AdbSyncStream(stream);
        }

        public static void install(@NotNull Dadb this_, @NotNull File file, String ... options) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (this_.supportsFeature("cmd")) {
                this_.install(Okio.source((File)file), file.length(), Arrays.copyOf(options, options.length));
            } else {
                DefaultImpls.pmInstall(this_, file, Arrays.copyOf(options, options.length));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void install(@NotNull Dadb this_, @NotNull Source source2, long size, String ... options) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (this_.supportsFeature("cmd")) {
                Object object = new SpreadBuilder(5);
                object.add((Object)"package");
                object.add((Object)"install");
                object.add((Object)"-S");
                object.add((Object)String.valueOf(size));
                object.addSpread((Object)options);
                object = this_.execCmd((String[])object.toArray((Object[])new String[object.size()]));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    AdbStream stream = (AdbStream)object;
                    boolean bl3 = false;
                    stream.getSink().writeAll(source2);
                    stream.getSink().flush();
                    String response = stream.getSource().readString(Charsets.UTF_8);
                    if (!StringsKt.startsWith$default((String)response, (String)"Success", (boolean)false, (int)2, null)) {
                        throw new IOException(Intrinsics.stringPlus((String)"Install failed: ", (Object)response));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                }
            } else {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                String string = null;
                Object object = null;
                boolean bl = false;
                Path path = Files.createTempFile(string, (String)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempFile(prefix, suffix, *attributes)");
                Path tempFile = path;
                BufferedSink fileSink = Okio.buffer((Sink)Okio.sink((Path)tempFile, (OpenOption[])new OpenOption[0]));
                fileSink.writeAll(source2);
                fileSink.flush();
                object = tempFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"tempFile.toFile()");
                DefaultImpls.pmInstall(this_, (File)object, Arrays.copyOf(options, options.length));
            }
        }

        private static void pmInstall(Dadb this_, File file, String ... options) {
            String fileName = file.getName();
            String remotePath = Intrinsics.stringPlus((String)"/data/local/tmp/", (Object)fileName);
            DefaultImpls.push$default(this_, file, remotePath, 0, 0L, 12, null);
            this_.shell("pm install " + ArraysKt.joinToString$default((Object[])options, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + " \"" + remotePath + '\"');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public static void installMultiple(@NotNull Dadb this_, @NotNull List<? extends File> apks, String ... options) throws IOException {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            MatchGroup acc3;
            void $this$reduce$iv;
            Object object;
            Iterable it;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(apks, (String)"apks");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (this_.supportsFeature("cmd")) {
                Object $this$reduce$iv2;
                void $this$mapTo$iv$iv4;
                Iterable $this$map$iv = apks;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                    void it2;
                    File file = (File)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    Long l = it2.length();
                    collection2.add(l);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator iterator$iv322 = $this$reduce$iv2.iterator();
                if (!iterator$iv322.hasNext()) {
                    throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv322.next();
                while (iterator$iv322.hasNext()) {
                    void l;
                    long $i$f$mapTo2 = ((Number)iterator$iv322.next()).longValue();
                    long acc2 = ((Number)accumulator$iv).longValue();
                    boolean bl = false;
                    accumulator$iv = acc2 + l;
                }
                long totalLength = ((Number)accumulator$iv).longValue();
                $this$reduce$iv2 = new SpreadBuilder(5);
                $this$reduce$iv2.add((Object)"package");
                $this$reduce$iv2.add((Object)"install-create");
                $this$reduce$iv2.add((Object)"-S");
                $this$reduce$iv2.add((Object)String.valueOf(totalLength));
                $this$reduce$iv2.addSpread((Object)options);
                $this$reduce$iv2 = this_.execCmd((String[])$this$reduce$iv2.toArray((Object[])new String[$this$reduce$iv2.size()]));
                $i$f$reduce = false;
                boolean iterator$iv322 = false;
                Throwable iterator$iv322 = null;
                try {
                    Object object2;
                    MatchGroupCollection matchGroupCollection;
                    AdbStream createStream = (AdbStream)$this$reduce$iv2;
                    boolean bl = false;
                    String response = createStream.getSource().readString(Charsets.UTF_8);
                    if (!StringsKt.startsWith$default((String)response, (String)"Success", (boolean)false, (int)2, null)) {
                        throw new IOException(Intrinsics.stringPlus((String)"connect error for create: ", (Object)response));
                    }
                    String acc2 = "\\[(\\w+)]";
                    boolean it2 = false;
                    Regex pattern = new Regex(acc2);
                    MatchResult matchResult = Regex.find$default((Regex)pattern, (CharSequence)response, (int)0, (int)2, null);
                    String string = matchResult == null ? null : ((matchGroupCollection = matchResult.getGroups()) == null ? null : (it2 = (object2 = matchGroupCollection.get(1)) == null ? null : object2.getValue()));
                    if (it2 == null) {
                        throw new IOException("failed to create session");
                    }
                    String sessionId = it2;
                    String error = null;
                    Iterable $this$forEach$iv = apks;
                    boolean $i$f$forEach22 = false;
                    for (Object element$iv22 : $this$forEach$iv) {
                        File apk = (File)element$iv22;
                        boolean bl2 = false;
                        Object object3 = new SpreadBuilder(8);
                        object3.add((Object)"package");
                        object3.add((Object)"install-write");
                        object3.add((Object)"-S");
                        object3.add((Object)String.valueOf(apk.length()));
                        object3.add((Object)sessionId);
                        String string2 = apk.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"apk.name");
                        object3.add((Object)string2);
                        object3.add((Object)"-");
                        object3.addSpread((Object)options);
                        object3 = this_.execCmd((String[])object3.toArray((Object[])new String[object3.size()]));
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Throwable throwable = null;
                        try {
                            AdbStream writeStream = (AdbStream)object3;
                            boolean bl5 = false;
                            writeStream.getSink().writeAll(Okio.source((File)apk));
                            writeStream.getSink().flush();
                            String writeResponse = writeStream.getSource().readString(Charsets.UTF_8);
                            if (!StringsKt.startsWith$default((String)writeResponse, (String)"Success", (boolean)false, (int)2, null)) {
                                error = writeResponse;
                                continue;
                            }
                            writeStream = Unit.INSTANCE;
                        }
                        catch (Throwable writeStream) {
                            throwable = writeStream;
                            throw writeStream;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)object3, (Throwable)throwable);
                        }
                    }
                    String finalCommand = error == null ? "install-commit" : "install-abandon";
                    Object $i$f$forEach22 = new SpreadBuilder(4);
                    $i$f$forEach22.add((Object)"package");
                    $i$f$forEach22.add((Object)finalCommand);
                    $i$f$forEach22.add((Object)sessionId);
                    $i$f$forEach22.addSpread((Object)options);
                    $i$f$forEach22 = this_.execCmd((String[])$i$f$forEach22.toArray((Object[])new String[$i$f$forEach22.size()]));
                    boolean bl6 = false;
                    boolean element$iv22 = false;
                    Throwable element$iv22 = null;
                    try {
                        AdbStream commitStream = (AdbStream)$i$f$forEach22;
                        boolean bl7 = false;
                        String finalResponse = commitStream.getSource().readString(Charsets.UTF_8);
                        if (!StringsKt.startsWith$default((String)finalResponse, (String)"Success", (boolean)false, (int)2, null)) {
                            throw new IOException(Intrinsics.stringPlus((String)"failed to finalize session: ", (Object)commitStream));
                        }
                        commitStream = Unit.INSTANCE;
                    }
                    catch (Throwable commitStream) {
                        element$iv22 = commitStream;
                        throw commitStream;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)$i$f$forEach22, (Throwable)element$iv22);
                    }
                    if (error != null) {
                        throw new IOException(Intrinsics.stringPlus((String)"Install failed: ", error));
                    }
                    createStream = Unit.INSTANCE;
                }
                catch (Throwable createStream) {
                    iterator$iv322 = createStream;
                    throw createStream;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)$this$reduce$iv2, (Throwable)iterator$iv322);
                }
            }
            Iterable $this$map$iv = apks;
            boolean $i$f$map = false;
            Iterator iterator$iv322 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            MatchGroupCollection response = $this$mapTo$iv$iv3.iterator();
            while (response.hasNext()) {
                Object item$iv$iv = response.next();
                File error = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = ((File)((Object)it)).length();
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            iterator$iv322 = $this$reduce$iv.iterator();
            if (!iterator$iv322.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv22 = iterator$iv322.next();
            while (iterator$iv322.hasNext()) {
                void l;
                long $i$f$mapTo3 = ((Number)iterator$iv322.next()).longValue();
                long acc3 = ((Number)accumulator$iv22).longValue();
                boolean bl = false;
                accumulator$iv22 = acc3 + l;
            }
            long totalLength = ((Number)accumulator$iv22).longValue();
            AdbShellResponse response2 = this_.shell("pm install-create -S " + totalLength + ' ' + ArraysKt.joinToString$default((Object[])options, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            if (!StringsKt.startsWith$default((String)response2.getAllOutput(), (String)"Success", (boolean)false, (int)2, null)) {
                throw new IOException(Intrinsics.stringPlus((String)"pm create session failed: ", (Object)response2));
            }
            iterator$iv322 = "\\[(\\w+)]";
            boolean accumulator$iv22 = false;
            Regex pattern = new Regex((String)((Object)iterator$iv322));
            MatchResult l = Regex.find$default((Regex)pattern, (CharSequence)response2.getAllOutput(), (int)0, (int)2, null);
            String string = l == null ? null : ((response = l.getGroups()) == null ? null : (accumulator$iv22 = (acc3 = response.get(1)) == null ? null : acc3.getValue()));
            if (accumulator$iv22 == null) {
                throw new IOException("failed to create session");
            }
            String sessionId = accumulator$iv22;
            String error = null;
            Iterable $this$map$iv2 = apks;
            boolean $i$f$map2 = false;
            it = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                File element$iv22 = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                object = it3.getName();
                collection.add(object);
            }
            List fileNames = (List)destination$iv$iv2;
            Iterable $this$map$iv3 = fileNames;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl8 = false;
                object = Intrinsics.stringPlus((String)"/data/local/tmp/", (Object)it4);
                collection.add(object);
            }
            List remotePaths = (List)destination$iv$iv3;
            Iterable $this$forEachIndexed$iv = CollectionsKt.zip((Iterable)apks, (Iterable)remotePaths);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void pair;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair it4 = (Pair)item$iv;
                int index = n;
                boolean bl9 = false;
                File apk = (File)pair.getFirst();
                String remotePath = (String)pair.getSecond();
                try {
                    DefaultImpls.push$default(this_, apk, remotePath, 0, 0L, 12, null);
                }
                catch (IOException t) {
                    error = t.getMessage();
                    continue;
                }
                AdbShellResponse writeResponse = this_.shell("pm install-write -S " + apk.length() + ' ' + sessionId + ' ' + index + ' ' + remotePath);
                if (StringsKt.startsWith$default((String)writeResponse.getAllOutput(), (String)"Success", (boolean)false, (int)2, null)) continue;
                error = writeResponse.getAllOutput();
            }
            String finalCommand = error == null ? Intrinsics.stringPlus((String)"pm install-commit ", (Object)sessionId) : Intrinsics.stringPlus((String)"pm install-abandon ", (Object)sessionId);
            AdbShellResponse finalResponse = this_.shell(finalCommand);
            if (!StringsKt.startsWith$default((String)finalResponse.getAllOutput(), (String)"Success", (boolean)false, (int)2, null)) {
                throw new IOException(Intrinsics.stringPlus((String)"failed to finalize session: ", (Object)finalResponse));
            }
            if (error != null) {
                throw new IOException(Intrinsics.stringPlus((String)"Install failed: ", error));
            }
        }

        public static void uninstall(@NotNull Dadb this_, @NotNull String packageName) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            AdbShellResponse response = this_.shell(Intrinsics.stringPlus((String)"cmd package uninstall ", (Object)packageName));
            if (response.getExitCode() != 0) {
                throw new IOException(Intrinsics.stringPlus((String)"Uninstall failed: ", (Object)response.getAllOutput()));
            }
        }

        @NotNull
        public static AdbStream execCmd(@NotNull Dadb this_, String ... command) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (!this_.supportsFeature("cmd")) {
                throw new UnsupportedOperationException("cmd is not supported on this version of Android");
            }
            String destination = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"exec:cmd"), (Object[])command), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            return this_.open(destination);
        }

        @NotNull
        public static AdbStream abbExec(@NotNull Dadb this_, String ... command) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (!this_.supportsFeature("abb_exec")) {
                throw new UnsupportedOperationException("abb_exec is not supported on this version of Android");
            }
            String destination = Intrinsics.stringPlus((String)"abb_exec:", (Object)ArraysKt.joinToString$default((Object[])command, (CharSequence)"\u0000", null, null, (int)0, null, null, (int)62, null));
            return this_.open(destination);
        }

        public static void root(@NotNull Dadb this_) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String response = Companion.restartAdb(this_, "root:");
            if (!StringsKt.startsWith$default((String)response, (String)"restarting", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)response, (CharSequence)"already", (boolean)false, (int)2, null)) {
                throw new IOException(Intrinsics.stringPlus((String)"Failed to restart adb as root: ", (Object)response));
            }
            Companion.waitRootOrClose(this_, true);
        }

        public static void unroot(@NotNull Dadb this_) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String response = Companion.restartAdb(this_, "unroot:");
            if (!StringsKt.startsWith$default((String)response, (String)"restarting", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)response, (CharSequence)"not running as root", (boolean)false, (int)2, null)) {
                throw new IOException(Intrinsics.stringPlus((String)"Failed to restart adb as root: ", (Object)response));
            }
            Companion.waitRootOrClose(this_, false);
        }

        @NotNull
        public static AutoCloseable tcpForward(@NotNull Dadb this_, int hostPort, int targetPort) throws InterruptedException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            TcpForwarder forwarder = new TcpForwarder(this_, hostPort, targetPort);
            forwarder.start();
            return forwarder;
        }
    }
}

