/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbConnection;
import dadb.AdbKeyPair;
import dadb.AdbShellResponse;
import dadb.AdbShellStream;
import dadb.AdbStream;
import dadb.AdbSyncStream;
import dadb.Dadb;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u000b\u001a\u00020\rH\u0002J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldadb/DadbImpl;", "Ldadb/Dadb;", "host", "", "port", "", "keyPair", "Ldadb/AdbKeyPair;", "connectTimeout", "socketTimeout", "(Ljava/lang/String;ILdadb/AdbKeyPair;II)V", "connection", "Lkotlin/Pair;", "Ldadb/AdbConnection;", "Ljava/net/Socket;", "close", "", "closeConnection", "newConnection", "open", "Ldadb/AdbStream;", "destination", "supportsFeature", "", "feature", "toString", "dadb"})
public final class DadbImpl
implements Dadb {
    @NotNull
    private final String host;
    private final int port;
    @Nullable
    private final AdbKeyPair keyPair;
    private final int connectTimeout;
    private final int socketTimeout;
    @Nullable
    private Pair<AdbConnection, ? extends Socket> connection;

    public DadbImpl(@NotNull String host, int port, @Nullable AdbKeyPair keyPair, int connectTimeout, int socketTimeout) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.keyPair = keyPair;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        if (this.port < 0) {
            throw new IllegalArgumentException("port must be >= 0");
        }
        if (this.connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        if (this.socketTimeout < 0) {
            throw new IllegalArgumentException("socketTimeout must be >= 0");
        }
    }

    public /* synthetic */ DadbImpl(String string, int n, AdbKeyPair adbKeyPair, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) throws IllegalArgumentException {
        if ((n4 & 4) != 0) {
            adbKeyPair = null;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(string, n, adbKeyPair, n2, n3);
    }

    @Override
    @NotNull
    public AdbStream open(@NotNull String destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.connection().open(destination);
    }

    @Override
    public boolean supportsFeature(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.connection().supportsFeature(feature);
    }

    @Override
    public void close() {
        AdbConnection adbConnection;
        Pair<AdbConnection, ? extends Socket> pair = this.connection;
        if (pair != null && (adbConnection = (AdbConnection)pair.getFirst()) != null) {
            adbConnection.close();
        }
    }

    @NotNull
    public String toString() {
        return this.host + ':' + this.port;
    }

    public final void closeConnection() {
        Socket socket;
        Pair<AdbConnection, ? extends Socket> pair = this.connection;
        if (pair != null && (socket = (Socket)pair.getSecond()) != null) {
            socket.close();
        }
    }

    private final synchronized AdbConnection connection() {
        Pair<AdbConnection, ? extends Socket> connection = this.connection;
        if (connection == null || ((Socket)connection.getSecond()).isClosed()) {
            this.connection = connection = this.newConnection();
        }
        return (AdbConnection)connection.getFirst();
    }

    private final Pair<AdbConnection, Socket> newConnection() {
        InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
        Socket socket = new Socket();
        socket.setSoTimeout(this.socketTimeout);
        socket.connect(socketAddress, this.connectTimeout);
        AdbConnection adbConnection = AdbConnection.Companion.connect(socket, this.keyPair);
        return TuplesKt.to((Object)adbConnection, (Object)socket);
    }

    @Override
    @NotNull
    public AdbStream abbExec(String ... command) throws IOException {
        return Dadb.DefaultImpls.abbExec(this, command);
    }

    @Override
    @NotNull
    public AdbStream execCmd(String ... command) throws IOException {
        return Dadb.DefaultImpls.execCmd(this, command);
    }

    @Override
    public void install(@NotNull File file, String ... options) throws IOException {
        Dadb.DefaultImpls.install((Dadb)this, file, options);
    }

    @Override
    public void install(@NotNull Source source2, long size, String ... options) throws IOException {
        Dadb.DefaultImpls.install((Dadb)this, source2, size, options);
    }

    @Override
    public void installMultiple(@NotNull List<? extends File> apks, String ... options) throws IOException {
        Dadb.DefaultImpls.installMultiple(this, apks, options);
    }

    @Override
    @NotNull
    public AdbShellStream openShell(@NotNull String command) throws IOException {
        return Dadb.DefaultImpls.openShell(this, command);
    }

    @Override
    @NotNull
    public AdbSyncStream openSync() throws IOException {
        return Dadb.DefaultImpls.openSync(this);
    }

    @Override
    public void pull(@NotNull File dst, @NotNull String remotePath) throws IOException {
        Dadb.DefaultImpls.pull((Dadb)this, dst, remotePath);
    }

    @Override
    public void pull(@NotNull Sink sink2, @NotNull String remotePath) throws IOException {
        Dadb.DefaultImpls.pull((Dadb)this, sink2, remotePath);
    }

    @Override
    public void push(@NotNull Source source2, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
        Dadb.DefaultImpls.push((Dadb)this, source2, remotePath, mode, lastModifiedMs);
    }

    @Override
    public void push(@NotNull File src, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
        Dadb.DefaultImpls.push((Dadb)this, src, remotePath, mode, lastModifiedMs);
    }

    @Override
    public void root() throws IOException {
        Dadb.DefaultImpls.root(this);
    }

    @Override
    @NotNull
    public AdbShellResponse shell(@NotNull String command) throws IOException {
        return Dadb.DefaultImpls.shell(this, command);
    }

    @Override
    @NotNull
    public AutoCloseable tcpForward(int hostPort, int targetPort) throws InterruptedException {
        return Dadb.DefaultImpls.tcpForward(this, hostPort, targetPort);
    }

    @Override
    public void uninstall(@NotNull String packageName) throws IOException {
        Dadb.DefaultImpls.uninstall(this, packageName);
    }

    @Override
    public void unroot() throws IOException {
        Dadb.DefaultImpls.unroot(this);
    }
}

