/*
 * Decompiled with CFR 0.152.
 */
package dadb.adbserver;

import dadb.adbserver.AdbBinary;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Ldadb/adbserver/AdbBinary;", "", "()V", "ADB_BINARY", "Ljava/io/File;", "getADB_BINARY", "()Ljava/io/File;", "ADB_BINARY$delegate", "Lkotlin/Lazy;", "ensureServerRunning", "", "adbServerHost", "", "adbServerPort", "", "find", "findViaAndroidHome", "findViaWhich", "isServerRunning", "", "isWindows", "startServer", "adbBinary", "tryStartServer", "dadb"})
public final class AdbBinary {
    @NotNull
    public static final AdbBinary INSTANCE = new AdbBinary();
    @NotNull
    private static final Lazy ADB_BINARY$delegate = LazyKt.lazy((Function0)ADB_BINARY.2.INSTANCE);

    private AdbBinary() {
    }

    private final File getADB_BINARY() {
        Lazy lazy = ADB_BINARY$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    public final boolean tryStartServer(@NotNull String adbServerHost, int adbServerPort) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        try {
            this.ensureServerRunning(adbServerHost, adbServerPort);
            bl = true;
        }
        catch (Exception ignore) {
            bl = false;
        }
        return bl;
    }

    public final void ensureServerRunning(@NotNull String adbServerHost, int adbServerPort) {
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        if (!this.isServerRunning(adbServerHost, adbServerPort)) {
            if (!Intrinsics.areEqual((Object)adbServerHost, (Object)"localhost")) {
                throw new IOException("No running adb server found at " + adbServerHost + ':' + adbServerPort + '.');
            }
            File file = this.getADB_BINARY();
            if (file == null) {
                throw new IOException("No running adb server found at " + adbServerHost + ':' + adbServerPort + " and unable to discover an adb binary.");
            }
            File adbBinary = file;
            this.startServer(adbBinary, adbServerPort);
            Thread.sleep(200L);
        }
    }

    private final void startServer(File adbBinary, int adbServerPort) {
        String[] stringArray = new String[]{adbBinary.getAbsolutePath(), "-P", String.valueOf(adbServerPort), "start-server"};
        Process process = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            String output = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            throw new IOException("Failed to start adb server on port " + adbServerPort + ": " + output);
        }
    }

    private final boolean isServerRunning(String adbServerHost, int adbServerPort) {
        boolean bl;
        try {
            new Socket(adbServerHost, adbServerPort).close();
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final File find() {
        File file = this.findViaWhich();
        return file == null ? this.findViaAndroidHome() : file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File findViaWhich() {
        String which = this.isWindows() ? "where" : "which";
        String[] stringArray = new String[]{which, "adb"};
        Process process = new ProcessBuilder(stringArray).start();
        if (process.waitFor() != 0) {
            return null;
        }
        Closeable closeable = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"process.inputStream");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object = closeable;
        int n = 0;
        object = new InputStreamReader((InputStream)object, charset);
        n = 8192;
        boolean bl2 = false;
        closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader r = (BufferedReader)closeable;
            boolean bl4 = false;
            String string = r.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"r.readLine()");
            boolean bl5 = false;
            object = ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object output = object;
        File file = new File((String)output);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private final File findViaAndroidHome() {
        String string;
        String string2 = System.getenv("ANDROID_HOME");
        String string3 = string = string2 == null ? System.getenv("ANDROID_SDK_ROOT") : string2;
        if (string == null) {
            return null;
        }
        String androidEnvHome = string;
        String adbName = this.isWindows() ? "adb.exe" : "adb";
        File adbFile = FilesKt.resolve((File)FilesKt.resolve((File)new File(androidEnvHome), (String)"platform-tools"), (String)adbName);
        if (!adbFile.exists()) {
            return null;
        }
        return adbFile;
    }

    private final boolean isWindows() {
        boolean bl;
        String string = System.getProperty("os.name");
        if (string == null) {
            bl = false;
        } else {
            String string2 = string;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            boolean bl2 = false;
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
            String string4 = string3;
            bl = string4 == null ? false : StringsKt.contains$default((CharSequence)string4, (CharSequence)"win", (boolean)false, (int)2, null);
        }
        return bl;
    }

    public static final /* synthetic */ File access$find(AdbBinary $this) {
        return $this.find();
    }
}

