/*
 * Decompiled with CFR 0.152.
 */
package dadb.adbserver;

import dadb.Dadb;
import dadb.adbserver.AdbBinary;
import dadb.adbserver.AdbServerDadb;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u0007J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002\u00a8\u0006\u001d"}, d2={"Ldadb/adbserver/AdbServer;", "", "()V", "createDadb", "Ldadb/Dadb;", "adbServerHost", "", "adbServerPort", "", "deviceQuery", "connectTimeout", "socketTimeout", "listDadbs", "", "readString", "inputStream", "Ljava/io/DataInputStream;", "readString$dadb", "length", "send", "", "socket", "Ljava/net/Socket;", "command", "send$dadb", "writeString", "outputStream", "Ljava/io/DataOutputStream;", "string", "dadb"})
public final class AdbServer {
    @NotNull
    public static final AdbServer INSTANCE = new AdbServer();

    private AdbServer() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Dadb createDadb(@NotNull String adbServerHost, int adbServerPort, @NotNull String deviceQuery, int connectTimeout, int socketTimeout) {
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        Intrinsics.checkNotNullParameter((Object)deviceQuery, (String)"deviceQuery");
        String name = StringsKt.removePrefix((String)StringsKt.removePrefix((String)deviceQuery, (CharSequence)"host:"), (CharSequence)"transport:");
        return new AdbServerDadb(adbServerHost, adbServerPort, deviceQuery, name, connectTimeout, socketTimeout);
    }

    public static /* synthetic */ Dadb createDadb$default(String string, int n, String string2, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = "localhost";
        }
        if ((n4 & 2) != 0) {
            n = 5037;
        }
        if ((n4 & 4) != 0) {
            string2 = "host:transport-any";
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        return AdbServer.createDadb(string, n, string2, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Dadb> listDadbs(@NotNull String adbServerHost, int adbServerPort) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        if (!AdbBinary.INSTANCE.tryStartServer(adbServerHost, adbServerPort)) {
            return CollectionsKt.emptyList();
        }
        Closeable closeable = new Socket(adbServerHost, adbServerPort);
        boolean bl = false;
        boolean bl2 = false;
        Object object = null;
        try {
            Object socket = (Socket)closeable;
            boolean bl3 = false;
            INSTANCE.send$dadb((Socket)socket, "host:devices");
            socket = INSTANCE.readString$dadb(new DataInputStream(((Socket)socket).getInputStream()));
        }
        catch (Throwable socket) {
            object = socket;
            throw socket;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object output = socket;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)((CharSequence)output));
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl4 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl5 = false;
            boolean bl6 = !StringsKt.isBlank((CharSequence)charSequence);
            if (!bl6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl7 = false;
            String it2 = (String)element$iv$iv;
            boolean bl8 = false;
            String[] stringArray = new String[]{"\t"};
            List parts = StringsKt.split$default((CharSequence)it2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if ((parts.size() != 2 ? (String)null : (String)parts.get(0)) == null) continue;
            string = string;
            boolean bl9 = false;
            boolean bl10 = false;
            String it$iv$iv = string;
            boolean bl11 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl12 = false;
            Dadb dadb = AdbServer.createDadb$default(adbServerHost, adbServerPort, Intrinsics.stringPlus((String)"host:transport:", (Object)it), 0, 0, 24, null);
            collection.add(dadb);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List listDadbs$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 5037;
        }
        return AdbServer.listDadbs(string, n);
    }

    @NotNull
    public final String readString$dadb(@NotNull DataInputStream inputStream) {
        String encodedLength;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        String string = encodedLength = this.readString(inputStream, 4);
        int n = 16;
        boolean bl = false;
        int length = Integer.parseInt(string, CharsKt.checkRadix((int)n));
        return this.readString(inputStream, length);
    }

    public final void send$dadb(@NotNull Socket socket, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        DataInputStream inputStream = new DataInputStream(socket.getInputStream());
        DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
        this.writeString(outputStream, command);
        String response = this.readString(inputStream, 4);
        if (!Intrinsics.areEqual((Object)response, (Object)"OKAY")) {
            String error = this.readString$dadb(inputStream);
            throw new IOException("Command failed (" + command + "): " + error);
        }
    }

    private final void writeString(DataOutputStream outputStream, String string) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        boolean bl = false;
        boolean bl2 = false;
        OutputStreamWriter $this$writeString_u24lambda_u2d4 = outputStreamWriter;
        boolean bl3 = false;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%04x";
        Object[] objectArray = new Object[1];
        String string3 = string;
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        objectArray[0] = byArray.length;
        boolean bl5 = false;
        String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        $this$writeString_u24lambda_u2d4.write(string5);
        $this$writeString_u24lambda_u2d4.write(string);
        $this$writeString_u24lambda_u2d4.flush();
    }

    private final String readString(DataInputStream inputStream, int length) {
        byte[] responseBuffer = new byte[length];
        inputStream.readFully(responseBuffer);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl = false;
        return new String(responseBuffer, charset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Dadb createDadb(@NotNull String adbServerHost, int adbServerPort, @NotNull String deviceQuery, int connectTimeout) {
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        Intrinsics.checkNotNullParameter((Object)deviceQuery, (String)"deviceQuery");
        return AdbServer.createDadb$default(adbServerHost, adbServerPort, deviceQuery, connectTimeout, 0, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Dadb createDadb(@NotNull String adbServerHost, int adbServerPort, @NotNull String deviceQuery) {
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        Intrinsics.checkNotNullParameter((Object)deviceQuery, (String)"deviceQuery");
        return AdbServer.createDadb$default(adbServerHost, adbServerPort, deviceQuery, 0, 0, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Dadb createDadb(@NotNull String adbServerHost, int adbServerPort) {
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        return AdbServer.createDadb$default(adbServerHost, adbServerPort, null, 0, 0, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Dadb createDadb(@NotNull String adbServerHost) {
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        return AdbServer.createDadb$default(adbServerHost, 0, null, 0, 0, 30, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Dadb createDadb() {
        return AdbServer.createDadb$default(null, 0, null, 0, 0, 31, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Dadb> listDadbs(@NotNull String adbServerHost) {
        Intrinsics.checkNotNullParameter((Object)adbServerHost, (String)"adbServerHost");
        return AdbServer.listDadbs$default(adbServerHost, 0, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Dadb> listDadbs() {
        return AdbServer.listDadbs$default(null, 0, 3, null);
    }
}

