/*
 * Decompiled with CFR 0.152.
 */
package dadb.adbserver;

import dadb.AdbShellResponse;
import dadb.AdbShellStream;
import dadb.AdbStream;
import dadb.AdbSyncStream;
import dadb.Dadb;
import dadb.adbserver.AdbBinary;
import dadb.adbserver.AdbServer;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldadb/adbserver/AdbServerDadb;", "Ldadb/Dadb;", "host", "", "port", "", "deviceQuery", "name", "connectTimeout", "socketTimeout", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;II)V", "supportedFeatures", "", "close", "", "open", "Ldadb/AdbStream;", "destination", "supportsFeature", "", "feature", "toString", "dadb"})
final class AdbServerDadb
implements Dadb {
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String deviceQuery;
    @NotNull
    private final String name;
    private final int connectTimeout;
    private final int socketTimeout;
    @NotNull
    private final Set<String> supportedFeatures;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdbServerDadb(@NotNull String host, int port, @NotNull String deviceQuery, @NotNull String name, int connectTimeout, int socketTimeout) {
        Set set;
        Set set2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)deviceQuery, (String)"deviceQuery");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.host = host;
        this.port = port;
        this.deviceQuery = deviceQuery;
        this.name = name;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        AutoCloseable autoCloseable = this.open("host:features");
        AdbServerDadb adbServerDadb = this;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            AdbStream it = (AdbStream)autoCloseable;
            boolean bl3 = false;
            String features = AdbServer.INSTANCE.readString$dadb(new DataInputStream(it.getSource().inputStream()));
            String[] stringArray = new String[]{","};
            set2 = CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)features, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        adbServerDadb.supportedFeatures = set = set2;
    }

    public /* synthetic */ AdbServerDadb(String string, int n, String string2, String string3, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        this(string, n, string2, string3, n2, n3);
    }

    @Override
    @NotNull
    public AdbStream open(@NotNull String destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        AdbBinary.INSTANCE.ensureServerRunning(this.host, this.port);
        InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
        Socket socket = new Socket();
        socket.setSoTimeout(this.socketTimeout);
        socket.connect(socketAddress, this.connectTimeout);
        AdbServer.INSTANCE.send$dadb(socket, this.deviceQuery);
        AdbServer.INSTANCE.send$dadb(socket, destination);
        return new AdbStream(socket){
            @NotNull
            private final BufferedSource source;
            @NotNull
            private final BufferedSink sink;
            final /* synthetic */ Socket $socket;
            {
                this.$socket = $socket;
                this.source = Okio.buffer((Source)Okio.source((Socket)this.$socket));
                this.sink = Okio.buffer((Sink)Okio.sink((Socket)this.$socket));
            }

            @NotNull
            public BufferedSource getSource() {
                return this.source;
            }

            @NotNull
            public BufferedSink getSink() {
                return this.sink;
            }

            public void close() {
                this.$socket.close();
            }
        };
    }

    @Override
    public boolean supportsFeature(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.supportedFeatures.contains(feature);
    }

    @Override
    public void close() {
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @Override
    @NotNull
    public AdbStream abbExec(String ... command) throws IOException {
        return Dadb.DefaultImpls.abbExec(this, command);
    }

    @Override
    @NotNull
    public AdbStream execCmd(String ... command) throws IOException {
        return Dadb.DefaultImpls.execCmd(this, command);
    }

    @Override
    public void install(@NotNull File file, String ... options) throws IOException {
        Dadb.DefaultImpls.install((Dadb)this, file, options);
    }

    @Override
    public void install(@NotNull Source source2, long size, String ... options) throws IOException {
        Dadb.DefaultImpls.install((Dadb)this, source2, size, options);
    }

    @Override
    public void installMultiple(@NotNull List<? extends File> apks, String ... options) throws IOException {
        Dadb.DefaultImpls.installMultiple(this, apks, options);
    }

    @Override
    @NotNull
    public AdbShellStream openShell(@NotNull String command) throws IOException {
        return Dadb.DefaultImpls.openShell(this, command);
    }

    @Override
    @NotNull
    public AdbSyncStream openSync() throws IOException {
        return Dadb.DefaultImpls.openSync(this);
    }

    @Override
    public void pull(@NotNull File dst, @NotNull String remotePath) throws IOException {
        Dadb.DefaultImpls.pull((Dadb)this, dst, remotePath);
    }

    @Override
    public void pull(@NotNull Sink sink2, @NotNull String remotePath) throws IOException {
        Dadb.DefaultImpls.pull((Dadb)this, sink2, remotePath);
    }

    @Override
    public void push(@NotNull Source source2, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
        Dadb.DefaultImpls.push((Dadb)this, source2, remotePath, mode, lastModifiedMs);
    }

    @Override
    public void push(@NotNull File src, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
        Dadb.DefaultImpls.push((Dadb)this, src, remotePath, mode, lastModifiedMs);
    }

    @Override
    public void root() throws IOException {
        Dadb.DefaultImpls.root(this);
    }

    @Override
    @NotNull
    public AdbShellResponse shell(@NotNull String command) throws IOException {
        return Dadb.DefaultImpls.shell(this, command);
    }

    @Override
    @NotNull
    public AutoCloseable tcpForward(int hostPort, int targetPort) throws InterruptedException {
        return Dadb.DefaultImpls.tcpForward(this, hostPort, targetPort);
    }

    @Override
    public void uninstall(@NotNull String packageName) throws IOException {
        Dadb.DefaultImpls.uninstall(this, packageName);
    }

    @Override
    public void unroot() throws IOException {
        Dadb.DefaultImpls.unroot(this);
    }
}

