/*
 * Decompiled with CFR 0.152.
 */
package maestro;

import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import idb.CompanionServiceGrpc;
import idb.HIDEventKt;
import idb.Idb;
import idb.PointKt;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import ios.grpc.BlockingStreamObserver;
import ios.idb.IdbRunner;
import java.io.Closeable;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import maestro.debuglog.DebugLogStore;
import maestro.utils.MaestroTimer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lmaestro/LocalIdbRunner;", "Lios/idb/IdbRunner;", "host", "", "port", "", "deviceId", "(Ljava/lang/String;ILjava/lang/String;)V", "getDeviceId", "()Ljava/lang/String;", "getHost", "getPort", "()I", "isSocketAvailable", "", "start", "Lio/grpc/ManagedChannel;", "stop", "", "channel", "testPressAction", "Lcom/github/michaelbull/result/Result;", "", "Companion", "maestro-client"})
public final class LocalIdbRunner
implements IdbRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String deviceId;
    @NotNull
    private static final Logger logger = DebugLogStore.INSTANCE.loggerFor(LocalIdbRunner.class);

    public LocalIdbRunner(@NotNull String host, int port, @NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        this.host = host;
        this.port = port;
        this.deviceId = deviceId;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    public void stop(@NotNull ManagedChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        channel.shutdownNow();
        if (!channel.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new TimeoutException("Couldn't close Maestro iOS driver due to gRPC timeout");
        }
    }

    @NotNull
    public ManagedChannel start() {
        logger.info(Intrinsics.stringPlus((String)"startIDBCompanion on ", (Object)this.deviceId));
        if (this.isSocketAvailable(this.host, this.port)) {
            Object[] objectArray = new String[]{"killall", "idb_companion"};
            new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).start().waitFor();
        }
        String[] stringArray = new String[]{"idb_companion", "--udid", this.deviceId};
        ProcessBuilder idbProcessBuilder = new ProcessBuilder(stringArray);
        DebugLogStore.INSTANCE.logOutputOf(idbProcessBuilder);
        Process idbProcess = idbProcessBuilder.start();
        Runtime.getRuntime().addShutdownHook(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(idbProcess){
            final /* synthetic */ Process $idbProcess;
            {
                this.$idbProcess = $idbProcess;
                super(0);
            }

            public final void invoke() {
                this.$idbProcess.destroy();
            }
        }), (int)30, null));
        logger.warning("Waiting for idb service to start..");
        if (!MaestroTimer.INSTANCE.retryUntilTrue(60000L, Long.valueOf(100L), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ LocalIdbRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Boolean invoke() {
                Boolean bl;
                Closeable closeable = new Socket(this.this$0.getHost(), this.this$0.getPort());
                Throwable throwable = null;
                try {
                    Socket it = (Socket)closeable;
                    boolean bl2 = false;
                    bl = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return bl;
            }
        })) {
            throw new IllegalStateException("idb_companion did not start in time".toString());
        }
        logger.warning("Waiting for Simulator to boot..");
        if (!MaestroTimer.INSTANCE.retryUntilTrue(120000L, Long.valueOf(100L), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ LocalIdbRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                String[] stringArray = new String[]{"xcrun", "simctl", "bootstatus", this.this$0.getDeviceId()};
                Process process = new ProcessBuilder(stringArray).start();
                process.waitFor(1000L, TimeUnit.MILLISECONDS);
                return process.exitValue() == 0;
            }
        })) {
            throw new IllegalStateException("Simulator failed to boot".toString());
        }
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().build();
        logger.warning("Waiting for successful taps");
        if (!MaestroTimer.INSTANCE.retryUntilTrue(20000L, Long.valueOf(100L), (Function0)new Function0<Boolean>(this, channel){
            final /* synthetic */ LocalIdbRunner this$0;
            final /* synthetic */ ManagedChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ManagedChannel managedChannel = this.$channel;
                Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"channel");
                return LocalIdbRunner.access$testPressAction(this.this$0, managedChannel) instanceof Ok;
            }
        })) {
            throw new IllegalStateException("idb_companion is not able dispatch successful tap events".toString());
        }
        logger.warning("Simulator ready");
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        return channel;
    }

    /*
     * WARNING - void declaration
     */
    private final Result<Unit, Throwable> testPressAction(ManagedChannel channel) {
        Result result;
        boolean x = false;
        boolean y = false;
        long holdDelay = 50L;
        CompanionServiceGrpc.CompanionServiceStub asyncStub = CompanionServiceGrpc.newStub((Channel)((Channel)channel));
        LocalIdbRunner $this$runCatching$iv = this;
        boolean $i$f$runCatching = false;
        try {
            void $this$testPressAction_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d5;
            void $this$testPressAction_u24lambda_u2d7_u24lambda_u2d6;
            Idb.HIDEvent.HIDPress.Builder $this$testPressAction_u24lambda_u2d7_u24lambda_u2d4_u24lambda_u2d3;
            Idb.HIDEvent.Builder $this$testPressAction_u24lambda_u2d7_u24lambda_u2d4;
            void $this$testPressAction_u24lambda_u2d7_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0;
            void $this$testPressAction_u24lambda_u2d7_u24lambda_u2d2_u24lambda_u2d1;
            LocalIdbRunner $this$testPressAction_u24lambda_u2d7 = $this$runCatching$iv;
            boolean bl = false;
            BlockingStreamObserver responseObserver = new BlockingStreamObserver();
            StreamObserver stream = asyncStub.hid((StreamObserver)responseObserver);
            HIDEventKt this_$iv = HIDEventKt.INSTANCE;
            boolean bl2 = false;
            Idb.HIDEvent.HIDPressAction.Builder builder = Idb.HIDEvent.HIDPressAction.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
            Idb.HIDEvent.HIDPressAction.Builder $this$hIDPressAction_u24lambda_u2d3$iv = builder = HIDEventKt.HIDPressActionKt.Dsl.Companion._create(builder);
            boolean $i$a$-apply-HIDEventKt$hIDPressAction$1$iv22 = false;
            Idb.HIDEvent.HIDPressAction.Builder $this$testPressAction_u24lambda_u2d7_u24lambda_u2d2 = $this$hIDPressAction_u24lambda_u2d3$iv;
            boolean bl3 = false;
            HIDEventKt this_$iv2 = HIDEventKt.INSTANCE;
            boolean bl4 = false;
            Idb.HIDEvent.HIDTouch.Builder builder2 = Idb.HIDEvent.HIDTouch.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()");
            Idb.HIDEvent.HIDTouch.Builder $this$hIDTouch_u24lambda_u2d0$iv = builder2 = HIDEventKt.HIDTouchKt.Dsl.Companion._create(builder2);
            boolean $i$a$-apply-HIDEventKt$hIDTouch$1$iv22 = false;
            Idb.HIDEvent.HIDTouch.Builder builder3 = $this$hIDTouch_u24lambda_u2d0$iv;
            Idb.HIDEvent.HIDPressAction.Builder builder4 = $this$testPressAction_u24lambda_u2d7_u24lambda_u2d2;
            boolean bl5 = false;
            boolean bl6 = false;
            Idb.Point.Builder builder5 = Idb.Point.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"newBuilder()");
            Idb.Point.Builder $this$point_u24lambda_u2d0$iv = builder5 = PointKt.Dsl.Companion._create(builder5);
            boolean bl7 = false;
            Idb.Point.Builder builder6 = $this$point_u24lambda_u2d0$iv;
            void var33_43 = $this$testPressAction_u24lambda_u2d7_u24lambda_u2d2_u24lambda_u2d1;
            boolean bl8 = false;
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setX((double)x);
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setY((double)y);
            var33_43.setPoint(builder5._build());
            builder4.setTouch(builder2._build());
            Idb.HIDEvent.HIDPressAction pressAction = builder._build();
            boolean bl9 = false;
            Idb.HIDEvent.Builder builder7 = Idb.HIDEvent.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"newBuilder()");
            Idb.HIDEvent.Builder $this$hIDEvent_u24lambda_u2d0$iv = builder7 = HIDEventKt.Dsl.Companion._create(builder7);
            boolean bl10 = false;
            Idb.HIDEvent.Builder $i$a$-apply-HIDEventKt$hIDPressAction$1$iv22 = $this$hIDEvent_u24lambda_u2d0$iv;
            StreamObserver streamObserver = stream;
            boolean bl11 = false;
            HIDEventKt this_$iv3 = HIDEventKt.INSTANCE;
            boolean bl12 = false;
            Idb.HIDEvent.HIDPress.Builder builder8 = Idb.HIDEvent.HIDPress.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"newBuilder()");
            Idb.HIDEvent.HIDPress.Builder $this$hIDPress_u24lambda_u2d4$iv = builder8 = HIDEventKt.HIDPressKt.Dsl.Companion._create(builder8);
            boolean bl13 = false;
            Idb.HIDEvent.HIDPress.Builder $i$a$-apply-HIDEventKt$hIDTouch$1$iv22 = $this$hIDPress_u24lambda_u2d4$iv;
            builder3 = $this$testPressAction_u24lambda_u2d7_u24lambda_u2d4;
            boolean bl14 = false;
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d4_u24lambda_u2d3.setAction(pressAction);
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d4_u24lambda_u2d3.setDirection(Idb.HIDEvent.HIDDirection.DOWN);
            builder3.setPress(builder8._build());
            streamObserver.onNext((Object)builder7._build());
            Thread.sleep(holdDelay);
            bl9 = false;
            builder7 = Idb.HIDEvent.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"newBuilder()");
            $this$hIDEvent_u24lambda_u2d0$iv = builder7 = HIDEventKt.Dsl.Companion._create(builder7);
            bl10 = false;
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d4 = $this$hIDEvent_u24lambda_u2d0$iv;
            streamObserver = stream;
            boolean bl15 = false;
            this_$iv3 = HIDEventKt.INSTANCE;
            bl12 = false;
            builder8 = Idb.HIDEvent.HIDPress.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"newBuilder()");
            $this$hIDPress_u24lambda_u2d4$iv = builder8 = HIDEventKt.HIDPressKt.Dsl.Companion._create(builder8);
            bl13 = false;
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d4_u24lambda_u2d3 = $this$hIDPress_u24lambda_u2d4$iv;
            builder3 = $this$testPressAction_u24lambda_u2d7_u24lambda_u2d6;
            boolean bl16 = false;
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d5.setAction(pressAction);
            $this$testPressAction_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d5.setDirection(Idb.HIDEvent.HIDDirection.UP);
            builder3.setPress(builder8._build());
            streamObserver.onNext((Object)builder7._build());
            stream.onCompleted();
            responseObserver.awaitResult();
            Unit unit = Unit.INSTANCE;
            result = (Result)new Ok((Object)unit);
        }
        catch (Throwable e$iv) {
            result = (Result)new Err((Object)e$iv);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isSocketAvailable(String host, int port) {
        boolean bl;
        try {
            boolean bl2;
            Closeable closeable = new Socket(host, port);
            Throwable throwable = null;
            try {
                Socket it = (Socket)closeable;
                boolean bl3 = false;
                bl2 = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = bl2;
        }
        catch (Exception _) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ Result access$testPressAction(LocalIdbRunner $this, ManagedChannel channel) {
        return $this.testPressAction(channel);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmaestro/LocalIdbRunner$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

