/*
 * Decompiled with CFR 0.152.
 */
package maestro;

import com.github.romankh3.image.comparison.ImageComparison;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.Driver;
import maestro.Filters;
import maestro.FindElementResult;
import maestro.KeyCode;
import maestro.MaestroException;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TreeNode;
import maestro.UiElement;
import maestro.ViewHierarchy;
import maestro.drivers.WebDriver;
import maestro.utils.MaestroTimer;
import maestro.utils.ScreenshotUtils;
import maestro.utils.SocketUtils;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000 \u0080\u00012\u00020\u0001:\u0002\u0080\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\"\u0010\u000e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000fj\u0002`\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0012J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0006H\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J3\u0010%\u001a\u0004\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u001c2\b\u0010'\u001a\u0004\u0018\u00010\u001c2\b\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010)J4\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\"\u001a\u00020#2\"\u0010\u000e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000fj\u0002`\u0010J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\u0012JE\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020.2\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107J\u000e\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u0015J\u0006\u0010:\u001a\u00020.J\u0006\u0010;\u001a\u00020.J(\u0010<\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\b\b\u0002\u0010>\u001a\u00020.J(\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010A\u001a\u00020.2\u0006\u0010B\u001a\u00020.JE\u0010C\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020.2\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bD\u00107J\u0018\u0010E\u001a\u00020\u00122\u0006\u0010F\u001a\u00020G2\b\b\u0002\u0010H\u001a\u00020.J\u0016\u0010I\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010J\u001a\u00020KJ\u0016\u0010L\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010M\u001a\u00020KJ\u0006\u0010N\u001a\u00020\u0012JE\u0010O\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020.2\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bP\u00107J\u0006\u0010Q\u001a\u00020\u0012J\u0016\u0010R\u001a\u00020\u00122\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020TJ\"\u0010V\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150XJ\u0018\u0010Y\u001a\u00020\u00122\b\b\u0002\u0010Z\u001a\u00020\u00152\u0006\u0010[\u001a\u00020\u001cJ\u000e\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010a\u001a\u00020\u00122\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\u001f2\u0006\u0010e\u001a\u00020#JJ\u0010a\u001a\u00020\u00122\n\b\u0002\u0010b\u001a\u0004\u0018\u00010c2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010g2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010g2\n\b\u0002\u0010i\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010j\u001a\u0004\u0018\u00010\u00152\u0006\u0010k\u001a\u00020#J\u0016\u0010l\u001a\u00020\u00122\u0006\u0010b\u001a\u00020c2\u0006\u0010e\u001a\u00020#J\u000e\u0010m\u001a\u00020\u00122\u0006\u0010J\u001a\u00020KJ*\u0010n\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020.JA\u0010n\u001a\u00020\u00122\u0006\u0010o\u001a\u00020\u001f2\u0006\u00104\u001a\u0002052\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010p\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020.\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bq\u0010rJ*\u0010s\u001a\u00020\u00122\u0006\u0010t\u001a\u00020\u001c2\u0006\u0010u\u001a\u00020\u001c2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u00103\u001a\u00020.J\u0016\u0010v\u001a\u000205\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bw\u0010xJ\u0015\u0010y\u001a\u00020\u00122\b\u0010z\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010{J!\u0010H\u001a\u0004\u0018\u0001052\n\b\u0002\u00104\u001a\u0004\u0018\u000105\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b|\u0010}J \u0010p\u001a\u0002052\u0006\u0010o\u001a\u00020\u001fH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b~\u0010\u007fR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0081\u0001"}, d2={"Lmaestro/Maestro;", "Ljava/lang/AutoCloseable;", "driver", "Lmaestro/Driver;", "(Lmaestro/Driver;)V", "cachedDeviceInfo", "Lmaestro/DeviceInfo;", "getCachedDeviceInfo", "()Lmaestro/DeviceInfo;", "cachedDeviceInfo$delegate", "Lkotlin/Lazy;", "allElementsMatching", "", "Lmaestro/TreeNode;", "filter", "Lkotlin/Function1;", "Lmaestro/ElementFilter;", "backPress", "", "clearAppState", "appId", "", "clearKeychain", "close", "deviceInfo", "deviceName", "eraseText", "charactersToErase", "", "fetchDeviceInfo", "findElementByIdRegex", "Lmaestro/UiElement;", "regex", "Lkotlin/text/Regex;", "timeoutMs", "", "findElementByRegexp", "findElementBySize", "width", "height", "tolerance", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;J)Lmaestro/UiElement;", "findElementWithTimeout", "Lmaestro/FindElementResult;", "getNumberOfRetries", "retryIfNoChange", "", "hideKeyboard", "hierarchyBasedTap", "x", "y", "longPress", "initialHierarchy", "Lmaestro/ViewHierarchy;", "hierarchyBasedTap-9V-jo0g", "(IIZZLmaestro/TreeNode;)V", "inputText", "text", "isShutDown", "isUnicodeInputSupported", "launchApp", "launchArguments", "stopIfRunning", "openLink", "link", "autoVerify", "browser", "performTap", "performTap-9V-jo0g", "pressKey", "code", "Lmaestro/KeyCode;", "waitForAppToSettle", "pullAppState", "outFile", "Ljava/io/File;", "pushAppState", "stateFile", "resetProxy", "screenshotBasedTap", "screenshotBasedTap-9V-jo0g", "scrollVertical", "setLocation", "latitude", "", "longitude", "setPermissions", "permissions", "", "setProxy", "host", "port", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "stopApp", "swipe", "swipeDirection", "Lmaestro/SwipeDirection;", "uiElement", "durationMs", "startPoint", "Lmaestro/Point;", "endPoint", "startRelative", "endRelative", "duration", "swipeFromCenter", "takeScreenshot", "tap", "element", "waitUntilVisible", "tap-egYXmKw", "(Lmaestro/UiElement;Lmaestro/TreeNode;ZZZ)V", "tapOnRelative", "percentX", "percentY", "viewHierarchy", "viewHierarchy-prqvCes", "()Lmaestro/TreeNode;", "waitForAnimationToEnd", "timeout", "(Ljava/lang/Long;)V", "waitForAppToSettle-LubAXRY", "(Lmaestro/TreeNode;)Lmaestro/TreeNode;", "waitUntilVisible-c1iYVAs", "(Lmaestro/UiElement;)Lmaestro/TreeNode;", "Companion", "maestro-client"})
public final class Maestro
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Driver driver;
    @NotNull
    private final Lazy cachedDeviceInfo$delegate;
    private static final Logger LOGGER = LoggerFactory.getLogger(Maestro.class);
    private static final double SCREENSHOT_DIFF_THRESHOLD = 0.005;
    private static final long ANIMATION_TIMEOUT_MS = 15000L;

    public Maestro(@NotNull Driver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.driver = driver;
        this.cachedDeviceInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeviceInfo>(this){
            final /* synthetic */ Maestro this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DeviceInfo invoke() {
                return Maestro.access$fetchDeviceInfo(this.this$0);
            }
        }));
    }

    private final DeviceInfo getCachedDeviceInfo() {
        Lazy lazy = this.cachedDeviceInfo$delegate;
        return (DeviceInfo)lazy.getValue();
    }

    @NotNull
    public final String deviceName() {
        return this.driver.name();
    }

    @NotNull
    public final DeviceInfo deviceInfo() {
        return this.getCachedDeviceInfo();
    }

    private final DeviceInfo fetchDeviceInfo() {
        LOGGER.info("Getting device info");
        return this.driver.deviceInfo();
    }

    public final void launchApp(@NotNull String appId, @NotNull List<String> launchArguments, boolean stopIfRunning) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        LOGGER.info(Intrinsics.stringPlus((String)"Launching app ", (Object)appId));
        if (stopIfRunning) {
            this.driver.stopApp(appId);
        }
        this.driver.launchApp(appId, launchArguments);
    }

    public static /* synthetic */ void launchApp$default(Maestro maestro, String string, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        maestro.launchApp(string, list, bl);
    }

    public final void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        LOGGER.info(Intrinsics.stringPlus((String)"Stopping app ", (Object)appId));
        this.driver.stopApp(appId);
    }

    public final void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        LOGGER.info(Intrinsics.stringPlus((String)"Clearing app state ", (Object)appId));
        this.driver.clearAppState(appId);
    }

    public final void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.driver.setPermissions(appId, permissions);
    }

    public final void clearKeychain() {
        LOGGER.info("Clearing keychain");
        this.driver.clearKeychain();
    }

    public final void pullAppState(@NotNull String appId, @NotNull File outFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
        LOGGER.info(Intrinsics.stringPlus((String)"Pulling app state: ", (Object)appId));
        this.driver.pullAppState(appId, outFile);
    }

    public final void pushAppState(@NotNull String appId, @NotNull File stateFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
        LOGGER.info(Intrinsics.stringPlus((String)"Pushing app state: ", (Object)appId));
        this.driver.pushAppState(appId, stateFile);
    }

    public final void backPress() {
        LOGGER.info("Pressing back");
        this.driver.backPress();
        Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
    }

    public final void hideKeyboard() {
        LOGGER.info("Hiding Keyboard");
        this.driver.hideKeyboard();
    }

    /*
     * WARNING - void declaration
     */
    public final void swipe(@Nullable SwipeDirection swipeDirection, @Nullable Point startPoint, @Nullable Point endPoint, @Nullable String startRelative, @Nullable String endRelative, long duration) {
        if (swipeDirection != null) {
            this.driver.swipe(swipeDirection, duration);
        } else if (startPoint != null && endPoint != null) {
            this.driver.swipe(startPoint, endPoint, duration);
        } else if (startRelative != null && endRelative != null) {
            void $this$mapTo$iv$iv;
            Collection collection;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv2;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)startRelative, (String)"%", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
            }
            List startPoints = (List)destination$iv$iv;
            int startX = this.getCachedDeviceInfo().getWidthGrid() * ((Number)startPoints.get(0)).intValue() / 100;
            int startY = this.getCachedDeviceInfo().getHeightGrid() * ((Number)startPoints.get(1)).intValue() / 100;
            Point start2 = new Point(startX, startY);
            String[] $i$f$mapTo22 = new String[]{","};
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)endRelative, (String)"%", (String)"", (boolean)false, (int)4, null), (String[])$i$f$mapTo22, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map2 = false;
            item$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
            }
            List endPoints = (List)destination$iv$iv2;
            int endX = this.getCachedDeviceInfo().getWidthGrid() * ((Number)endPoints.get(0)).intValue() / 100;
            int endY = this.getCachedDeviceInfo().getHeightGrid() * ((Number)endPoints.get(1)).intValue() / 100;
            Point end = new Point(endX, endY);
            this.driver.swipe(start2, end, duration);
        }
        Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
    }

    public static /* synthetic */ void swipe$default(Maestro maestro, SwipeDirection swipeDirection, Point point, Point point2, String string, String string2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            swipeDirection = null;
        }
        if ((n & 2) != 0) {
            point = null;
        }
        if ((n & 4) != 0) {
            point2 = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        maestro.swipe(swipeDirection, point, point2, string, string2, l);
    }

    public final void swipe(@NotNull SwipeDirection swipeDirection, @NotNull UiElement uiElement, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        Intrinsics.checkNotNullParameter((Object)uiElement, (String)"uiElement");
        LOGGER.info("Swiping " + swipeDirection.name() + " on element: " + uiElement);
        this.driver.swipe(uiElement.getBounds().center(), swipeDirection, durationMs);
        Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
    }

    public final void swipeFromCenter(@NotNull SwipeDirection swipeDirection, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        LOGGER.info("Swiping " + swipeDirection.name() + " from center");
        Point center = new Point(this.getCachedDeviceInfo().getWidthGrid() / 2, this.getCachedDeviceInfo().getHeightGrid() / 2);
        this.driver.swipe(center, swipeDirection, durationMs);
        Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
    }

    public final void scrollVertical() {
        LOGGER.info("Scrolling vertically");
        this.driver.scrollVertical();
        Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
    }

    public final void tap-egYXmKw(@NotNull UiElement element2, @NotNull TreeNode initialHierarchy, boolean retryIfNoChange, boolean waitUntilVisible, boolean longPress) {
        TreeNode hierarchyAfterTap;
        Object object;
        TreeNode hierarchyBeforeTap;
        TreeNode treeNode;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)initialHierarchy, (String)"initialHierarchy");
        LOGGER.info(Intrinsics.stringPlus((String)"Tapping on element: ", (Object)element2));
        TreeNode treeNode2 = this.waitForAppToSettle-LubAXRY(initialHierarchy);
        if (treeNode2 == null) {
            treeNode2 = initialHierarchy;
        }
        if ((treeNode = ViewHierarchy.refreshElement-impl(hierarchyBeforeTap = treeNode2, element2.getTreeNode())) == null) {
            object = element2;
        } else {
            Object object2 = treeNode;
            TreeNode it = object2;
            boolean bl = false;
            LOGGER.info("Refreshed element");
            TreeNode treeNode3 = object2;
            object2 = UiElement.Companion.toUiElementOrNull(treeNode3);
            object = object2 == null ? element2 : object2;
        }
        Point center = ((UiElement)object).getBounds().center();
        this.performTap-9V-jo0g(center.getX(), center.getY(), retryIfNoChange, longPress, hierarchyBeforeTap);
        if (waitUntilVisible && ViewHierarchy.equals-impl0(hierarchyBeforeTap, hierarchyAfterTap = this.viewHierarchy-prqvCes()) && !ViewHierarchy.isVisible-impl(hierarchyAfterTap, element2.getTreeNode())) {
            LOGGER.info("Still no change in hierarchy. Wait until element is visible and try again.");
            TreeNode hierarchy = this.waitUntilVisible-c1iYVAs(element2);
            this.tap-egYXmKw(element2, hierarchy, false, false, longPress);
        }
    }

    public static /* synthetic */ void tap-egYXmKw$default(Maestro maestro, UiElement uiElement, TreeNode treeNode, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        maestro.tap-egYXmKw(uiElement, treeNode, bl, bl2, bl3);
    }

    public final void tapOnRelative(int percentX, int percentY, boolean retryIfNoChange, boolean longPress) {
        int x = this.getCachedDeviceInfo().getWidthGrid() * percentX / 100;
        int y = this.getCachedDeviceInfo().getHeightGrid() * percentY / 100;
        this.tap(x, y, retryIfNoChange, longPress);
    }

    public static /* synthetic */ void tapOnRelative$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        maestro.tapOnRelative(n, n2, bl, bl2);
    }

    public final void tap(int x, int y, boolean retryIfNoChange, boolean longPress) {
        Maestro.performTap-9V-jo0g$default(this, x, y, retryIfNoChange, longPress, null, 16, null);
    }

    public static /* synthetic */ void tap$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        maestro.tap(n, n2, bl, bl2);
    }

    private final int getNumberOfRetries(boolean retryIfNoChange) {
        return retryIfNoChange ? 2 : 1;
    }

    private final void performTap-9V-jo0g(int x, int y, boolean retryIfNoChange, boolean longPress, TreeNode initialHierarchy) {
        List<Capability> capabilities = this.driver.capabilities();
        if (capabilities.contains((Object)Capability.FAST_HIERARCHY)) {
            this.hierarchyBasedTap-9V-jo0g(x, y, retryIfNoChange, longPress, initialHierarchy);
        } else {
            this.screenshotBasedTap-9V-jo0g(x, y, retryIfNoChange, longPress, initialHierarchy);
        }
    }

    static /* synthetic */ void performTap-9V-jo0g$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TreeNode treeNode, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            treeNode = null;
        }
        maestro.performTap-9V-jo0g(n, n2, bl, bl2, treeNode);
    }

    private final void screenshotBasedTap-9V-jo0g(int x, int y, boolean retryIfNoChange, boolean longPress, TreeNode initialHierarchy) {
        LOGGER.info("Tapping at (" + x + ", " + y + ") using screenshot based logic for wait");
        TreeNode treeNode = initialHierarchy;
        if (treeNode == null) {
            treeNode = this.viewHierarchy-prqvCes();
        }
        TreeNode hierarchyBeforeTap = treeNode;
        int retries = this.getNumberOfRetries(retryIfNoChange);
        for (int i = 0; i < retries; ++i) {
            int it = i;
            boolean bl = false;
            if (longPress) {
                this.driver.longPress(new Point(x, y));
            } else {
                this.driver.tap(new Point(x, y));
            }
            TreeNode hierarchyAfterTap = Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
            if (hierarchyAfterTap != null && ViewHierarchy.equals-impl0(hierarchyBeforeTap, hierarchyAfterTap)) continue;
            LOGGER.info("Something have changed in the UI judging by view hierarchy. Proceed.");
            return;
        }
    }

    static /* synthetic */ void screenshotBasedTap-9V-jo0g$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TreeNode treeNode, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            treeNode = null;
        }
        maestro.screenshotBasedTap-9V-jo0g(n, n2, bl, bl2, treeNode);
    }

    private final void hierarchyBasedTap-9V-jo0g(int x, int y, boolean retryIfNoChange, boolean longPress, TreeNode initialHierarchy) {
        LOGGER.info("Tapping at (" + x + ", " + y + ") using hierarchy based logic for wait");
        TreeNode treeNode = initialHierarchy;
        if (treeNode == null) {
            treeNode = this.viewHierarchy-prqvCes();
        }
        TreeNode hierarchyBeforeTap = treeNode;
        BufferedImage screenshotBeforeTap = ScreenshotUtils.Companion.tryTakingScreenshot(this.driver);
        int retries = this.getNumberOfRetries(retryIfNoChange);
        for (int i = 0; i < retries; ++i) {
            TreeNode hierarchyAfterTap;
            int it = i;
            boolean bl = false;
            if (longPress) {
                this.driver.longPress(new Point(x, y));
            } else {
                this.driver.tap(new Point(x, y));
            }
            TreeNode treeNode2 = hierarchyAfterTap = Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
            if (!(treeNode2 == null ? false : ViewHierarchy.equals-impl0(hierarchyBeforeTap, treeNode2))) {
                LOGGER.info("Something have changed in the UI judging by view hierarchy. Proceed.");
                return;
            }
            BufferedImage screenshotAfterTap = ScreenshotUtils.Companion.tryTakingScreenshot(this.driver);
            if (screenshotBeforeTap != null && screenshotAfterTap != null && screenshotBeforeTap.getWidth() == screenshotAfterTap.getWidth() && screenshotBeforeTap.getHeight() == screenshotAfterTap.getHeight()) {
                float imageDiff = new ImageComparison(screenshotBeforeTap, screenshotAfterTap).compareImages().getDifferencePercent();
                if ((double)imageDiff > 0.005) {
                    LOGGER.info("Something have changed in the UI judging by screenshot (d=" + imageDiff + "). Proceed.");
                    return;
                }
                LOGGER.info("Screenshots are not different enough (d=" + imageDiff + ')');
            } else {
                LOGGER.info("Skipping screenshot comparison");
            }
            LOGGER.info("Nothing changed in the UI.");
        }
    }

    static /* synthetic */ void hierarchyBasedTap-9V-jo0g$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TreeNode treeNode, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            treeNode = null;
        }
        maestro.hierarchyBasedTap-9V-jo0g(n, n2, bl, bl2, treeNode);
    }

    private final TreeNode waitUntilVisible-c1iYVAs(UiElement element2) {
        TreeNode hierarchy = null;
        hierarchy = ViewHierarchy.constructor-impl(new TreeNode(null, null, null, null, null, null, null, 127, null));
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            hierarchy = this.viewHierarchy-prqvCes();
            if (ViewHierarchy.isVisible-impl(hierarchy, element2.getTreeNode())) {
                LOGGER.info("Element became visible.");
                return hierarchy;
            }
            LOGGER.info("Element is not visible yet. Waiting.");
            MaestroTimer.INSTANCE.getSleep().invoke((Object)MaestroTimer.Reason.WAIT_UNTIL_VISIBLE, (Object)1000L);
        }
        return hierarchy;
    }

    public final void pressKey(@NotNull KeyCode code, boolean waitForAppToSettle) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        LOGGER.info(Intrinsics.stringPlus((String)"Pressing key ", (Object)((Object)code)));
        this.driver.pressKey(code);
        if (waitForAppToSettle) {
            Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
        }
    }

    public static /* synthetic */ void pressKey$default(Maestro maestro, KeyCode keyCode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        maestro.pressKey(keyCode, bl);
    }

    @NotNull
    public final UiElement findElementByRegexp(@NotNull Regex regex, long timeoutMs) {
        UiElement uiElement;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        LOGGER.info("Looking for element by regex: " + regex.getPattern() + " (timeout " + timeoutMs + ')');
        FindElementResult findElementResult = this.findElementWithTimeout(timeoutMs, Filters.INSTANCE.textMatches(regex));
        UiElement uiElement2 = uiElement = findElementResult == null ? null : findElementResult.getElement();
        if (uiElement == null) {
            throw new MaestroException.ElementNotFound(Intrinsics.stringPlus((String)"No element that matches regex: ", (Object)regex), this.viewHierarchy-prqvCes());
        }
        return uiElement;
    }

    @NotNull
    public final TreeNode viewHierarchy-prqvCes() {
        return ViewHierarchy.Companion.from-c1iYVAs(this.driver);
    }

    @NotNull
    public final UiElement findElementByIdRegex(@NotNull Regex regex, long timeoutMs) {
        UiElement uiElement;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        LOGGER.info("Looking for element by id regex: " + regex.getPattern() + " (timeout " + timeoutMs + ')');
        FindElementResult findElementResult = this.findElementWithTimeout(timeoutMs, Filters.INSTANCE.idMatches(regex));
        UiElement uiElement2 = uiElement = findElementResult == null ? null : findElementResult.getElement();
        if (uiElement == null) {
            throw new MaestroException.ElementNotFound(Intrinsics.stringPlus((String)"No element has id that matches regex ", (Object)regex), this.viewHierarchy-prqvCes());
        }
        return uiElement;
    }

    @Nullable
    public final UiElement findElementBySize(@Nullable Integer width, @Nullable Integer height, @Nullable Integer tolerance, long timeoutMs) {
        LOGGER.info("Looking for element by size: " + width + " x " + height + " (tolerance " + tolerance + ") (timeout " + timeoutMs + ')');
        FindElementResult findElementResult = this.findElementWithTimeout(timeoutMs, Filters.INSTANCE.asFilter(Filters.INSTANCE.sizeMatches(width, height, tolerance)));
        return findElementResult == null ? null : findElementResult.getElement();
    }

    @Nullable
    public final FindElementResult findElementWithTimeout(long timeoutMs, @NotNull Function1<? super List<TreeNode>, ? extends List<TreeNode>> filter) {
        UiElement element2;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Ref.ObjectRef hierarchy = new Ref.ObjectRef();
        hierarchy.element = ViewHierarchy.constructor-impl(new TreeNode(null, null, null, null, null, null, null, 127, null));
        TreeNode treeNode = (TreeNode)MaestroTimer.INSTANCE.withTimeout(timeoutMs, (Function0)new Function0<TreeNode>((Ref.ObjectRef<ViewHierarchy>)hierarchy, this, filter){
            final /* synthetic */ Ref.ObjectRef<ViewHierarchy> $hierarchy;
            final /* synthetic */ Maestro this$0;
            final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $filter;
            {
                this.$hierarchy = $hierarchy;
                this.this$0 = $receiver;
                this.$filter = $filter;
                super(0);
            }

            @Nullable
            public final TreeNode invoke() {
                this.$hierarchy.element = this.this$0.viewHierarchy-prqvCes();
                return (TreeNode)CollectionsKt.firstOrNull((List)((List)this.$filter.invoke(ViewHierarchy.aggregate-impl((TreeNode)this.$hierarchy.element))));
            }
        });
        UiElement uiElement = element2 = treeNode == null ? null : UiElement.Companion.toUiElementOrNull(treeNode);
        if (element2 != null) {
            return new FindElementResult(element2, (TreeNode)hierarchy.element, null);
        }
        return null;
    }

    @NotNull
    public final List<TreeNode> allElementsMatching(@NotNull Function1<? super List<TreeNode>, ? extends List<TreeNode>> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return (List)filter.invoke(ViewHierarchy.aggregate-impl(this.viewHierarchy-prqvCes()));
    }

    @Nullable
    public final TreeNode waitForAppToSettle-LubAXRY(@Nullable TreeNode initialHierarchy) {
        return this.driver.waitForAppToSettle-LubAXRY(initialHierarchy);
    }

    public static /* synthetic */ TreeNode waitForAppToSettle-LubAXRY$default(Maestro maestro, TreeNode treeNode, int n, Object object) {
        if ((n & 1) != 0) {
            treeNode = null;
        }
        return maestro.waitForAppToSettle-LubAXRY(treeNode);
    }

    public final void inputText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LOGGER.info(Intrinsics.stringPlus((String)"Inputting text: ", (Object)text));
        this.driver.inputText(text);
        Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
    }

    public final void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        LOGGER.info("Opening link " + link + " for app: " + appId + " with autoVerify config as " + autoVerify);
        this.driver.openLink(link, appId, autoVerify, browser);
        Maestro.waitForAppToSettle-LubAXRY$default(this, null, 1, null);
    }

    @Override
    public void close() {
        this.driver.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void takeScreenshot(@NotNull File outFile) {
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
        LOGGER.info(Intrinsics.stringPlus((String)"Taking screenshot: ", (Object)outFile));
        File absoluteOutFile = outFile.getAbsoluteFile();
        if (absoluteOutFile.getParentFile().exists() || absoluteOutFile.getParentFile().mkdirs()) {
            Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)outFile, (boolean)false, (int)1, null));
            Throwable throwable = null;
            try {
                BufferedSink it = (BufferedSink)closeable;
                boolean bl = false;
                ScreenshotUtils.Companion.takeScreenshot((Sink)it, false, this.driver);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            throw new MaestroException.DestinationIsNotWritable(Intrinsics.stringPlus((String)"Failed to create directory for screenshot: ", (Object)absoluteOutFile.getParentFile()));
        }
    }

    @NotNull
    public final ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        LOGGER.info("Starting screen recording");
        ScreenRecording screenRecording = this.driver.startScreenRecording(out);
        long startTimestamp = System.currentTimeMillis();
        return new ScreenRecording(startTimestamp, screenRecording){
            final /* synthetic */ long $startTimestamp;
            final /* synthetic */ ScreenRecording $screenRecording;
            {
                this.$startTimestamp = $startTimestamp;
                this.$screenRecording = $screenRecording;
            }

            public void close() {
                Maestro.access$getLOGGER$cp().info("Stopping screen recording");
                long durationPadding = (long)3000 - (System.currentTimeMillis() - this.$startTimestamp);
                if (durationPadding > 0L) {
                    Thread.sleep(durationPadding);
                }
                this.$screenRecording.close();
            }
        };
    }

    public final void setLocation(double latitude, double longitude) {
        LOGGER.info("Setting location: (" + latitude + ", " + longitude + ')');
        this.driver.setLocation(latitude, longitude);
    }

    public final void eraseText(int charactersToErase) {
        LOGGER.info("Erasing " + charactersToErase + " characters");
        this.driver.eraseText(charactersToErase);
    }

    public final void waitForAnimationToEnd(@Nullable Long timeout) {
        Long l = timeout;
        long timeout2 = l == null ? 15000L : l;
        LOGGER.info(Intrinsics.stringPlus((String)"Waiting for animation to end with timeout ", (Object)timeout2));
        ScreenshotUtils.Companion.waitUntilScreenIsStatic(timeout2, 0.005, this.driver);
    }

    public final void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        LOGGER.info("Setting proxy: " + host + ':' + port);
        this.driver.setProxy(host, port);
    }

    public static /* synthetic */ void setProxy$default(Maestro maestro, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = SocketUtils.INSTANCE.localIp();
        }
        maestro.setProxy(string, n);
    }

    public final void resetProxy() {
        LOGGER.info("Resetting proxy");
        this.driver.resetProxy();
    }

    public final boolean isShutDown() {
        return this.driver.isShutdown();
    }

    public final boolean isUnicodeInputSupported() {
        return this.driver.isUnicodeInputSupported();
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ DeviceInfo access$fetchDeviceInfo(Maestro $this) {
        return $this.fetchDeviceInfo();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmaestro/Maestro$Companion;", "", "()V", "ANIMATION_TIMEOUT_MS", "", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SCREENSHOT_DIFF_THRESHOLD", "", "android", "Lmaestro/Maestro;", "driver", "Lmaestro/Driver;", "openDriver", "", "ios", "web", "isStudio", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Maestro ios(@NotNull Driver driver, boolean openDriver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            if (openDriver) {
                driver.open();
            }
            return new Maestro(driver);
        }

        public static /* synthetic */ Maestro ios$default(Companion companion, Driver driver, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.ios(driver, bl);
        }

        @NotNull
        public final Maestro android(@NotNull Driver driver, boolean openDriver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            if (openDriver) {
                driver.open();
            }
            return new Maestro(driver);
        }

        public static /* synthetic */ Maestro android$default(Companion companion, Driver driver, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.android(driver, bl);
        }

        @NotNull
        public final Maestro web(boolean isStudio) {
            WebDriver driver = new WebDriver(isStudio);
            driver.open();
            return new Maestro(driver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

