/*
 * Decompiled with CFR 0.152.
 */
package maestro.android;

import dadb.AdbShellResponse;
import dadb.AdbStream;
import dadb.Dadb;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004J(\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0004J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lmaestro/android/AndroidAppFiles;", "", "()V", "getApkFile", "Ljava/io/File;", "dadb", "Ldadb/Dadb;", "appId", "", "listRemoteFiles", "", "packageName", "options", "pull", "", "zipOutFile", "pullAppFile", "localPath", "Ljava/nio/file/Path;", "remotePath", "push", "appFilesZip", "shell", "command", "maestro-client"})
public final class AndroidAppFiles {
    @NotNull
    public static final AndroidAppFiles INSTANCE = new AndroidAppFiles();

    private AndroidAppFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pull(@NotNull Dadb dadb, @NotNull String packageName, @NotNull File zipOutFile) {
        Intrinsics.checkNotNullParameter((Object)dadb, (String)"dadb");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)zipOutFile, (String)"zipOutFile");
        zipOutFile.delete();
        URI zipOutUri = new URI(Intrinsics.stringPlus((String)"jar:", (Object)zipOutFile.toURI().getScheme()), zipOutFile.getAbsolutePath(), null);
        Closeable closeable = FileSystems.newFileSystem(zipOutUri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"true")));
        Throwable throwable = null;
        try {
            Path dstPath;
            String dstLocation;
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = INSTANCE.listRemoteFiles(dadb, packageName, "-type d");
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String remoteDir = (String)element$iv;
                boolean bl2 = false;
                dstLocation = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)remoteDir, (CharSequence)"/"), (CharSequence)"/."), (CharSequence)"/");
                dstPath = fs.getPath(dstLocation, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)dstPath, (String)"dstPath");
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dstPath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
            }
            $this$forEach$iv = INSTANCE.listRemoteFiles(dadb, packageName, "-type f");
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String remoteFile = (String)element$iv;
                boolean bl3 = false;
                dstLocation = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)remoteFile, (CharSequence)"/"), (CharSequence)"/."), (CharSequence)"/");
                dstPath = fs.getPath(dstLocation, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)dstPath, (String)"dstPath");
                INSTANCE.pullAppFile(dadb, packageName, dstPath, remoteFile);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final File getApkFile(@NotNull Dadb dadb, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)dadb, (String)"dadb");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        String apkPath = StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)dadb.shell("pm list packages -f --user 0 | grep " + appId + " | head -1").getOutput(), (String)"package:", null, (int)2, null), (String)Intrinsics.stringPlus((String)"=", (Object)appId), null, (int)2, null);
        StringsKt.substringBefore$default((String)apkPath, (String)Intrinsics.stringPlus((String)"=", (Object)appId), null, (int)2, null);
        File dst = File.createTempFile("tmp", ".apk");
        Intrinsics.checkNotNullExpressionValue((Object)dst, (String)"dst");
        dadb.pull(dst, apkPath);
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void push(@NotNull Dadb dadb, @NotNull String packageName, @NotNull File appFilesZip) {
        Intrinsics.checkNotNullParameter((Object)dadb, (String)"dadb");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)appFilesZip, (String)"appFilesZip");
        String remoteZip = "/data/local/tmp/app.zip";
        Dadb.DefaultImpls.push$default((Dadb)dadb, (File)appFilesZip, (String)remoteZip, (int)0, (long)0L, (int)12, null);
        try {
            this.shell(dadb, "run-as " + packageName + " unzip -o -d / " + remoteZip);
        }
        finally {
            this.shell(dadb, Intrinsics.stringPlus((String)"rm ", (Object)remoteZip));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pullAppFile(Dadb dadb, String packageName, Path localPath, String remotePath) {
        AutoCloseable autoCloseable = (AutoCloseable)dadb.open("exec:run-as " + packageName + " cat " + remotePath);
        Throwable throwable = null;
        try {
            AdbStream stream = (AdbStream)autoCloseable;
            boolean bl = false;
            long l = Files.copy(stream.getSource().inputStream(), localPath, new CopyOption[0]);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> listRemoteFiles(Dadb dadb, String packageName, String options) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String result = this.shell(dadb, "run-as " + packageName + " find " + options);
        String appDataDir = Intrinsics.stringPlus((String)"/data/data/", (Object)packageName);
        Iterable iterable = StringsKt.lines((CharSequence)result);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(appDataDir + '/' + StringsKt.removePrefix((String)it, (CharSequence)"./"));
        }
        return (List)destination$iv$iv;
    }

    private final String shell(Dadb dadb, String command) {
        AdbShellResponse response = dadb.shell(command);
        if (response.getExitCode() != 0) {
            throw new IOException("Shell command failed (" + command + "):\n" + response.getAllOutput());
        }
        return response.getAllOutput();
    }
}

