/*
 * Decompiled with CFR 0.152.
 */
package maestro.android;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import maestro.android.AndroidBuildToolsDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lmaestro/android/AndroidBuildToolsDirectory;", "", "()V", "findBuildToolsDir", "Ljava/io/File;", "androidHome", "getLatestToolsVersion", "Lmaestro/android/AndroidBuildToolsDirectory$BuildToolsVersion;", "buildToolsParent", "BuildToolsVersion", "maestro-client"})
public final class AndroidBuildToolsDirectory {
    @NotNull
    public static final AndroidBuildToolsDirectory INSTANCE = new AndroidBuildToolsDirectory();

    private AndroidBuildToolsDirectory() {
    }

    @NotNull
    public final File findBuildToolsDir(@NotNull File androidHome) {
        Intrinsics.checkNotNullParameter((Object)androidHome, (String)"androidHome");
        File buildToolsParent = new File(androidHome, "build-tools");
        if (!buildToolsParent.exists()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"build-tools directory does not exist: ", (Object)buildToolsParent));
        }
        BuildToolsVersion buildToolsVersion = this.getLatestToolsVersion(buildToolsParent);
        if (buildToolsVersion == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Could not find a valid build-tools subdirectory in ", (Object)buildToolsParent));
        }
        BuildToolsVersion latestBuildToolsVersion = buildToolsVersion;
        return new File(buildToolsParent, latestBuildToolsVersion.toString());
    }

    /*
     * WARNING - void declaration
     */
    private final BuildToolsVersion getLatestToolsVersion(File buildToolsParent) {
        Object object;
        void $this$mapNotNullTo$iv$iv;
        File[] fileArray = buildToolsParent.listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        File[] $this$mapNotNull$iv = fileArray;
        boolean $i$f$mapNotNull = false;
        Object object2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            BuildToolsVersion it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            if (BuildToolsVersion.Companion.parse(string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            BuildToolsVersion it = (BuildToolsVersion)iterator.next();
            boolean bl = false;
            object2 = it;
            while (iterator.hasNext()) {
                BuildToolsVersion it2 = (BuildToolsVersion)iterator.next();
                $i$a$-maxOfOrNull-AndroidBuildToolsDirectory$getLatestToolsVersion$2 = false;
                Comparable comparable = it2;
                if (object2.compareTo(comparable) >= 0) continue;
                object2 = comparable;
            }
            object = object2;
        }
        return (BuildToolsVersion)object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lmaestro/android/AndroidBuildToolsDirectory$BuildToolsVersion;", "", "major", "", "minor", "patch", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "compareTo", "other", "toString", "", "Companion", "maestro-client"})
    private static final class BuildToolsVersion
    implements Comparable<BuildToolsVersion> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int major;
        private final int minor;
        private final int patch;
        private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)");
        @NotNull
        private static final Comparator<BuildToolsVersion> VERSION_COMPARATOR;

        public BuildToolsVersion(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getPatch() {
            return this.patch;
        }

        @NotNull
        public String toString() {
            return "" + this.major + '.' + this.minor + '.' + this.patch;
        }

        @Override
        public int compareTo(@NotNull BuildToolsVersion other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return VERSION_COMPARATOR.compare(this, other);
        }

        static {
            Function1[] function1Array = new Function1[]{Companion.VERSION_COMPARATOR.1.INSTANCE, Companion.VERSION_COMPARATOR.2.INSTANCE, Companion.VERSION_COMPARATOR.3.INSTANCE};
            VERSION_COMPARATOR = ComparisonsKt.compareBy((Function1[])function1Array);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmaestro/android/AndroidBuildToolsDirectory$BuildToolsVersion$Companion;", "", "()V", "VERSION_COMPARATOR", "Ljava/util/Comparator;", "Lmaestro/android/AndroidBuildToolsDirectory$BuildToolsVersion;", "Lkotlin/Comparator;", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parse", "name", "", "maestro-client"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final BuildToolsVersion parse(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Matcher m = VERSION_PATTERN.matcher(name);
                if (!m.matches()) {
                    return null;
                }
                String string = m.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(1)");
                int n = Integer.parseInt(string);
                string = m.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(2)");
                int n2 = Integer.parseInt(string);
                string = m.group(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(3)");
                return new BuildToolsVersion(n, n2, Integer.parseInt(string));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

