/*
 * Decompiled with CFR 0.152.
 */
package maestro.android;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import maestro.android.AndroidBuildToolsDirectory;
import maestro.utils.TemporaryDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pxb.android.axml.AxmlReader;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.AxmlWriter;
import pxb.android.axml.NodeVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\tH\u0002J\"\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\rH\u0002\u00a8\u0006\u0018"}, d2={"Lmaestro/android/ApkDebuggable;", "", "()V", "createDebuggableManifestBytes", "", "originalManifestBytes", "enable", "", "apkFile", "Ljava/io/File;", "apkOutFile", "getOriginalManifestBytes", "isManifestDebuggable", "", "manifestBytes", "isManifestDebuggable$maestro_client", "requireAndroidHome", "requireDebugKeystore", "runShell", "cwd", "Ljava/nio/file/Path;", "script", "", "ignoreError", "maestro-client"})
public final class ApkDebuggable {
    @NotNull
    public static final ApkDebuggable INSTANCE = new ApkDebuggable();

    private ApkDebuggable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enable(@NotNull File apkFile, @NotNull File apkOutFile) {
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        Intrinsics.checkNotNullParameter((Object)apkOutFile, (String)"apkOutFile");
        byte[] originalManifestBytes = this.getOriginalManifestBytes(apkFile);
        if (this.isManifestDebuggable$maestro_client(originalManifestBytes)) {
            FilesKt.copyTo$default((File)apkFile, (File)apkOutFile, (boolean)true, (int)0, (int)4, null);
            return;
        }
        File androidHome = this.requireAndroidHome();
        File debugKeystore = this.requireDebugKeystore();
        File buildToolsDir = AndroidBuildToolsDirectory.INSTANCE.findBuildToolsDir(androidHome);
        byte[] debuggableManifestBytes = this.createDebuggableManifestBytes(originalManifestBytes);
        TemporaryDirectory this_$iv = TemporaryDirectory.INSTANCE;
        boolean $i$f$use = false;
        Path tmpDir$iv = Files.createTempDirectory(null, new FileAttribute[0]);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir$iv, (String)"tmpDir");
            Path workDir = tmpDir$iv;
            boolean bl = false;
            Path apkPath = workDir.resolve("tmp.apk");
            Path manifestPath = workDir.resolve("AndroidManifest.xml");
            Comparable<File> comparable = apkPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"apkPath.toFile()");
            FilesKt.copyTo$default((File)apkFile, (File)comparable, (boolean)false, (int)0, (int)6, null);
            Intrinsics.checkNotNullExpressionValue((Object)manifestPath, (String)"manifestPath");
            comparable = manifestPath;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write((Path)comparable, debuggableManifestBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
            ApkDebuggable.runShell$default(INSTANCE, workDir, "zip " + apkPath + " AndroidManifest.xml", false, 4, null);
            ApkDebuggable.runShell$default(INSTANCE, workDir, buildToolsDir + "/zipalign -p -f 4 " + apkPath + ' ' + apkPath + ".aligned", false, 4, null);
            ApkDebuggable.runShell$default(INSTANCE, workDir, buildToolsDir + "/apksigner sign --ks " + debugKeystore + " --ks-pass pass:android --ks-key-alias androiddebugkey --key-pass pass:android " + apkPath + ".aligned", false, 4, null);
            Path path = Files.move(Paths.get(apkPath + ".aligned", new String[0]), apkOutFile.toPath(), new CopyOption[0]);
        }
        finally {
            File file = tmpDir$iv.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir.toFile()");
            FilesKt.deleteRecursively((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getOriginalManifestBytes(File apkFile) {
        Closeable closeable = FileSystems.newFileSystem(apkFile.toPath(), null);
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            Path manifestPath = fs.getPath("AndroidManifest.xml", new String[0]);
            byte[] byArray = Files.readAllBytes(manifestPath);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(manifestPath)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final byte[] createDebuggableManifestBytes(byte[] originalManifestBytes) {
        AxmlReader reader = new AxmlReader(originalManifestBytes);
        AxmlWriter writer = new AxmlWriter();
        reader.accept(new AxmlVisitor(writer){
            final /* synthetic */ AxmlWriter $writer;
            {
                this.$writer = $writer;
                super((NodeVisitor)$writer);
            }

            public void ns(@Nullable String prefix, @Nullable String uri, int ln) {
                if (uri != null) {
                    super.ns(prefix, uri, ln);
                }
            }

            @NotNull
            public NodeVisitor child(@Nullable String ns, @Nullable String name) {
                NodeVisitor nodeVisitor = super.child(ns, name);
                return new NodeVisitor(nodeVisitor){

                    @Nullable
                    public NodeVisitor child(@Nullable String ns, @Nullable String name) {
                        if (!Intrinsics.areEqual((Object)name, (Object)"application")) {
                            return super.child(ns, name);
                        }
                        NodeVisitor nodeVisitor = super.child(ns, name);
                        return new NodeVisitor(nodeVisitor){

                            public void attr(@Nullable String ns, @Nullable String name, int resourceId, int type, @Nullable Object obj) {
                                if (Intrinsics.areEqual((Object)name, (Object)"debuggable")) {
                                    return;
                                }
                                super.attr(ns, name, resourceId, type, obj);
                            }

                            public void end() {
                                super.attr("http://schemas.android.com/apk/res/android", "debuggable", 0x101000F, 18, (Object)-1);
                                super.end();
                            }
                        };
                    }
                };
            }
        });
        byte[] byArray = writer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writer.toByteArray()");
        return byArray;
    }

    public final boolean isManifestDebuggable$maestro_client(@NotNull byte[] manifestBytes) {
        Intrinsics.checkNotNullParameter((Object)manifestBytes, (String)"manifestBytes");
        AtomicBoolean isDebuggable = new AtomicBoolean(false);
        AxmlReader reader = new AxmlReader(manifestBytes);
        reader.accept(new AxmlVisitor(isDebuggable){
            final /* synthetic */ AtomicBoolean $isDebuggable;
            {
                this.$isDebuggable = $isDebuggable;
                super(null);
            }

            @NotNull
            public NodeVisitor child(@Nullable String ns, @Nullable String name) {
                NodeVisitor nodeVisitor = super.child(ns, name);
                return new NodeVisitor(this.$isDebuggable, nodeVisitor){
                    final /* synthetic */ AtomicBoolean $isDebuggable;
                    {
                        this.$isDebuggable = $isDebuggable;
                        super($super_call_param$1);
                    }

                    @Nullable
                    public NodeVisitor child(@Nullable String ns, @Nullable String name) {
                        if (!Intrinsics.areEqual((Object)name, (Object)"application")) {
                            return super.child(ns, name);
                        }
                        NodeVisitor nodeVisitor = super.child(ns, name);
                        return new NodeVisitor(this.$isDebuggable, nodeVisitor){
                            final /* synthetic */ AtomicBoolean $isDebuggable;
                            {
                                this.$isDebuggable = $isDebuggable;
                                super($super_call_param$1);
                            }

                            public void attr(@Nullable String ns, @Nullable String name, int resourceId, int type, @Nullable Object obj) {
                                if (Intrinsics.areEqual((Object)name, (Object)"debuggable")) {
                                    this.$isDebuggable.set(Intrinsics.areEqual((Object)obj, (Object)true));
                                }
                                super.attr(ns, name, resourceId, type, obj);
                            }
                        };
                    }
                };
            }
        });
        return isDebuggable.get();
    }

    private final File requireAndroidHome() {
        String androidSdkRoot = System.getenv("ANDROID_SDK_ROOT");
        if (androidSdkRoot != null && !StringsKt.isBlank((CharSequence)androidSdkRoot)) {
            return new File(androidSdkRoot);
        }
        String androidHome = System.getenv("ANDROID_HOME_ROOT");
        if (androidHome == null || StringsKt.isBlank((CharSequence)androidHome)) {
            throw new IllegalStateException("$ANDROID_SDK_ROOT or $ANDROID_HOME must be set");
        }
        return new File(androidHome);
    }

    private final File requireDebugKeystore() {
        String home = System.getenv("HOME");
        if (home == null || StringsKt.isBlank((CharSequence)home)) {
            throw new IllegalStateException("$HOME must be set");
        }
        File debugKeystore = new File(Intrinsics.stringPlus((String)home, (Object)"/.android/debug.keystore"));
        if (!debugKeystore.exists()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Could not find debug keystore at ", (Object)debugKeystore));
        }
        return debugKeystore;
    }

    private final void runShell(Path cwd, String script, boolean ignoreError) {
        Object[] objectArray = new String[]{"bash", "-c", "cd " + cwd + " && " + script};
        Process process = new ProcessBuilder(new String[0]).command(CollectionsKt.listOf((Object[])objectArray)).redirectErrorStream(true).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        String output = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        if (!ignoreError && process.waitFor() != 0) {
            throw new IllegalStateException("Command failed: " + script + '\n' + output);
        }
    }

    static /* synthetic */ void runShell$default(ApkDebuggable apkDebuggable, Path path, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        apkDebuggable.runShell(path, string, bl);
    }
}

