/*
 * Decompiled with CFR 0.152.
 */
package maestro.debuglog;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import maestro.Driver;
import maestro.utils.FileUtils;
import net.harawata.appdirs.AppDirsFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lmaestro/debuglog/DebugLogStore;", "", "()V", "APP_AUTHOR", "", "APP_NAME", "KEEP_LOG_COUNT", "", "LOG_DIR_DATE_FORMAT", "consoleHandler", "Ljava/util/logging/ConsoleHandler;", "currentRunLogDirectory", "Ljava/io/File;", "fileHandler", "Ljava/util/logging/FileHandler;", "logDirectory", "getLogDirectory", "()Ljava/io/File;", "appVersion", "finalizeRun", "", "logFile", "named", "logOutputOf", "processBuilder", "Ljava/lang/ProcessBuilder;", "logSystemInfo", "loggerFor", "Ljava/util/logging/Logger;", "clazz", "Ljava/lang/Class;", "removeOldLogs", "baseDir", "maestro-client"})
public final class DebugLogStore {
    @NotNull
    public static final DebugLogStore INSTANCE = new DebugLogStore();
    @NotNull
    private static final String APP_NAME = "maestro";
    @NotNull
    private static final String APP_AUTHOR = "mobile_dev";
    @NotNull
    private static final String LOG_DIR_DATE_FORMAT = "yyyy-MM-dd_HHmmss";
    private static final int KEEP_LOG_COUNT = 6;
    @NotNull
    private static final File logDirectory = new File(AppDirsFactory.getInstance().getUserLogDir("maestro", null, "mobile_dev"));
    @NotNull
    private static final File currentRunLogDirectory;
    @NotNull
    private static final ConsoleHandler consoleHandler;
    @NotNull
    private static final FileHandler fileHandler;

    private DebugLogStore() {
    }

    @NotNull
    public final File getLogDirectory() {
        return logDirectory;
    }

    @NotNull
    public final Logger loggerFor(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Logger logger = Logger.getLogger(clazz.getName());
        logger.setUseParentHandlers(false);
        logger.addHandler(consoleHandler);
        logger.addHandler(fileHandler);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        return logger;
    }

    public final void logOutputOf(@NotNull ProcessBuilder processBuilder) {
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        List<String> list = processBuilder.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"processBuilder.command()");
        String string = (String)CollectionsKt.first(list);
        if (string == null) {
            string = "unknown";
        }
        String command = string;
        File logFile = this.logFile(command);
        ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.to(logFile);
        processBuilder.redirectOutput(redirect).redirectError(redirect);
    }

    public final void finalizeRun() {
        fileHandler.close();
        File output = new File(currentRunLogDirectory.getParent(), Intrinsics.stringPlus((String)currentRunLogDirectory.getName(), (Object)".zip"));
        Path path = currentRunLogDirectory.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"currentRunLogDirectory.toPath()");
        Path path2 = path;
        path = output.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"output.toPath()");
        FileUtils.INSTANCE.zipDir(path2, path);
        FilesKt.deleteRecursively((File)currentRunLogDirectory);
    }

    private final File logFile(String named) {
        return new File(currentRunLogDirectory, Intrinsics.stringPlus((String)named, (Object)".log"));
    }

    private final void removeOldLogs(File baseDir) {
        Object[] existing;
        if (!baseDir.isDirectory()) {
            return;
        }
        Object[] objectArray = baseDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] $this$sortedByDescending$iv = existing = objectArray;
        boolean $i$f$sortedByDescending = false;
        List toDelete = CollectionsKt.toList((Iterable)CollectionsKt.drop((Iterable)ArraysKt.sortedWith((Object[])$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }), (int)6));
        Iterable $this$forEach$iv = toDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            FilesKt.deleteRecursively((File)it);
        }
    }

    private final void logSystemInfo() {
        String logData = Intrinsics.stringPlus((String)StringsKt.trimIndent((String)("\n            Maestro version: " + this.appVersion() + "\n            OS: " + System.getProperty("os.name") + "\n            OS version: " + System.getProperty("os.version") + "\n            Architecture: " + System.getProperty("os.arch") + "\n            ")), (Object)"\n");
        FilesKt.writeText$default((File)this.logFile("system_info"), (String)logData, null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String appVersion() {
        Properties properties;
        Closeable closeable = Driver.class.getClassLoader().getResourceAsStream("version.properties");
        Throwable throwable = null;
        try {
            Properties properties2;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Properties $this$appVersion_u24lambda_u2d3_u24lambda_u2d2 = properties2 = new Properties();
            boolean bl2 = false;
            $this$appVersion_u24lambda_u2d3_u24lambda_u2d2.load(it);
            properties = properties2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Properties props = properties;
        return String.valueOf(props.get("version"));
    }

    static {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(LOG_DIR_DATE_FORMAT);
        String date = dateFormatter.format(LocalDateTime.now());
        currentRunLogDirectory = new File(logDirectory, date);
        currentRunLogDirectory.mkdirs();
        INSTANCE.removeOldLogs(logDirectory);
        consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.WARNING);
        consoleHandler.setFormatter(new SimpleFormatter(){

            @Override
            @NotNull
            public String format(@NotNull LogRecord record) {
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                String level = record.getLevel().intValue() > 900 ? "Error: " : "";
                return level + record.getMessage() + '\n';
            }
        });
        File maestroLogFile = INSTANCE.logFile(APP_NAME);
        fileHandler = new FileHandler(maestroLogFile.getAbsolutePath());
        fileHandler.setLevel(Level.ALL);
        fileHandler.setFormatter(new SimpleFormatter(){
            @NotNull
            private final String format;
            {
                this.format = "[%1$tF %1$tT] [%2$-7s] %3$s %n";
            }

            @Override
            @NotNull
            public synchronized String format(@NotNull LogRecord lr) {
                Intrinsics.checkNotNullParameter((Object)lr, (String)"lr");
                Object[] objectArray = new Object[]{new Date(lr.getMillis()), lr.getLevel().getLocalizedName(), lr.getMessage()};
                String string = String.format(this.format, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(\n                \u2026message\n                )");
                return string;
            }
        });
        INSTANCE.logSystemInfo();
    }
}

