/*
 * Decompiled with CFR 0.152.
 */
package maestro.drivers;

import com.android.ide.common.xml.ManifestData;
import dadb.AdbShellResponse;
import dadb.AdbShellStream;
import dadb.Dadb;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.Driver;
import maestro.Filters;
import maestro.KeyCode;
import maestro.Maestro;
import maestro.Platform;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TreeNode;
import maestro.UiElement;
import maestro.android.AndroidAppFiles;
import maestro.android.AndroidExtKt;
import maestro.utils.MaestroTimer;
import maestro.utils.ScreenshotUtils;
import maestro.utils.StringUtils;
import maestro_android.DeviceInfoRequestKt;
import maestro_android.EraseAllTextRequestKt;
import maestro_android.InputTextRequestKt;
import maestro_android.MaestroAndroid;
import maestro_android.MaestroDriverGrpc;
import maestro_android.ScreenshotRequestKt;
import maestro_android.SetLocationRequestKt;
import maestro_android.TapRequestKt;
import maestro_android.ViewHierarchyRequestKt;
import net.dongliu.apk.parser.ApkFile;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u0080\u00012\u00020\u0001:\u0002\u0080\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0005H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0016H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u00020\u0016H\u0002J\b\u00102\u001a\u00020\u0013H\u0016J\u0010\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0016H\u0016J\u0010\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u0013H\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0002J\u0010\u0010:\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0016H\u0002J\b\u0010<\u001a\u00020\u0011H\u0016J\b\u0010=\u001a\u00020\u0011H\u0016J\u001e\u0010>\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0016J\u0010\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020)H\u0016J\u0010\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020\u0016H\u0016J\b\u0010F\u001a\u00020\u0013H\u0016J\u0010\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u0016H\u0002J*\u0010I\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u0011H\u0016J\u0010\u0010L\u001a\u00020\u00132\u0006\u0010M\u001a\u00020NH\u0016J\u0018\u0010O\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010P\u001a\u000207H\u0016J\u0018\u0010Q\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010R\u001a\u000207H\u0016J\b\u0010S\u001a\u00020\u0013H\u0016J\b\u0010T\u001a\u00020\u0013H\u0016J\u0018\u0010U\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010V\u001a\u00020\u0016H\u0002J\u0018\u0010W\u001a\u00020\u00132\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020YH\u0016J \u0010[\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\u00162\u0006\u0010V\u001a\u00020\u0016H\u0002J$\u0010]\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160_H\u0016J\u0018\u0010`\u001a\u00020\u00132\u0006\u0010a\u001a\u00020\u00162\u0006\u0010b\u001a\u00020\u0005H\u0016J\u0010\u0010c\u001a\u00020\u00162\u0006\u0010d\u001a\u00020\u0016H\u0002J\u0010\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0016J\u0010\u0010i\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010j\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J \u0010j\u001a\u00020\u00132\u0006\u0010k\u001a\u00020)2\u0006\u0010l\u001a\u00020m2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010j\u001a\u00020\u00132\u0006\u0010n\u001a\u00020m2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010o\u001a\u00020\u00132\u0006\u0010g\u001a\u00020h2\u0006\u0010p\u001a\u00020\u0011H\u0016J\u0010\u0010q\u001a\u00020\u00132\u0006\u0010A\u001a\u00020)H\u0016J\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010E\u001a\u00020\u0016H\u0002J\u0010\u0010s\u001a\u00020\u00162\u0006\u0010t\u001a\u00020\u0016H\u0002J\u0010\u0010u\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u0016H\u0002J\b\u0010v\u001a\u00020\u0013H\u0002J!\u0010w\u001a\u0004\u0018\u00010x2\b\u0010y\u001a\u0004\u0018\u00010xH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bz\u0010{J\u0010\u0010|\u001a\u00020\u00112\u0006\u0010}\u001a\u00020'H\u0016J\u001b\u0010~\u001a\u0004\u0018\u00010\u0011*\u00020D2\u0006\u0010E\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u007fR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0081\u0001"}, d2={"Lmaestro/drivers/AndroidDriver;", "Lmaestro/Driver;", "dadb", "Ldadb/Dadb;", "hostPort", "", "(Ldadb/Dadb;I)V", "blockingStub", "Lmaestro_android/MaestroDriverGrpc$MaestroDriverBlockingStub;", "kotlin.jvm.PlatformType", "channel", "Lio/grpc/ManagedChannel;", "documentBuilderFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "instrumentationSession", "Ldadb/AdbShellStream;", "proxySet", "", "allocateForwarder", "", "autoVerifyApp", "appId", "", "autoVerifyChromeAgreement", "autoVerifyWithAppName", "awaitLaunch", "backPress", "capabilities", "", "Lmaestro/Capability;", "clearAppState", "clearKeychain", "close", "contentDescriptor", "Lmaestro/TreeNode;", "deviceInfo", "Lmaestro/DeviceInfo;", "directionalSwipe", "durationMs", "", "start", "Lmaestro/Point;", "end", "eraseText", "charactersToErase", "filterById", "Lmaestro/UiElement;", "idRegex", "filterByText", "textRegex", "hideKeyboard", "inputText", "text", "install", "apkFile", "Ljava/io/File;", "installMaestroApks", "installedPackages", "isPackageInstalled", "packageName", "isShutdown", "isUnicodeInputSupported", "launchApp", "launchArguments", "longPress", "point", "mapHierarchy", "node", "Lorg/w3c/dom/Node;", "name", "open", "openBrowser", "link", "openLink", "autoVerify", "browser", "pressKey", "code", "Lmaestro/KeyCode;", "pullAppState", "outFile", "pushAppState", "stateFile", "resetProxy", "scrollVertical", "setAllPermissions", "permissionValue", "setLocation", "latitude", "", "longitude", "setPermissionInternal", "permission", "setPermissions", "permissions", "", "setProxy", "host", "port", "shell", "command", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "stopApp", "swipe", "elementPoint", "direction", "Lmaestro/SwipeDirection;", "swipeDirection", "takeScreenshot", "compressed", "tap", "translatePermissionName", "translatePermissionValue", "value", "uninstall", "uninstallMaestroApks", "waitForAppToSettle", "Lmaestro/ViewHierarchy;", "initialHierarchy", "waitForAppToSettle-LubAXRY", "(Lmaestro/TreeNode;)Lmaestro/TreeNode;", "waitUntilScreenIsStatic", "timeoutMs", "getBoolean", "(Lorg/w3c/dom/Node;Ljava/lang/String;)Ljava/lang/Boolean;", "Companion", "maestro-client"})
public final class AndroidDriver
implements Driver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dadb dadb;
    private final int hostPort;
    private final ManagedChannel channel;
    private final MaestroDriverGrpc.MaestroDriverBlockingStub blockingStub;
    private final DocumentBuilderFactory documentBuilderFactory;
    @Nullable
    private AdbShellStream instrumentationSession;
    private boolean proxySet;
    private static final int SERVER_LAUNCH_TIMEOUT_MS = 15000;
    @NotNull
    private static final Set<RegexOption> REGEX_OPTIONS;
    private static final Logger LOGGER;
    @NotNull
    private static final String TOAST_CLASS_NAME = "android.widget.Toast";
    @NotNull
    private static final Map<Integer, AutoCloseable> PORT_TO_FORWARDER;
    @NotNull
    private static final Map<Integer, String> PORT_TO_ALLOCATION_POINT;
    private static final double SCREENSHOT_DIFF_THRESHOLD = 0.005;

    public AndroidDriver(@NotNull Dadb dadb, int hostPort) {
        Intrinsics.checkNotNullParameter((Object)dadb, (String)"dadb");
        this.dadb = dadb;
        this.hostPort = hostPort;
        this.channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.hostPort).usePlaintext().build();
        this.blockingStub = MaestroDriverGrpc.newBlockingStub((Channel)this.channel);
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    public /* synthetic */ AndroidDriver(Dadb dadb, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 7001;
        }
        this(dadb, n);
    }

    @Override
    @NotNull
    public String name() {
        return "Android Device (" + this.dadb + ')';
    }

    @Override
    public void open() {
        this.uninstallMaestroApks();
        this.installMaestroApks();
        AdbShellStream adbShellStream = this.instrumentationSession = Dadb.DefaultImpls.openShell$default((Dadb)this.dadb, null, (int)1, null);
        if (adbShellStream != null) {
            adbShellStream.write("am instrument -w -m -e debug false -e class 'dev.mobile.maestro.MaestroDriverService#grpcServer' dev.mobile.maestro.test/androidx.test.runner.AndroidJUnitRunner &\n");
        }
        try {
            this.awaitLaunch();
        }
        catch (InterruptedException ignored) {
            AdbShellStream adbShellStream2 = this.instrumentationSession;
            if (adbShellStream2 != null) {
                adbShellStream2.close();
            }
            return;
        }
        this.allocateForwarder();
    }

    private final void allocateForwarder() {
        AutoCloseable autoCloseable = PORT_TO_FORWARDER.get(this.hostPort);
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        String string = PORT_TO_ALLOCATION_POINT.get(this.hostPort);
        if (string != null) {
            String it = string;
            boolean bl = false;
            LOGGER.warn("Port " + this.hostPort + " was already allocated. Allocation point: " + it);
        }
        PORT_TO_FORWARDER.put(this.hostPort, this.dadb.tcpForward(this.hostPort, 7001));
        PORT_TO_ALLOCATION_POINT.put(this.hostPort, ExceptionsKt.stackTraceToString((Throwable)new Exception()));
    }

    private final void awaitLaunch() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 15000L) {
            try {
                this.dadb.open("tcp:7001").close();
                return;
            }
            catch (Exception exception) {
                Thread.sleep(100L);
            }
        }
        throw new TimeoutException("Maestro Android driver did not start up in time");
    }

    @Override
    public void close() {
        if (this.proxySet) {
            this.resetProxy();
        }
        AutoCloseable autoCloseable = PORT_TO_FORWARDER.get(this.hostPort);
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        PORT_TO_FORWARDER.remove(this.hostPort);
        PORT_TO_ALLOCATION_POINT.remove(this.hostPort);
        this.uninstallMaestroApks();
        AdbShellStream adbShellStream = this.instrumentationSession;
        if (adbShellStream != null) {
            adbShellStream.close();
        }
        this.instrumentationSession = null;
        this.channel.shutdown();
        if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
            throw new TimeoutException("Couldn't close Maestro Android driver due to gRPC timeout");
        }
    }

    @Override
    @NotNull
    public DeviceInfo deviceInfo() {
        boolean bl = false;
        Object object = MaestroAndroid.DeviceInfoRequest.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
        Object $this$deviceInfoRequest_u24lambda_u2d0$iv = object = DeviceInfoRequestKt.Dsl.Companion._create((MaestroAndroid.DeviceInfoRequest.Builder)object);
        boolean bl2 = false;
        Object object2 = $this$deviceInfoRequest_u24lambda_u2d0$iv;
        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
        boolean bl3 = false;
        MaestroAndroid.DeviceInfo response = maestroDriverBlockingStub.deviceInfo(((DeviceInfoRequestKt.Dsl)object)._build());
        return new DeviceInfo(Platform.ANDROID, response.getWidthPixels(), response.getHeightPixels(), response.getWidthPixels(), response.getHeightPixels());
    }

    @Override
    public void launchApp(@NotNull String appId, @NotNull List<String> launchArguments) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        if (!this.isPackageInstalled(appId)) {
            throw new IllegalArgumentException("Package " + appId + " is not installed");
        }
        try {
            Object object;
            File apkFile = AndroidAppFiles.INSTANCE.getApkFile(this.dadb, appId);
            ManifestData manifest = AndroidExtKt.asManifest(apkFile);
            Object object2 = this;
            try {
                AndroidDriver $this$launchApp_u24lambda_u2d2 = object2;
                boolean bl = false;
                String launcherActivity = AndroidExtKt.resolveLauncherActivity(manifest, appId);
                AdbShellResponse shellResponse = $this$launchApp_u24lambda_u2d2.dadb.shell("am start-activity -n " + appId + '/' + launcherActivity);
                if (((CharSequence)shellResponse.getErrorOutput()).length() > 0) {
                    $this$launchApp_u24lambda_u2d2.shell("monkey --pct-syskeys 0 -p " + appId + " 1");
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                this.shell("monkey --pct-syskeys 0 -p " + appId + " 1");
            }
        }
        catch (IOException ioException) {
            this.shell("monkey --pct-syskeys 0 -p " + appId + " 1");
        }
        catch (SAXException saxException) {
            this.shell("monkey --pct-syskeys 0 -p " + appId + " 1");
        }
    }

    @Override
    public void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.shell(Intrinsics.stringPlus((String)"am force-stop ", (Object)appId));
    }

    @Override
    public void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        if (!this.isPackageInstalled(appId)) {
            return;
        }
        this.shell(Intrinsics.stringPlus((String)"pm clear ", (Object)appId));
    }

    @Override
    public void clearKeychain() {
    }

    @Override
    public void pullAppState(@NotNull String appId, @NotNull File outFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
        AndroidAppFiles.INSTANCE.pull(this.dadb, appId, outFile);
    }

    @Override
    public void pushAppState(@NotNull String appId, @NotNull File stateFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
        AndroidAppFiles.INSTANCE.push(this.dadb, appId, stateFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tap(@NotNull Point point) {
        void $this$tap_u24lambda_u2d4;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        boolean bl = false;
        Object object = MaestroAndroid.TapRequest.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
        Object $this$tapRequest_u24lambda_u2d0$iv = object = TapRequestKt.Dsl.Companion._create((MaestroAndroid.TapRequest.Builder)object);
        boolean bl2 = false;
        Object object2 = $this$tapRequest_u24lambda_u2d0$iv;
        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
        boolean bl3 = false;
        $this$tap_u24lambda_u2d4.setX(point.getX());
        $this$tap_u24lambda_u2d4.setY(point.getY());
        MaestroAndroid.TapResponse tapResponse = maestroDriverBlockingStub.tap(((TapRequestKt.Dsl)object)._build());
        if (tapResponse == null) {
            throw new IllegalStateException("Response can't be null");
        }
    }

    @Override
    public void longPress(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.dadb.shell("input swipe " + point.getX() + ' ' + point.getY() + ' ' + point.getX() + ' ' + point.getY() + " 3000");
    }

    @Override
    public void pressKey(@NotNull KeyCode code) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        switch (WhenMappings.$EnumSwitchMapping$0[code.ordinal()]) {
            case 1: {
                n = 66;
                break;
            }
            case 2: {
                n = 67;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 24;
                break;
            }
            case 5: {
                n = 25;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 7: {
                n = 276;
                break;
            }
            case 8: {
                n = 19;
                break;
            }
            case 9: {
                n = 20;
                break;
            }
            case 10: {
                n = 21;
                break;
            }
            case 11: {
                n = 22;
                break;
            }
            case 12: {
                n = 23;
                break;
            }
            case 13: {
                n = 85;
                break;
            }
            case 14: {
                n = 86;
                break;
            }
            case 15: {
                n = 87;
                break;
            }
            case 16: {
                n = 88;
                break;
            }
            case 17: {
                n = 89;
                break;
            }
            case 18: {
                n = 90;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int intCode = n;
        this.dadb.shell(Intrinsics.stringPlus((String)"input keyevent ", (Object)intCode));
        Thread.sleep(300L);
    }

    @Override
    @NotNull
    public TreeNode contentDescriptor() {
        MaestroAndroid.ViewHierarchyResponse $i$f$-initializeviewHierarchyRequest22;
        Object object;
        try {
            boolean $i$f$-initializeviewHierarchyRequest22 = false;
            object = MaestroAndroid.ViewHierarchyRequest.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
            Object $this$viewHierarchyRequest_u24lambda_u2d0$iv = object = ViewHierarchyRequestKt.Dsl.Companion._create((MaestroAndroid.ViewHierarchyRequest.Builder)object);
            boolean bl = false;
            Object object2 = $this$viewHierarchyRequest_u24lambda_u2d0$iv;
            MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
            boolean bl2 = false;
            $i$f$-initializeviewHierarchyRequest22 = maestroDriverBlockingStub.viewHierarchy(((ViewHierarchyRequestKt.Dsl)object)._build());
        }
        catch (Exception ignored) {
            MaestroTimer.INSTANCE.getSleep().invoke((Object)MaestroTimer.Reason.BUFFER, (Object)1000L);
            boolean bl = false;
            Object object3 = MaestroAndroid.ViewHierarchyRequest.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"newBuilder()");
            Object $this$viewHierarchyRequest_u24lambda_u2d0$iv = object3 = ViewHierarchyRequestKt.Dsl.Companion._create((MaestroAndroid.ViewHierarchyRequest.Builder)object3);
            boolean bl3 = false;
            Object object4 = $this$viewHierarchyRequest_u24lambda_u2d0$iv;
            MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
            boolean bl4 = false;
            $i$f$-initializeviewHierarchyRequest22 = maestroDriverBlockingStub.viewHierarchy(((ViewHierarchyRequestKt.Dsl)object3)._build());
        }
        MaestroAndroid.ViewHierarchyResponse response = $i$f$-initializeviewHierarchyRequest22;
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        object = response.getHierarchy();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.hierarchy");
        Charset charset = Charsets.UTF_8;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        return this.mapHierarchy(document);
    }

    @Override
    public void scrollVertical() {
        this.swipe(SwipeDirection.UP, 400L);
    }

    @Override
    public void swipe(@NotNull Point start2, @NotNull Point end, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.dadb.shell("input swipe " + start2.getX() + ' ' + start2.getY() + ' ' + end.getX() + ' ' + end.getY() + ' ' + durationMs);
    }

    @Override
    public void swipe(@NotNull SwipeDirection swipeDirection, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        DeviceInfo deviceInfo2 = this.deviceInfo();
        switch (WhenMappings.$EnumSwitchMapping$1[swipeDirection.ordinal()]) {
            case 1: {
                int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.1f);
                this.directionalSwipe(durationMs, new Point(startX, startY), new Point(endX, endY));
                break;
            }
            case 2: {
                int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.2f);
                int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.9f);
                this.directionalSwipe(durationMs, new Point(startX, startY), new Point(endX, endY));
                break;
            }
            case 3: {
                int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.1f);
                int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.9f);
                int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                this.directionalSwipe(durationMs, new Point(startX, startY), new Point(endX, endY));
                break;
            }
            case 4: {
                int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.9f);
                int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.1f);
                int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                this.directionalSwipe(durationMs, new Point(startX, startY), new Point(endX, endY));
            }
        }
    }

    @Override
    public void swipe(@NotNull Point elementPoint, @NotNull SwipeDirection direction, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)elementPoint, (String)"elementPoint");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        DeviceInfo deviceInfo2 = this.deviceInfo();
        switch (WhenMappings.$EnumSwitchMapping$1[direction.ordinal()]) {
            case 1: {
                int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.1f);
                this.directionalSwipe(durationMs, elementPoint, new Point(elementPoint.getX(), endY));
                break;
            }
            case 2: {
                int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.9f);
                this.directionalSwipe(durationMs, elementPoint, new Point(elementPoint.getX(), endY));
                break;
            }
            case 3: {
                int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.9f);
                this.directionalSwipe(durationMs, elementPoint, new Point(endX, elementPoint.getY()));
                break;
            }
            case 4: {
                int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.1f);
                this.directionalSwipe(durationMs, elementPoint, new Point(endX, elementPoint.getY()));
            }
        }
    }

    private final void directionalSwipe(long durationMs, Point start2, Point end) {
        this.dadb.shell("input swipe " + start2.getX() + ' ' + start2.getY() + ' ' + end.getX() + ' ' + end.getY() + ' ' + durationMs);
    }

    @Override
    public void backPress() {
        this.dadb.shell("input keyevent 4");
        Thread.sleep(300L);
    }

    @Override
    public void hideKeyboard() {
        this.dadb.shell("input keyevent 4");
        this.dadb.shell("input keyevent 111");
        Thread.sleep(300L);
        this.waitForAppToSettle-LubAXRY(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeScreenshot(@NotNull Sink out, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        boolean bl = false;
        Object object = MaestroAndroid.ScreenshotRequest.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
        Object $this$screenshotRequest_u24lambda_u2d0$iv = object = ScreenshotRequestKt.Dsl.Companion._create((MaestroAndroid.ScreenshotRequest.Builder)object);
        boolean bl2 = false;
        Object object2 = $this$screenshotRequest_u24lambda_u2d0$iv;
        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
        boolean bl3 = false;
        MaestroAndroid.ScreenshotResponse response = maestroDriverBlockingStub.screenshot(((ScreenshotRequestKt.Dsl)object)._build());
        Closeable closeable = (Closeable)Okio.buffer((Sink)out);
        object = null;
        try {
            BufferedSink it = (BufferedSink)closeable;
            boolean bl4 = false;
            object2 = response.getBytes().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"response.bytes.toByteArray()");
            BufferedSink bufferedSink = it.write((byte[])object2);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    @Override
    @NotNull
    public ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        String deviceScreenRecordingPath = "/sdcard/maestro-screenrecording.mp4";
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> AndroidDriver.startScreenRecording$lambda-9(this, deviceScreenRecordingPath), Executors.newSingleThreadExecutor());
        return new ScreenRecording(this, future, out, deviceScreenRecordingPath){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ CompletableFuture<Void> $future;
            final /* synthetic */ Sink $out;
            final /* synthetic */ String $deviceScreenRecordingPath;
            {
                this.this$0 = $receiver;
                this.$future = $future;
                this.$out = $out;
                this.$deviceScreenRecordingPath = $deviceScreenRecordingPath;
            }

            public void close() {
                AndroidDriver.access$getDadb$p(this.this$0).shell("killall -INT screenrecord");
                this.$future.get();
                Thread.sleep(3000L);
                AndroidDriver.access$getDadb$p(this.this$0).pull(this.$out, this.$deviceScreenRecordingPath);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void inputText(@NotNull String text) {
        void $this$inputText_u24lambda_u2d10;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean bl = false;
        Object object = MaestroAndroid.InputTextRequest.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
        Object $this$inputTextRequest_u24lambda_u2d0$iv = object = InputTextRequestKt.Dsl.Companion._create((MaestroAndroid.InputTextRequest.Builder)object);
        boolean bl2 = false;
        Object object2 = $this$inputTextRequest_u24lambda_u2d0$iv;
        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
        boolean bl3 = false;
        $this$inputText_u24lambda_u2d10.setText(text);
        MaestroAndroid.InputTextResponse inputTextResponse = maestroDriverBlockingStub.inputText(((InputTextRequestKt.Dsl)object)._build());
        if (inputTextResponse == null) {
            throw new IllegalStateException("Input Response can't be null");
        }
    }

    @Override
    public void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        if (browser) {
            this.openBrowser(link);
        } else {
            this.dadb.shell("am start -a android.intent.action.VIEW -d \"" + link + '\"');
        }
        if (autoVerify) {
            this.autoVerifyApp(appId);
        }
    }

    private final void autoVerifyApp(String appId) {
        if (appId != null) {
            this.autoVerifyWithAppName(appId);
        }
        this.autoVerifyChromeAgreement();
    }

    private final void autoVerifyWithAppName(String appId) {
        Object $this$autoVerifyWithAppName_u24lambda_u2d11;
        AndroidDriver androidDriver = this;
        try {
            $this$autoVerifyWithAppName_u24lambda_u2d11 = androidDriver;
            boolean bl = false;
            File apkFile = AndroidAppFiles.INSTANCE.getApkFile(((AndroidDriver)$this$autoVerifyWithAppName_u24lambda_u2d11).dadb, appId);
            String appName = new ApkFile(apkFile).getApkMeta().getName();
            $this$autoVerifyWithAppName_u24lambda_u2d11 = Result.constructor-impl((Object)appName);
        }
        catch (Throwable bl) {
            $this$autoVerifyWithAppName_u24lambda_u2d11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        Object appNameResult = $this$autoVerifyWithAppName_u24lambda_u2d11;
        if (Result.isSuccess-impl((Object)appNameResult)) {
            $this$autoVerifyWithAppName_u24lambda_u2d11 = appNameResult;
            ResultKt.throwOnFailure((Object)$this$autoVerifyWithAppName_u24lambda_u2d11);
            String appName = (String)$this$autoVerifyWithAppName_u24lambda_u2d11;
            this.waitUntilScreenIsStatic(3000L);
            Intrinsics.checkNotNullExpressionValue((Object)appName, (String)"appName");
            UiElement appNameElement = this.filterByText(appName);
            if (appNameElement != null) {
                this.tap(appNameElement.getBounds().center());
                UiElement uiElement = this.filterById("android:id/button_once");
                if (uiElement != null) {
                    UiElement it = uiElement;
                    boolean bl = false;
                    this.tap(it.getBounds().center());
                }
            } else {
                UiElement openWithAppElement = this.filterByText(".*" + appName + ".*");
                if (openWithAppElement != null) {
                    UiElement uiElement = this.filterById("android:id/button_once");
                    if (uiElement != null) {
                        UiElement it = uiElement;
                        boolean bl = false;
                        this.tap(it.getBounds().center());
                    }
                }
            }
        }
    }

    private final void autoVerifyChromeAgreement() {
        UiElement it;
        UiElement uiElement = this.filterById("com.android.chrome:id/terms_accept");
        if (uiElement != null) {
            it = uiElement;
            boolean bl = false;
            this.tap(it.getBounds().center());
        }
        this.waitForAppToSettle-LubAXRY(null);
        UiElement uiElement2 = this.filterById("com.android.chrome:id/negative_button");
        if (uiElement2 != null) {
            it = uiElement2;
            boolean bl = false;
            this.tap(it.getBounds().center());
        }
    }

    private final UiElement filterByText(String textRegex) {
        Function1<List<TreeNode>, List<TreeNode>> textMatcher = Filters.INSTANCE.textMatches(StringUtils.INSTANCE.toRegexSafe(textRegex, REGEX_OPTIONS));
        Function1<List<TreeNode>, List<TreeNode>> filterFunc = Filters.INSTANCE.deepestMatchingElement(textMatcher);
        TreeNode treeNode = (TreeNode)CollectionsKt.firstOrNull((List)((List)filterFunc.invoke(this.contentDescriptor().aggregate())));
        return treeNode == null ? null : UiElement.Companion.toUiElementOrNull(treeNode);
    }

    private final UiElement filterById(String idRegex) {
        Function1<List<TreeNode>, List<TreeNode>> idMatcher = Filters.INSTANCE.idMatches(StringUtils.INSTANCE.toRegexSafe(idRegex, REGEX_OPTIONS));
        Function1<List<TreeNode>, List<TreeNode>> filterFunc = Filters.INSTANCE.deepestMatchingElement(idMatcher);
        TreeNode treeNode = (TreeNode)CollectionsKt.firstOrNull((List)((List)filterFunc.invoke(this.contentDescriptor().aggregate())));
        return treeNode == null ? null : UiElement.Companion.toUiElementOrNull(treeNode);
    }

    private final void openBrowser(String link) {
        List<String> installedPackages = this.installedPackages();
        if (installedPackages.contains("com.android.chrome")) {
            this.dadb.shell("am start -a android.intent.action.VIEW -d \"" + link + "\" com.android.chrome");
        } else if (installedPackages.contains("org.mozilla.firefox")) {
            this.dadb.shell("am start -a android.intent.action.VIEW -d \"" + link + "\" org.mozilla.firefox");
        } else {
            this.dadb.shell("am start -a android.intent.action.VIEW -d \"" + link + '\"');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> installedPackages() {
        String[] parts;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)this.shell("pm list packages"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$toTypedArray$iv;
            void line;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = (CharSequence)line;
            Regex regex = new Regex(":");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            collection.add(stringArray2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            parts = (String[])element$iv$iv;
            boolean bl = false;
            if (!(parts.length == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            parts = (String[])item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(parts[1]);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLocation(double latitude, double longitude) {
        void $this$setLocation_u24lambda_u2d19;
        this.shell("appops set dev.mobile.maestro android:mock_location allow");
        boolean bl = false;
        Object object = MaestroAndroid.SetLocationRequest.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
        Object $this$setLocationRequest_u24lambda_u2d0$iv = object = SetLocationRequestKt.Dsl.Companion._create((MaestroAndroid.SetLocationRequest.Builder)object);
        boolean bl2 = false;
        Object object2 = $this$setLocationRequest_u24lambda_u2d0$iv;
        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
        boolean bl3 = false;
        $this$setLocation_u24lambda_u2d19.setLatitude(latitude);
        $this$setLocation_u24lambda_u2d19.setLongitude(longitude);
        MaestroAndroid.SetLocationResponse setLocationResponse = maestroDriverBlockingStub.setLocation(((SetLocationRequestKt.Dsl)object)._build());
        if (setLocationResponse == null) {
            throw new IllegalStateException("Set Location Response can't be null".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void eraseText(int charactersToErase) {
        void $this$eraseText_u24lambda_u2d20;
        boolean bl = false;
        Object object = MaestroAndroid.EraseAllTextRequest.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder()");
        Object $this$eraseAllTextRequest_u24lambda_u2d0$iv = object = EraseAllTextRequestKt.Dsl.Companion._create((MaestroAndroid.EraseAllTextRequest.Builder)object);
        boolean bl2 = false;
        Object object2 = $this$eraseAllTextRequest_u24lambda_u2d0$iv;
        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.blockingStub;
        boolean bl3 = false;
        $this$eraseText_u24lambda_u2d20.setCharactersToErase(charactersToErase);
        MaestroAndroid.EraseAllTextResponse eraseAllTextResponse = maestroDriverBlockingStub.eraseAllText(((EraseAllTextRequestKt.Dsl)object)._build());
        if (eraseAllTextResponse == null) {
            throw new IllegalStateException("Erase Response can't be null");
        }
    }

    @Override
    public void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.shell("settings put global http_proxy \"" + host + ':' + port + '\"');
        this.proxySet = true;
    }

    @Override
    public void resetProxy() {
        this.shell("settings put global http_proxy :0");
    }

    @Override
    public boolean isShutdown() {
        return this.channel.isShutdown();
    }

    @Override
    public boolean isUnicodeInputSupported() {
        return false;
    }

    @Override
    @Nullable
    public TreeNode waitForAppToSettle-LubAXRY(@Nullable TreeNode initialHierarchy) {
        return ScreenshotUtils.Companion.waitForAppToSettle-d60svg8(initialHierarchy, this);
    }

    @Override
    public boolean waitUntilScreenIsStatic(long timeoutMs) {
        return ScreenshotUtils.Companion.waitUntilScreenIsStatic(timeoutMs, 0.005, this);
    }

    @Override
    @NotNull
    public List<Capability> capabilities() {
        return CollectionsKt.listOf((Object)((Object)Capability.FAST_HIERARCHY));
    }

    @Override
    public void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Map mutable = MapsKt.toMutableMap(permissions);
        String string = (String)mutable.remove("all");
        if (string != null) {
            String value = string;
            boolean bl = false;
            this.setAllPermissions(appId, value);
        }
        Map $this$forEach$iv = mutable;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry permission = element$iv = iterator.next();
            boolean bl = false;
            String permissionValue = this.translatePermissionValue((String)permission.getValue());
            Iterable $this$forEach$iv2 = this.translatePermissionName((String)permission.getKey());
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String permissionName = (String)element$iv2;
                boolean bl2 = false;
                this.setPermissionInternal(appId, permissionName, permissionValue);
            }
        }
    }

    private final void setAllPermissions(String appId, String permissionValue) {
        Object object;
        AndroidDriver androidDriver = this;
        try {
            AndroidDriver $this$setAllPermissions_u24lambda_u2d24 = androidDriver;
            boolean bl = false;
            File apkFile = AndroidAppFiles.INSTANCE.getApkFile($this$setAllPermissions_u24lambda_u2d24.dadb, appId);
            object = Result.constructor-impl((Object)new ApkFile(apkFile).getApkMeta().getUsesPermissions());
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        Object permissionsResult = object;
        if (Result.isSuccess-impl((Object)permissionsResult)) {
            List list = (List)(Result.isFailure-impl((Object)permissionsResult) ? null : permissionsResult);
            if (list != null) {
                List it = list;
                boolean bl = false;
                Iterable $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String permission = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)permission, (String)"permission");
                    this.setPermissionInternal(appId, permission, this.translatePermissionValue(permissionValue));
                }
            }
        }
    }

    private final void setPermissionInternal(String appId, String permission, String permissionValue) {
        try {
            this.dadb.shell("pm " + permissionValue + ' ' + appId + ' ' + permission);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final List<String> translatePermissionName(String name) {
        List list;
        switch (name) {
            case "location": {
                Object[] objectArray = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "camera": {
                list = CollectionsKt.listOf((Object)"android.permission.CAMERA");
                break;
            }
            case "contacts": {
                Object[] objectArray = new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "phone": {
                Object[] objectArray = new String[]{"android.permission.CALL_PHONE", "android.permission.ANSWER_PHONE_CALLS"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "microphone": {
                list = CollectionsKt.listOf((Object)"android.permission.RECORD_AUDIO");
                break;
            }
            case "bluetooth": {
                Object[] objectArray = new String[]{"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_SCAN"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "storage": {
                Object[] objectArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "notifications": {
                list = CollectionsKt.listOf((Object)"android.permission.POST_NOTIFICATIONS");
                break;
            }
            case "medialibrary": {
                Object[] objectArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_MEDIA_AUDIO", "android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "calendar": {
                Object[] objectArray = new String[]{"android.permission.WRITE_CALENDAR", "android.permission.READ_CALENDAR"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "sms": {
                Object[] objectArray = new String[]{"android.permission.READ_SMS", "android.permission.RECEIVE_SMS", "android.permission.SEND_SMS"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            default: {
                CharSequence charSequence = name;
                Regex regex = new Regex("[^A-Za-z0-9._]+");
                String string = "";
                list = CollectionsKt.listOf((Object)regex.replace(charSequence, string));
            }
        }
        return list;
    }

    private final String translatePermissionValue(String value) {
        String string;
        switch (value) {
            case "allow": {
                string = "grant";
                break;
            }
            case "deny": {
                string = "revoke";
                break;
            }
            case "unset": {
                string = "revoke";
                break;
            }
            default: {
                string = "revoke";
            }
        }
        return string;
    }

    private final TreeNode mapHierarchy(Node node) {
        Map map;
        if (node instanceof Element) {
            String string;
            Map attributesBuilder = new LinkedHashMap();
            if (((Element)node).hasAttribute("text")) {
                String text = ((Element)node).getAttribute("text");
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                attributesBuilder.put("text", text);
            }
            if (((Element)node).hasAttribute("content-desc")) {
                string = ((Element)node).getAttribute("content-desc");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"content-desc\")");
                attributesBuilder.put("accessibilityText", string);
            }
            if (((Element)node).hasAttribute("hintText")) {
                string = ((Element)node).getAttribute("hintText");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"hintText\")");
                attributesBuilder.put("hintText", string);
            }
            if (((Element)node).hasAttribute("class") && Intrinsics.areEqual((Object)((Element)node).getAttribute("class"), (Object)TOAST_CLASS_NAME)) {
                attributesBuilder.put("ignoreBoundsFiltering", "true");
            } else {
                attributesBuilder.put("ignoreBoundsFiltering", "false");
            }
            if (((Element)node).hasAttribute("resource-id")) {
                string = ((Element)node).getAttribute("resource-id");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"resource-id\")");
                attributesBuilder.put("resource-id", string);
            }
            if (((Element)node).hasAttribute("clickable")) {
                string = ((Element)node).getAttribute("clickable");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"clickable\")");
                attributesBuilder.put("clickable", string);
            }
            if (((Element)node).hasAttribute("bounds")) {
                string = ((Element)node).getAttribute("bounds");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"bounds\")");
                attributesBuilder.put("bounds", string);
            }
            if (((Element)node).hasAttribute("enabled")) {
                string = ((Element)node).getAttribute("enabled");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"enabled\")");
                attributesBuilder.put("enabled", string);
            }
            if (((Element)node).hasAttribute("focused")) {
                string = ((Element)node).getAttribute("focused");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"focused\")");
                attributesBuilder.put("focused", string);
            }
            if (((Element)node).hasAttribute("checked")) {
                string = ((Element)node).getAttribute("checked");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"checked\")");
                attributesBuilder.put("checked", string);
            }
            if (((Element)node).hasAttribute("selected")) {
                string = ((Element)node).getAttribute("selected");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getAttribute(\"selected\")");
                attributesBuilder.put("selected", string);
            }
            map = attributesBuilder;
        } else {
            map = MapsKt.emptyMap();
        }
        Map attributes = map;
        List children = new ArrayList();
        NodeList childNodes = node.getChildNodes();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)childNodes.getLength());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Collection collection = children;
            Node node2 = childNodes.item(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"childNodes.item(i)");
            collection.add(this.mapHierarchy(node2));
        }
        return new TreeNode(MapsKt.toMutableMap((Map)attributes), children, this.getBoolean(node, "clickable"), this.getBoolean(node, "enabled"), this.getBoolean(node, "focused"), this.getBoolean(node, "checked"), this.getBoolean(node, "selected"));
    }

    private final Boolean getBoolean(Node $this$getBoolean, String name) {
        Boolean bl;
        Element element2;
        Element element3 = element2 = $this$getBoolean instanceof Element ? (Element)$this$getBoolean : null;
        if (element2 == null) {
            bl = null;
        } else {
            String string = element2.getAttribute(name);
            if (string == null) {
                bl = null;
            } else {
                String it = string;
                boolean bl2 = false;
                bl = Intrinsics.areEqual((Object)it, (Object)"true");
            }
        }
        return bl;
    }

    private final void installMaestroApks() {
        BufferedSink bufferedSink;
        InputStream it;
        File maestroAppApk = File.createTempFile("maestro-app", ".apk");
        File maestroServerApk = File.createTempFile("maestro-server", ".apk");
        InputStream inputStream = Maestro.class.getResourceAsStream("/maestro-app.apk");
        if (inputStream != null) {
            it = inputStream;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)maestroAppApk, (String)"maestroAppApk");
            bufferedSink = Okio.buffer((Sink)Okio.sink$default((File)maestroAppApk, (boolean)false, (int)1, null));
            bufferedSink.writeAll(Okio.source((InputStream)it));
            bufferedSink.flush();
        }
        InputStream inputStream2 = Maestro.class.getResourceAsStream("/maestro-server.apk");
        if (inputStream2 != null) {
            it = inputStream2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)maestroServerApk, (String)"maestroServerApk");
            bufferedSink = Okio.buffer((Sink)Okio.sink$default((File)maestroServerApk, (boolean)false, (int)1, null));
            bufferedSink.writeAll(Okio.source((InputStream)it));
            bufferedSink.flush();
        }
        Intrinsics.checkNotNullExpressionValue((Object)maestroAppApk, (String)"maestroAppApk");
        this.install(maestroAppApk);
        if (!this.isPackageInstalled("dev.mobile.maestro")) {
            throw new IllegalStateException("dev.mobile.maestro was not installed");
        }
        Intrinsics.checkNotNullExpressionValue((Object)maestroServerApk, (String)"maestroServerApk");
        this.install(maestroServerApk);
    }

    private final void uninstallMaestroApks() {
        if (this.isPackageInstalled("dev.mobile.maestro.test")) {
            this.uninstall("dev.mobile.maestro.test");
        }
        if (this.isPackageInstalled("dev.mobile.maestro")) {
            this.uninstall("dev.mobile.maestro");
        }
    }

    private final void install(File apkFile) {
        try {
            this.dadb.install(apkFile, new String[0]);
        }
        catch (IOException installError) {
            throw new IOException("Failed to install apk " + apkFile + ": " + installError.getMessage(), installError);
        }
    }

    private final void uninstall(String packageName) {
        try {
            this.dadb.uninstall(packageName);
        }
        catch (IOException error) {
            throw new IOException("Failed to uninstall package " + packageName + ": " + error.getMessage(), error);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPackageInstalled(String packageName) {
        boolean bl;
        block6: {
            List parts;
            Iterable $this$filterTo$iv$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            String output = this.shell(Intrinsics.stringPlus((String)"pm list packages --user 0 ", (Object)packageName));
            CharSequence charSequence = output;
            Regex regex = new Regex("\n");
            int n = 0;
            Iterable $this$map$iv = regex.split(charSequence, n);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                CharSequence charSequence2 = (CharSequence)line;
                Regex regex2 = new Regex(":");
                int n2 = 0;
                collection.add(regex2.split(charSequence2, n2));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                parts = (List)element$iv$iv;
                boolean bl3 = false;
                if (!(parts.size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                parts = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add((String)parts.get(1));
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String linePackageName = (String)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)linePackageName, (Object)packageName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String shell(String command) {
        AdbShellResponse adbShellResponse;
        try {
            adbShellResponse = this.dadb.shell(command);
        }
        catch (IOException e) {
            throw new IOException(command, e);
        }
        AdbShellResponse response = adbShellResponse;
        if (response.getExitCode() != 0) {
            throw new IOException(command + ": " + response.getAllOutput());
        }
        return response.getOutput();
    }

    private static final void startScreenRecording$lambda-9(AndroidDriver this$0, String $deviceScreenRecordingPath) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$deviceScreenRecordingPath, (String)"$deviceScreenRecordingPath");
        try {
            this$0.shell(Intrinsics.stringPlus((String)"screenrecord --bit-rate '100000' ", (Object)$deviceScreenRecordingPath));
        }
        catch (IOException e) {
            throw new IOException("Failed to capture screen recording on the device. Note that some Android emulators do not support screen recording. Try using a different Android emulator (eg. Pixel 5 / API 30)", e);
        }
    }

    public static final /* synthetic */ Dadb access$getDadb$p(AndroidDriver $this) {
        return $this.dadb;
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        REGEX_OPTIONS = SetsKt.setOf((Object[])objectArray);
        LOGGER = LoggerFactory.getLogger(AndroidDriver.class);
        PORT_TO_FORWARDER = new LinkedHashMap();
        PORT_TO_ALLOCATION_POINT = new LinkedHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmaestro/drivers/AndroidDriver$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PORT_TO_ALLOCATION_POINT", "", "", "", "PORT_TO_FORWARDER", "Ljava/lang/AutoCloseable;", "REGEX_OPTIONS", "", "Lkotlin/text/RegexOption;", "SCREENSHOT_DIFF_THRESHOLD", "", "SERVER_LAUNCH_TIMEOUT_MS", "TOAST_CLASS_NAME", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KeyCode.values().length];
            nArray[KeyCode.ENTER.ordinal()] = 1;
            nArray[KeyCode.BACKSPACE.ordinal()] = 2;
            nArray[KeyCode.BACK.ordinal()] = 3;
            nArray[KeyCode.VOLUME_UP.ordinal()] = 4;
            nArray[KeyCode.VOLUME_DOWN.ordinal()] = 5;
            nArray[KeyCode.HOME.ordinal()] = 6;
            nArray[KeyCode.LOCK.ordinal()] = 7;
            nArray[KeyCode.REMOTE_UP.ordinal()] = 8;
            nArray[KeyCode.REMOTE_DOWN.ordinal()] = 9;
            nArray[KeyCode.REMOTE_LEFT.ordinal()] = 10;
            nArray[KeyCode.REMOTE_RIGHT.ordinal()] = 11;
            nArray[KeyCode.REMOTE_CENTER.ordinal()] = 12;
            nArray[KeyCode.REMOTE_PLAY_PAUSE.ordinal()] = 13;
            nArray[KeyCode.REMOTE_STOP.ordinal()] = 14;
            nArray[KeyCode.REMOTE_NEXT.ordinal()] = 15;
            nArray[KeyCode.REMOTE_PREVIOUS.ordinal()] = 16;
            nArray[KeyCode.REMOTE_REWIND.ordinal()] = 17;
            nArray[KeyCode.REMOTE_FAST_FORWARD.ordinal()] = 18;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SwipeDirection.values().length];
            nArray[SwipeDirection.UP.ordinal()] = 1;
            nArray[SwipeDirection.DOWN.ordinal()] = 2;
            nArray[SwipeDirection.RIGHT.ordinal()] = 3;
            nArray[SwipeDirection.LEFT.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

