/*
 * Decompiled with CFR 0.152.
 */
package maestro.drivers;

import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import com.github.michaelbull.result.UnwrapException;
import hierarchy.AccessibilityNode;
import hierarchy.IdbElementNode;
import hierarchy.XCUIElement;
import hierarchy.XCUIElementNode;
import ios.IOSDevice;
import ios.IOSScreenRecording;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.Driver;
import maestro.Filters;
import maestro.KeyCode;
import maestro.MaestroException;
import maestro.Platform;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TreeNode;
import maestro.UiElement;
import maestro.drivers.IOSDriver;
import maestro.utils.FileUtils;
import maestro.utils.MaestroTimer;
import maestro.utils.ScreenshotUtils;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.XCRunnerCLIUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 t2\u00020\u0001:\u0001tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010\u0007\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001eH\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u0014H\u0016J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u001eH\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0006H\u0016J\b\u00101\u001a\u00020\u0019H\u0002J\b\u00102\u001a\u00020\u0019H\u0002J\b\u00103\u001a\u00020\u0019H\u0016J\b\u00104\u001a\u00020\u0019H\u0016J\u001e\u00105\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0016J\u0010\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020\u0006H\u0016J\b\u0010>\u001a\u00020\u001eH\u0016J*\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020\u0019H\u0016J\u0010\u0010C\u001a\u00020&2\u0006\u0010;\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020&2\u0006\u0010;\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u001e2\u0006\u0010H\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010K\u001a\u00020LH\u0016J\u0018\u0010M\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010N\u001a\u00020LH\u0016J\b\u0010O\u001a\u00020\u001eH\u0016J\b\u0010P\u001a\u00020\u001eH\u0016J\u0018\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020-2\u0006\u0010S\u001a\u00020-H\u0016J$\u0010T\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060VH\u0016J\u0018\u0010W\u001a\u00020\u001e2\u0006\u0010X\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\u0014H\u0016J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010_\u001a\u00020\u001e2\u0006\u0010`\u001a\u0002092\u0006\u0010a\u001a\u0002092\u0006\u0010b\u001a\u00020cH\u0016J \u0010_\u001a\u00020\u001e2\u0006\u0010d\u001a\u0002092\u0006\u0010e\u001a\u00020f2\u0006\u0010b\u001a\u00020cH\u0016J\u0018\u0010_\u001a\u00020\u001e2\u0006\u0010g\u001a\u00020f2\u0006\u0010b\u001a\u00020cH\u0016J\u0018\u0010h\u001a\u00020\u001e2\u0006\u0010\\\u001a\u00020]2\u0006\u0010i\u001a\u00020\u0019H\u0016J\u0010\u0010j\u001a\u00020\u001e2\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010k\u001a\u00020\u001e2\u0006\u0010`\u001a\u0002092\u0006\u0010a\u001a\u000209H\u0002J!\u0010l\u001a\u0004\u0018\u00010m2\b\u0010n\u001a\u0004\u0018\u00010mH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bo\u0010pJ\u0010\u0010q\u001a\u00020\u00192\u0006\u0010r\u001a\u00020cH\u0016J\u0010\u0010s\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\f\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\f\u001a\u0004\b\u001b\u0010\u0016\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006u"}, d2={"Lmaestro/drivers/IOSDriver;", "Lmaestro/Driver;", "iosDevice", "Lios/IOSDevice;", "(Lios/IOSDevice;)V", "appId", "", "deviceInfo", "Lios/device/DeviceInfo;", "getDeviceInfo", "()Lios/device/DeviceInfo;", "deviceInfo$delegate", "Lkotlin/Lazy;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "executor$delegate", "heightPoints", "", "getHeightPoints", "()I", "heightPoints$delegate", "proxySet", "", "widthPoints", "getWidthPoints", "widthPoints$delegate", "backPress", "", "capabilities", "", "Lmaestro/Capability;", "clearAppState", "clearKeychain", "close", "contentDescriptor", "Lmaestro/TreeNode;", "Lmaestro/DeviceInfo;", "dismissKeyboardIntroduction", "eraseText", "charactersToErase", "heightPercentToPoint", "percent", "", "hideKeyboard", "inputText", "text", "isKeyboardHidden", "isScreenStatic", "isShutdown", "isUnicodeInputSupported", "launchApp", "launchArguments", "longPress", "point", "Lmaestro/Point;", "mapHierarchy", "xcUiElement", "Lhierarchy/XCUIElement;", "name", "open", "openLink", "link", "autoVerify", "browser", "parseIdbElementNode", "Lhierarchy/IdbElementNode;", "parseXCUIElementNode", "Lhierarchy/XCUIElementNode;", "pressKey", "code", "Lmaestro/KeyCode;", "pullAppState", "outFile", "Ljava/io/File;", "pushAppState", "stateFile", "resetProxy", "scrollVertical", "setLocation", "latitude", "longitude", "setPermissions", "permissions", "", "setProxy", "host", "port", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "stopApp", "swipe", "start", "end", "durationMs", "", "elementPoint", "direction", "Lmaestro/SwipeDirection;", "swipeDirection", "takeScreenshot", "compressed", "tap", "validate", "waitForAppToSettle", "Lmaestro/ViewHierarchy;", "initialHierarchy", "waitForAppToSettle-LubAXRY", "(Lmaestro/TreeNode;)Lmaestro/TreeNode;", "waitUntilScreenIsStatic", "timeoutMs", "widthPercentToPoint", "Companion", "maestro-client"})
public final class IOSDriver
implements Driver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IOSDevice iosDevice;
    @NotNull
    private final Lazy executor$delegate;
    @NotNull
    private final Lazy deviceInfo$delegate;
    @NotNull
    private final Lazy widthPoints$delegate;
    @NotNull
    private final Lazy heightPoints$delegate;
    @Nullable
    private String appId;
    private boolean proxySet;
    @NotNull
    public static final String NAME = "iOS Simulator";
    private static final Logger LOGGER = LoggerFactory.getLogger(IOSDevice.class);
    private static final int ELEMENT_TYPE_CHECKBOX = 12;
    private static final int ELEMENT_TYPE_SWITCH = 40;
    private static final int ELEMENT_TYPE_TOGGLE = 41;
    @NotNull
    private static final Set<Integer> CHECKABLE_ELEMENTS;
    private static final long SCREEN_SETTLE_TIMEOUT_MS = 3000L;

    public IOSDriver(@NotNull IOSDevice iosDevice) {
        Intrinsics.checkNotNullParameter((Object)iosDevice, (String)"iosDevice");
        this.iosDevice = iosDevice;
        this.executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);
        this.deviceInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ios.device.DeviceInfo>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ios.device.DeviceInfo invoke() {
                Result $this$expect$iv = IOSDriver.access$getIosDevice$p(this.this$0).deviceInfo();
                boolean $i$f$expect = false;
                Result result = $this$expect$iv;
                if (!(result instanceof Ok)) {
                    if (result instanceof Err) {
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl = false;
                        String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                        throw new UnwrapException(string);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return (ios.device.DeviceInfo)((Ok)$this$expect$iv).getValue();
            }
        }));
        this.widthPoints$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return IOSDriver.access$getDeviceInfo(this.this$0).getWidthPoints();
            }
        }));
        this.heightPoints$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return IOSDriver.access$getDeviceInfo(this.this$0).getHeightPoints();
            }
        }));
    }

    private final ExecutorService getExecutor() {
        Lazy lazy = this.executor$delegate;
        return (ExecutorService)lazy.getValue();
    }

    private final ios.device.DeviceInfo getDeviceInfo() {
        Lazy lazy = this.deviceInfo$delegate;
        return (ios.device.DeviceInfo)lazy.getValue();
    }

    private final int getWidthPoints() {
        Lazy lazy = this.widthPoints$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int getHeightPoints() {
        Lazy lazy = this.heightPoints$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    @NotNull
    public String name() {
        return NAME;
    }

    @Override
    public void open() {
        this.iosDevice.open();
    }

    @Override
    public void close() {
        if (this.proxySet) {
            this.resetProxy();
        }
        this.iosDevice.close();
        this.appId = null;
    }

    @Override
    @NotNull
    public DeviceInfo deviceInfo() {
        return new DeviceInfo(Platform.IOS, this.getDeviceInfo().getWidthPixels(), this.getDeviceInfo().getHeightPixels(), this.getDeviceInfo().getWidthPoints(), this.getDeviceInfo().getHeightPoints());
    }

    @Override
    public void launchApp(@NotNull String appId, @NotNull List<String> launchArguments) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        Result $this$onSuccess$iv = this.iosDevice.launch(appId, launchArguments);
        boolean $i$f$onSuccess = false;
        if ($this$onSuccess$iv instanceof Ok) {
            Unit it = (Unit)((Ok)$this$onSuccess$iv).getValue();
            boolean bl = false;
            this.appId = appId;
        }
        Result $this$getOrThrow$iv = $this$onSuccess$iv;
        boolean $i$f$getOrThrow = false;
        Result result = $this$getOrThrow$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                Throwable it = (Throwable)((Err)$this$getOrThrow$iv).getError();
                boolean bl = false;
                throw (Throwable)new MaestroException.UnableToLaunchApp("Unable to launch app " + appId + ' ' + it.getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$getOrThrow$iv).getValue();
    }

    @Override
    public void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.iosDevice.stop(appId);
    }

    @Override
    public void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.iosDevice.clearAppState(appId);
    }

    @Override
    public void clearKeychain() {
        Result $this$expect$iv = this.iosDevice.clearKeychain();
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$expect$iv).getValue();
    }

    @Override
    public void pullAppState(@NotNull String appId, @NotNull File outFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        Path tmpDir = Files.createTempDirectory("maestro_state_", new FileAttribute[0]);
        Comparable<File> comparable = tmpDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tmpDir.toFile()");
        Result $this$getOrThrow$iv = this.iosDevice.pullAppState(appId, comparable);
        boolean $i$f$getOrThrow = false;
        Result result = $this$getOrThrow$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                Throwable it = (Throwable)((Err)$this$getOrThrow$iv).getError();
                boolean bl = false;
                throw (Throwable)new MaestroException.UnableToPullState("Unable to pull state for " + appId + ". " + it.getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$getOrThrow$iv).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
        comparable = outFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"outFile.toPath()");
        FileUtils.INSTANCE.zipDir(tmpDir, (Path)comparable);
        FileUtils.INSTANCE.deleteDir(tmpDir);
    }

    @Override
    public void pushAppState(@NotNull String appId, @NotNull File stateFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
        Path tmpDir = Files.createTempDirectory("maestro_state_", new FileAttribute[0]);
        Comparable<Path> comparable = stateFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"stateFile.toPath()");
        Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
        FileUtils.INSTANCE.unzip((Path)comparable, tmpDir);
        comparable = tmpDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tmpDir.toFile()");
        Result $this$getOrThrow$iv = this.iosDevice.pushAppState(appId, (File)comparable);
        boolean $i$f$getOrThrow = false;
        Result result = $this$getOrThrow$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                Throwable it = (Throwable)((Err)$this$getOrThrow$iv).getError();
                boolean bl = false;
                throw (Throwable)new MaestroException.UnableToPushState("Unable to push state for " + appId + ". " + it.getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$getOrThrow$iv).getValue();
        FileUtils.INSTANCE.deleteDir(tmpDir);
    }

    @Override
    public void tap(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Result $this$expect$iv = this.iosDevice.tap(point.getX(), point.getY());
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$expect$iv).getValue();
    }

    @Override
    public void longPress(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Result $this$expect$iv = this.iosDevice.longPress(point.getX(), point.getY(), 3000L);
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$expect$iv).getValue();
    }

    @Override
    public void pressKey(@NotNull KeyCode code) {
        String name;
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KeyCode.BACKSPACE), (Object)"delete"), TuplesKt.to((Object)((Object)KeyCode.ENTER), (Object)"return")};
        Map keyCodeNameMap = MapsKt.mapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)KeyCode.HOME), (Object)"home"), TuplesKt.to((Object)((Object)KeyCode.LOCK), (Object)"lock")};
        Map buttonNameMap = MapsKt.mapOf((Pair[])pairArray2);
        String string = (String)keyCodeNameMap.get((Object)code);
        if (string != null) {
            name = string;
            boolean bl = false;
            this.iosDevice.pressKey(name);
        }
        String string2 = (String)buttonNameMap.get((Object)code);
        if (string2 != null) {
            name = string2;
            boolean bl = false;
            this.iosDevice.pressButton(name);
        }
    }

    @Override
    @NotNull
    public TreeNode contentDescriptor() {
        TreeNode treeNode;
        Result contentDescriptorResult = this.iosDevice.contentDescriptor();
        if (contentDescriptorResult instanceof Ok) {
            treeNode = this.mapHierarchy((XCUIElement)((Ok)contentDescriptorResult).getValue());
        } else if (contentDescriptorResult instanceof Err) {
            treeNode = new TreeNode(null, null, null, null, null, null, null, 127, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return treeNode;
    }

    @Override
    public boolean isUnicodeInputSupported() {
        return true;
    }

    private final TreeNode mapHierarchy(XCUIElement xcUiElement) {
        TreeNode treeNode;
        XCUIElement xCUIElement = xcUiElement;
        if (xCUIElement instanceof XCUIElementNode) {
            treeNode = this.parseXCUIElementNode((XCUIElementNode)xcUiElement);
        } else if (xCUIElement instanceof IdbElementNode) {
            treeNode = this.parseIdbElementNode((IdbElementNode)xcUiElement);
        } else {
            throw new IllegalStateException("Illegal instance for parsing hierarchy".toString());
        }
        return treeNode;
    }

    /*
     * WARNING - void declaration
     */
    private final TreeNode parseIdbElementNode(IdbElementNode xcUiElement) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = xcUiElement.getChildren();
        Map map = null;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            Map map2;
            String string2;
            void it;
            AccessibilityNode accessibilityNode = (AccessibilityNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map attributes = new LinkedHashMap();
            String string3 = it.getTitle();
            if (string3 == null) {
                String string4 = it.getAxLabel();
                string3 = string4 == null ? it.getAxValue() : string4;
            }
            if ((string2 = string3) != null) {
                String title = string2;
                boolean bl2 = false;
                map2 = attributes;
                string = "text";
                map2.put(string, title);
            }
            if (it.getAxUniqueId() != null) {
                String resourceId;
                boolean bl3 = false;
                map2 = attributes;
                string = "resource-id";
                map2.put(string, resourceId);
            }
            AccessibilityNode.Frame frame = it.getFrame();
            boolean bl4 = false;
            int left = (int)frame.getX();
            int top = (int)frame.getY();
            int right = left + (int)frame.getWidth();
            int bottom = top + (int)frame.getHeight();
            attributes.put("bounds", "" + '[' + left + ',' + top + "][" + right + ',' + bottom + ']');
            collection.add(new TreeNode(attributes, null, null, it.getEnabled(), null, null, null, 118, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 125;
        Boolean bl = null;
        Boolean bl5 = null;
        Boolean bl6 = null;
        Boolean bl7 = null;
        Boolean bl8 = null;
        List list = (List)destination$iv$iv;
        Map map3 = map;
        return new TreeNode(map3, list, bl8, bl7, bl6, bl5, bl, n, defaultConstructorMarker);
    }

    private final TreeNode parseXCUIElementNode(XCUIElementNode xcUiElement) {
        String string;
        Map attributes = new LinkedHashMap();
        String string2 = xcUiElement.getTitle();
        if (string2 == null) {
            string = null;
        } else {
            CharSequence charSequence;
            CharSequence charSequence2 = string2;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = xcUiElement.getValue();
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        }
        String text = string;
        attributes.put("accessibilityText", xcUiElement.getLabel());
        String string3 = text;
        if (string3 == null) {
            string3 = "";
        }
        attributes.put("text", string3);
        String string4 = xcUiElement.getPlaceholderValue();
        if (string4 == null) {
            string4 = "";
        }
        attributes.put("hintText", string4);
        attributes.put("resource-id", xcUiElement.getIdentifier());
        float right = xcUiElement.getFrame().getX() + xcUiElement.getFrame().getWidth();
        float bottom = xcUiElement.getFrame().getY() + xcUiElement.getFrame().getHeight();
        attributes.put("bounds", "" + '[' + (int)xcUiElement.getFrame().getX() + ',' + (int)xcUiElement.getFrame().getY() + "][" + (int)right + ',' + (int)bottom + ']');
        attributes.put("enabled", String.valueOf(xcUiElement.getEnabled()));
        attributes.put("focused", String.valueOf(xcUiElement.getHasFocus()));
        attributes.put("selected", String.valueOf(xcUiElement.getSelected()));
        boolean checked2 = CHECKABLE_ELEMENTS.contains(xcUiElement.getElementType()) && Intrinsics.areEqual((Object)xcUiElement.getValue(), (Object)"1");
        attributes.put("checked", String.valueOf(checked2));
        List children = new ArrayList();
        ArrayList childNodes = xcUiElement.getChildren();
        if (childNodes != null) {
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)childNodes.size());
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Collection collection = children;
                Object e = childNodes.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"childNodes[i]");
                collection.add(this.mapHierarchy((XCUIElement)e));
            }
        }
        boolean bl = xcUiElement.getEnabled();
        boolean bl2 = xcUiElement.getHasFocus();
        boolean bl3 = xcUiElement.getSelected();
        return new TreeNode(attributes, children, null, bl, bl2, checked2, bl3, 4, null);
    }

    @Override
    public void scrollVertical() {
        this.swipe(new Point(this.widthPercentToPoint(0.5), this.heightPercentToPoint(0.5)), new Point(this.widthPercentToPoint(0.5), this.heightPercentToPoint(0.1)), 333L);
    }

    private final void validate(Point start2, Point end) {
        int screenWidth = this.getWidthPoints();
        int screenHeight = this.getHeightPoints();
        if (start2.getX() < 0 || start2.getX() > screenWidth) {
            throw new IllegalStateException(("x value of start point (" + start2.getX() + ") needs to be between 0 and " + screenWidth).toString());
        }
        if (end.getX() < 0 || end.getX() > screenWidth) {
            throw new IllegalStateException(("x value of end point (" + end.getX() + ") needs to be between 0 and " + screenWidth).toString());
        }
        if (start2.getY() < 0 || start2.getY() > screenHeight) {
            throw new IllegalStateException(("y value of start point (" + start2.getY() + ") needs to be between 0 and " + screenHeight).toString());
        }
        if (end.getY() < 0 || end.getY() > screenHeight) {
            throw new IllegalStateException(("y value of end point (" + end.getY() + ") needs to be between 0 and " + screenHeight).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void swipe(@NotNull Point start2, @NotNull Point end, long durationMs) {
        void $this$expect$iv;
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.validate(start2, end);
        this.waitForAppToSettle-LubAXRY(null);
        Result result = this.iosDevice.scroll((double)start2.getX(), (double)start2.getY(), (double)end.getX(), (double)end.getY(), (double)durationMs / (double)1000);
        boolean $i$f$expect = false;
        void var7_6 = $this$expect$iv;
        if (!(var7_6 instanceof Ok)) {
            if (var7_6 instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$expect$iv).getValue();
    }

    @Override
    public void swipe(@NotNull SwipeDirection swipeDirection, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        Point startPoint = null;
        Point endPoint = null;
        switch (WhenMappings.$EnumSwitchMapping$0[swipeDirection.ordinal()]) {
            case 1: {
                startPoint = new Point(this.widthPercentToPoint(0.5), this.heightPercentToPoint(0.9));
                endPoint = new Point(this.widthPercentToPoint(0.5), this.heightPercentToPoint(0.1));
                break;
            }
            case 2: {
                startPoint = new Point(this.widthPercentToPoint(0.5), this.heightPercentToPoint(0.2));
                endPoint = new Point(this.widthPercentToPoint(0.5), this.heightPercentToPoint(0.9));
                break;
            }
            case 3: {
                startPoint = new Point(this.widthPercentToPoint(0.1), this.heightPercentToPoint(0.5));
                endPoint = new Point(this.widthPercentToPoint(0.9), this.heightPercentToPoint(0.5));
                break;
            }
            case 4: {
                startPoint = new Point(this.widthPercentToPoint(0.9), this.heightPercentToPoint(0.5));
                endPoint = new Point(this.widthPercentToPoint(0.1), this.heightPercentToPoint(0.5));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.swipe(startPoint, endPoint, durationMs);
    }

    @Override
    public void swipe(@NotNull Point elementPoint, @NotNull SwipeDirection direction, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)elementPoint, (String)"elementPoint");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                Point end = new Point(elementPoint.getX(), this.heightPercentToPoint(0.1));
                this.swipe(elementPoint, end, durationMs);
                break;
            }
            case 2: {
                Point end = new Point(elementPoint.getX(), this.heightPercentToPoint(0.9));
                this.swipe(elementPoint, end, durationMs);
                break;
            }
            case 3: {
                Point end = new Point(this.widthPercentToPoint(0.9), elementPoint.getY());
                this.swipe(elementPoint, end, durationMs);
                break;
            }
            case 4: {
                Point end = new Point(this.widthPercentToPoint(0.1), elementPoint.getY());
                this.swipe(elementPoint, end, durationMs);
            }
        }
    }

    @Override
    public void backPress() {
    }

    @Override
    public void hideKeyboard() {
        Future<?> future = this.getExecutor().submit(() -> IOSDriver.hideKeyboard$lambda-16(this));
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception _) {
            future.cancel(true);
        }
    }

    private final boolean isKeyboardHidden() {
        Function1<List<TreeNode>, List<TreeNode>> filter = Filters.INSTANCE.idMatches(new Regex("delete"));
        TreeNode treeNode = (TreeNode)MaestroTimer.INSTANCE.withTimeout(2000L, (Function0)new Function0<TreeNode>(filter, this){
            final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $filter;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$filter = $filter;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TreeNode invoke() {
                return (TreeNode)CollectionsKt.firstOrNull((List)((List)this.$filter.invoke(this.this$0.contentDescriptor().aggregate())));
            }
        });
        UiElement element2 = treeNode == null ? null : UiElement.Companion.toUiElementOrNull(treeNode);
        return element2 == null;
    }

    private final void dismissKeyboardIntroduction() {
        UiElement instructionText2;
        Regex fastTypingInstruction = new Regex("Speed up your typing by sliding your finger across the letters to compose a word.*");
        Function1<List<TreeNode>, List<TreeNode>> instructionTextFilter = Filters.INSTANCE.textMatches(fastTypingInstruction);
        TreeNode treeNode = (TreeNode)MaestroTimer.INSTANCE.withTimeout(2000L, (Function0)new Function0<TreeNode>(instructionTextFilter, this){
            final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $instructionTextFilter;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$instructionTextFilter = $instructionTextFilter;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TreeNode invoke() {
                return (TreeNode)CollectionsKt.firstOrNull((List)((List)this.$instructionTextFilter.invoke(this.this$0.contentDescriptor().aggregate())));
            }
        });
        UiElement uiElement = instructionText2 = treeNode == null ? null : UiElement.Companion.toUiElementOrNull(treeNode);
        if (instructionText2 != null) {
            int n = this.getHeightPoints() / 2;
            int n2 = this.getHeightPoints();
            int n3 = instructionText2.getBounds().center().getY();
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (bl) {
                UiElement continueElement2;
                Function1<List<TreeNode>, List<TreeNode>> continueElementFilter = Filters.INSTANCE.textMatches(new Regex("Continue"));
                TreeNode treeNode2 = (TreeNode)MaestroTimer.INSTANCE.withTimeout(2000L, (Function0)new Function0<TreeNode>(continueElementFilter, this, instructionText2){
                    final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $continueElementFilter;
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ UiElement $instructionText;
                    {
                        this.$continueElementFilter = $continueElementFilter;
                        this.this$0 = $receiver;
                        this.$instructionText = $instructionText;
                        super(0);
                    }

                    @Nullable
                    public final TreeNode invoke() {
                        Object v0;
                        block1: {
                            Iterable iterable = (Iterable)this.$continueElementFilter.invoke(this.this$0.contentDescriptor().aggregate());
                            UiElement uiElement = this.$instructionText;
                            for (T t : iterable) {
                                TreeNode it = (TreeNode)t;
                                boolean bl = false;
                                if (!(UiElement.Companion.toUiElement(it).getBounds().center().getY() > uiElement.getBounds().center().getY())) continue;
                                v0 = t;
                                break block1;
                            }
                            v0 = null;
                        }
                        return v0;
                    }
                });
                UiElement uiElement2 = continueElement2 = treeNode2 == null ? null : UiElement.Companion.toUiElementOrNull(treeNode2);
                if (continueElement2 != null && continueElement2.getBounds().center().getY() > instructionText2.getBounds().center().getY()) {
                    this.tap(continueElement2.getBounds().center());
                }
            }
        }
    }

    @Override
    public void takeScreenshot(@NotNull Sink out, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Result $this$expect$iv = this.iosDevice.takeScreenshot(out, compressed);
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$expect$iv).getValue();
    }

    @Override
    @NotNull
    public ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Result $this$expect$iv = this.iosDevice.startScreenRecording(out);
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        IOSScreenRecording iosScreenRecording = (IOSScreenRecording)((Ok)$this$expect$iv).getValue();
        return new ScreenRecording(iosScreenRecording){
            final /* synthetic */ IOSScreenRecording $iosScreenRecording;
            {
                this.$iosScreenRecording = $iosScreenRecording;
            }

            public void close() {
                this.$iosScreenRecording.close();
            }
        };
    }

    @Override
    public void inputText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.iosDevice.input(text);
    }

    @Override
    public void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Result $this$expect$iv = this.iosDevice.openLink(link);
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$expect$iv).getValue();
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        Result $this$expect$iv = this.iosDevice.setLocation(latitude, longitude);
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Ok)$this$expect$iv).getValue();
    }

    @Override
    public void eraseText(int charactersToErase) {
        this.iosDevice.eraseText(charactersToErase);
    }

    @Override
    public void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        XCRunnerCLIUtils.INSTANCE.setProxy(host, port);
        this.proxySet = true;
    }

    @Override
    public void resetProxy() {
        XCRunnerCLIUtils.INSTANCE.resetProxy();
    }

    @Override
    public boolean isShutdown() {
        return this.iosDevice.isShutdown();
    }

    @Override
    public boolean waitUntilScreenIsStatic(long timeoutMs) {
        return MaestroTimer.retryUntilTrue$default((MaestroTimer)MaestroTimer.INSTANCE, (long)timeoutMs, null, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean isScreenStatic = IOSDriver.access$isScreenStatic(this.this$0);
                IOSDriver.access$getLOGGER$cp().info(Intrinsics.stringPlus((String)"screen static = ", (Object)isScreenStatic));
                return isScreenStatic;
            }
        }), (int)2, null);
    }

    @Override
    @Nullable
    public TreeNode waitForAppToSettle-LubAXRY(@Nullable TreeNode initialHierarchy) {
        LOGGER.info("Waiting for animation to end with timeout 3000");
        boolean didFinishOnTime = this.waitUntilScreenIsStatic(3000L);
        return didFinishOnTime ? null : ScreenshotUtils.Companion.waitForAppToSettle-d60svg8(initialHierarchy, this);
    }

    @Override
    @NotNull
    public List<Capability> capabilities() {
        return CollectionsKt.emptyList();
    }

    @Override
    public void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.iosDevice.setPermissions(appId, permissions);
    }

    private final boolean isScreenStatic() {
        Result $this$expect$iv = this.iosDevice.isScreenStatic();
        boolean $i$f$expect = false;
        Result result = $this$expect$iv;
        if (!(result instanceof Ok)) {
            if (result instanceof Err) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                throw new UnwrapException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (Boolean)((Ok)$this$expect$iv).getValue();
    }

    private final int heightPercentToPoint(double percent) {
        return (int)(percent * (double)this.getHeightPoints());
    }

    private final int widthPercentToPoint(double percent) {
        return (int)(percent * (double)this.getWidthPoints());
    }

    private static final void hideKeyboard$lambda-16(IOSDriver this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.dismissKeyboardIntroduction();
        if (this$0.isKeyboardHidden()) {
            return;
        }
        this$0.swipe(new Point(this$0.widthPercentToPoint(0.5), this$0.heightPercentToPoint(0.5)), new Point(this$0.widthPercentToPoint(0.5), this$0.heightPercentToPoint(0.47)), 50L);
        if (this$0.isKeyboardHidden()) {
            return;
        }
        this$0.swipe(new Point(this$0.widthPercentToPoint(0.5), this$0.heightPercentToPoint(0.5)), new Point(this$0.widthPercentToPoint(0.47), this$0.heightPercentToPoint(0.5)), 50L);
        this$0.waitForAppToSettle-LubAXRY(null);
    }

    public static final /* synthetic */ boolean access$isScreenStatic(IOSDriver $this) {
        return $this.isScreenStatic();
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ IOSDevice access$getIosDevice$p(IOSDriver $this) {
        return $this.iosDevice;
    }

    public static final /* synthetic */ ios.device.DeviceInfo access$getDeviceInfo(IOSDriver $this) {
        return $this.getDeviceInfo();
    }

    static {
        Object[] objectArray = new Integer[]{12, 40, 41};
        CHECKABLE_ELEMENTS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmaestro/drivers/IOSDriver$Companion;", "", "()V", "CHECKABLE_ELEMENTS", "", "", "ELEMENT_TYPE_CHECKBOX", "ELEMENT_TYPE_SWITCH", "ELEMENT_TYPE_TOGGLE", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "NAME", "", "SCREEN_SETTLE_TIMEOUT_MS", "", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SwipeDirection.values().length];
            nArray[SwipeDirection.UP.ordinal()] = 1;
            nArray[SwipeDirection.DOWN.ordinal()] = 2;
            nArray[SwipeDirection.RIGHT.ordinal()] = 3;
            nArray[SwipeDirection.LEFT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

