/*
 * Decompiled with CFR 0.152.
 */
package maestro.drivers;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.Driver;
import maestro.KeyCode;
import maestro.Maestro;
import maestro.Platform;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TreeNode;
import maestro.utils.ScreenshotUtils;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.apache.commons.io.output.NullOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverLogLevel;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 a2\u00020\u0001:\u0001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0007H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016J\u001e\u0010#\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0007H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J*\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0016J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u00105\u001a\u000203H\u0016J\u0018\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u001aH\u0002J\b\u00109\u001a\u00020\u000bH\u0016J\u0018\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010?\u001a\u00020\u000bH\u0016J\u0018\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0016J$\u0010D\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070FH\u0016J\u0018\u0010G\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u001aH\u0016J\u0010\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020>H\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0016\u0010Q\u001a\u00020\u000b2\u0006\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020'J \u0010Q\u001a\u00020\u000b2\u0006\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020'2\u0006\u0010R\u001a\u00020>H\u0016J \u0010Q\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020'2\u0006\u0010T\u001a\u00020U2\u0006\u0010R\u001a\u00020>H\u0016J\u0018\u0010Q\u001a\u00020\u000b2\u0006\u0010V\u001a\u00020U2\u0006\u0010R\u001a\u00020>H\u0016J\u0018\u0010W\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020O2\u0006\u0010X\u001a\u00020\u0003H\u0016J\u0010\u0010Y\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J!\u0010Z\u001a\u0004\u0018\u00010[2\b\u0010\\\u001a\u0004\u0018\u00010[H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b]\u0010^J\u0010\u0010_\u001a\u00020\u00032\u0006\u0010`\u001a\u00020>H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006b"}, d2={"Lmaestro/drivers/WebDriver;", "Lmaestro/Driver;", "isStudio", "", "(Z)V", "()Z", "maestroWebScript", "", "seleniumDriver", "Lorg/openqa/selenium/WebDriver;", "backPress", "", "capabilities", "", "Lmaestro/Capability;", "clearAppState", "appId", "clearKeychain", "close", "contentDescriptor", "Lmaestro/TreeNode;", "deviceInfo", "Lmaestro/DeviceInfo;", "ensureOpen", "eraseText", "charactersToErase", "", "executeJS", "", "js", "hideKeyboard", "inputText", "text", "isShutdown", "isUnicodeInputSupported", "launchApp", "launchArguments", "longPress", "point", "Lmaestro/Point;", "name", "open", "openLink", "link", "autoVerify", "browser", "pressKey", "code", "Lmaestro/KeyCode;", "pullAppState", "outFile", "Ljava/io/File;", "pushAppState", "stateFile", "random", "start", "end", "resetProxy", "scroll", "top", "left", "scrollToPoint", "", "scrollVertical", "setLocation", "latitude", "", "longitude", "setPermissions", "permissions", "", "setProxy", "host", "port", "sleep", "ms", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "stopApp", "swipe", "durationMs", "elementPoint", "direction", "Lmaestro/SwipeDirection;", "swipeDirection", "takeScreenshot", "compressed", "tap", "waitForAppToSettle", "Lmaestro/ViewHierarchy;", "initialHierarchy", "waitForAppToSettle-LubAXRY", "(Lmaestro/TreeNode;)Lmaestro/TreeNode;", "waitUntilScreenIsStatic", "timeoutMs", "Companion", "maestro-client"})
public final class WebDriver
implements Driver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isStudio;
    @Nullable
    private org.openqa.selenium.WebDriver seleniumDriver;
    @Nullable
    private String maestroWebScript;
    private static final double SCREENSHOT_DIFF_THRESHOLD = 0.005;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver(boolean isStudio) {
        Unit unit;
        Unit unit2;
        this.isStudio = isStudio;
        InputStream inputStream = Maestro.class.getResourceAsStream("/maestro-web.js");
        if (inputStream == null) {
            unit2 = null;
        } else {
            InputStream it = inputStream;
            boolean bl = false;
            Closeable closeable = it;
            Object object = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            object = null;
            try {
                BufferedReader br = (BufferedReader)closeable;
                boolean bl2 = false;
                this.maestroWebScript = TextStreamsKt.readText((Reader)br);
                reader = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new IllegalStateException("Could not read maestro web script".toString());
        }
    }

    public final boolean isStudio() {
        return this.isStudio;
    }

    @Override
    @NotNull
    public String name() {
        return "Chromium Desktop Browser (Experimental)";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open() {
        void $this$open_u24lambda_u2d2;
        ChromeOptions chromeOptions;
        System.setProperty("webdriver.chrome.silentOutput", "true");
        System.setProperty("webdriver.chrome.silentOutput", "true");
        Logger.getLogger("org.openqa.selenium").setLevel(Level.OFF);
        Logger.getLogger("org.openqa.selenium.devtools.CdpVersionFinder").setLevel(Level.OFF);
        WebDriverManager.chromedriver().setup();
        ChromeDriverService driverService = (ChromeDriverService)new ChromeDriverService.Builder().build();
        driverService.sendOutputTo((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        ChromeOptions chromeOptions2 = chromeOptions = new ChromeOptions();
        ChromeDriverService chromeDriverService = driverService;
        WebDriver webDriver = this;
        boolean bl = false;
        $this$open_u24lambda_u2d2.setLogLevel(ChromeDriverLogLevel.OFF);
        String[] stringArray = new String[]{"--remote-allow-origins=*"};
        $this$open_u24lambda_u2d2.addArguments(stringArray);
        if (this.isStudio()) {
            $this$open_u24lambda_u2d2.setHeadless(true);
            stringArray = new String[]{"--window-size=1024,768"};
            $this$open_u24lambda_u2d2.addArguments(stringArray);
        }
        Unit unit = Unit.INSTANCE;
        ChromeOptions chromeOptions3 = chromeOptions;
        ChromeDriverService chromeDriverService2 = chromeDriverService;
        webDriver.seleniumDriver = (org.openqa.selenium.WebDriver)new ChromeDriver(chromeDriverService2, chromeOptions3);
        if (this.isStudio) {
            org.openqa.selenium.WebDriver webDriver2 = this.seleniumDriver;
            if (webDriver2 != null) {
                webDriver2.get("https://maestro.mobile.dev");
            }
        }
    }

    private final org.openqa.selenium.WebDriver ensureOpen() {
        org.openqa.selenium.WebDriver webDriver = this.seleniumDriver;
        if (webDriver == null) {
            throw new IllegalStateException("Driver is not open".toString());
        }
        return webDriver;
    }

    private final Object executeJS(String js) {
        org.openqa.selenium.WebDriver webDriver = this.seleniumDriver;
        if (webDriver == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openqa.selenium.JavascriptExecutor");
        }
        JavascriptExecutor executor2 = (JavascriptExecutor)webDriver;
        try {
            executor2.executeScript(String.valueOf(this.maestroWebScript), new Object[0]);
            Thread.sleep(100L);
            return executor2.executeScript(js, new Object[0]);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null ? false : StringsKt.contains$default((CharSequence)string, (CharSequence)"getContentDescription", (boolean)false, (int)2, null)) {
                return this.executeJS(js);
            }
            return null;
        }
    }

    private final long scrollToPoint(Point point) {
        this.ensureOpen();
        Object object = this.executeJS("return window.innerHeight");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
        }
        long windowHeight = (Long)object;
        if (point.getY() > 0 && (long)point.getY() <= windowHeight - (long)50) {
            return 0L;
        }
        Object object2 = this.executeJS("const delta = " + point.getY() + " - Math.floor(window.innerHeight / 2); window.scrollBy({ top: delta, left: 0, behavior: 'smooth' }); return delta");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
        }
        long scrolledPixels = (Long)object2;
        this.sleep(3000L);
        return scrolledPixels;
    }

    private final void sleep(long ms) {
        Thread.sleep(ms);
    }

    private final void scroll(String top, String left) {
        this.executeJS("window.scroll({ top: " + top + ", left: " + left + ", behavior: 'smooth' });");
    }

    private final int random(int start2, int end) {
        return new Random().nextInt(end + 1 - start2) + start2;
    }

    @Override
    public void close() {
        org.openqa.selenium.WebDriver webDriver = this.seleniumDriver;
        if (webDriver != null) {
            webDriver.quit();
        }
        this.seleniumDriver = null;
    }

    @Override
    @NotNull
    public DeviceInfo deviceInfo() {
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        Dimension windowSize = driver.manage().window().getSize();
        return new DeviceInfo(Platform.WEB, windowSize.width, windowSize.height, windowSize.width, windowSize.height);
    }

    @Override
    public void launchApp(@NotNull String appId, @NotNull List<String> launchArguments) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        this.open();
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        driver.manage().timeouts().implicitlyWait(Duration.ofMillis(5000L));
        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(30L));
        driver.get(appId);
        wait.until(WebDriver::launchApp$lambda-3);
    }

    @Override
    public void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        driver.close();
    }

    @Override
    @NotNull
    public TreeNode contentDescriptor() {
        this.ensureOpen();
        Object object = this.executeJS("return window.maestro.getContentDescription()");
        if (object == null) {
            throw new IllegalStateException("Could not retrieve hierarchy through maestro.getContentDescription()");
        }
        Object contentDesc = object;
        return WebDriver.contentDescriptor$parse((Map)contentDesc);
    }

    @Override
    public void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
    }

    @Override
    public void clearKeychain() {
    }

    @Override
    public void pullAppState(@NotNull String appId, @NotNull File outFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
    }

    @Override
    public void pushAppState(@NotNull String appId, @NotNull File stateFile) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
    }

    @Override
    public void tap(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        long pixelsScrolled = this.scrollToPoint(point);
        PointerInput mouse = new PointerInput(PointerInput.Kind.MOUSE, "default mouse");
        Sequence actions = new Sequence((InputSource)mouse, 1).addAction(mouse.createPointerMove(Duration.ofMillis(400L), PointerInput.Origin.viewport(), point.getX(), point.getY() - (int)pixelsScrolled));
        ((RemoteWebDriver)driver).perform((Collection)CollectionsKt.listOf((Object)actions));
        new Actions(driver).click().build().perform();
    }

    @Override
    public void longPress(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        PointerInput mouse = new PointerInput(PointerInput.Kind.MOUSE, "default mouse");
        Sequence actions = new Sequence((InputSource)mouse, 0).addAction(mouse.createPointerMove(Duration.ZERO, PointerInput.Origin.viewport(), point.getX(), point.getY()));
        ((RemoteWebDriver)driver).perform((Collection)CollectionsKt.listOf((Object)actions));
        new Actions(driver).clickAndHold().pause(3000L).release().build().perform();
    }

    @Override
    public void pressKey(@NotNull KeyCode code) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        Object object = this.executeJS("return window.maestro.createXPathFromElement(document.activeElement)");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String xPath = (String)object;
        WebElement element2 = driver.findElement((By)new By.ByXPath(xPath));
        CharSequence[] charSequenceArray = KeyCode.Companion.mapToSeleniumKey(code);
        if (charSequenceArray == null) {
            throw new IllegalArgumentException("Keycode " + (Object)((Object)code) + " is not supported on web");
        }
        CharSequence[] key = charSequenceArray;
        charSequenceArray = new CharSequence[]{(CharSequence)key};
        element2.sendKeys(charSequenceArray);
    }

    @Override
    public void scrollVertical() {
        this.scroll("window.scrollY + Math.round(window.innerHeight / 2)", "window.scrollX");
    }

    @Override
    public void swipe(@NotNull Point start2, @NotNull Point end, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        Sequence swipe = new Sequence((InputSource)finger, 1);
        swipe.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), start2.getX(), start2.getY()));
        swipe.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
        swipe.addAction(finger.createPointerMove(Duration.ofMillis(durationMs), PointerInput.Origin.viewport(), end.getX(), end.getY()));
        swipe.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        ((RemoteWebDriver)driver).perform((Collection)CollectionsKt.listOf((Object)swipe));
    }

    @Override
    public void swipe(@NotNull SwipeDirection swipeDirection, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        switch (WhenMappings.$EnumSwitchMapping$0[swipeDirection.ordinal()]) {
            case 1: {
                this.scroll("window.scrollY + Math.round(window.innerHeight / 2)", "window.scrollX");
                break;
            }
            case 2: {
                this.scroll("window.scrollY - Math.round(window.innerHeight / 2)", "window.scrollX");
                break;
            }
            case 3: {
                this.scroll("window.scrollY", "window.scrollX + Math.round(window.innerWidth / 2)");
                break;
            }
            case 4: {
                this.scroll("window.scrollY", "window.scrollX - Math.round(window.innerWidth / 2)");
            }
        }
    }

    @Override
    public void swipe(@NotNull Point elementPoint, @NotNull SwipeDirection direction, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)elementPoint, (String)"elementPoint");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final void swipe(@NotNull Point start2, @NotNull Point end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void backPress() {
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        driver.navigate().back();
    }

    @Override
    public void inputText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        Object object = this.executeJS("return window.maestro.createXPathFromElement(document.activeElement)");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String xPath = (String)object;
        WebElement element2 = driver.findElement((By)new By.ByXPath(xPath));
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        for (char c : cArray) {
            CharSequence[] charSequenceArray = new CharSequence[]{String.valueOf(c)};
            element2.sendKeys(charSequenceArray);
            this.sleep(this.random(20, 100));
        }
    }

    @Override
    public void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        driver.get(link);
    }

    @Override
    public void hideKeyboard() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeScreenshot(@NotNull Sink out, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        File src = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
        Closeable closeable = (Closeable)Okio.buffer((Sink)out);
        Throwable throwable = null;
        try {
            BufferedSink it = (BufferedSink)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)src, (String)"src");
            BufferedSink bufferedSink = it.write(FilesKt.readBytes((File)src));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void eraseText(int charactersToErase) {
        org.openqa.selenium.WebDriver driver = this.ensureOpen();
        Object object = this.executeJS("return window.maestro.createXPathFromElement(document.activeElement)");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String xPath = (String)object;
        WebElement element2 = driver.findElement((By)new By.ByXPath(xPath));
        int n = 0;
        while (n < charactersToErase) {
            int i = n++;
            CharSequence[] charSequenceArray = new CharSequence[]{(CharSequence)Keys.BACK_SPACE};
            element2.sendKeys(charSequenceArray);
            this.sleep(this.random(20, 50));
        }
        this.sleep(1000L);
    }

    @Override
    public void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void resetProxy() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean isShutdown() {
        this.close();
        return true;
    }

    @Override
    public boolean isUnicodeInputSupported() {
        return true;
    }

    @Override
    @Nullable
    public TreeNode waitForAppToSettle-LubAXRY(@Nullable TreeNode initialHierarchy) {
        return ScreenshotUtils.Companion.waitForAppToSettle-d60svg8(initialHierarchy, this);
    }

    @Override
    public boolean waitUntilScreenIsStatic(long timeoutMs) {
        return ScreenshotUtils.Companion.waitUntilScreenIsStatic(timeoutMs, 0.005, this);
    }

    @Override
    @NotNull
    public List<Capability> capabilities() {
        return CollectionsKt.listOf((Object)((Object)Capability.FAST_HIERARCHY));
    }

    @Override
    public void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
    }

    private static final Boolean launchApp$lambda-3(org.openqa.selenium.WebDriver it) {
        org.openqa.selenium.WebDriver webDriver = it;
        if (webDriver == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openqa.selenium.JavascriptExecutor");
        }
        return Intrinsics.areEqual((Object)((JavascriptExecutor)webDriver).executeScript("return document.readyState", new Object[0]), (Object)"complete");
    }

    /*
     * WARNING - void declaration
     */
    private static final TreeNode contentDescriptor$parse(Map<String, ? extends Object> domRepresentation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = domRepresentation.get("attributes");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        Map attrs = (Map)object;
        Pair[] pairArray = new Pair[2];
        Object v = attrs.get("text");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        pairArray[0] = TuplesKt.to((Object)"text", (Object)((String)v));
        Object v2 = attrs.get("bounds");
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        pairArray[1] = TuplesKt.to((Object)"bounds", (Object)((String)v2));
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        if (attrs.containsKey("resource-id") && attrs.get("resource-id") != null) {
            Object v3 = attrs.get("resource-id");
            if (v3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            attributes.put("resource-id", (String)v3);
        }
        Object object2 = domRepresentation.get("children");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
        }
        List children = (List)object2;
        Iterable iterable = children;
        Map map = attributes;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map map2 = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WebDriver.contentDescriptor$parse((Map<String, ? extends Object>)it));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 124;
        Boolean bl = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        Boolean bl5 = null;
        List list = (List)destination$iv$iv;
        Map map3 = map;
        return new TreeNode(map3, list, bl5, bl4, bl3, bl2, bl, n, defaultConstructorMarker);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmaestro/drivers/WebDriver$Companion;", "", "()V", "SCREENSHOT_DIFF_THRESHOLD", "", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SwipeDirection.values().length];
            nArray[SwipeDirection.UP.ordinal()] = 1;
            nArray[SwipeDirection.DOWN.ordinal()] = 2;
            nArray[SwipeDirection.LEFT.ordinal()] = 3;
            nArray[SwipeDirection.RIGHT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

