/*
 * Decompiled with CFR 0.152.
 */
package maestro.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lmaestro/utils/FileUtils;", "", "()V", "deleteDir", "", "dir", "Ljava/nio/file/Path;", "unzip", "from", "to", "zipDir", "maestro-client"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zipDir(@NotNull Path from, @NotNull Path to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        File file = to.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"to.toFile()");
        FileOutputStream stream = new FileOutputStream(file);
        AutoCloseable autoCloseable = Files.walk(from, new FileVisitOption[0]).filter(FileUtils::zipDir$lambda-0);
        Intrinsics.checkNotNullExpressionValue(autoCloseable, (String)"walk(from).filter { !it.isDirectory() }");
        List files = StreamsKt.toList(autoCloseable);
        autoCloseable = new ZipOutputStream(stream);
        Throwable throwable = null;
        try {
            ZipOutputStream zs = (ZipOutputStream)autoCloseable;
            boolean bl = false;
            try {
                Iterable $this$forEach$iv = files;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    String relativePath = ((Object)from.relativize(it)).toString();
                    ZipEntry entry = new ZipEntry(relativePath);
                    zs.putNextEntry(entry);
                    Files.copy(it, zs);
                    zs.closeEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void unzip(@NotNull Path from, @NotNull Path to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(to, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(to, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        }
        Closeable closeable = new ZipFile(((Object)from.toAbsolutePath()).toString());
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            Sequence sequence = zip.entries();
            Intrinsics.checkNotNullExpressionValue(sequence, (String)"zip.entries()");
            sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(sequence));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ZipEntry entry = (ZipEntry)element$iv;
                boolean bl2 = false;
                Closeable closeable2 = zip.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    InputStream input = (InputStream)closeable2;
                    boolean bl3 = false;
                    Path filePath = to.resolve(entry.getName());
                    if (!entry.isDirectory()) {
                        Path path = filePath.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"filePath.parent");
                        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
                        Files.copy(input, filePath, new CopyOption[0]);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
                        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(filePath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void deleteDir(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Files.walk(dir, new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(p0 -> p0.delete());
    }

    private static final boolean zipDir$lambda-0(Path it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }
}

