/*
 * Decompiled with CFR 0.152.
 */
package maestro.utils;

import com.github.romankh3.image.comparison.ImageComparison;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import maestro.Driver;
import maestro.TreeNode;
import maestro.ViewHierarchy;
import maestro.utils.MaestroTimer;
import okio.Buffer;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lmaestro/utils/ScreenshotUtils;", "", "()V", "Companion", "maestro-client"})
public final class ScreenshotUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenshotUtils.class);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0006\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001e"}, d2={"Lmaestro/utils/ScreenshotUtils$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "takeScreenshot", "", "compressed", "", "driver", "Lmaestro/Driver;", "", "out", "Lokio/Sink;", "tryTakingScreenshot", "Ljava/awt/image/BufferedImage;", "viewHierarchy", "Lmaestro/ViewHierarchy;", "viewHierarchy-c1iYVAs", "(Lmaestro/Driver;)Lmaestro/TreeNode;", "waitForAppToSettle", "initialHierarchy", "waitForAppToSettle-d60svg8", "(Lmaestro/TreeNode;Lmaestro/Driver;)Lmaestro/TreeNode;", "waitUntilScreenIsStatic", "timeoutMs", "", "threshold", "", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        public final void takeScreenshot(@NotNull Sink out, boolean compressed, @NotNull Driver driver) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            LOGGER.info("Taking screenshot to output sink");
            driver.takeScreenshot(out, compressed);
        }

        @NotNull
        public final byte[] takeScreenshot(boolean compressed, @NotNull Driver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            LOGGER.info("Taking screenshot to byte array");
            Buffer buffer = new Buffer();
            this.takeScreenshot((Sink)buffer, compressed, driver);
            return buffer.readByteArray();
        }

        @Nullable
        public final BufferedImage tryTakingScreenshot(@NotNull Driver driver) {
            BufferedImage bufferedImage;
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            try {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(this.takeScreenshot(true, driver)));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
                bufferedImage = null;
            }
            return bufferedImage;
        }

        @NotNull
        public final TreeNode waitForAppToSettle-d60svg8(@Nullable TreeNode initialHierarchy, @NotNull Driver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            TreeNode latestHierarchy = null;
            TreeNode treeNode = initialHierarchy;
            if (treeNode == null) {
                treeNode = this.viewHierarchy-c1iYVAs(driver);
            }
            latestHierarchy = treeNode;
            int n = 10;
            for (int i = 0; i < n; ++i) {
                boolean isLoading;
                int it = i;
                boolean bl = false;
                TreeNode hierarchyAfter = Companion.viewHierarchy-c1iYVAs(driver);
                if (ViewHierarchy.equals-impl0(latestHierarchy, hierarchyAfter) && !(isLoading = Boolean.parseBoolean(latestHierarchy.getAttributes().getOrDefault("is-loading", "false")))) {
                    return hierarchyAfter;
                }
                latestHierarchy = hierarchyAfter;
                MaestroTimer.INSTANCE.getSleep().invoke((Object)MaestroTimer.Reason.WAIT_TO_SETTLE, (Object)200L);
            }
            return latestHierarchy;
        }

        public final boolean waitUntilScreenIsStatic(long timeoutMs, double threshold, @NotNull Driver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            return MaestroTimer.retryUntilTrue$default((MaestroTimer)MaestroTimer.INSTANCE, (long)timeoutMs, null, (Function0)((Function0)new Function0<Boolean>(driver, threshold){
                final /* synthetic */ Driver $driver;
                final /* synthetic */ double $threshold;
                {
                    this.$driver = $driver;
                    this.$threshold = $threshold;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    BufferedImage startScreenshot = ScreenshotUtils.Companion.tryTakingScreenshot(this.$driver);
                    BufferedImage endScreenshot = ScreenshotUtils.Companion.tryTakingScreenshot(this.$driver);
                    if (startScreenshot != null && endScreenshot != null && startScreenshot.getWidth() == endScreenshot.getWidth() && startScreenshot.getHeight() == endScreenshot.getHeight()) {
                        float imageDiff = new ImageComparison(startScreenshot, endScreenshot).compareImages().getDifferencePercent();
                        return (double)imageDiff <= this.$threshold;
                    }
                    return false;
                }
            }), (int)2, null);
        }

        private final TreeNode viewHierarchy-c1iYVAs(Driver driver) {
            return ViewHierarchy.Companion.from-c1iYVAs(driver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

