/*
 * Decompiled with CFR 0.152.
 */
package maestro;

import com.github.romankh3.image.comparison.ImageComparison;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.Driver;
import maestro.Filters;
import maestro.FindElementResult;
import maestro.KeyCode;
import maestro.MaestroException;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TapRepeat;
import maestro.TreeNode;
import maestro.UiElement;
import maestro.ViewHierarchy;
import maestro.drivers.WebDriver;
import maestro.utils.MaestroTimer;
import maestro.utils.ScreenshotUtils;
import maestro.utils.SocketUtils;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 \u0095\u00012\u00020\u0001:\u0002\u0095\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00172\"\u0010\u001a\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00170\u001bj\u0002`\u001cJ\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020\u0015J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0007J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J3\u0010-\u001a\u0004\u0018\u00010'2\b\u0010.\u001a\u0004\u0018\u00010%2\b\u0010/\u001a\u0004\u0018\u00010%2\b\u00100\u001a\u0004\u0018\u00010%2\u0006\u0010*\u001a\u00020+\u00a2\u0006\u0002\u00101JM\u00102\u001a\u0004\u0018\u0001032\u0006\u0010*\u001a\u00020+2\"\u0010\u001a\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00170\u001bj\u0002`\u001c2\n\b\u0002\u00104\u001a\u0004\u0018\u000105\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020\u0010H\u0002J\u0006\u0010:\u001a\u00020\u0015J]\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020%2\b\b\u0002\u00109\u001a\u00020\u00102\b\b\u0002\u0010>\u001a\u00020\u00102\n\b\u0002\u0010?\u001a\u0004\u0018\u0001052\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bC\u0010DJ\u000e\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\fJ\u0006\u0010G\u001a\u00020\u0010J\u0006\u0010H\u001a\u00020\u0010J\u0006\u0010I\u001a\u00020\u0010J\u0006\u0010J\u001a\u00020\u0010J\u000e\u0010K\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\fJ.\u0010L\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\f2\u0014\b\u0002\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020O0N2\b\b\u0002\u0010P\u001a\u00020\u0010J(\u0010Q\u001a\u00020\u00152\u0006\u0010R\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010S\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\u0010J]\u0010U\u001a\u00020\u00152\u0006\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020%2\b\b\u0002\u00109\u001a\u00020\u00102\b\b\u0002\u0010>\u001a\u00020\u00102\n\b\u0002\u0010?\u001a\u0004\u0018\u0001052\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bV\u0010DJ\u0018\u0010W\u001a\u00020\u00152\u0006\u0010X\u001a\u00020Y2\b\b\u0002\u0010Z\u001a\u00020\u0010J\u0006\u0010[\u001a\u00020\u0015J]\u0010\\\u001a\u00020\u00152\u0006\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020%2\b\b\u0002\u00109\u001a\u00020\u00102\b\b\u0002\u0010>\u001a\u00020\u00102\n\b\u0002\u0010?\u001a\u0004\u0018\u0001052\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b]\u0010DJ\u0006\u0010^\u001a\u00020\u0015J\u000e\u0010_\u001a\u00020\u00152\u0006\u0010`\u001a\u00020\u0010J\u0016\u0010a\u001a\u00020\u00152\u0006\u0010b\u001a\u00020\f2\u0006\u0010c\u001a\u00020\fJ\"\u0010d\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\f2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0NJ\u0018\u0010f\u001a\u00020\u00152\b\b\u0002\u0010g\u001a\u00020\f2\u0006\u0010h\u001a\u00020%J\u000e\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020lJ\u000e\u0010m\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\fJ-\u0010n\u001a\u00020\u00152\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020'2\u0006\u0010r\u001a\u00020+2\b\u0010B\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010sJ[\u0010n\u001a\u00020\u00152\n\b\u0002\u0010o\u001a\u0004\u0018\u00010p2\n\b\u0002\u0010t\u001a\u0004\u0018\u00010u2\n\b\u0002\u0010v\u001a\u0004\u0018\u00010u2\n\b\u0002\u0010w\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010x\u001a\u0004\u0018\u00010\f2\u0006\u0010y\u001a\u00020+2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010zJ%\u0010{\u001a\u00020\u00152\u0006\u0010o\u001a\u00020p2\u0006\u0010r\u001a\u00020+2\b\u0010B\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010|J\u0019\u0010}\u001a\u00020\u00152\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020\u0010H\u0007J\u0018\u0010}\u001a\u00020\u00152\u0007\u0010\u0081\u0001\u001a\u00020l2\u0007\u0010\u0080\u0001\u001a\u00020\u0010JI\u0010\u0082\u0001\u001a\u00020\u00152\u0006\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020%2\b\b\u0002\u00109\u001a\u00020\u00102\b\b\u0002\u0010>\u001a\u00020\u00102\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%\u00a2\u0006\u0003\u0010\u0083\u0001Jj\u0010\u0082\u0001\u001a\u00020\u00152\u0007\u0010\u0084\u0001\u001a\u00020'2\u0006\u0010?\u001a\u0002052\b\b\u0002\u00109\u001a\u00020\u00102\t\b\u0002\u0010\u0085\u0001\u001a\u00020\u00102\b\b\u0002\u0010>\u001a\u00020\u00102\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u0086\u0001\u0010\u0087\u0001JK\u0010\u0088\u0001\u001a\u00020\u00152\u0007\u0010\u0089\u0001\u001a\u00020%2\u0007\u0010\u008a\u0001\u001a\u00020%2\b\b\u0002\u00109\u001a\u00020\u00102\b\b\u0002\u0010>\u001a\u00020\u00102\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%\u00a2\u0006\u0003\u0010\u0083\u0001J#\u00104\u001a\u0002052\t\b\u0002\u0010\u008b\u0001\u001a\u00020\u0010\u00f8\u0001\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001J\u0018\u0010\u008e\u0001\u001a\u00020\u00152\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010+\u00a2\u0006\u0003\u0010\u0090\u0001J;\u0010Z\u001a\u0004\u0018\u0001052\n\b\u0002\u0010?\u001a\u0004\u0018\u0001052\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010%\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u0091\u0001\u0010\u0092\u0001J$\u0010\u0085\u0001\u001a\u0002052\u0007\u0010\u0084\u0001\u001a\u00020'H\u0002\u00f8\u0001\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u0093\u0001\u0010\u0094\u0001R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006\u0096\u0001"}, d2={"Lmaestro/Maestro;", "Ljava/lang/AutoCloseable;", "driver", "Lmaestro/Driver;", "(Lmaestro/Driver;)V", "cachedDeviceInfo", "Lmaestro/DeviceInfo;", "getCachedDeviceInfo", "()Lmaestro/DeviceInfo;", "cachedDeviceInfo$delegate", "Lkotlin/Lazy;", "deviceName", "", "getDeviceName", "()Ljava/lang/String;", "screenRecordingInProgress", "", "sessionId", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "addMedia", "", "fileNames", "", "allElementsMatching", "Lmaestro/TreeNode;", "filter", "Lkotlin/Function1;", "Lmaestro/ElementFilter;", "backPress", "clearAppState", "appId", "clearKeychain", "close", "deviceInfo", "eraseText", "charactersToErase", "", "findElementByIdRegex", "Lmaestro/UiElement;", "regex", "Lkotlin/text/Regex;", "timeoutMs", "", "findElementByRegexp", "findElementBySize", "width", "height", "tolerance", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;J)Lmaestro/UiElement;", "findElementWithTimeout", "Lmaestro/FindElementResult;", "viewHierarchy", "Lmaestro/ViewHierarchy;", "findElementWithTimeout-AE3g2Tc", "(JLkotlin/jvm/functions/Function1;Lmaestro/TreeNode;)Lmaestro/FindElementResult;", "getNumberOfRetries", "retryIfNoChange", "hideKeyboard", "hierarchyBasedTap", "x", "y", "longPress", "initialHierarchy", "tapRepeat", "Lmaestro/TapRepeat;", "waitToSettleTimeoutMs", "hierarchyBasedTap-hbl3e4M", "(IIZZLmaestro/TreeNode;Lmaestro/TapRepeat;Ljava/lang/Integer;)V", "inputText", "text", "isAirplaneModeEnabled", "isKeyboardVisible", "isShutDown", "isUnicodeInputSupported", "killApp", "launchApp", "launchArguments", "", "", "stopIfRunning", "openLink", "link", "autoVerify", "browser", "performTap", "performTap-hbl3e4M", "pressKey", "code", "Lmaestro/KeyCode;", "waitForAppToSettle", "resetProxy", "screenshotBasedTap", "screenshotBasedTap-hbl3e4M", "scrollVertical", "setAirplaneModeState", "enabled", "setLocation", "latitude", "longitude", "setPermissions", "permissions", "setProxy", "host", "port", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "stopApp", "swipe", "swipeDirection", "Lmaestro/SwipeDirection;", "uiElement", "durationMs", "(Lmaestro/SwipeDirection;Lmaestro/UiElement;JLjava/lang/Integer;)V", "startPoint", "Lmaestro/Point;", "endPoint", "startRelative", "endRelative", "duration", "(Lmaestro/SwipeDirection;Lmaestro/Point;Lmaestro/Point;Ljava/lang/String;Ljava/lang/String;JLjava/lang/Integer;)V", "swipeFromCenter", "(Lmaestro/SwipeDirection;JLjava/lang/Integer;)V", "takeScreenshot", "outFile", "Ljava/io/File;", "compressed", "sink", "tap", "(IIZZLmaestro/TapRepeat;Ljava/lang/Integer;)V", "element", "waitUntilVisible", "tap-BUbHBYE", "(Lmaestro/UiElement;Lmaestro/TreeNode;ZZZLjava/lang/String;Lmaestro/TapRepeat;Ljava/lang/Integer;)V", "tapOnRelative", "percentX", "percentY", "excludeKeyboardElements", "viewHierarchy-c1iYVAs", "(Z)Lmaestro/TreeNode;", "waitForAnimationToEnd", "timeout", "(Ljava/lang/Long;)V", "waitForAppToSettle-5RpGHs4", "(Lmaestro/TreeNode;Ljava/lang/String;Ljava/lang/Integer;)Lmaestro/TreeNode;", "waitUntilVisible-c1iYVAs", "(Lmaestro/UiElement;)Lmaestro/TreeNode;", "Companion", "maestro-client"})
@SourceDebugExtension(value={"SMAP\nMaestro.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Maestro.kt\nmaestro/Maestro\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,644:1\n1549#2:645\n1620#2,3:646\n1549#2:649\n1620#2,3:650\n1549#2:666\n1620#2,3:667\n1#3:653\n17#4,6:654\n17#4,6:660\n66#5:670\n52#5,21:671\n66#5:692\n52#5,21:693\n*S KotlinDebug\n*F\n+ 1 Maestro.kt\nmaestro/Maestro\n*L\n135#1:645\n135#1:646,3\n141#1:649\n141#1:650,3\n496#1:666\n496#1:667,3\n312#1:654,6\n349#1:660,6\n514#1:670\n514#1:671,21\n529#1:692\n529#1:693,21\n*E\n"})
public final class Maestro
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Driver driver;
    private final UUID sessionId;
    @NotNull
    private final Lazy cachedDeviceInfo$delegate;
    private boolean screenRecordingInProgress;
    private static final Logger LOGGER = LoggerFactory.getLogger(Maestro.class);
    private static final double SCREENSHOT_DIFF_THRESHOLD = 0.005;
    private static final long ANIMATION_TIMEOUT_MS = 15000L;

    public Maestro(@NotNull Driver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.driver = driver;
        this.sessionId = UUID.randomUUID();
        this.cachedDeviceInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeviceInfo>(this){
            final /* synthetic */ Maestro this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DeviceInfo invoke() {
                Maestro.access$getLOGGER$cp().info("Getting device info");
                DeviceInfo deviceInfo2 = Maestro.access$getDriver$p(this.this$0).deviceInfo();
                Maestro.access$getLOGGER$cp().info("Got device info: " + deviceInfo2);
                return deviceInfo2;
            }
        }));
    }

    @NotNull
    public final String getDeviceName() {
        return this.driver.name();
    }

    @NotNull
    public final DeviceInfo getCachedDeviceInfo() {
        Lazy lazy = this.cachedDeviceInfo$delegate;
        return (DeviceInfo)lazy.getValue();
    }

    @Deprecated(message="This function should be removed and its usages refactored. See issue #2031")
    @NotNull
    public final DeviceInfo deviceInfo() {
        return this.driver.deviceInfo();
    }

    public final void launchApp(@NotNull String appId, @NotNull Map<String, ? extends Object> launchArguments, boolean stopIfRunning) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        LOGGER.info("Launching app " + appId);
        if (stopIfRunning) {
            this.driver.stopApp(appId);
        }
        this.driver.launchApp(appId, launchArguments, this.sessionId);
    }

    public static /* synthetic */ void launchApp$default(Maestro maestro, String string, Map map, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        maestro.launchApp(string, map, bl);
    }

    public final void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        LOGGER.info("Stopping app " + appId);
        this.driver.stopApp(appId);
    }

    public final void killApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        LOGGER.info("Killing app " + appId);
        this.driver.killApp(appId);
    }

    public final void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        LOGGER.info("Clearing app state " + appId);
        this.driver.clearAppState(appId);
    }

    public final void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.driver.setPermissions(appId, permissions);
    }

    public final void clearKeychain() {
        LOGGER.info("Clearing keychain");
        this.driver.clearKeychain();
    }

    public final void backPress() {
        LOGGER.info("Pressing back");
        this.driver.backPress();
        Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, null, 7, null);
    }

    public final void hideKeyboard() {
        LOGGER.info("Hiding Keyboard");
        this.driver.hideKeyboard();
    }

    public final boolean isKeyboardVisible() {
        return this.driver.isKeyboardVisible();
    }

    /*
     * WARNING - void declaration
     */
    public final void swipe(@Nullable SwipeDirection swipeDirection, @Nullable Point startPoint, @Nullable Point endPoint, @Nullable String startRelative, @Nullable String endRelative, long duration, @Nullable Integer waitToSettleTimeoutMs) {
        DeviceInfo deviceInfo2 = this.deviceInfo();
        if (swipeDirection != null) {
            this.driver.swipe(swipeDirection, duration);
        } else if (startPoint != null && endPoint != null) {
            this.driver.swipe(startPoint, endPoint, duration);
        } else if (startRelative != null && endRelative != null) {
            void $this$mapTo$iv$iv;
            Collection collection;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv2;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)startRelative, (String)"%", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
            }
            List startPoints = (List)destination$iv$iv;
            int startX = deviceInfo2.getWidthGrid() * ((Number)startPoints.get(0)).intValue() / 100;
            int startY = deviceInfo2.getHeightGrid() * ((Number)startPoints.get(1)).intValue() / 100;
            Point start = new Point(startX, startY);
            String[] $i$f$mapTo22 = new String[]{","};
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)endRelative, (String)"%", (String)"", (boolean)false, (int)4, null), (String[])$i$f$mapTo22, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map2 = false;
            item$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
            }
            List endPoints = (List)destination$iv$iv2;
            int endX = deviceInfo2.getWidthGrid() * ((Number)endPoints.get(0)).intValue() / 100;
            int endY = deviceInfo2.getHeightGrid() * ((Number)endPoints.get(1)).intValue() / 100;
            Point end = new Point(endX, endY);
            this.driver.swipe(start, end, duration);
        }
        Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, waitToSettleTimeoutMs, 3, null);
    }

    public static /* synthetic */ void swipe$default(Maestro maestro, SwipeDirection swipeDirection, Point point, Point point2, String string, String string2, long l, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            swipeDirection = null;
        }
        if ((n2 & 2) != 0) {
            point = null;
        }
        if ((n2 & 4) != 0) {
            point2 = null;
        }
        if ((n2 & 8) != 0) {
            string = null;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        if ((n2 & 0x40) != 0) {
            n = null;
        }
        maestro.swipe(swipeDirection, point, point2, string, string2, l, n);
    }

    public final void swipe(@NotNull SwipeDirection swipeDirection, @NotNull UiElement uiElement, long durationMs, @Nullable Integer waitToSettleTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        Intrinsics.checkNotNullParameter((Object)uiElement, (String)"uiElement");
        LOGGER.info("Swiping " + swipeDirection.name() + " on element: " + uiElement);
        this.driver.swipe(uiElement.getBounds().center(), swipeDirection, durationMs);
        Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, waitToSettleTimeoutMs, 3, null);
    }

    public final void swipeFromCenter(@NotNull SwipeDirection swipeDirection, long durationMs, @Nullable Integer waitToSettleTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        DeviceInfo deviceInfo2 = this.deviceInfo();
        LOGGER.info("Swiping " + swipeDirection.name() + " from center");
        Point center = new Point(deviceInfo2.getWidthGrid() / 2, deviceInfo2.getHeightGrid() / 2);
        this.driver.swipe(center, swipeDirection, durationMs);
        Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, waitToSettleTimeoutMs, 3, null);
    }

    public final void scrollVertical() {
        LOGGER.info("Scrolling vertically");
        this.driver.scrollVertical();
        Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, null, 7, null);
    }

    /*
     * Unable to fully structure code
     */
    public final void tap-BUbHBYE(@NotNull UiElement element, @NotNull TreeNode initialHierarchy, boolean retryIfNoChange, boolean waitUntilVisible, boolean longPress, @Nullable String appId, @Nullable TapRepeat tapRepeat, @Nullable Integer waitToSettleTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)initialHierarchy, (String)"initialHierarchy");
        v0 = new StringBuilder().append("Tapping on element: ");
        v1 = tapRepeat;
        if (v1 == null) {
            v1 = "";
        }
        Maestro.LOGGER.info(v0.append(v1).append(' ').append(element).toString());
        v2 = this.waitForAppToSettle-5RpGHs4(initialHierarchy, appId, waitToSettleTimeoutMs);
        if (v2 == null) {
            v2 = initialHierarchy;
        }
        if ((var11_10 = ViewHierarchy.refreshElement-impl(hierarchyBeforeTap = v2, element.getTreeNode())) == null) ** GOTO lbl-1000
        var13_11 = var11_10;
        it = var13_11;
        $i$a$-also-Maestro$tap$center$1 = false;
        Maestro.LOGGER.info("Refreshed element");
        var12_14 = var13_11;
        var13_11 = UiElement.Companion.toUiElementOrNull(var12_14);
        if (var13_11 != null) {
            v3 = var13_11;
        } else lbl-1000:
        // 2 sources

        {
            v3 = element;
        }
        center = v3.getBounds().center();
        this.performTap-hbl3e4M(center.getX(), center.getY(), retryIfNoChange, longPress, hierarchyBeforeTap, tapRepeat, waitToSettleTimeoutMs);
        if (waitUntilVisible && ViewHierarchy.equals-impl0(hierarchyBeforeTap, hierarchyAfterTap = Maestro.viewHierarchy-c1iYVAs$default(this, false, 1, null)) && !ViewHierarchy.isVisible-impl(hierarchyAfterTap, element.getTreeNode())) {
            Maestro.LOGGER.info("Still no change in hierarchy. Wait until element is visible and try again.");
            hierarchy = this.waitUntilVisible-c1iYVAs(element);
            Maestro.tap-BUbHBYE$default(this, element, hierarchy, false, false, longPress, null, tapRepeat, null, 160, null);
        }
    }

    public static /* synthetic */ void tap-BUbHBYE$default(Maestro maestro, UiElement uiElement, TreeNode treeNode, boolean bl, boolean bl2, boolean bl3, String string, TapRepeat tapRepeat, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x20) != 0) {
            string = null;
        }
        if ((n2 & 0x40) != 0) {
            tapRepeat = null;
        }
        if ((n2 & 0x80) != 0) {
            n = null;
        }
        maestro.tap-BUbHBYE(uiElement, treeNode, bl, bl2, bl3, string, tapRepeat, n);
    }

    public final void tapOnRelative(int percentX, int percentY, boolean retryIfNoChange, boolean longPress2, @Nullable TapRepeat tapRepeat, @Nullable Integer waitToSettleTimeoutMs) {
        DeviceInfo deviceInfo2 = this.driver.deviceInfo();
        int x = deviceInfo2.getWidthGrid() * percentX / 100;
        int y = deviceInfo2.getHeightGrid() * percentY / 100;
        this.tap(x, y, retryIfNoChange, longPress2, tapRepeat, waitToSettleTimeoutMs);
    }

    public static /* synthetic */ void tapOnRelative$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TapRepeat tapRepeat, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if ((n4 & 8) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x10) != 0) {
            tapRepeat = null;
        }
        if ((n4 & 0x20) != 0) {
            n3 = null;
        }
        maestro.tapOnRelative(n, n2, bl, bl2, tapRepeat, n3);
    }

    public final void tap(int x, int y, boolean retryIfNoChange, boolean longPress2, @Nullable TapRepeat tapRepeat, @Nullable Integer waitToSettleTimeoutMs) {
        Maestro.performTap-hbl3e4M$default(this, x, y, retryIfNoChange, longPress2, null, tapRepeat, waitToSettleTimeoutMs, 16, null);
    }

    public static /* synthetic */ void tap$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TapRepeat tapRepeat, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if ((n4 & 8) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x10) != 0) {
            tapRepeat = null;
        }
        if ((n4 & 0x20) != 0) {
            n3 = null;
        }
        maestro.tap(n, n2, bl, bl2, tapRepeat, n3);
    }

    private final int getNumberOfRetries(boolean retryIfNoChange) {
        return retryIfNoChange ? 2 : 1;
    }

    private final void performTap-hbl3e4M(int x, int y, boolean retryIfNoChange, boolean longPress2, TreeNode initialHierarchy, TapRepeat tapRepeat, Integer waitToSettleTimeoutMs) {
        List<Capability> capabilities2 = this.driver.capabilities();
        if (capabilities2.contains((Object)Capability.FAST_HIERARCHY)) {
            this.hierarchyBasedTap-hbl3e4M(x, y, retryIfNoChange, longPress2, initialHierarchy, tapRepeat, waitToSettleTimeoutMs);
        } else {
            this.screenshotBasedTap-hbl3e4M(x, y, retryIfNoChange, longPress2, initialHierarchy, tapRepeat, waitToSettleTimeoutMs);
        }
    }

    static /* synthetic */ void performTap-hbl3e4M$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TreeNode treeNode, TapRepeat tapRepeat, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if ((n4 & 8) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x10) != 0) {
            treeNode = null;
        }
        if ((n4 & 0x20) != 0) {
            tapRepeat = null;
        }
        if ((n4 & 0x40) != 0) {
            n3 = null;
        }
        maestro.performTap-hbl3e4M(n, n2, bl, bl2, treeNode, tapRepeat, n3);
    }

    private final void screenshotBasedTap-hbl3e4M(int x, int y, boolean retryIfNoChange, boolean longPress2, TreeNode initialHierarchy, TapRepeat tapRepeat, Integer waitToSettleTimeoutMs) {
        LOGGER.info("Tapping at (" + x + ", " + y + ") using screenshot based logic for wait");
        TreeNode treeNode = initialHierarchy;
        if (treeNode == null) {
            treeNode = Maestro.viewHierarchy-c1iYVAs$default(this, false, 1, null);
        }
        TreeNode hierarchyBeforeTap = treeNode;
        int retries = this.getNumberOfRetries(retryIfNoChange);
        for (int i = 0; i < retries; ++i) {
            int it = i;
            boolean bl = false;
            if (longPress2) {
                this.driver.longPress(new Point(x, y));
            } else if (tapRepeat != null) {
                int n = tapRepeat.getRepeat();
                for (int i2 = 0; i2 < n; ++i2) {
                    long delay;
                    boolean $i$f$measureTimeMillis = false;
                    long start$iv = System.currentTimeMillis();
                    boolean bl2 = false;
                    this.driver.tap(new Point(x, y));
                    long duration = System.currentTimeMillis() - start$iv;
                    long l = delay = duration >= tapRepeat.getDelay() ? 0L : tapRepeat.getDelay() - duration;
                    if (tapRepeat.getRepeat() <= 1) continue;
                    Thread.sleep(delay);
                }
            } else {
                this.driver.tap(new Point(x, y));
            }
            TreeNode hierarchyAfterTap = Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, waitToSettleTimeoutMs, 3, null);
            if (hierarchyAfterTap != null && ViewHierarchy.equals-impl0(hierarchyBeforeTap, hierarchyAfterTap)) continue;
            LOGGER.info("Something has changed in the UI judging by view hierarchy. Proceed.");
            return;
        }
    }

    static /* synthetic */ void screenshotBasedTap-hbl3e4M$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TreeNode treeNode, TapRepeat tapRepeat, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if ((n4 & 8) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x10) != 0) {
            treeNode = null;
        }
        if ((n4 & 0x20) != 0) {
            tapRepeat = null;
        }
        if ((n4 & 0x40) != 0) {
            n3 = null;
        }
        maestro.screenshotBasedTap-hbl3e4M(n, n2, bl, bl2, treeNode, tapRepeat, n3);
    }

    private final void hierarchyBasedTap-hbl3e4M(int x, int y, boolean retryIfNoChange, boolean longPress2, TreeNode initialHierarchy, TapRepeat tapRepeat, Integer waitToSettleTimeoutMs) {
        LOGGER.info("Tapping at (" + x + ", " + y + ") using hierarchy based logic for wait");
        TreeNode treeNode = initialHierarchy;
        if (treeNode == null) {
            treeNode = Maestro.viewHierarchy-c1iYVAs$default(this, false, 1, null);
        }
        TreeNode hierarchyBeforeTap = treeNode;
        BufferedImage screenshotBeforeTap = ScreenshotUtils.Companion.tryTakingScreenshot(this.driver);
        int retries = this.getNumberOfRetries(retryIfNoChange);
        for (int i = 0; i < retries; ++i) {
            TreeNode hierarchyAfterTap;
            int it = i;
            boolean bl = false;
            if (longPress2) {
                this.driver.longPress(new Point(x, y));
            } else if (tapRepeat != null) {
                int n = tapRepeat.getRepeat();
                for (int i2 = 0; i2 < n; ++i2) {
                    long delay;
                    boolean $i$f$measureTimeMillis = false;
                    long start$iv = System.currentTimeMillis();
                    boolean bl2 = false;
                    this.driver.tap(new Point(x, y));
                    long duration = System.currentTimeMillis() - start$iv;
                    long l = delay = duration >= tapRepeat.getDelay() ? 0L : tapRepeat.getDelay() - duration;
                    if (tapRepeat.getRepeat() <= 1) continue;
                    Thread.sleep(delay);
                }
            } else {
                this.driver.tap(new Point(x, y));
            }
            TreeNode treeNode2 = hierarchyAfterTap = Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, waitToSettleTimeoutMs, 3, null);
            if (!(treeNode2 == null ? false : ViewHierarchy.equals-impl0(hierarchyBeforeTap, treeNode2))) {
                LOGGER.info("Something have changed in the UI judging by view hierarchy. Proceed.");
                return;
            }
            BufferedImage screenshotAfterTap = ScreenshotUtils.Companion.tryTakingScreenshot(this.driver);
            if (screenshotBeforeTap != null && screenshotAfterTap != null && screenshotBeforeTap.getWidth() == screenshotAfterTap.getWidth() && screenshotBeforeTap.getHeight() == screenshotAfterTap.getHeight()) {
                float imageDiff = new ImageComparison(screenshotBeforeTap, screenshotAfterTap).compareImages().getDifferencePercent();
                if ((double)imageDiff > 0.005) {
                    LOGGER.info("Something have changed in the UI judging by screenshot (d=" + imageDiff + "). Proceed.");
                    return;
                }
                LOGGER.info("Screenshots are not different enough (d=" + imageDiff + ')');
            } else {
                LOGGER.info("Skipping screenshot comparison");
            }
            LOGGER.info("Nothing changed in the UI.");
        }
    }

    static /* synthetic */ void hierarchyBasedTap-hbl3e4M$default(Maestro maestro, int n, int n2, boolean bl, boolean bl2, TreeNode treeNode, TapRepeat tapRepeat, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if ((n4 & 8) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x10) != 0) {
            treeNode = null;
        }
        if ((n4 & 0x20) != 0) {
            tapRepeat = null;
        }
        if ((n4 & 0x40) != 0) {
            n3 = null;
        }
        maestro.hierarchyBasedTap-hbl3e4M(n, n2, bl, bl2, treeNode, tapRepeat, n3);
    }

    private final TreeNode waitUntilVisible-c1iYVAs(UiElement element2) {
        TreeNode hierarchy = null;
        hierarchy = ViewHierarchy.constructor-impl(new TreeNode(null, null, null, null, null, null, null, 127, null));
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            hierarchy = Maestro.viewHierarchy-c1iYVAs$default(this, false, 1, null);
            if (ViewHierarchy.isVisible-impl(hierarchy, element2.getTreeNode())) {
                LOGGER.info("Element became visible.");
                return hierarchy;
            }
            LOGGER.info("Element is not visible yet. Waiting.");
            MaestroTimer.INSTANCE.getSleep().invoke((Object)MaestroTimer.Reason.WAIT_UNTIL_VISIBLE, (Object)1000L);
        }
        return hierarchy;
    }

    public final void pressKey(@NotNull KeyCode code, boolean waitForAppToSettle2) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        LOGGER.info("Pressing key " + (Object)((Object)code));
        this.driver.pressKey(code);
        if (waitForAppToSettle2) {
            Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, null, 7, null);
        }
    }

    public static /* synthetic */ void pressKey$default(Maestro maestro, KeyCode keyCode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        maestro.pressKey(keyCode, bl);
    }

    @NotNull
    public final UiElement findElementByRegexp(@NotNull Regex regex, long timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        LOGGER.info("Looking for element by regex: " + regex.getPattern() + " (timeout " + timeoutMs + ')');
        Object object = Maestro.findElementWithTimeout-AE3g2Tc$default(this, timeoutMs, Filters.INSTANCE.textMatches(regex), null, 4, null);
        if (object == null || (object = ((FindElementResult)object).getElement()) == null) {
            throw new MaestroException.ElementNotFound("No element that matches regex: " + regex, Maestro.viewHierarchy-c1iYVAs$default(this, false, 1, null));
        }
        return object;
    }

    @NotNull
    public final TreeNode viewHierarchy-c1iYVAs(boolean excludeKeyboardElements) {
        return ViewHierarchy.Companion.from-8JJjmZI(this.driver, excludeKeyboardElements);
    }

    public static /* synthetic */ TreeNode viewHierarchy-c1iYVAs$default(Maestro maestro, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return maestro.viewHierarchy-c1iYVAs(bl);
    }

    @NotNull
    public final UiElement findElementByIdRegex(@NotNull Regex regex, long timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        LOGGER.info("Looking for element by id regex: " + regex.getPattern() + " (timeout " + timeoutMs + ')');
        Object object = Maestro.findElementWithTimeout-AE3g2Tc$default(this, timeoutMs, Filters.INSTANCE.idMatches(regex), null, 4, null);
        if (object == null || (object = ((FindElementResult)object).getElement()) == null) {
            throw new MaestroException.ElementNotFound("No element has id that matches regex " + regex, Maestro.viewHierarchy-c1iYVAs$default(this, false, 1, null));
        }
        return object;
    }

    @Nullable
    public final UiElement findElementBySize(@Nullable Integer width, @Nullable Integer height, @Nullable Integer tolerance, long timeoutMs) {
        LOGGER.info("Looking for element by size: " + width + " x " + height + " (tolerance " + tolerance + ") (timeout " + timeoutMs + ')');
        FindElementResult findElementResult = Maestro.findElementWithTimeout-AE3g2Tc$default(this, timeoutMs, Filters.INSTANCE.asFilter(Filters.INSTANCE.sizeMatches(width, height, tolerance)), null, 4, null);
        return findElementResult != null ? findElementResult.getElement() : null;
    }

    @Nullable
    public final FindElementResult findElementWithTimeout-AE3g2Tc(long timeoutMs, @NotNull Function1<? super List<TreeNode>, ? extends List<TreeNode>> filter, @Nullable TreeNode viewHierarchy) {
        UiElement element2;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Ref.ObjectRef hierarchy = new Ref.ObjectRef();
        TreeNode treeNode = viewHierarchy;
        if (treeNode == null) {
            treeNode = ViewHierarchy.constructor-impl(new TreeNode(null, null, null, null, null, null, null, 127, null));
        }
        hierarchy.element = treeNode;
        TreeNode treeNode2 = (TreeNode)MaestroTimer.INSTANCE.withTimeout(timeoutMs, (Function0)new Function0<TreeNode>((Ref.ObjectRef<ViewHierarchy>)hierarchy, viewHierarchy, this, filter){
            final /* synthetic */ Ref.ObjectRef<ViewHierarchy> $hierarchy;
            final /* synthetic */ TreeNode $viewHierarchy;
            final /* synthetic */ Maestro this$0;
            final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $filter;
            {
                this.$hierarchy = $hierarchy;
                this.$viewHierarchy = $viewHierarchy;
                this.this$0 = $receiver;
                this.$filter = $filter;
                super(0);
            }

            @Nullable
            public final TreeNode invoke() {
                TreeNode treeNode = this.$viewHierarchy;
                if (treeNode == null) {
                    treeNode = Maestro.viewHierarchy-c1iYVAs$default(this.this$0, false, 1, null);
                }
                this.$hierarchy.element = treeNode;
                return (TreeNode)CollectionsKt.firstOrNull((List)((List)this.$filter.invoke(ViewHierarchy.aggregate-impl((TreeNode)this.$hierarchy.element))));
            }
        });
        UiElement uiElement = element2 = treeNode2 != null ? UiElement.Companion.toUiElementOrNull(treeNode2) : null;
        if (element2 != null) {
            if (viewHierarchy != null) {
                hierarchy.element = ViewHierarchy.constructor-impl(element2.getTreeNode());
            }
            return new FindElementResult(element2, (TreeNode)hierarchy.element, null);
        }
        return null;
    }

    public static /* synthetic */ FindElementResult findElementWithTimeout-AE3g2Tc$default(Maestro maestro, long l, Function1 function1, TreeNode treeNode, int n, Object object) {
        if ((n & 4) != 0) {
            treeNode = null;
        }
        return maestro.findElementWithTimeout-AE3g2Tc(l, (Function1<? super List<TreeNode>, ? extends List<TreeNode>>)function1, treeNode);
    }

    @NotNull
    public final List<TreeNode> allElementsMatching(@NotNull Function1<? super List<TreeNode>, ? extends List<TreeNode>> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return (List)filter.invoke(ViewHierarchy.aggregate-impl(Maestro.viewHierarchy-c1iYVAs$default(this, false, 1, null)));
    }

    @Nullable
    public final TreeNode waitForAppToSettle-5RpGHs4(@Nullable TreeNode initialHierarchy, @Nullable String appId, @Nullable Integer waitToSettleTimeoutMs) {
        return this.driver.waitForAppToSettle-5RpGHs4(initialHierarchy, appId, waitToSettleTimeoutMs);
    }

    public static /* synthetic */ TreeNode waitForAppToSettle-5RpGHs4$default(Maestro maestro, TreeNode treeNode, String string, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            treeNode = null;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return maestro.waitForAppToSettle-5RpGHs4(treeNode, string, n);
    }

    public final void inputText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LOGGER.info("Inputting text: " + text);
        this.driver.inputText(text);
        Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, null, 7, null);
    }

    public final void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        LOGGER.info("Opening link " + link + " for app: " + appId + " with autoVerify config as " + autoVerify);
        this.driver.openLink(link, appId, autoVerify, browser);
        Maestro.waitForAppToSettle-5RpGHs4$default(this, null, null, null, 7, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addMedia(@NotNull List<String> fileNames) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileNames, (String)"fileNames");
        Iterable $this$map$iv = fileNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it));
        }
        List mediaFiles = (List)destination$iv$iv;
        this.driver.addMedia(mediaFiles);
    }

    @Override
    public void close() {
        this.driver.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Deprecated(message="Use takeScreenshot(Sink, Boolean) instead")
    public final void takeScreenshot(@NotNull File outFile, boolean compressed) {
        Unit result$iv;
        block17: {
            File absoluteOutFile;
            block16: {
                Throwable thrown$iv;
                block15: {
                    void $this$use$iv;
                    Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
                    LOGGER.info("Taking screenshot to a file: " + outFile);
                    absoluteOutFile = outFile.getAbsoluteFile();
                    if (!absoluteOutFile.getParentFile().exists() && !absoluteOutFile.getParentFile().mkdirs()) break block16;
                    Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)outFile, (boolean)false, (int)1, null));
                    boolean $i$f$use = false;
                    result$iv = null;
                    thrown$iv = null;
                    BufferedSink it = (BufferedSink)$this$use$iv;
                    boolean bl = false;
                    ScreenshotUtils.Companion.takeScreenshot((Sink)it, compressed, this.driver);
                    result$iv = Unit.INSTANCE;
                    try {
                        void v0 = $this$use$iv;
                        if (v0 != null) {
                            v0.close();
                        }
                        break block15;
                    }
                    catch (Throwable t$iv) {
                        thrown$iv = t$iv;
                    }
                    break block15;
                    catch (Throwable t$iv) {
                        try {
                            thrown$iv = t$iv;
                        }
                        catch (Throwable throwable) {
                            try {
                                void v1 = $this$use$iv;
                                if (v1 != null) {
                                    v1.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                thrown$iv = t$iv2;
                            }
                            throw throwable;
                        }
                        try {
                            void v2 = $this$use$iv;
                            if (v2 != null) {
                                v2.close();
                            }
                        }
                        catch (Throwable t$iv3) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv3;
                                break block15;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv3);
                        }
                    }
                }
                Throwable throwable = thrown$iv;
                if (throwable != null) {
                    throw throwable;
                }
                break block17;
            }
            throw new MaestroException.DestinationIsNotWritable("Failed to create directory for screenshot: " + absoluteOutFile.getParentFile());
        }
        Intrinsics.checkNotNull((Object)result$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void takeScreenshot(@NotNull Sink sink, boolean compressed) {
        Throwable thrown$iv;
        Unit result$iv;
        block15: {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            LOGGER.info("Taking screenshot");
            Closeable $this$use$iv = (Closeable)Okio.buffer((Sink)sink);
            boolean $i$f$use = false;
            result$iv = null;
            thrown$iv = null;
            BufferedSink it = (BufferedSink)$this$use$iv;
            boolean bl = false;
            ScreenshotUtils.Companion.takeScreenshot((Sink)it, compressed, this.driver);
            result$iv = Unit.INSTANCE;
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
                break block15;
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
            break block15;
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                }
                catch (Throwable throwable) {
                    try {
                        Closeable closeable = $this$use$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv2) {
                        thrown$iv = t$iv2;
                    }
                    throw throwable;
                }
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv3) {
                    if (thrown$iv == null) {
                        thrown$iv = t$iv3;
                        break block15;
                    }
                    ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv3);
                }
            }
        }
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        Intrinsics.checkNotNull((Object)result$iv);
    }

    @NotNull
    public final ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        LOGGER.info("Starting screen recording");
        if (this.screenRecordingInProgress) {
            LOGGER.info("Screen recording not started: Already in progress");
            return new ScreenRecording(){

                public void close() {
                }
            };
        }
        this.screenRecordingInProgress = true;
        LOGGER.info("Starting screen recording");
        ScreenRecording screenRecording = this.driver.startScreenRecording(out);
        long startTimestamp = System.currentTimeMillis();
        return new ScreenRecording(startTimestamp, screenRecording, this){
            final /* synthetic */ long $startTimestamp;
            final /* synthetic */ ScreenRecording $screenRecording;
            final /* synthetic */ Maestro this$0;
            {
                this.$startTimestamp = $startTimestamp;
                this.$screenRecording = $screenRecording;
                this.this$0 = $receiver;
            }

            public void close() {
                Maestro.access$getLOGGER$cp().info("Stopping screen recording");
                long durationPadding = (long)3000 - (System.currentTimeMillis() - this.$startTimestamp);
                if (durationPadding > 0L) {
                    Thread.sleep(durationPadding);
                }
                this.$screenRecording.close();
                Maestro.access$setScreenRecordingInProgress$p(this.this$0, false);
            }
        };
    }

    public final void setLocation(@NotNull String latitude, @NotNull String longitude) {
        Intrinsics.checkNotNullParameter((Object)latitude, (String)"latitude");
        Intrinsics.checkNotNullParameter((Object)longitude, (String)"longitude");
        LOGGER.info("Setting location: (" + latitude + ", " + longitude + ')');
        this.driver.setLocation(Double.parseDouble(latitude), Double.parseDouble(longitude));
    }

    public final void eraseText(int charactersToErase) {
        LOGGER.info("Erasing " + charactersToErase + " characters");
        this.driver.eraseText(charactersToErase);
    }

    public final void waitForAnimationToEnd(@Nullable Long timeout) {
        Long l = timeout;
        long timeout2 = l != null ? l : 15000L;
        LOGGER.info("Waiting for animation to end with timeout " + timeout2);
        ScreenshotUtils.Companion.waitUntilScreenIsStatic(timeout2, 0.005, this.driver);
    }

    public final void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        LOGGER.info("Setting proxy: " + host + ':' + port);
        this.driver.setProxy(host, port);
    }

    public static /* synthetic */ void setProxy$default(Maestro maestro, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = SocketUtils.INSTANCE.localIp();
        }
        maestro.setProxy(string, n);
    }

    public final void resetProxy() {
        LOGGER.info("Resetting proxy");
        this.driver.resetProxy();
    }

    public final boolean isShutDown() {
        return this.driver.isShutdown();
    }

    public final boolean isUnicodeInputSupported() {
        return this.driver.isUnicodeInputSupported();
    }

    public final boolean isAirplaneModeEnabled() {
        return this.driver.isAirplaneModeEnabled();
    }

    public final void setAirplaneModeState(boolean enabled2) {
        this.driver.setAirplaneMode(enabled2);
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ void access$setScreenRecordingInProgress$p(Maestro $this, boolean bl) {
        $this.screenRecordingInProgress = bl;
    }

    public static final /* synthetic */ Driver access$getDriver$p(Maestro $this) {
        return $this.driver;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmaestro/Maestro$Companion;", "", "()V", "ANIMATION_TIMEOUT_MS", "", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SCREENSHOT_DIFF_THRESHOLD", "", "android", "Lmaestro/Maestro;", "driver", "Lmaestro/Driver;", "openDriver", "", "ios", "web", "isStudio", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Maestro ios(@NotNull Driver driver, boolean openDriver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            if (openDriver) {
                driver.open();
            }
            return new Maestro(driver);
        }

        public static /* synthetic */ Maestro ios$default(Companion companion, Driver driver, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.ios(driver, bl);
        }

        @NotNull
        public final Maestro android(@NotNull Driver driver, boolean openDriver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            if (openDriver) {
                driver.open();
            }
            return new Maestro(driver);
        }

        public static /* synthetic */ Maestro android$default(Companion companion, Driver driver, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.android(driver, bl);
        }

        @NotNull
        public final Maestro web(boolean isStudio) {
            WebDriver driver = new WebDriver(isStudio);
            driver.open();
            return new Maestro(driver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

