/*
 * Decompiled with CFR 0.152.
 */
package maestro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import maestro.Bounds;
import maestro.DeviceInfo;
import maestro.SwipeDirection;
import maestro.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\t\u0010\u0018\u001a\u00020\u0016H\u00d6\u0001J\u001e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\"\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u000fJ\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lmaestro/UiElement;", "", "treeNode", "Lmaestro/TreeNode;", "bounds", "Lmaestro/Bounds;", "(Lmaestro/TreeNode;Lmaestro/Bounds;)V", "getBounds", "()Lmaestro/Bounds;", "getTreeNode", "()Lmaestro/TreeNode;", "component1", "component2", "copy", "distanceTo", "", "other", "equals", "", "getVisiblePercentage", "", "screenWidth", "", "screenHeight", "hashCode", "isElementNearScreenCenter", "direction", "Lmaestro/SwipeDirection;", "isWithinViewPortBounds", "info", "Lmaestro/DeviceInfo;", "paddingHorizontal", "paddingVertical", "toString", "", "Companion", "maestro-client"})
public final class UiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TreeNode treeNode;
    @NotNull
    private final Bounds bounds;

    public UiElement(@NotNull TreeNode treeNode, @NotNull Bounds bounds) {
        Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.treeNode = treeNode;
        this.bounds = bounds;
    }

    @NotNull
    public final TreeNode getTreeNode() {
        return this.treeNode;
    }

    @NotNull
    public final Bounds getBounds() {
        return this.bounds;
    }

    public final float distanceTo(@NotNull UiElement other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.bounds.center().distance(other.bounds.center());
    }

    public final double getVisiblePercentage(int screenWidth, int screenHeight) {
        boolean overflow;
        if (this.bounds.getWidth() == 0 && this.bounds.getHeight() == 0) {
            return 0.0;
        }
        boolean bl = overflow = this.bounds.getX() <= 0 && this.bounds.getY() <= 0 && this.bounds.getX() + this.bounds.getWidth() >= screenWidth && this.bounds.getY() + this.bounds.getHeight() >= screenHeight;
        if (overflow) {
            return 1.0;
        }
        int visibleX = Math.max(0, Math.min(this.bounds.getX() + this.bounds.getWidth(), screenWidth) - Math.max(this.bounds.getX(), 0));
        int visibleY = Math.max(0, Math.min(this.bounds.getY() + this.bounds.getHeight(), screenHeight) - Math.max(this.bounds.getY(), 0));
        int visibleArea = visibleX * visibleY;
        int totalArea = this.bounds.getWidth() * this.bounds.getHeight();
        return (double)visibleArea / (double)totalArea;
    }

    public final boolean isElementNearScreenCenter(@NotNull SwipeDirection direction, int screenWidth, int screenHeight) {
        boolean bl;
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int elementCenterX = this.bounds.getX() + this.bounds.getWidth() / 2;
        int elementCenterY = this.bounds.getY() + this.bounds.getHeight() / 2;
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: 
            case 2: {
                n = screenHeight / 5;
                break;
            }
            case 3: 
            case 4: {
                n = screenWidth / 5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int margin = n;
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 4: {
                if (elementCenterX > centerX - margin) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (elementCenterX < centerX + margin) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (elementCenterY < centerY + margin) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (elementCenterY > centerY - margin) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean isWithinViewPortBounds(@NotNull DeviceInfo info, float paddingHorizontal, float paddingVertical) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        int paddingX = (int)((float)info.getWidthGrid() * paddingHorizontal);
        int paddingY = (int)((float)info.getHeightGrid() * paddingVertical);
        int xEnd = info.getWidthGrid() - paddingX;
        int yEnd = info.getHeightGrid() - paddingY;
        int n = this.bounds.getX();
        boolean isXWithinBounds = paddingX <= n ? n <= xEnd : false;
        int n2 = this.bounds.getY();
        boolean isYWithinBounds = paddingY <= n2 ? n2 <= yEnd : false;
        return isXWithinBounds && isYWithinBounds;
    }

    public static /* synthetic */ boolean isWithinViewPortBounds$default(UiElement uiElement, DeviceInfo deviceInfo2, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        if ((n & 4) != 0) {
            f2 = 0.0f;
        }
        return uiElement.isWithinViewPortBounds(deviceInfo2, f, f2);
    }

    @NotNull
    public final TreeNode component1() {
        return this.treeNode;
    }

    @NotNull
    public final Bounds component2() {
        return this.bounds;
    }

    @NotNull
    public final UiElement copy(@NotNull TreeNode treeNode, @NotNull Bounds bounds) {
        Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return new UiElement(treeNode, bounds);
    }

    public static /* synthetic */ UiElement copy$default(UiElement uiElement, TreeNode treeNode, Bounds bounds, int n, Object object) {
        if ((n & 1) != 0) {
            treeNode = uiElement.treeNode;
        }
        if ((n & 2) != 0) {
            bounds = uiElement.bounds;
        }
        return uiElement.copy(treeNode, bounds);
    }

    @NotNull
    public String toString() {
        return "UiElement(treeNode=" + this.treeNode + ", bounds=" + this.bounds + ')';
    }

    public int hashCode() {
        int result = this.treeNode.hashCode();
        result = result * 31 + this.bounds.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UiElement)) {
            return false;
        }
        UiElement uiElement = (UiElement)other;
        if (!Intrinsics.areEqual((Object)this.treeNode, (Object)uiElement.treeNode)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bounds, (Object)uiElement.bounds);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005J\f\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lmaestro/UiElement$Companion;", "", "()V", "toUiElement", "Lmaestro/UiElement;", "Lmaestro/TreeNode;", "toUiElementOrNull", "maestro-client"})
    @SourceDebugExtension(value={"SMAP\nUiElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiElement.kt\nmaestro/UiElement$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n*S KotlinDebug\n*F\n+ 1 UiElement.kt\nmaestro/UiElement$Companion\n*L\n99#1:114\n99#1:115,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UiElement toUiElement(@NotNull TreeNode $this$toUiElement) {
            Intrinsics.checkNotNullParameter((Object)$this$toUiElement, (String)"<this>");
            UiElement uiElement = this.toUiElementOrNull($this$toUiElement);
            if (uiElement == null) {
                throw new IllegalStateException("Node has no bounds");
            }
            return uiElement;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final UiElement toUiElementOrNull(@NotNull TreeNode $this$toUiElementOrNull) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$toUiElementOrNull, (String)"<this>");
            String string = $this$toUiElementOrNull.getAttributes().get("bounds");
            if (string == null) {
                return null;
            }
            String boundsStr = string;
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.replace$default((String)boundsStr, (String)"][", (String)",", (boolean)false, (int)4, null), (CharSequence)"["), (CharSequence)"]"), (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Integer.parseInt((String)it));
            }
            List boundsArr = (List)destination$iv$iv;
            return new UiElement($this$toUiElementOrNull, new Bounds(((Number)boundsArr.get(0)).intValue(), ((Number)boundsArr.get(1)).intValue(), ((Number)boundsArr.get(2)).intValue() - ((Number)boundsArr.get(0)).intValue(), ((Number)boundsArr.get(3)).intValue() - ((Number)boundsArr.get(1)).intValue()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SwipeDirection.values().length];
            try {
                nArray[SwipeDirection.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwipeDirection.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwipeDirection.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwipeDirection.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

