/*
 * Decompiled with CFR 0.152.
 */
package maestro.debuglog;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.NopStatusListener;
import ch.qos.logback.core.status.StatusListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmaestro/debuglog/LogConfig;", "", "()V", "CONSOLE_LOG_PATTERN", "", "DEFAULT_CONSOLE_LOG_PATTERN", "DEFAULT_FILE_LOG_PATTERN", "FILE_LOG_PATTERN", "configure", "", "logFileName", "printToConsole", "", "createAndAddConsoleAppender", "loggerContext", "Lch/qos/logback/classic/LoggerContext;", "createAndAddFileAppender", "maestro-client"})
public final class LogConfig {
    @NotNull
    public static final LogConfig INSTANCE;
    @NotNull
    private static final String DEFAULT_FILE_LOG_PATTERN = "%d{HH:mm:ss.SSS} [%5level] %logger.%method: %msg%n";
    @NotNull
    private static final String DEFAULT_CONSOLE_LOG_PATTERN = "%highlight([%5level]) %msg%n";
    @NotNull
    private static final String FILE_LOG_PATTERN;
    @NotNull
    private static final String CONSOLE_LOG_PATTERN;

    private LogConfig() {
    }

    public final void configure(@NotNull String logFileName, boolean printToConsole) {
        Intrinsics.checkNotNullParameter((Object)logFileName, (String)"logFileName");
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        Intrinsics.checkNotNull((Object)iLoggerFactory, (String)"null cannot be cast to non-null type ch.qos.logback.classic.LoggerContext");
        LoggerContext loggerContext = (LoggerContext)iLoggerFactory;
        loggerContext.getStatusManager().add((StatusListener)new NopStatusListener());
        loggerContext.reset();
        this.createAndAddFileAppender(loggerContext, logFileName);
        if (printToConsole) {
            this.createAndAddConsoleAppender(loggerContext);
        }
        loggerContext.getLogger("ROOT").setLevel(Level.ALL);
    }

    private final void createAndAddConsoleAppender(LoggerContext loggerContext) {
        ConsoleAppender consoleAppender;
        PatternLayoutEncoder patternLayoutEncoder;
        PatternLayoutEncoder $this$createAndAddConsoleAppender_u24lambda_u240 = patternLayoutEncoder = new PatternLayoutEncoder();
        boolean bl = false;
        $this$createAndAddConsoleAppender_u24lambda_u240.setContext((Context)loggerContext);
        $this$createAndAddConsoleAppender_u24lambda_u240.setPattern(CONSOLE_LOG_PATTERN);
        $this$createAndAddConsoleAppender_u24lambda_u240.start();
        PatternLayoutEncoder encoder = patternLayoutEncoder;
        ConsoleAppender $this$createAndAddConsoleAppender_u24lambda_u241 = consoleAppender = new ConsoleAppender();
        boolean bl2 = false;
        $this$createAndAddConsoleAppender_u24lambda_u241.setContext((Context)loggerContext);
        $this$createAndAddConsoleAppender_u24lambda_u241.setEncoder((Encoder)encoder);
        $this$createAndAddConsoleAppender_u24lambda_u241.start();
        ConsoleAppender consoleAppender2 = consoleAppender;
        loggerContext.getLogger("ROOT").addAppender((Appender)consoleAppender2);
    }

    private final void createAndAddFileAppender(LoggerContext loggerContext, String logFileName) {
        FileAppender fileAppender;
        PatternLayoutEncoder patternLayoutEncoder;
        PatternLayoutEncoder $this$createAndAddFileAppender_u24lambda_u242 = patternLayoutEncoder = new PatternLayoutEncoder();
        boolean bl = false;
        $this$createAndAddFileAppender_u24lambda_u242.setContext((Context)loggerContext);
        $this$createAndAddFileAppender_u24lambda_u242.setPattern(FILE_LOG_PATTERN);
        $this$createAndAddFileAppender_u24lambda_u242.start();
        PatternLayoutEncoder encoder = patternLayoutEncoder;
        FileAppender $this$createAndAddFileAppender_u24lambda_u243 = fileAppender = new FileAppender();
        boolean bl2 = false;
        $this$createAndAddFileAppender_u24lambda_u243.setContext((Context)loggerContext);
        $this$createAndAddFileAppender_u24lambda_u243.setEncoder((Encoder)encoder);
        $this$createAndAddFileAppender_u24lambda_u243.setFile(logFileName);
        $this$createAndAddFileAppender_u24lambda_u243.start();
        FileAppender fileAppender2 = fileAppender;
        loggerContext.getLogger("ROOT").addAppender((Appender)fileAppender2);
    }

    static {
        String string;
        INSTANCE = new LogConfig();
        String string2 = System.getenv("MAESTRO_CLI_LOG_PATTERN_FILE");
        if (string2 == null) {
            string2 = FILE_LOG_PATTERN = DEFAULT_FILE_LOG_PATTERN;
        }
        if ((string = System.getenv("MAESTRO_CLI_LOG_PATTERN_CONSOLE")) == null) {
            string = DEFAULT_CONSOLE_LOG_PATTERN;
        }
        CONSOLE_LOG_PATTERN = string;
    }
}

