/*
 * Decompiled with CFR 0.152.
 */
package maestro.drivers;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.protobuf.ByteString;
import dadb.AdbShellPacket;
import dadb.AdbShellResponse;
import dadb.AdbShellStream;
import dadb.Dadb;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.Driver;
import maestro.Filters;
import maestro.KeyCode;
import maestro.Maestro;
import maestro.MaestroDriverStartupException;
import maestro.MaestroException;
import maestro.MediaExt;
import maestro.NamedSource;
import maestro.Platform;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TreeNode;
import maestro.UiElement;
import maestro.ViewHierarchy;
import maestro.ViewHierarchyKt;
import maestro.android.AndroidAppFiles;
import maestro.android.AndroidLaunchArguments;
import maestro.drivers.AndroidDriver;
import maestro.utils.BlockingStreamObserver;
import maestro.utils.MaestroTimer;
import maestro.utils.Metrics;
import maestro.utils.MetricsProvider;
import maestro.utils.ScreenshotUtils;
import maestro.utils.StringUtils;
import maestro_android.AddMediaRequestKt;
import maestro_android.CheckWindowUpdatingRequestKt;
import maestro_android.DeviceInfoRequestKt;
import maestro_android.EraseAllTextRequestKt;
import maestro_android.InputTextRequestKt;
import maestro_android.LaunchAppRequestKt;
import maestro_android.MaestroAndroid;
import maestro_android.MaestroDriverGrpc;
import maestro_android.PayloadKt;
import maestro_android.ScreenshotRequestKt;
import maestro_android.SetLocationRequestKt;
import maestro_android.TapRequestKt;
import maestro_android.ViewHierarchyRequestKt;
import net.dongliu.apk.parser.ApkFile;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00ac\u00012\u00020\u0001:\u0002\u00ac\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\"H\u0002J\b\u0010%\u001a\u00020\u001fH\u0002J\u0012\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010(\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020\u001fH\u0002J\b\u0010+\u001a\u00020\u001fH\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u0016H\u0002J\u0012\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020\u0005H\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u0002020!H\u0016J\u0010\u00103\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0007H\u0016J\b\u00104\u001a\u00020\u001fH\u0016J\b\u00105\u001a\u00020\u001fH\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0016H\u0016J\b\u00109\u001a\u00020:H\u0016J \u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?H\u0002J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020\u0005H\u0016J\u0010\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0007H\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\u0007H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010F2\u0006\u0010I\u001a\u00020\u0007H\u0002J\b\u0010J\u001a\u00020\u0005H\u0002J\b\u0010K\u001a\u00020=H\u0002J\b\u0010L\u001a\u00020\u001fH\u0016J\u0010\u0010M\u001a\u00020\u001f2\u0006\u0010N\u001a\u00020\u0007H\u0016J\u0010\u0010O\u001a\u00020\u001f2\u0006\u0010P\u001a\u00020\"H\u0002J\b\u0010Q\u001a\u00020\u001fH\u0002J\u0006\u0010R\u001a\u00020\u001fJ\b\u0010S\u001a\u00020\u001fH\u0002J\u000e\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00070!H\u0002J\b\u0010U\u001a\u00020\u0016H\u0016J\b\u0010V\u001a\u00020\u0016H\u0016J\u0010\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u0007H\u0002J\b\u0010Y\u001a\u00020\u0016H\u0016J\b\u0010Z\u001a\u00020\u0016H\u0016J\u0010\u0010[\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0007H\u0016J.\u0010\\\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00072\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020_0^2\b\u0010`\u001a\u0004\u0018\u00010aH\u0016J\u0010\u0010b\u001a\u00020\u001f2\u0006\u0010c\u001a\u00020?H\u0016J\u0010\u0010d\u001a\u0002072\u0006\u0010e\u001a\u00020fH\u0002J\b\u0010g\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u001fH\u0016J\u0010\u0010h\u001a\u00020\u001f2\u0006\u0010i\u001a\u00020\u0007H\u0002J*\u0010j\u001a\u00020\u001f2\u0006\u0010i\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010k\u001a\u00020\u00162\u0006\u0010l\u001a\u00020\u0016H\u0016J\u0010\u0010m\u001a\u00020\u001f2\u0006\u0010n\u001a\u00020oH\u0016J\b\u0010p\u001a\u00020\u001fH\u0016J!\u0010q\u001a\u0002Hr\"\u0004\b\u0000\u0010r2\f\u0010s\u001a\b\u0012\u0004\u0012\u0002Hr0tH\u0002\u00a2\u0006\u0002\u0010uJ\b\u0010v\u001a\u00020\u001fH\u0016J\u0010\u0010w\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u0016H\u0016J\u0018\u0010x\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010y\u001a\u00020\u0007H\u0002J\u0016\u0010z\u001a\u00020\u00052\u0006\u0010{\u001a\u00020\u00072\u0006\u0010|\u001a\u00020\u0007J\u0019\u0010}\u001a\u00020\u001f2\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020\u007fH\u0016J\"\u0010\u0081\u0001\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00072\u0007\u0010\u0082\u0001\u001a\u00020\u00072\u0006\u0010y\u001a\u00020\u0007H\u0002J&\u0010\u0083\u0001\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00072\u0013\u0010\u0084\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070^H\u0016J\u001b\u0010\u0085\u0001\u001a\u00020\u001f2\u0007\u0010\u0086\u0001\u001a\u00020\u00072\u0007\u0010\u0087\u0001\u001a\u00020\u0005H\u0016J\u0012\u0010\u0088\u0001\u001a\u00020\u00072\u0007\u0010\u0089\u0001\u001a\u00020\u0007H\u0002J\u0014\u0010\u008a\u0001\u001a\u00020\u001f2\t\b\u0002\u0010\u0087\u0001\u001a\u00020\u0005H\u0002J\u0014\u0010\u008b\u0001\u001a\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0016J\u0011\u0010\u008f\u0001\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0007H\u0016J!\u0010\u0090\u0001\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\u0006\u0010<\u001a\u00020=H\u0016J$\u0010\u0090\u0001\u001a\u00020\u001f2\u0007\u0010\u0091\u0001\u001a\u00020?2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0006\u0010<\u001a\u00020=H\u0016J\u001b\u0010\u0090\u0001\u001a\u00020\u001f2\b\u0010\u0094\u0001\u001a\u00030\u0093\u00012\u0006\u0010<\u001a\u00020=H\u0016J\u001c\u0010\u0095\u0001\u001a\u00020\u001f2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u0096\u0001\u001a\u00020\u0016H\u0016J\u0011\u0010\u0097\u0001\u001a\u00020\u001f2\u0006\u0010c\u001a\u00020?H\u0016J\u0017\u0010\u0098\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070!2\u0006\u0010g\u001a\u00020\u0007H\u0002J\u0012\u0010\u0099\u0001\u001a\u00020\u00072\u0007\u0010\u009a\u0001\u001a\u00020\u0007H\u0002J\u0011\u0010\u009b\u0001\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020\u0007H\u0002J\t\u0010\u009c\u0001\u001a\u00020\u001fH\u0002J\u0007\u0010\u009d\u0001\u001a\u00020\u001fJ\t\u0010\u009e\u0001\u001a\u00020\u001fH\u0002J<\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u00a0\u00012\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u00a0\u00012\b\u0010'\u001a\u0004\u0018\u00010\u00072\t\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u0005H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u00a3\u0001\u0010\u00a4\u0001J:\u0010\u00a5\u0001\u001a\u00030\u00a0\u00012\u0006\u0010'\u001a\u00020\u00072\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u00a0\u00012\u000b\b\u0002\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u0005H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\b\u00a6\u0001\u0010\u00a7\u0001J\u0012\u0010\u00a8\u0001\u001a\u00020\u00162\u0007\u0010\u00a2\u0001\u001a\u00020=H\u0016J\u000e\u00108\u001a\u0004\u0018\u000107*\u000207H\u0002J\u001d\u0010\u00a9\u0001\u001a\u0004\u0018\u00010\u0016*\u00020f2\u0006\u0010g\u001a\u00020\u0007H\u0002\u00a2\u0006\u0003\u0010\u00aa\u0001J\u000f\u0010\u00ab\u0001\u001a\u00020\u0016*\u0004\u0018\u00010\u001aH\u0002R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n \r*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \r*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \r*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u00ad\u0001"}, d2={"Lmaestro/drivers/AndroidDriver;", "Lmaestro/Driver;", "dadb", "Ldadb/Dadb;", "hostPort", "", "emulatorName", "", "metricsProvider", "Lmaestro/utils/Metrics;", "(Ldadb/Dadb;Ljava/lang/Integer;Ljava/lang/String;Lmaestro/utils/Metrics;)V", "asyncStub", "Lmaestro_android/MaestroDriverGrpc$MaestroDriverStub;", "kotlin.jvm.PlatformType", "blockingStub", "Lmaestro_android/MaestroDriverGrpc$MaestroDriverBlockingStub;", "blockingStubWithTimeout", "getBlockingStubWithTimeout", "()Lmaestro_android/MaestroDriverGrpc$MaestroDriverBlockingStub;", "channel", "Lio/grpc/ManagedChannel;", "closed", "", "documentBuilderFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "instrumentationSession", "Ldadb/AdbShellStream;", "metrics", "open", "proxySet", "addMedia", "", "mediaFiles", "", "Ljava/io/File;", "addMediaToDevice", "mediaFile", "allocateForwarder", "autoVerifyApp", "appId", "autoVerifyChromeAgreement", "autoVerifyWithAppName", "awaitLaunch", "backPress", "broadcastAirplaneMode", "enabled", "callViewHierarchy", "Lmaestro_android/MaestroAndroid$ViewHierarchyResponse;", "attempt", "capabilities", "Lmaestro/Capability;", "clearAppState", "clearKeychain", "close", "contentDescriptor", "Lmaestro/TreeNode;", "excludeKeyboardElements", "deviceInfo", "Lmaestro/DeviceInfo;", "directionalSwipe", "durationMs", "", "start", "Lmaestro/Point;", "end", "eraseText", "charactersToErase", "extractSetLocaleResult", "result", "filterById", "Lmaestro/UiElement;", "idRegex", "filterByText", "textRegex", "getDeviceApiLevel", "getStartupTimeout", "hideKeyboard", "inputText", "text", "install", "apkFile", "installMaestroApks", "installMaestroDriverApp", "installMaestroServerApp", "installedPackages", "isAirplaneModeEnabled", "isKeyboardVisible", "isPackageInstalled", "packageName", "isShutdown", "isUnicodeInputSupported", "killApp", "launchApp", "launchArguments", "", "", "sessionId", "Ljava/util/UUID;", "longPress", "point", "mapHierarchy", "node", "Lorg/w3c/dom/Node;", "name", "openBrowser", "link", "openLink", "autoVerify", "browser", "pressKey", "code", "Lmaestro/KeyCode;", "resetProxy", "runDeviceCall", "T", "call", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "scrollVertical", "setAirplaneMode", "setAllPermissions", "permissionValue", "setDeviceLocale", "country", "language", "setLocation", "latitude", "", "longitude", "setPermissionInternal", "permission", "setPermissions", "permissions", "setProxy", "host", "port", "shell", "command", "startInstrumentationSession", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "stopApp", "swipe", "elementPoint", "direction", "Lmaestro/SwipeDirection;", "swipeDirection", "takeScreenshot", "compressed", "tap", "translatePermissionName", "translatePermissionValue", "value", "uninstall", "uninstallMaestroApks", "uninstallMaestroDriverApp", "uninstallMaestroServerApp", "waitForAppToSettle", "Lmaestro/ViewHierarchy;", "initialHierarchy", "timeoutMs", "waitForAppToSettle-5RpGHs4", "(Lmaestro/TreeNode;Ljava/lang/String;Ljava/lang/Integer;)Lmaestro/TreeNode;", "waitForWindowToSettle", "waitForWindowToSettle-6OQmXwk", "(Ljava/lang/String;Lmaestro/TreeNode;Ljava/lang/Integer;)Lmaestro/TreeNode;", "waitUntilScreenIsStatic", "getBoolean", "(Lorg/w3c/dom/Node;Ljava/lang/String;)Ljava/lang/Boolean;", "successfullyStarted", "Companion", "maestro-client"})
@SourceDebugExtension(value={"SMAP\nAndroidDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidDriver.kt\nmaestro/drivers/AndroidDriver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ViewHierarchyRequestKt.kt\nmaestro_android/ViewHierarchyRequestKtKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 AddMediaRequestKt.kt\nmaestro_android/AddMediaRequestKtKt\n+ 8 PayloadKt.kt\nmaestro_android/PayloadKtKt\n*L\n1#1,1176:1\n1603#2,9:1177\n1855#2:1186\n1856#2:1188\n1612#2:1189\n1549#2:1193\n1620#2,2:1194\n1622#2:1198\n766#2:1199\n857#2,2:1200\n1549#2:1202\n1620#2,3:1203\n1855#2,2:1212\n1855#2,2:1214\n1549#2:1217\n1620#2,3:1218\n766#2:1221\n857#2,2:1222\n1549#2:1224\n1620#2,3:1225\n1747#2,3:1228\n1#3:1187\n1#3:1191\n1#3:1192\n1#3:1209\n1#3:1211\n1#3:1216\n8#4:1190\n37#5,2:1196\n1282#6,2:1206\n8#7:1208\n8#8:1210\n*S KotlinDebug\n*F\n+ 1 AndroidDriver.kt\nmaestro/drivers/AndroidDriver\n*L\n329#1:1177,9\n329#1:1186\n329#1:1188\n329#1:1189\n631#1:1193\n631#1:1194,2\n631#1:1198\n632#1:1199\n632#1:1200,2\n633#1:1202\n633#1:1203,3\n861#1:1212,2\n1010#1:1214,2\n1112#1:1217\n1112#1:1218,3\n1113#1:1221\n1113#1:1222,2\n1114#1:1224\n1114#1:1225,3\n1115#1:1228,3\n329#1:1187\n350#1:1191\n837#1:1209\n838#1:1211\n350#1:1190\n631#1:1196,2\n829#1:1206,2\n837#1:1208\n838#1:1210\n*E\n"})
public final class AndroidDriver
implements Driver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dadb dadb;
    @NotNull
    private String emulatorName;
    @NotNull
    private final Metrics metricsProvider;
    private boolean open;
    private final int hostPort;
    @NotNull
    private final Metrics metrics;
    private final ManagedChannel channel;
    private final MaestroDriverGrpc.MaestroDriverBlockingStub blockingStub;
    private final MaestroDriverGrpc.MaestroDriverStub asyncStub;
    private final DocumentBuilderFactory documentBuilderFactory;
    @Nullable
    private AdbShellStream instrumentationSession;
    private boolean proxySet;
    private boolean closed;
    private static final long SERVER_LAUNCH_TIMEOUT_MS = 15000L;
    @NotNull
    private static final String MAESTRO_DRIVER_STARTUP_TIMEOUT = "MAESTRO_DRIVER_STARTUP_TIMEOUT";
    private static final int WINDOW_UPDATE_TIMEOUT_MS = 750;
    @NotNull
    private static final Set<RegexOption> REGEX_OPTIONS;
    private static final Logger LOGGER;
    @NotNull
    private static final String TOAST_CLASS_NAME = "android.widget.Toast";
    @NotNull
    private static final Map<Integer, AutoCloseable> PORT_TO_FORWARDER;
    @NotNull
    private static final Map<Integer, String> PORT_TO_ALLOCATION_POINT;
    private static final double SCREENSHOT_DIFF_THRESHOLD = 0.005;
    private static final long CHUNK_SIZE = 0x300000L;

    public AndroidDriver(@NotNull Dadb dadb, @Nullable Integer hostPort, @NotNull String emulatorName, @NotNull Metrics metricsProvider) {
        Intrinsics.checkNotNullParameter((Object)dadb, (String)"dadb");
        Intrinsics.checkNotNullParameter((Object)emulatorName, (String)"emulatorName");
        Intrinsics.checkNotNullParameter((Object)metricsProvider, (String)"metricsProvider");
        this.dadb = dadb;
        this.emulatorName = emulatorName;
        this.metricsProvider = metricsProvider;
        Integer n = hostPort;
        this.hostPort = n != null ? n : 7001;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"platform", (Object)"android"), TuplesKt.to((Object)"emulatorName", (Object)this.emulatorName)};
        this.metrics = this.metricsProvider.withPrefix("maestro.driver").withTags(MapsKt.mapOf((Pair[])pairArray));
        this.channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.hostPort).usePlaintext().build();
        this.blockingStub = MaestroDriverGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = MaestroDriverGrpc.newStub((Channel)this.channel);
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    public /* synthetic */ AndroidDriver(Dadb dadb, Integer n, String string, Metrics metrics, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string = "";
        }
        if ((n2 & 8) != 0) {
            metrics = MetricsProvider.INSTANCE.getInstance();
        }
        this(dadb, n, string, metrics);
    }

    private final MaestroDriverGrpc.MaestroDriverBlockingStub getBlockingStubWithTimeout() {
        return (MaestroDriverGrpc.MaestroDriverBlockingStub)this.blockingStub.withDeadlineAfter(120L, TimeUnit.SECONDS);
    }

    @Override
    @NotNull
    public String name() {
        return "Android Device (" + this.dadb + ')';
    }

    @Override
    public void open() {
        this.allocateForwarder();
        this.installMaestroApks();
        this.startInstrumentationSession(this.hostPort);
        try {
            this.awaitLaunch();
        }
        catch (InterruptedException ignored) {
            AdbShellStream adbShellStream = this.instrumentationSession;
            if (adbShellStream != null) {
                adbShellStream.close();
            }
            return;
        }
    }

    private final void startInstrumentationSession(int port) {
        StringBuilder stringBuilder;
        long startTime = System.currentTimeMillis();
        int apiLevel = this.getDeviceApiLevel();
        StringBuilder $this$startInstrumentationSession_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$startInstrumentationSession_u24lambda_u240.append("am instrument -w ");
        if (apiLevel >= 26) {
            $this$startInstrumentationSession_u24lambda_u240.append("-m ");
        }
        $this$startInstrumentationSession_u24lambda_u240.append("-e debug false ");
        $this$startInstrumentationSession_u24lambda_u240.append("-e class 'dev.mobile.maestro.MaestroDriverService#grpcServer' ");
        $this$startInstrumentationSession_u24lambda_u240.append("-e port " + port + ' ');
        $this$startInstrumentationSession_u24lambda_u240.append("dev.mobile.maestro.test/androidx.test.runner.AndroidJUnitRunner &\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String instrumentationCommand = string;
        this.open = true;
        while (System.currentTimeMillis() - startTime < this.getStartupTimeout()) {
            this.instrumentationSession = this.dadb.openShell(instrumentationCommand);
            if (this.successfullyStarted(this.instrumentationSession)) {
                return;
            }
            AdbShellStream adbShellStream = this.instrumentationSession;
            if (adbShellStream != null) {
                adbShellStream.close();
            }
            Thread.sleep(100L);
        }
        throw new MaestroDriverStartupException.AndroidInstrumentationSetupFailure("Maestro instrumentation could not be initialized");
    }

    static /* synthetic */ void startInstrumentationSession$default(AndroidDriver androidDriver, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 7001;
        }
        androidDriver.startInstrumentationSession(n);
    }

    private final int getDeviceApiLevel() {
        AdbShellResponse response = this.dadb.openShell("getprop ro.build.version.sdk").readAll();
        if (response.getExitCode() != 0) {
            throw new IOException("Failed to get device API level: " + response.getErrorOutput());
        }
        Integer n = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)response.getOutput())).toString());
        if (n == null) {
            throw new IOException("Invalid API level: " + response.getOutput());
        }
        return n;
    }

    private final void allocateForwarder() {
        AutoCloseable autoCloseable = PORT_TO_FORWARDER.get(this.hostPort);
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        String string = PORT_TO_ALLOCATION_POINT.get(this.hostPort);
        if (string != null) {
            String it = string;
            boolean bl = false;
            LOGGER.warn("Port " + this.hostPort + " was already allocated. Allocation point: " + it);
        }
        PORT_TO_FORWARDER.put(this.hostPort, this.dadb.tcpForward(this.hostPort, this.hostPort));
        PORT_TO_ALLOCATION_POINT.put(this.hostPort, ExceptionsKt.stackTraceToString((Throwable)new Exception()));
    }

    private final void awaitLaunch() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.getStartupTimeout()) {
            AndroidDriver androidDriver = this;
            try {
                AndroidDriver $this$awaitLaunch_u24lambda_u242 = androidDriver;
                boolean bl = false;
                $this$awaitLaunch_u24lambda_u242.dadb.open("tcp:" + $this$awaitLaunch_u24lambda_u242.hostPort).close();
                return;
            }
            catch (Throwable throwable) {
                Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                Thread.sleep(100L);
            }
        }
        throw new MaestroDriverStartupException.AndroidDriverTimeoutException("Maestro Android driver did not start up in time  ---  emulator [ " + this.emulatorName + " ] & port  [ dadb.open( tcp:" + this.hostPort + " ) ]");
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.proxySet) {
            this.resetProxy();
        }
        AutoCloseable autoCloseable = PORT_TO_FORWARDER.get(this.hostPort);
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        PORT_TO_FORWARDER.remove(this.hostPort);
        PORT_TO_ALLOCATION_POINT.remove(this.hostPort);
        this.uninstallMaestroApks();
        AdbShellStream adbShellStream = this.instrumentationSession;
        if (adbShellStream != null) {
            adbShellStream.close();
        }
        this.instrumentationSession = null;
        this.channel.shutdown();
        if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
            throw new TimeoutException("Couldn't close Maestro Android driver due to gRPC timeout");
        }
    }

    @Override
    @NotNull
    public DeviceInfo deviceInfo() {
        return (DeviceInfo)this.runDeviceCall((Function0)new Function0<DeviceInfo>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DeviceInfo invoke() {
                DeviceInfoRequestKt.Dsl dsl;
                MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                boolean bl = false;
                MaestroAndroid.DeviceInfoRequest.Builder builder = MaestroAndroid.DeviceInfoRequest.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                DeviceInfoRequestKt.Dsl $this$deviceInfoRequest_u24lambda_u240$iv = dsl = DeviceInfoRequestKt.Dsl.Companion._create(builder);
                boolean bl2 = false;
                DeviceInfoRequestKt.Dsl dsl2 = $this$deviceInfoRequest_u24lambda_u240$iv;
                MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                boolean bl3 = false;
                MaestroAndroid.DeviceInfo response = maestroDriverBlockingStub2.deviceInfo(dsl._build());
                return new DeviceInfo(Platform.ANDROID, response.getWidthPixels(), response.getHeightPixels(), response.getWidthPixels(), response.getHeightPixels());
            }
        });
    }

    @Override
    public void launchApp(@NotNull String appId, @NotNull Map<String, ? extends Object> launchArguments, @Nullable UUID sessionId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"launchApp"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<MaestroAndroid.LaunchAppResponse>(this, appId, launchArguments, sessionId){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $appId;
            final /* synthetic */ Map<String, Object> $launchArguments;
            final /* synthetic */ UUID $sessionId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                this.$launchArguments = $launchArguments;
                this.$sessionId = $sessionId;
                super(0);
            }

            @NotNull
            public final MaestroAndroid.LaunchAppResponse invoke() {
                if (!AndroidDriver.access$getOpen$p(this.this$0)) {
                    this.this$0.open();
                }
                if (!AndroidDriver.access$isPackageInstalled(this.this$0, this.$appId)) {
                    throw new IllegalArgumentException("Package " + this.$appId + " is not installed");
                }
                List<MaestroAndroid.ArgumentValue> arguments = AndroidLaunchArguments.INSTANCE.toAndroidLaunchArguments(this.$launchArguments);
                UUID uUID = this.$sessionId;
                if (uUID == null) {
                    uUID = UUID.randomUUID();
                }
                UUID sessionUUID = uUID;
                AndroidDriver.access$getDadb$p(this.this$0).shell("setprop debug.maestro.sessionId " + sessionUUID);
                return (MaestroAndroid.LaunchAppResponse)AndroidDriver.access$runDeviceCall(this.this$0, (Function0)new Function0<MaestroAndroid.LaunchAppResponse>(this.this$0, this.$appId, arguments){
                    final /* synthetic */ AndroidDriver this$0;
                    final /* synthetic */ String $appId;
                    final /* synthetic */ List<MaestroAndroid.ArgumentValue> $arguments;
                    {
                        this.this$0 = $receiver;
                        this.$appId = $appId;
                        this.$arguments = $arguments;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final MaestroAndroid.LaunchAppResponse invoke() {
                        void $this$invoke_u24lambda_u240;
                        LaunchAppRequestKt.Dsl dsl;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                        String string = this.$appId;
                        List<MaestroAndroid.ArgumentValue> list = this.$arguments;
                        boolean bl = false;
                        MaestroAndroid.LaunchAppRequest.Builder builder = MaestroAndroid.LaunchAppRequest.newBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                        LaunchAppRequestKt.Dsl $this$launchAppRequest_u24lambda_u240$iv = dsl = LaunchAppRequestKt.Dsl.Companion._create(builder);
                        boolean bl2 = false;
                        LaunchAppRequestKt.Dsl dsl2 = $this$launchAppRequest_u24lambda_u240$iv;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u240.setPackageName(string);
                        $this$invoke_u24lambda_u240.addAllArguments($this$invoke_u24lambda_u240.getArguments(), list);
                        MaestroAndroid.LaunchAppResponse launchAppResponse = maestroDriverBlockingStub2.launchApp(dsl._build());
                        if (launchAppResponse == null) {
                            throw new IllegalStateException("Maestro driver failed to launch app");
                        }
                        return launchAppResponse;
                    }
                });
            }
        });
    }

    @Override
    public void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"stopApp"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<String>(this, appId){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $appId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return AndroidDriver.access$shell(this.this$0, "am force-stop " + this.$appId);
            }
        });
    }

    @Override
    public void killApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"killApp"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<String>(this, appId){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $appId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return AndroidDriver.access$shell(this.this$0, "am kill " + this.$appId);
            }
        });
    }

    @Override
    public void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"clearAppState"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, appId){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $appId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                super(0);
            }

            public final void invoke() {
                if (!AndroidDriver.access$isPackageInstalled(this.this$0, this.$appId)) {
                    return;
                }
                AndroidDriver.access$shell(this.this$0, "pm clear " + this.$appId);
            }
        });
    }

    @Override
    public void clearKeychain() {
    }

    @Override
    public void tap(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"tap")), (Function0)new Function0<MaestroAndroid.TapResponse>(this, point){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ Point $point;
            {
                this.this$0 = $receiver;
                this.$point = $point;
                super(0);
            }

            @NotNull
            public final MaestroAndroid.TapResponse invoke() {
                return (MaestroAndroid.TapResponse)AndroidDriver.access$runDeviceCall(this.this$0, (Function0)new Function0<MaestroAndroid.TapResponse>(this.this$0, this.$point){
                    final /* synthetic */ AndroidDriver this$0;
                    final /* synthetic */ Point $point;
                    {
                        this.this$0 = $receiver;
                        this.$point = $point;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final MaestroAndroid.TapResponse invoke() {
                        void $this$invoke_u24lambda_u240;
                        TapRequestKt.Dsl dsl;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                        Point point = this.$point;
                        boolean bl = false;
                        MaestroAndroid.TapRequest.Builder builder = MaestroAndroid.TapRequest.newBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                        TapRequestKt.Dsl $this$tapRequest_u24lambda_u240$iv = dsl = TapRequestKt.Dsl.Companion._create(builder);
                        boolean bl2 = false;
                        TapRequestKt.Dsl dsl2 = $this$tapRequest_u24lambda_u240$iv;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u240.setX(point.getX());
                        $this$invoke_u24lambda_u240.setY(point.getY());
                        MaestroAndroid.TapResponse tapResponse = maestroDriverBlockingStub2.tap(dsl._build());
                        if (tapResponse == null) {
                            throw new IllegalStateException("Response can't be null");
                        }
                        return tapResponse;
                    }
                });
            }
        });
    }

    @Override
    public void longPress(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"longPress")), (Function0)new Function0<AdbShellResponse>(this, point){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ Point $point;
            {
                this.this$0 = $receiver;
                this.$point = $point;
                super(0);
            }

            @NotNull
            public final AdbShellResponse invoke() {
                return AndroidDriver.access$getDadb$p(this.this$0).shell("input swipe " + this.$point.getX() + ' ' + this.$point.getY() + ' ' + this.$point.getX() + ' ' + this.$point.getY() + " 3000");
            }
        });
    }

    @Override
    public void pressKey(@NotNull KeyCode code) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"pressKey")), (Function0)new Function0<Unit>(code, this){
            final /* synthetic */ KeyCode $code;
            final /* synthetic */ AndroidDriver this$0;
            {
                this.$code = $code;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                int n;
                switch (pressKey.WhenMappings.$EnumSwitchMapping$0[this.$code.ordinal()]) {
                    case 1: {
                        n = 66;
                        break;
                    }
                    case 2: {
                        n = 67;
                        break;
                    }
                    case 3: {
                        n = 4;
                        break;
                    }
                    case 4: {
                        n = 24;
                        break;
                    }
                    case 5: {
                        n = 25;
                        break;
                    }
                    case 6: {
                        n = 3;
                        break;
                    }
                    case 7: {
                        n = 276;
                        break;
                    }
                    case 8: {
                        n = 19;
                        break;
                    }
                    case 9: {
                        n = 20;
                        break;
                    }
                    case 10: {
                        n = 21;
                        break;
                    }
                    case 11: {
                        n = 22;
                        break;
                    }
                    case 12: {
                        n = 23;
                        break;
                    }
                    case 13: {
                        n = 85;
                        break;
                    }
                    case 14: {
                        n = 86;
                        break;
                    }
                    case 15: {
                        n = 87;
                        break;
                    }
                    case 16: {
                        n = 88;
                        break;
                    }
                    case 17: {
                        n = 89;
                        break;
                    }
                    case 18: {
                        n = 90;
                        break;
                    }
                    case 19: {
                        n = 26;
                        break;
                    }
                    case 20: {
                        n = 111;
                        break;
                    }
                    case 21: {
                        n = 62;
                        break;
                    }
                    case 22: {
                        n = 280;
                        break;
                    }
                    case 23: {
                        n = 281;
                        break;
                    }
                    case 24: {
                        n = 96;
                        break;
                    }
                    case 25: {
                        n = 97;
                        break;
                    }
                    case 26: {
                        n = 82;
                        break;
                    }
                    case 27: {
                        n = 178;
                        break;
                    }
                    case 28: {
                        n = 243;
                        break;
                    }
                    case 29: {
                        n = 244;
                        break;
                    }
                    case 30: {
                        n = 245;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                int intCode = n;
                AndroidDriver.access$getDadb$p(this.this$0).shell("input keyevent " + intCode);
                Thread.sleep(300L);
            }
        });
    }

    @Override
    @NotNull
    public TreeNode contentDescriptor(boolean excludeKeyboardElements) {
        return (TreeNode)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"contentDescriptor")), (Function0)new Function0<TreeNode>(this, excludeKeyboardElements){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ boolean $excludeKeyboardElements;
            {
                this.this$0 = $receiver;
                this.$excludeKeyboardElements = $excludeKeyboardElements;
                super(0);
            }

            @NotNull
            public final TreeNode invoke() {
                TreeNode treeNode;
                MaestroAndroid.ViewHierarchyResponse response = AndroidDriver.callViewHierarchy$default(this.this$0, 0, 1, null);
                DocumentBuilder documentBuilder = AndroidDriver.access$getDocumentBuilderFactory$p(this.this$0).newDocumentBuilder();
                String string = response.getHierarchy();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.hierarchy");
                String string2 = string;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
                TreeNode treeNode2 = AndroidDriver.access$mapHierarchy(this.this$0, document);
                if (this.$excludeKeyboardElements) {
                    treeNode = AndroidDriver.access$excludeKeyboardElements(this.this$0, treeNode2);
                    if (treeNode == null) {
                        treeNode = treeNode2;
                    }
                } else {
                    treeNode = treeNode2;
                }
                return treeNode;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final TreeNode excludeKeyboardElements(TreeNode $this$excludeKeyboardElements) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$excludeKeyboardElements.getChildren();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TreeNode it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TreeNode it = (TreeNode)element$iv$iv;
            boolean bl2 = false;
            if (this.excludeKeyboardElements(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filtered = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        String resourceId = $this$excludeKeyboardElements.getAttributes().get("resource-id");
        if (resourceId != null && StringsKt.startsWith$default((String)resourceId, (String)"com.google.android.inputmethod.latin:id/", (boolean)false, (int)2, null)) {
            return null;
        }
        return new TreeNode($this$excludeKeyboardElements.getAttributes(), filtered, $this$excludeKeyboardElements.getClickable(), $this$excludeKeyboardElements.getEnabled(), $this$excludeKeyboardElements.getFocused(), $this$excludeKeyboardElements.getChecked(), $this$excludeKeyboardElements.getSelected());
    }

    private final MaestroAndroid.ViewHierarchyResponse callViewHierarchy(int attempt) {
        MaestroAndroid.ViewHierarchyResponse viewHierarchyResponse;
        try {
            ViewHierarchyRequestKt.Dsl dsl;
            MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = this.getBlockingStubWithTimeout();
            boolean bl = false;
            MaestroAndroid.ViewHierarchyRequest.Builder builder = MaestroAndroid.ViewHierarchyRequest.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
            ViewHierarchyRequestKt.Dsl $this$viewHierarchyRequest_u24lambda_u240$iv = dsl = ViewHierarchyRequestKt.Dsl.Companion._create(builder);
            boolean bl2 = false;
            ViewHierarchyRequestKt.Dsl dsl2 = $this$viewHierarchyRequest_u24lambda_u240$iv;
            MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
            boolean bl3 = false;
            MaestroAndroid.ViewHierarchyResponse viewHierarchyResponse2 = maestroDriverBlockingStub2.viewHierarchy(dsl._build());
            Intrinsics.checkNotNullExpressionValue((Object)viewHierarchyResponse2, (String)"{\n            blockingSt\u2026rchyRequest {})\n        }");
            viewHierarchyResponse = viewHierarchyResponse2;
        }
        catch (StatusRuntimeException throwable) {
            Status status = Status.fromThrowable((Throwable)throwable);
            if (status.getCode() == Status.Code.DEADLINE_EXCEEDED) {
                LOGGER.error("Timeout while fetching view hierarchy");
                throw new MaestroException.DriverTimeout("Android driver unreachable");
            }
            LOGGER.error("Failed to get view hierarchy: " + status.getDescription(), (Throwable)throwable);
            if (attempt > 0) {
                MaestroTimer.INSTANCE.getSleep().invoke((Object)MaestroTimer.Reason.BUFFER, (Object)1000L);
                return this.callViewHierarchy(attempt - 1);
            }
            throw throwable;
        }
        return viewHierarchyResponse;
    }

    static /* synthetic */ MaestroAndroid.ViewHierarchyResponse callViewHierarchy$default(AndroidDriver androidDriver, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return androidDriver.callViewHierarchy(n);
    }

    @Override
    public void scrollVertical() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"scrollVertical")), (Function0)new Function0<Unit>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.swipe(SwipeDirection.UP, 400L);
            }
        });
    }

    @Override
    public boolean isKeyboardVisible() {
        return (Boolean)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"isKeyboardVisible")), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                TreeNode treeNode = Driver.DefaultImpls.contentDescriptor$default(this.this$0, false, 1, null);
                AndroidDriver androidDriver = this.this$0;
                TreeNode it = treeNode;
                boolean bl = false;
                DeviceInfo deviceInfo2 = androidDriver.deviceInfo();
                TreeNode filtered = ViewHierarchyKt.filterOutOfBounds(it, deviceInfo2.getWidthGrid(), deviceInfo2.getHeightGrid());
                TreeNode treeNode2 = filtered;
                if (treeNode2 == null) {
                    treeNode2 = it;
                }
                TreeNode root = treeNode2;
                String string = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).writeValueAsString((Object)root);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonObjectMapper().writeValueAsString(root)");
                return StringsKt.contains$default((CharSequence)string, (CharSequence)"com.google.android.inputmethod.latin:id", (boolean)false, (int)2, null);
            }
        });
    }

    @Override
    public void swipe(@NotNull Point start, @NotNull Point end, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.dadb.shell("input swipe " + start.getX() + ' ' + start.getY() + ' ' + end.getX() + ' ' + end.getY() + ' ' + durationMs);
    }

    @Override
    public void swipe(@NotNull SwipeDirection swipeDirection, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"swipeWithDirection"), TuplesKt.to((Object)"direction", (Object)swipeDirection.name()), TuplesKt.to((Object)"durationMs", (Object)String.valueOf(durationMs))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, swipeDirection, durationMs){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ SwipeDirection $swipeDirection;
            final /* synthetic */ long $durationMs;
            {
                this.this$0 = $receiver;
                this.$swipeDirection = $swipeDirection;
                this.$durationMs = $durationMs;
                super(0);
            }

            public final void invoke() {
                DeviceInfo deviceInfo2 = this.this$0.deviceInfo();
                switch (swipe.WhenMappings.$EnumSwitchMapping$0[this.$swipeDirection.ordinal()]) {
                    case 1: {
                        int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                        int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                        int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                        int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.1f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, new Point(startX, startY), new Point(endX, endY));
                        break;
                    }
                    case 2: {
                        int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                        int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.2f);
                        int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.5f);
                        int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.9f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, new Point(startX, startY), new Point(endX, endY));
                        break;
                    }
                    case 3: {
                        int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.1f);
                        int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                        int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.9f);
                        int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, new Point(startX, startY), new Point(endX, endY));
                        break;
                    }
                    case 4: {
                        int startX = (int)((float)deviceInfo2.getWidthGrid() * 0.9f);
                        int startY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                        int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.1f);
                        int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.5f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, new Point(startX, startY), new Point(endX, endY));
                    }
                }
            }
        });
    }

    @Override
    public void swipe(@NotNull Point elementPoint, @NotNull SwipeDirection direction, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)elementPoint, (String)"elementPoint");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"swipeWithElementPoint"), TuplesKt.to((Object)"direction", (Object)direction.name()), TuplesKt.to((Object)"durationMs", (Object)String.valueOf(durationMs))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, direction, durationMs, elementPoint){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ SwipeDirection $direction;
            final /* synthetic */ long $durationMs;
            final /* synthetic */ Point $elementPoint;
            {
                this.this$0 = $receiver;
                this.$direction = $direction;
                this.$durationMs = $durationMs;
                this.$elementPoint = $elementPoint;
                super(0);
            }

            public final void invoke() {
                DeviceInfo deviceInfo2 = this.this$0.deviceInfo();
                switch (swipe.WhenMappings.$EnumSwitchMapping$0[this.$direction.ordinal()]) {
                    case 1: {
                        int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.1f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, this.$elementPoint, new Point(this.$elementPoint.getX(), endY));
                        break;
                    }
                    case 2: {
                        int endY = (int)((float)deviceInfo2.getHeightGrid() * 0.9f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, this.$elementPoint, new Point(this.$elementPoint.getX(), endY));
                        break;
                    }
                    case 3: {
                        int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.9f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, this.$elementPoint, new Point(endX, this.$elementPoint.getY()));
                        break;
                    }
                    case 4: {
                        int endX = (int)((float)deviceInfo2.getWidthGrid() * 0.1f);
                        AndroidDriver.access$directionalSwipe(this.this$0, this.$durationMs, this.$elementPoint, new Point(endX, this.$elementPoint.getY()));
                    }
                }
            }
        });
    }

    private final void directionalSwipe(long durationMs, Point start, Point end) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"directionalSwipe"), TuplesKt.to((Object)"durationMs", (Object)String.valueOf(durationMs))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<AdbShellResponse>(this, start, end, durationMs){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ Point $start;
            final /* synthetic */ Point $end;
            final /* synthetic */ long $durationMs;
            {
                this.this$0 = $receiver;
                this.$start = $start;
                this.$end = $end;
                this.$durationMs = $durationMs;
                super(0);
            }

            @NotNull
            public final AdbShellResponse invoke() {
                return AndroidDriver.access$getDadb$p(this.this$0).shell("input swipe " + this.$start.getX() + ' ' + this.$start.getY() + ' ' + this.$end.getX() + ' ' + this.$end.getY() + ' ' + this.$durationMs);
            }
        });
    }

    @Override
    public void backPress() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"backPress")), (Function0)new Function0<Unit>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AndroidDriver.access$getDadb$p(this.this$0).shell("input keyevent 4");
                Thread.sleep(300L);
            }
        });
    }

    @Override
    public void hideKeyboard() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"hideKeyboard")), (Function0)new Function0<ViewHierarchy>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TreeNode invoke-F9mIFpk() {
                AndroidDriver.access$getDadb$p(this.this$0).shell("input keyevent 4");
                Thread.sleep(300L);
                return Driver.DefaultImpls.waitForAppToSettle-5RpGHs4$default(this.this$0, null, null, null, 4, null);
            }
        });
    }

    @Override
    public void takeScreenshot(@NotNull Sink out, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"takeScreenshot"), TuplesKt.to((Object)"compressed", (Object)String.valueOf(compressed))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<BufferedSink>(this, out){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ Sink $out;
            {
                this.this$0 = $receiver;
                this.$out = $out;
                super(0);
            }

            @NotNull
            public final BufferedSink invoke() {
                return (BufferedSink)AndroidDriver.access$runDeviceCall(this.this$0, (Function0)new Function0<BufferedSink>(this.this$0, this.$out){
                    final /* synthetic */ AndroidDriver this$0;
                    final /* synthetic */ Sink $out;
                    {
                        this.this$0 = $receiver;
                        this.$out = $out;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final BufferedSink invoke() {
                        BufferedSink bufferedSink;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                        boolean bl = false;
                        MaestroAndroid.ScreenshotRequest.Builder builder = MaestroAndroid.ScreenshotRequest.newBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                        Object object = ScreenshotRequestKt.Dsl.Companion._create(builder);
                        ScreenshotRequestKt.Dsl $this$screenshotRequest_u24lambda_u240$iv = object;
                        boolean bl2 = false;
                        ScreenshotRequestKt.Dsl dsl = $this$screenshotRequest_u24lambda_u240$iv;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                        boolean bl3 = false;
                        MaestroAndroid.ScreenshotResponse response = maestroDriverBlockingStub2.screenshot(((ScreenshotRequestKt.Dsl)object)._build());
                        Closeable closeable = (Closeable)Okio.buffer((Sink)this.$out);
                        object = null;
                        try {
                            BufferedSink it = (BufferedSink)closeable;
                            boolean bl4 = false;
                            byte[] byArray = response.getBytes().toByteArray();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"response.bytes.toByteArray()");
                            bufferedSink = it.write(byArray);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                        }
                        return bufferedSink;
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return (ScreenRecording)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"startScreenRecording")), (Function0)new Function0<startScreenRecording.1>(this, out){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ Sink $out;
            {
                this.this$0 = $receiver;
                this.$out = $out;
                super(0);
            }

            @NotNull
            public final startScreenRecording.1 invoke() {
                String deviceScreenRecordingPath = "/sdcard/maestro-screenrecording.mp4";
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> startScreenRecording.1.invoke$lambda$0(this.this$0, deviceScreenRecordingPath), Executors.newSingleThreadExecutor());
                return new ScreenRecording(this.this$0, future, this.$out, deviceScreenRecordingPath){
                    final /* synthetic */ AndroidDriver this$0;
                    final /* synthetic */ CompletableFuture<Void> $future;
                    final /* synthetic */ Sink $out;
                    final /* synthetic */ String $deviceScreenRecordingPath;
                    {
                        this.this$0 = $receiver;
                        this.$future = $future;
                        this.$out = $out;
                        this.$deviceScreenRecordingPath = $deviceScreenRecordingPath;
                    }

                    public void close() {
                        AndroidDriver.access$getDadb$p(this.this$0).shell("killall -INT screenrecord");
                        this.$future.get();
                        Thread.sleep(3000L);
                        AndroidDriver.access$getDadb$p(this.this$0).pull(this.$out, this.$deviceScreenRecordingPath);
                    }
                };
            }

            private static final void invoke$lambda$0(AndroidDriver this$0, String $deviceScreenRecordingPath) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$deviceScreenRecordingPath, (String)"$deviceScreenRecordingPath");
                String timeLimit = AndroidDriver.access$getDeviceApiLevel(this$0) >= 34 ? "--time-limit 0" : "";
                try {
                    AndroidDriver.access$shell(this$0, "screenrecord " + timeLimit + " --bit-rate '100000' " + $deviceScreenRecordingPath);
                }
                catch (IOException e) {
                    throw new IOException("Failed to capture screen recording on the device. Note that some Android emulators do not support screen recording. Try using a different Android emulator (eg. Pixel 5 / API 30)", e);
                }
            }
        });
    }

    @Override
    public void inputText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"inputText")), (Function0)new Function0<MaestroAndroid.InputTextResponse>(this, text){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                super(0);
            }

            @NotNull
            public final MaestroAndroid.InputTextResponse invoke() {
                return (MaestroAndroid.InputTextResponse)AndroidDriver.access$runDeviceCall(this.this$0, (Function0)new Function0<MaestroAndroid.InputTextResponse>(this.this$0, this.$text){
                    final /* synthetic */ AndroidDriver this$0;
                    final /* synthetic */ String $text;
                    {
                        this.this$0 = $receiver;
                        this.$text = $text;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final MaestroAndroid.InputTextResponse invoke() {
                        void $this$invoke_u24lambda_u240;
                        InputTextRequestKt.Dsl dsl;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                        String string = this.$text;
                        boolean bl = false;
                        MaestroAndroid.InputTextRequest.Builder builder = MaestroAndroid.InputTextRequest.newBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                        InputTextRequestKt.Dsl $this$inputTextRequest_u24lambda_u240$iv = dsl = InputTextRequestKt.Dsl.Companion._create(builder);
                        boolean bl2 = false;
                        InputTextRequestKt.Dsl dsl2 = $this$inputTextRequest_u24lambda_u240$iv;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u240.setText(string);
                        MaestroAndroid.InputTextResponse inputTextResponse = maestroDriverBlockingStub2.inputText(dsl._build());
                        if (inputTextResponse == null) {
                            throw new IllegalStateException("Input Response can't be null");
                        }
                        return inputTextResponse;
                    }
                });
            }
        });
    }

    @Override
    public void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"openLink"), TuplesKt.to((Object)"appId", (Object)appId), TuplesKt.to((Object)"autoVerify", (Object)String.valueOf(autoVerify)), TuplesKt.to((Object)"browser", (Object)String.valueOf(browser))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(browser, this, link, autoVerify, appId){
            final /* synthetic */ boolean $browser;
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $link;
            final /* synthetic */ boolean $autoVerify;
            final /* synthetic */ String $appId;
            {
                this.$browser = $browser;
                this.this$0 = $receiver;
                this.$link = $link;
                this.$autoVerify = $autoVerify;
                this.$appId = $appId;
                super(0);
            }

            public final void invoke() {
                if (this.$browser) {
                    AndroidDriver.access$openBrowser(this.this$0, this.$link);
                } else {
                    AndroidDriver.access$getDadb$p(this.this$0).shell("am start -a android.intent.action.VIEW -d \"" + this.$link + '\"');
                }
                if (this.$autoVerify) {
                    AndroidDriver.access$autoVerifyApp(this.this$0, this.$appId);
                }
            }
        });
    }

    private final void autoVerifyApp(String appId) {
        if (appId != null) {
            this.autoVerifyWithAppName(appId);
        }
        this.autoVerifyChromeAgreement();
    }

    private final void autoVerifyWithAppName(String appId) {
        block3: {
            String appName;
            block4: {
                Object $this$autoVerifyWithAppName_u24lambda_u245;
                AndroidDriver androidDriver = this;
                try {
                    $this$autoVerifyWithAppName_u24lambda_u245 = androidDriver;
                    boolean bl = false;
                    File apkFile = AndroidAppFiles.INSTANCE.getApkFile(((AndroidDriver)$this$autoVerifyWithAppName_u24lambda_u245).dadb, appId);
                    String appName2 = new ApkFile(apkFile).getApkMeta().getName();
                    apkFile.delete();
                    $this$autoVerifyWithAppName_u24lambda_u245 = Result.constructor-impl((Object)appName2);
                }
                catch (Throwable bl) {
                    $this$autoVerifyWithAppName_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                Object appNameResult = $this$autoVerifyWithAppName_u24lambda_u245;
                if (!Result.isSuccess-impl((Object)appNameResult)) break block3;
                $this$autoVerifyWithAppName_u24lambda_u245 = appNameResult;
                ResultKt.throwOnFailure((Object)$this$autoVerifyWithAppName_u24lambda_u245);
                appName = (String)$this$autoVerifyWithAppName_u24lambda_u245;
                this.waitUntilScreenIsStatic(3000L);
                Intrinsics.checkNotNullExpressionValue((Object)appName, (String)"appName");
                UiElement appNameElement = this.filterByText(appName);
                if (appNameElement == null) break block4;
                this.tap(appNameElement.getBounds().center());
                UiElement uiElement = this.filterById("android:id/button_once");
                if (uiElement == null) break block3;
                UiElement it = uiElement;
                boolean bl = false;
                this.tap(it.getBounds().center());
                break block3;
            }
            UiElement openWithAppElement = this.filterByText(".*" + appName + ".*");
            if (openWithAppElement == null) break block3;
            UiElement uiElement = this.filterById("android:id/button_once");
            if (uiElement != null) {
                UiElement it = uiElement;
                boolean bl = false;
                this.tap(it.getBounds().center());
            }
        }
    }

    private final void autoVerifyChromeAgreement() {
        block1: {
            UiElement it;
            UiElement uiElement = this.filterById("com.android.chrome:id/terms_accept");
            if (uiElement != null) {
                it = uiElement;
                boolean bl = false;
                this.tap(it.getBounds().center());
            }
            Driver.DefaultImpls.waitForAppToSettle-5RpGHs4$default(this, null, null, null, 4, null);
            UiElement uiElement2 = this.filterById("com.android.chrome:id/negative_button");
            if (uiElement2 == null) break block1;
            it = uiElement2;
            boolean bl = false;
            this.tap(it.getBounds().center());
        }
    }

    private final UiElement filterByText(String textRegex) {
        Function1<List<TreeNode>, List<TreeNode>> textMatcher = Filters.INSTANCE.textMatches(StringUtils.INSTANCE.toRegexSafe(textRegex, REGEX_OPTIONS));
        Function1<List<TreeNode>, List<TreeNode>> filterFunc = Filters.INSTANCE.deepestMatchingElement(textMatcher);
        TreeNode treeNode = (TreeNode)CollectionsKt.firstOrNull((List)((List)filterFunc.invoke(Driver.DefaultImpls.contentDescriptor$default(this, false, 1, null).aggregate())));
        return treeNode != null ? UiElement.Companion.toUiElementOrNull(treeNode) : null;
    }

    private final UiElement filterById(String idRegex) {
        Function1<List<TreeNode>, List<TreeNode>> idMatcher = Filters.INSTANCE.idMatches(StringUtils.INSTANCE.toRegexSafe(idRegex, REGEX_OPTIONS));
        Function1<List<TreeNode>, List<TreeNode>> filterFunc = Filters.INSTANCE.deepestMatchingElement(idMatcher);
        TreeNode treeNode = (TreeNode)CollectionsKt.firstOrNull((List)((List)filterFunc.invoke(Driver.DefaultImpls.contentDescriptor$default(this, false, 1, null).aggregate())));
        return treeNode != null ? UiElement.Companion.toUiElementOrNull(treeNode) : null;
    }

    private final void openBrowser(String link) {
        List<String> installedPackages = this.installedPackages();
        if (installedPackages.contains("com.android.chrome")) {
            this.dadb.shell("am start -a android.intent.action.VIEW -d \"" + link + "\" com.android.chrome");
        } else if (installedPackages.contains("org.mozilla.firefox")) {
            this.dadb.shell("am start -a android.intent.action.VIEW -d \"" + link + "\" org.mozilla.firefox");
        } else {
            this.dadb.shell("am start -a android.intent.action.VIEW -d \"" + link + '\"');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> installedPackages() {
        String[] parts;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)this.shell("pm list packages"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$toTypedArray$iv;
            void line;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = (CharSequence)line;
            Regex regex = new Regex(":");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            collection.add(thisCollection$iv.toArray(new String[0]));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            parts = (String[])element$iv$iv;
            boolean bl = false;
            if (!(parts.length == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            parts = (String[])item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(parts[1]);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"setLocation")), (Function0)new Function0<MaestroAndroid.SetLocationResponse>(this, latitude, longitude){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ double $latitude;
            final /* synthetic */ double $longitude;
            {
                this.this$0 = $receiver;
                this.$latitude = $latitude;
                this.$longitude = $longitude;
                super(0);
            }

            @NotNull
            public final MaestroAndroid.SetLocationResponse invoke() {
                AndroidDriver.access$shell(this.this$0, "appops set dev.mobile.maestro android:mock_location allow");
                return (MaestroAndroid.SetLocationResponse)AndroidDriver.access$runDeviceCall(this.this$0, (Function0)new Function0<MaestroAndroid.SetLocationResponse>(this.this$0, this.$latitude, this.$longitude){
                    final /* synthetic */ AndroidDriver this$0;
                    final /* synthetic */ double $latitude;
                    final /* synthetic */ double $longitude;
                    {
                        this.this$0 = $receiver;
                        this.$latitude = $latitude;
                        this.$longitude = $longitude;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final MaestroAndroid.SetLocationResponse invoke() {
                        void $this$invoke_u24lambda_u240;
                        SetLocationRequestKt.Dsl dsl;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                        double d = this.$latitude;
                        double d2 = this.$longitude;
                        boolean bl = false;
                        MaestroAndroid.SetLocationRequest.Builder builder = MaestroAndroid.SetLocationRequest.newBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                        SetLocationRequestKt.Dsl $this$setLocationRequest_u24lambda_u240$iv = dsl = SetLocationRequestKt.Dsl.Companion._create(builder);
                        boolean bl2 = false;
                        SetLocationRequestKt.Dsl dsl2 = $this$setLocationRequest_u24lambda_u240$iv;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u240.setLatitude(d);
                        $this$invoke_u24lambda_u240.setLongitude(d2);
                        MaestroAndroid.SetLocationResponse setLocationResponse = maestroDriverBlockingStub2.setLocation(dsl._build());
                        if (setLocationResponse == null) {
                            throw new IllegalStateException("Set Location Response can't be null".toString());
                        }
                        return setLocationResponse;
                    }
                });
            }
        });
    }

    @Override
    public void eraseText(int charactersToErase) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"eraseText"), TuplesKt.to((Object)"charactersToErase", (Object)String.valueOf(charactersToErase))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<MaestroAndroid.EraseAllTextResponse>(this, charactersToErase){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ int $charactersToErase;
            {
                this.this$0 = $receiver;
                this.$charactersToErase = $charactersToErase;
                super(0);
            }

            @NotNull
            public final MaestroAndroid.EraseAllTextResponse invoke() {
                return (MaestroAndroid.EraseAllTextResponse)AndroidDriver.access$runDeviceCall(this.this$0, (Function0)new Function0<MaestroAndroid.EraseAllTextResponse>(this.this$0, this.$charactersToErase){
                    final /* synthetic */ AndroidDriver this$0;
                    final /* synthetic */ int $charactersToErase;
                    {
                        this.this$0 = $receiver;
                        this.$charactersToErase = $charactersToErase;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final MaestroAndroid.EraseAllTextResponse invoke() {
                        void $this$invoke_u24lambda_u240;
                        EraseAllTextRequestKt.Dsl dsl;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                        int n = this.$charactersToErase;
                        boolean bl = false;
                        MaestroAndroid.EraseAllTextRequest.Builder builder = MaestroAndroid.EraseAllTextRequest.newBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                        EraseAllTextRequestKt.Dsl $this$eraseAllTextRequest_u24lambda_u240$iv = dsl = EraseAllTextRequestKt.Dsl.Companion._create(builder);
                        boolean bl2 = false;
                        EraseAllTextRequestKt.Dsl dsl2 = $this$eraseAllTextRequest_u24lambda_u240$iv;
                        MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u240.setCharactersToErase(n);
                        MaestroAndroid.EraseAllTextResponse eraseAllTextResponse = maestroDriverBlockingStub2.eraseAllText(dsl._build());
                        if (eraseAllTextResponse == null) {
                            throw new IllegalStateException("Erase Response can't be null");
                        }
                        return eraseAllTextResponse;
                    }
                });
            }
        });
    }

    @Override
    public void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"setProxy")), (Function0)new Function0<Unit>(this, host, port){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                this.$port = $port;
                super(0);
            }

            public final void invoke() {
                AndroidDriver.access$shell(this.this$0, "settings put global http_proxy \"" + this.$host + ':' + this.$port + '\"');
                AndroidDriver.access$setProxySet$p(this.this$0, true);
            }
        });
    }

    @Override
    public void resetProxy() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"resetProxy")), (Function0)new Function0<String>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return AndroidDriver.access$shell(this.this$0, "settings put global http_proxy :0");
            }
        });
    }

    @Override
    public boolean isShutdown() {
        return (Boolean)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"isShutdown")), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return AndroidDriver.access$getChannel$p(this.this$0).isShutdown();
            }
        });
    }

    @Override
    public boolean isUnicodeInputSupported() {
        return false;
    }

    @Override
    @Nullable
    public TreeNode waitForAppToSettle-5RpGHs4(@Nullable TreeNode initialHierarchy, @Nullable String appId, @Nullable Integer timeoutMs) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"waitForAppToSettle"), TuplesKt.to((Object)"appId", (Object)appId), TuplesKt.to((Object)"timeoutMs", (Object)String.valueOf(timeoutMs))};
        ViewHierarchy viewHierarchy = (ViewHierarchy)this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<ViewHierarchy>(appId, this, initialHierarchy, timeoutMs){
            final /* synthetic */ String $appId;
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ TreeNode $initialHierarchy;
            final /* synthetic */ Integer $timeoutMs;
            {
                this.$appId = $appId;
                this.this$0 = $receiver;
                this.$initialHierarchy = $initialHierarchy;
                this.$timeoutMs = $timeoutMs;
                super(0);
            }

            @NotNull
            public final TreeNode invoke-prqvCes() {
                return this.$appId != null ? AndroidDriver.access$waitForWindowToSettle-6OQmXwk(this.this$0, this.$appId, this.$initialHierarchy, this.$timeoutMs) : ScreenshotUtils.Companion.waitForAppToSettle-OpTFbEc(this.$initialHierarchy, this.this$0, this.$timeoutMs);
            }
        });
        return viewHierarchy != null ? viewHierarchy.unbox-impl() : null;
    }

    private final TreeNode waitForWindowToSettle-6OQmXwk(String appId, TreeNode initialHierarchy, Integer timeoutMs) {
        long endTime = System.currentTimeMillis() + (long)750;
        Ref.ObjectRef hierarchy = new Ref.ObjectRef();
        do {
            this.runDeviceCall((Function0)new Function0<Unit>(this, (Ref.ObjectRef<ViewHierarchy>)hierarchy, initialHierarchy, timeoutMs, appId){
                final /* synthetic */ AndroidDriver this$0;
                final /* synthetic */ Ref.ObjectRef<ViewHierarchy> $hierarchy;
                final /* synthetic */ TreeNode $initialHierarchy;
                final /* synthetic */ Integer $timeoutMs;
                final /* synthetic */ String $appId;
                {
                    this.this$0 = $receiver;
                    this.$hierarchy = $hierarchy;
                    this.$initialHierarchy = $initialHierarchy;
                    this.$timeoutMs = $timeoutMs;
                    this.$appId = $appId;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$invoke_u24lambda_u240;
                    CheckWindowUpdatingRequestKt.Dsl dsl;
                    MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub = AndroidDriver.access$getBlockingStubWithTimeout(this.this$0);
                    String string = this.$appId;
                    boolean bl = false;
                    MaestroAndroid.CheckWindowUpdatingRequest.Builder builder = MaestroAndroid.CheckWindowUpdatingRequest.newBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
                    CheckWindowUpdatingRequestKt.Dsl $this$checkWindowUpdatingRequest_u24lambda_u240$iv = dsl = CheckWindowUpdatingRequestKt.Dsl.Companion._create(builder);
                    boolean bl2 = false;
                    CheckWindowUpdatingRequestKt.Dsl dsl2 = $this$checkWindowUpdatingRequest_u24lambda_u240$iv;
                    MaestroDriverGrpc.MaestroDriverBlockingStub maestroDriverBlockingStub2 = maestroDriverBlockingStub;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u240.setAppId(string);
                    boolean windowUpdating = maestroDriverBlockingStub2.isWindowUpdating(dsl._build()).getIsWindowUpdating();
                    if (windowUpdating) {
                        this.$hierarchy.element = ScreenshotUtils.Companion.waitForAppToSettle-OpTFbEc(this.$initialHierarchy, this.this$0, this.$timeoutMs);
                    }
                }
            });
        } while (System.currentTimeMillis() < endTime);
        TreeNode treeNode = (TreeNode)hierarchy.element;
        if (treeNode == null) {
            treeNode = ScreenshotUtils.Companion.waitForAppToSettle-OpTFbEc$default(ScreenshotUtils.Companion, initialHierarchy, this, null, 4, null);
        }
        return treeNode;
    }

    static /* synthetic */ TreeNode waitForWindowToSettle-6OQmXwk$default(AndroidDriver androidDriver, String string, TreeNode treeNode, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return androidDriver.waitForWindowToSettle-6OQmXwk(string, treeNode, n);
    }

    @Override
    public boolean waitUntilScreenIsStatic(long timeoutMs) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"waitUntilScreenIsStatic"), TuplesKt.to((Object)"timeoutMs", (Object)String.valueOf(timeoutMs))};
        return (Boolean)this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Boolean>(timeoutMs, this){
            final /* synthetic */ long $timeoutMs;
            final /* synthetic */ AndroidDriver this$0;
            {
                this.$timeoutMs = $timeoutMs;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ScreenshotUtils.Companion.waitUntilScreenIsStatic(this.$timeoutMs, 0.005, this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public List<Capability> capabilities() {
        return (List)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"capabilities")), (Function0)capabilities.1.INSTANCE);
    }

    @Override
    public void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"setPermissions"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(permissions, this, appId){
            final /* synthetic */ Map<String, String> $permissions;
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $appId;
            {
                this.$permissions = $permissions;
                this.this$0 = $receiver;
                this.$appId = $appId;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Object object;
                Object object2;
                Map mutable = MapsKt.toMutableMap(this.$permissions);
                String string = (String)mutable.remove("all");
                if (string != null) {
                    object2 = string;
                    object = this.this$0;
                    String string2 = this.$appId;
                    Object value = object2;
                    boolean bl = false;
                    AndroidDriver.access$setAllPermissions((AndroidDriver)object, string2, (String)value);
                }
                Map map = mutable;
                object2 = this.this$0;
                object = this.$appId;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> permission = element$iv = iterator.next();
                    boolean bl = false;
                    String permissionValue = AndroidDriver.access$translatePermissionValue((AndroidDriver)object2, (String)permission.getValue());
                    Iterable $this$forEach$iv2 = AndroidDriver.access$translatePermissionName((AndroidDriver)object2, (String)permission.getKey());
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String permissionName = (String)element$iv2;
                        boolean bl2 = false;
                        AndroidDriver.access$setPermissionInternal((AndroidDriver)object2, (String)object, permissionName, permissionValue);
                    }
                }
            }
        });
    }

    @Override
    public void addMedia(@NotNull List<? extends File> mediaFiles) {
        Intrinsics.checkNotNullParameter(mediaFiles, (String)"mediaFiles");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"addMedia"), TuplesKt.to((Object)"mediaFilesCount", (Object)String.valueOf(mediaFiles.size()))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(mediaFiles, this){
            final /* synthetic */ List<File> $mediaFiles;
            final /* synthetic */ AndroidDriver this$0;
            {
                this.$mediaFiles = $mediaFiles;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                AndroidDriver.access$getLOGGER$cp().info("[Start] Adding media files");
                Iterable iterable = this.$mediaFiles;
                AndroidDriver androidDriver = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    AndroidDriver.access$addMediaToDevice(androidDriver, it);
                }
                AndroidDriver.access$getLOGGER$cp().info("[Done] Adding media files");
            }
        });
    }

    @Override
    public boolean isAirplaneModeEnabled() {
        return (Boolean)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"isAirplaneModeEnabled")), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                switch (((Object)StringsKt.trim((CharSequence)AndroidDriver.access$shell(this.this$0, "cmd connectivity airplane-mode"))).toString()) {
                    case "": 
                    case "No shell command implementation.": {
                        AndroidDriver.access$getLOGGER$cp().debug("Falling back to old airplane mode read method");
                        String fallbackResult = ((Object)StringsKt.trim((CharSequence)AndroidDriver.access$shell(this.this$0, "settings get global airplane_mode_on"))).toString();
                        if (Intrinsics.areEqual((Object)fallbackResult, (Object)"0")) {
                            bl = false;
                            break;
                        }
                        if (Intrinsics.areEqual((Object)fallbackResult, (Object)"1")) {
                            bl = true;
                            break;
                        }
                        throw new IllegalStateException("Received invalid response from while trying to read airplane mode state: " + fallbackResult);
                    }
                    case "disabled": {
                        bl = false;
                        break;
                    }
                    case "enabled": {
                        bl = true;
                        break;
                    }
                    default: {
                        String result;
                        throw new IllegalStateException("Received invalid response while trying to read airplane mode state: " + result);
                    }
                }
                return bl;
            }
        });
    }

    @Override
    public void setAirplaneMode(boolean enabled2) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"setAirplaneMode"), TuplesKt.to((Object)"enabled", (Object)String.valueOf(enabled2))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, enabled2){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ boolean $enabled;
            {
                this.this$0 = $receiver;
                this.$enabled = $enabled;
                super(0);
            }

            public final void invoke() {
                if (AndroidDriver.access$getDeviceApiLevel(this.this$0) < 28) {
                    int num = this.$enabled ? 1 : 0;
                    AndroidDriver.access$shell(this.this$0, "settings put global airplane_mode_on " + num);
                    AndroidDriver.access$broadcastAirplaneMode(this.this$0, this.$enabled);
                    return;
                }
                String value = this.$enabled ? "enable" : "disable";
                AndroidDriver.access$shell(this.this$0, "cmd connectivity airplane-mode " + value);
            }
        });
    }

    private final void broadcastAirplaneMode(boolean enabled2) {
        block4: {
            String command = "am broadcast -a android.intent.action.AIRPLANE_MODE --ez state " + enabled2;
            try {
                this.shell(command);
            }
            catch (IOException e) {
                String string = e.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Security exception: Permission Denial:", (boolean)false, (int)2, null) : false;
                if (!bl) break block4;
                try {
                    this.shell("su root " + command);
                }
                catch (IOException e2) {
                    throw new MaestroException.NoRootAccess("Failed to broadcast airplane mode change. Make sure to run an emulator with root access for API < 28");
                }
            }
        }
    }

    public final int setDeviceLocale(@NotNull String country, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"setDeviceLocale"), TuplesKt.to((Object)"country", (Object)country), TuplesKt.to((Object)"language", (Object)language)};
        return ((Number)this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Integer>(this, language, country){
            final /* synthetic */ AndroidDriver this$0;
            final /* synthetic */ String $language;
            final /* synthetic */ String $country;
            {
                this.this$0 = $receiver;
                this.$language = $language;
                this.$country = $country;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                AndroidDriver.access$getDadb$p(this.this$0).shell("pm grant dev.mobile.maestro android.permission.CHANGE_CONFIGURATION");
                AdbShellResponse response = AndroidDriver.access$getDadb$p(this.this$0).shell("am broadcast -a dev.mobile.maestro.locale -n dev.mobile.maestro/.receivers.LocaleSettingReceiver --es lang " + this.$language + " --es country " + this.$country);
                return AndroidDriver.access$extractSetLocaleResult(this.this$0, response.getOutput());
            }
        })).intValue();
    }

    private final int extractSetLocaleResult(String result) {
        Regex regex = new Regex("result=(-?\\d+)");
        MatchResult match = Regex.find$default((Regex)regex, (CharSequence)result, (int)0, (int)2, null);
        Object object = match;
        return object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : -1;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMediaToDevice(File mediaFile) {
        MediaExt mediaExt;
        Object it;
        StreamObserver<MaestroAndroid.AddMediaRequest> requestStream;
        BlockingStreamObserver responseObserver;
        NamedSource namedSource;
        block3: {
            String string = mediaFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mediaFile.name");
            Source source = Okio.source((File)mediaFile);
            String string2 = FilesKt.getExtension((File)mediaFile);
            String string3 = mediaFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mediaFile.path");
            namedSource = new NamedSource(string, source, string2, string3);
            responseObserver = new BlockingStreamObserver();
            requestStream = this.asyncStub.addMedia(responseObserver);
            MediaExt[] $this$firstOrNull$iv = MediaExt.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaExt element$iv;
                it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getExtName(), (Object)namedSource.getExtension())) continue;
                mediaExt = element$iv;
                break block3;
            }
            mediaExt = null;
        }
        if (mediaExt == null) {
            throw new IllegalArgumentException("Extension ." + namedSource.getExtension() + " is not yet supported for add media");
        }
        MediaExt ext = mediaExt;
        Buffer buffer = new Buffer();
        Source source = namedSource.getSource();
        while (source.read(buffer, 0x300000L) != -1L) {
            void $this$addMediaToDevice_u24lambda_u2415_u24lambda_u2414;
            void $this$addMediaToDevice_u24lambda_u2415;
            PayloadKt.Dsl dsl;
            AddMediaRequestKt.Dsl dsl2;
            boolean bl = false;
            MaestroAndroid.AddMediaRequest.Builder builder = MaestroAndroid.AddMediaRequest.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
            AddMediaRequestKt.Dsl $this$addMediaRequest_u24lambda_u240$iv = dsl2 = AddMediaRequestKt.Dsl.Companion._create(builder);
            boolean bl2 = false;
            it = $this$addMediaRequest_u24lambda_u240$iv;
            StreamObserver<MaestroAndroid.AddMediaRequest> streamObserver = requestStream;
            boolean bl3 = false;
            boolean bl4 = false;
            MaestroAndroid.Payload.Builder builder2 = MaestroAndroid.Payload.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()");
            PayloadKt.Dsl $this$payload_u24lambda_u240$iv = dsl = PayloadKt.Dsl.Companion._create(builder2);
            boolean bl5 = false;
            PayloadKt.Dsl dsl3 = $this$payload_u24lambda_u240$iv;
            void var19_22 = $this$addMediaToDevice_u24lambda_u2415;
            boolean bl6 = false;
            ByteString byteString = ByteString.copyFrom((byte[])buffer.readByteArray());
            Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"copyFrom(buffer.readByteArray())");
            $this$addMediaToDevice_u24lambda_u2415_u24lambda_u2414.setData(byteString);
            var19_22.setPayload(dsl._build());
            $this$addMediaToDevice_u24lambda_u2415.setMediaName(namedSource.getName());
            $this$addMediaToDevice_u24lambda_u2415.setMediaExt(ext.getExtName());
            streamObserver.onNext((Object)dsl2._build());
            buffer.clear();
        }
        source.close();
        requestStream.onCompleted();
        responseObserver.awaitResult();
    }

    private final void setAllPermissions(String appId, String permissionValue) {
        block4: {
            Object object;
            AndroidDriver androidDriver = this;
            try {
                AndroidDriver $this$setAllPermissions_u24lambda_u2416 = androidDriver;
                boolean bl = false;
                File apkFile = AndroidAppFiles.INSTANCE.getApkFile($this$setAllPermissions_u24lambda_u2416.dadb, appId);
                List permissions = new ApkFile(apkFile).getApkMeta().getUsesPermissions();
                apkFile.delete();
                object = Result.constructor-impl((Object)permissions);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            Object permissionsResult = object;
            if (!Result.isSuccess-impl((Object)permissionsResult)) break block4;
            List list = (List)(Result.isFailure-impl((Object)permissionsResult) ? null : permissionsResult);
            if (list != null) {
                List it = list;
                boolean bl = false;
                Iterable $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String permission = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)permission, (String)"permission");
                    this.setPermissionInternal(appId, permission, this.translatePermissionValue(permissionValue));
                }
            }
        }
    }

    private final void setPermissionInternal(String appId, String permission, String permissionValue) {
        try {
            this.dadb.shell("pm " + permissionValue + ' ' + appId + ' ' + permission);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final List<String> translatePermissionName(String name2) {
        List list;
        switch (name2) {
            case "location": {
                Object[] objectArray = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "camera": {
                list = CollectionsKt.listOf((Object)"android.permission.CAMERA");
                break;
            }
            case "contacts": {
                Object[] objectArray = new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "phone": {
                Object[] objectArray = new String[]{"android.permission.CALL_PHONE", "android.permission.ANSWER_PHONE_CALLS"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "microphone": {
                list = CollectionsKt.listOf((Object)"android.permission.RECORD_AUDIO");
                break;
            }
            case "bluetooth": {
                Object[] objectArray = new String[]{"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_SCAN"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "storage": {
                Object[] objectArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "notifications": {
                list = CollectionsKt.listOf((Object)"android.permission.POST_NOTIFICATIONS");
                break;
            }
            case "medialibrary": {
                Object[] objectArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_MEDIA_AUDIO", "android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "calendar": {
                Object[] objectArray = new String[]{"android.permission.WRITE_CALENDAR", "android.permission.READ_CALENDAR"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case "sms": {
                Object[] objectArray = new String[]{"android.permission.READ_SMS", "android.permission.RECEIVE_SMS", "android.permission.SEND_SMS"};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            default: {
                CharSequence charSequence = name2;
                Regex regex = new Regex("[^A-Za-z0-9._]+");
                String string = "";
                list = CollectionsKt.listOf((Object)regex.replace(charSequence, string));
            }
        }
        return list;
    }

    private final String translatePermissionValue(String value) {
        String string;
        switch (value) {
            case "allow": {
                string = "grant";
                break;
            }
            case "deny": {
                string = "revoke";
                break;
            }
            case "unset": {
                string = "revoke";
                break;
            }
            default: {
                string = "revoke";
            }
        }
        return string;
    }

    private final TreeNode mapHierarchy(Node node) {
        Map map;
        if (node instanceof Element) {
            String string;
            String string2;
            Object text;
            Map attributesBuilder = new LinkedHashMap();
            if (((Element)node).hasAttribute("text")) {
                text = ((Element)node).getAttribute("text");
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                attributesBuilder.put("text", text);
            }
            if (((Element)node).hasAttribute("content-desc")) {
                text = attributesBuilder;
                string2 = "accessibilityText";
                String string3 = ((Element)node).getAttribute("content-desc");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"node.getAttribute(\"content-desc\")");
                string = string3;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("hintText")) {
                text = attributesBuilder;
                string2 = "hintText";
                String string4 = ((Element)node).getAttribute("hintText");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"node.getAttribute(\"hintText\")");
                string = string4;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("class") && Intrinsics.areEqual((Object)((Element)node).getAttribute("class"), (Object)TOAST_CLASS_NAME)) {
                attributesBuilder.put("ignoreBoundsFiltering", "true");
            } else {
                attributesBuilder.put("ignoreBoundsFiltering", "false");
            }
            if (((Element)node).hasAttribute("resource-id")) {
                text = attributesBuilder;
                string2 = "resource-id";
                String string5 = ((Element)node).getAttribute("resource-id");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"node.getAttribute(\"resource-id\")");
                string = string5;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("clickable")) {
                text = attributesBuilder;
                string2 = "clickable";
                String string6 = ((Element)node).getAttribute("clickable");
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"node.getAttribute(\"clickable\")");
                string = string6;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("bounds")) {
                text = attributesBuilder;
                string2 = "bounds";
                String string7 = ((Element)node).getAttribute("bounds");
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"node.getAttribute(\"bounds\")");
                string = string7;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("enabled")) {
                text = attributesBuilder;
                string2 = "enabled";
                String string8 = ((Element)node).getAttribute("enabled");
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"node.getAttribute(\"enabled\")");
                string = string8;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("focused")) {
                text = attributesBuilder;
                string2 = "focused";
                String string9 = ((Element)node).getAttribute("focused");
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"node.getAttribute(\"focused\")");
                string = string9;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("checked")) {
                text = attributesBuilder;
                string2 = "checked";
                String string10 = ((Element)node).getAttribute("checked");
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"node.getAttribute(\"checked\")");
                string = string10;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("scrollable")) {
                text = attributesBuilder;
                string2 = "scrollable";
                String string11 = ((Element)node).getAttribute("scrollable");
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"node.getAttribute(\"scrollable\")");
                string = string11;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("selected")) {
                text = attributesBuilder;
                string2 = "selected";
                String string12 = ((Element)node).getAttribute("selected");
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"node.getAttribute(\"selected\")");
                string = string12;
                text.put(string2, string);
            }
            if (((Element)node).hasAttribute("class")) {
                text = attributesBuilder;
                string2 = "class";
                String string13 = ((Element)node).getAttribute("class");
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"node.getAttribute(\"class\")");
                string = string13;
                text.put(string2, string);
            }
            map = attributesBuilder;
        } else {
            map = MapsKt.emptyMap();
        }
        Map attributes = map;
        List children = new ArrayList();
        NodeList childNodes = node.getChildNodes();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)childNodes.getLength());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Collection collection = children;
            Node node2 = childNodes.item(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"childNodes.item(i)");
            collection.add(this.mapHierarchy(node2));
        }
        return new TreeNode(MapsKt.toMutableMap((Map)attributes), children, this.getBoolean(node, "clickable"), this.getBoolean(node, "enabled"), this.getBoolean(node, "focused"), this.getBoolean(node, "checked"), this.getBoolean(node, "selected"));
    }

    private final Boolean getBoolean(Node $this$getBoolean, String name2) {
        Boolean bl;
        String string;
        Element element2;
        Element element3 = element2 = $this$getBoolean instanceof Element ? (Element)$this$getBoolean : null;
        if (element2 != null && (string = element2.getAttribute(name2)) != null) {
            String it = string;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)"true");
        } else {
            bl = null;
        }
        return bl;
    }

    public final void installMaestroDriverApp() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"installMaestroDriverApp")), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                this.this$0.uninstallMaestroDriverApp();
                File maestroAppApk = File.createTempFile("maestro-app", ".apk");
                InputStream inputStream = Maestro.class.getResourceAsStream("/maestro-app.apk");
                if (inputStream != null) {
                    InputStream it = inputStream;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)maestroAppApk, (String)"maestroAppApk");
                    BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink$default((File)maestroAppApk, (boolean)false, (int)1, null));
                    bufferedSink.writeAll(Okio.source((InputStream)it));
                    bufferedSink.flush();
                }
                Intrinsics.checkNotNullExpressionValue((Object)maestroAppApk, (String)"maestroAppApk");
                AndroidDriver.access$install(this.this$0, maestroAppApk);
                if (!AndroidDriver.access$isPackageInstalled(this.this$0, "dev.mobile.maestro")) {
                    throw new IllegalStateException("dev.mobile.maestro was not installed");
                }
                return maestroAppApk.delete();
            }
        });
    }

    private final void installMaestroServerApp() {
        this.uninstallMaestroServerApp();
        File maestroServerApk = File.createTempFile("maestro-server", ".apk");
        InputStream inputStream = Maestro.class.getResourceAsStream("/maestro-server.apk");
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)maestroServerApk, (String)"maestroServerApk");
            BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink$default((File)maestroServerApk, (boolean)false, (int)1, null));
            bufferedSink.writeAll(Okio.source((InputStream)it));
            bufferedSink.flush();
        }
        Intrinsics.checkNotNullExpressionValue((Object)maestroServerApk, (String)"maestroServerApk");
        this.install(maestroServerApk);
        if (!this.isPackageInstalled("dev.mobile.maestro.test")) {
            throw new IllegalStateException("dev.mobile.maestro.test was not installed");
        }
        maestroServerApk.delete();
    }

    private final void installMaestroApks() {
        this.installMaestroDriverApp();
        this.installMaestroServerApp();
    }

    public final void uninstallMaestroDriverApp() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"uninstallMaestroDriverApp")), (Function0)new Function0<Unit>(this){
            final /* synthetic */ AndroidDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (AndroidDriver.access$isPackageInstalled(this.this$0, "dev.mobile.maestro")) {
                    AndroidDriver.access$uninstall(this.this$0, "dev.mobile.maestro");
                }
            }
        });
    }

    private final void uninstallMaestroServerApp() {
        if (this.isPackageInstalled("dev.mobile.maestro.test")) {
            this.uninstall("dev.mobile.maestro.test");
        }
    }

    private final void uninstallMaestroApks() {
        this.uninstallMaestroDriverApp();
        this.uninstallMaestroServerApp();
    }

    private final void install(File apkFile) {
        try {
            this.dadb.install(apkFile, new String[0]);
        }
        catch (IOException installError) {
            throw new IOException("Failed to install apk " + apkFile + ": " + installError.getMessage(), installError);
        }
    }

    private final void uninstall(String packageName) {
        try {
            this.dadb.uninstall(packageName);
        }
        catch (IOException error) {
            throw new IOException("Failed to uninstall package " + packageName + ": " + error.getMessage(), error);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPackageInstalled(String packageName) {
        boolean bl;
        block6: {
            List parts;
            Iterable $this$filterTo$iv$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            String output = this.shell("pm list packages --user 0 " + packageName);
            CharSequence charSequence = output;
            Regex regex = new Regex("\n");
            int n = 0;
            Iterable $this$map$iv = regex.split(charSequence, n);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                CharSequence charSequence2 = (CharSequence)line;
                Regex regex2 = new Regex(":");
                int n2 = 0;
                collection.add(regex2.split(charSequence2, n2));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                parts = (List)element$iv$iv;
                boolean bl3 = false;
                if (!(parts.size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                parts = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add((String)parts.get(1));
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String linePackageName = (String)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)linePackageName, (Object)packageName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String shell(String command) {
        AdbShellResponse adbShellResponse;
        try {
            adbShellResponse = this.dadb.shell(command);
        }
        catch (IOException e) {
            throw new IOException(command, e);
        }
        AdbShellResponse response = adbShellResponse;
        if (response.getExitCode() != 0) {
            throw new IOException(command + ": " + response.getAllOutput());
        }
        return response.getOutput();
    }

    private final long getStartupTimeout() {
        Object object;
        Object object2 = this;
        try {
            AndroidDriver $this$getStartupTimeout_u24lambda_u2426 = object2;
            boolean bl = false;
            String string = System.getenv(MAESTRO_DRIVER_STARTUP_TIMEOUT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(MAESTRO_DRIVER_STARTUP_TIMEOUT)");
            object = Result.constructor-impl((Object)Long.parseLong(string));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = 15000L;
        return ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).longValue();
    }

    private final boolean successfullyStarted(AdbShellStream $this$successfullyStarted) {
        AdbShellStream adbShellStream = $this$successfullyStarted;
        AdbShellPacket output = adbShellStream != null ? adbShellStream.read() : null;
        return output instanceof AdbShellPacket.StdError ? false : (StringsKt.contains((CharSequence)String.valueOf(output), (CharSequence)"FAILED", (boolean)true) ? false : !StringsKt.contains((CharSequence)String.valueOf(output), (CharSequence)"UNABLE", (boolean)true));
    }

    private final <T> T runDeviceCall(Function0<? extends T> call) {
        Object object;
        try {
            object = call.invoke();
        }
        catch (StatusRuntimeException throwable) {
            Status status = Status.fromThrowable((Throwable)throwable);
            if (status.getCode() == Status.Code.DEADLINE_EXCEEDED) {
                this.closed = true;
                throw new MaestroException.DriverTimeout("Android driver unreachable");
            }
            throw throwable;
        }
        return (T)object;
    }

    public static final /* synthetic */ MaestroDriverGrpc.MaestroDriverBlockingStub access$getBlockingStubWithTimeout(AndroidDriver $this) {
        return $this.getBlockingStubWithTimeout();
    }

    public static final /* synthetic */ boolean access$getOpen$p(AndroidDriver $this) {
        return $this.open;
    }

    public static final /* synthetic */ boolean access$isPackageInstalled(AndroidDriver $this, String packageName) {
        return $this.isPackageInstalled(packageName);
    }

    public static final /* synthetic */ Dadb access$getDadb$p(AndroidDriver $this) {
        return $this.dadb;
    }

    public static final /* synthetic */ Object access$runDeviceCall(AndroidDriver $this, Function0 call) {
        return $this.runDeviceCall(call);
    }

    public static final /* synthetic */ String access$shell(AndroidDriver $this, String command) {
        return $this.shell(command);
    }

    public static final /* synthetic */ DocumentBuilderFactory access$getDocumentBuilderFactory$p(AndroidDriver $this) {
        return $this.documentBuilderFactory;
    }

    public static final /* synthetic */ TreeNode access$mapHierarchy(AndroidDriver $this, Node node) {
        return $this.mapHierarchy(node);
    }

    public static final /* synthetic */ TreeNode access$excludeKeyboardElements(AndroidDriver $this, TreeNode $receiver) {
        return $this.excludeKeyboardElements($receiver);
    }

    public static final /* synthetic */ void access$directionalSwipe(AndroidDriver $this, long durationMs, Point start, Point end) {
        $this.directionalSwipe(durationMs, start, end);
    }

    public static final /* synthetic */ int access$getDeviceApiLevel(AndroidDriver $this) {
        return $this.getDeviceApiLevel();
    }

    public static final /* synthetic */ void access$openBrowser(AndroidDriver $this, String link) {
        $this.openBrowser(link);
    }

    public static final /* synthetic */ void access$autoVerifyApp(AndroidDriver $this, String appId) {
        $this.autoVerifyApp(appId);
    }

    public static final /* synthetic */ void access$setProxySet$p(AndroidDriver $this, boolean bl) {
        $this.proxySet = bl;
    }

    public static final /* synthetic */ ManagedChannel access$getChannel$p(AndroidDriver $this) {
        return $this.channel;
    }

    public static final /* synthetic */ TreeNode access$waitForWindowToSettle-6OQmXwk(AndroidDriver $this, String appId, TreeNode initialHierarchy, Integer timeoutMs) {
        return $this.waitForWindowToSettle-6OQmXwk(appId, initialHierarchy, timeoutMs);
    }

    public static final /* synthetic */ void access$setAllPermissions(AndroidDriver $this, String appId, String permissionValue) {
        $this.setAllPermissions(appId, permissionValue);
    }

    public static final /* synthetic */ void access$setPermissionInternal(AndroidDriver $this, String appId, String permission, String permissionValue) {
        $this.setPermissionInternal(appId, permission, permissionValue);
    }

    public static final /* synthetic */ String access$translatePermissionValue(AndroidDriver $this, String value) {
        return $this.translatePermissionValue(value);
    }

    public static final /* synthetic */ List access$translatePermissionName(AndroidDriver $this, String name2) {
        return $this.translatePermissionName(name2);
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ void access$addMediaToDevice(AndroidDriver $this, File mediaFile) {
        $this.addMediaToDevice(mediaFile);
    }

    public static final /* synthetic */ void access$broadcastAirplaneMode(AndroidDriver $this, boolean enabled2) {
        $this.broadcastAirplaneMode(enabled2);
    }

    public static final /* synthetic */ int access$extractSetLocaleResult(AndroidDriver $this, String result) {
        return $this.extractSetLocaleResult(result);
    }

    public static final /* synthetic */ void access$install(AndroidDriver $this, File apkFile) {
        $this.install(apkFile);
    }

    public static final /* synthetic */ void access$uninstall(AndroidDriver $this, String packageName) {
        $this.uninstall(packageName);
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        REGEX_OPTIONS = SetsKt.setOf((Object[])objectArray);
        LOGGER = LoggerFactory.getLogger(AndroidDriver.class);
        PORT_TO_FORWARDER = new LinkedHashMap();
        PORT_TO_ALLOCATION_POINT = new LinkedHashMap();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lmaestro/drivers/AndroidDriver$Companion;", "", "()V", "CHUNK_SIZE", "", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAESTRO_DRIVER_STARTUP_TIMEOUT", "", "PORT_TO_ALLOCATION_POINT", "", "", "PORT_TO_FORWARDER", "Ljava/lang/AutoCloseable;", "REGEX_OPTIONS", "", "Lkotlin/text/RegexOption;", "SCREENSHOT_DIFF_THRESHOLD", "", "SERVER_LAUNCH_TIMEOUT_MS", "TOAST_CLASS_NAME", "WINDOW_UPDATE_TIMEOUT_MS", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

