/*
 * Decompiled with CFR 0.152.
 */
package maestro.drivers;

import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import com.github.michaelbull.result.UnwrapException;
import hierarchy.AXElement;
import ios.IOSDevice;
import ios.IOSDeviceErrors;
import ios.IOSScreenRecording;
import java.io.File;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import maestro.Capability;
import maestro.DeviceInfo;
import maestro.DeviceInfoKt;
import maestro.Driver;
import maestro.Filters;
import maestro.KeyCode;
import maestro.MaestroException;
import maestro.MediaExt;
import maestro.NamedSource;
import maestro.Point;
import maestro.ScreenRecording;
import maestro.SwipeDirection;
import maestro.TreeNode;
import maestro.UiElement;
import maestro.ViewHierarchy;
import maestro.drivers.IOSDriver;
import maestro.drivers.IOSDriverKt;
import maestro.utils.Insight;
import maestro.utils.Insights;
import maestro.utils.MaestroTimer;
import maestro.utils.Metrics;
import maestro.utils.MetricsProvider;
import maestro.utils.NoopInsights;
import maestro.utils.ScreenshotUtils;
import maestro.utils.network.XCUITestServerError;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.XCRunnerCLIUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 p2\u00020\u0001:\u0001pB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\"H\u0016J\b\u0010%\u001a\u00020\u000fH\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\rH\u0016J\b\u0010)\u001a\u00020\rH\u0002J\b\u0010*\u001a\u00020\rH\u0016J\b\u0010+\u001a\u00020\rH\u0002J\b\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020\rH\u0016J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J.\u0010/\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u000202012\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020\nH\u0016J\b\u0010<\u001a\u00020\u000fH\u0016J*\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020\rH\u0016J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u000fH\u0016J)\u0010E\u001a\u0002HF\"\u0004\b\u0000\u0010F2\u0006\u0010G\u001a\u00020\n2\f\u0010H\u001a\b\u0012\u0004\u0012\u0002HF0IH\u0002\u00a2\u0006\u0002\u0010JJ\b\u0010K\u001a\u00020\u000fH\u0016J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\rH\u0016J\u0018\u0010N\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020PH\u0016J$\u0010R\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n01H\u0016J\u0018\u0010T\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020\n2\u0006\u0010V\u001a\u00020\"H\u0016J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\\\u001a\u00020\u000f2\u0006\u0010]\u001a\u0002072\u0006\u0010^\u001a\u0002072\u0006\u0010_\u001a\u00020`H\u0016J \u0010\\\u001a\u00020\u000f2\u0006\u0010a\u001a\u0002072\u0006\u0010b\u001a\u00020c2\u0006\u0010_\u001a\u00020`H\u0016J\u0018\u0010\\\u001a\u00020\u000f2\u0006\u0010d\u001a\u00020c2\u0006\u0010_\u001a\u00020`H\u0016J\u0018\u0010e\u001a\u00020\u000f2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010f\u001a\u00020\rH\u0016J\u0010\u0010g\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010h\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J5\u0010i\u001a\u0004\u0018\u00010j2\b\u0010k\u001a\u0004\u0018\u00010j2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010l\u001a\u0004\u0018\u00010\"H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bm\u0010nJ\u0010\u0010o\u001a\u00020\r2\u0006\u0010l\u001a\u00020`H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006q"}, d2={"Lmaestro/drivers/IOSDriver;", "Lmaestro/Driver;", "iosDevice", "Lios/IOSDevice;", "insights", "Lmaestro/utils/Insights;", "metricsProvider", "Lmaestro/utils/Metrics;", "(Lios/IOSDevice;Lmaestro/utils/Insights;Lmaestro/utils/Metrics;)V", "appId", "", "metrics", "proxySet", "", "addMedia", "", "mediaFiles", "", "Ljava/io/File;", "addMediaToDevice", "mediaFile", "backPress", "capabilities", "Lmaestro/Capability;", "clearAppState", "clearKeychain", "close", "contentDescriptor", "Lmaestro/TreeNode;", "excludeKeyboardElements", "deviceInfo", "Lmaestro/DeviceInfo;", "dismissKeyboardIntroduction", "heightPoints", "", "eraseText", "charactersToErase", "hideKeyboard", "inputText", "text", "isAirplaneModeEnabled", "isKeyboardHidden", "isKeyboardVisible", "isScreenStatic", "isShutdown", "isUnicodeInputSupported", "killApp", "launchApp", "launchArguments", "", "", "sessionId", "Ljava/util/UUID;", "longPress", "point", "Lmaestro/Point;", "mapViewHierarchy", "element", "Lhierarchy/AXElement;", "name", "open", "openLink", "link", "autoVerify", "browser", "pressKey", "code", "Lmaestro/KeyCode;", "resetProxy", "runDeviceCall", "T", "callName", "call", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "scrollVertical", "setAirplaneMode", "enabled", "setLocation", "latitude", "", "longitude", "setPermissions", "permissions", "setProxy", "host", "port", "startScreenRecording", "Lmaestro/ScreenRecording;", "out", "Lokio/Sink;", "stopApp", "swipe", "start", "end", "durationMs", "", "elementPoint", "direction", "Lmaestro/SwipeDirection;", "swipeDirection", "takeScreenshot", "compressed", "tap", "viewHierarchy", "waitForAppToSettle", "Lmaestro/ViewHierarchy;", "initialHierarchy", "timeoutMs", "waitForAppToSettle-5RpGHs4", "(Lmaestro/TreeNode;Ljava/lang/String;Ljava/lang/Integer;)Lmaestro/TreeNode;", "waitUntilScreenIsStatic", "Companion", "maestro-client"})
@SourceDebugExtension(value={"SMAP\nIOSDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IOSDriver.kt\nmaestro/drivers/IOSDriver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,573:1\n494#2,7:574\n453#2:581\n403#2:582\n1238#3,4:583\n1549#3:588\n1620#3,3:589\n1#4:587\n*S KotlinDebug\n*F\n+ 1 IOSDriver.kt\nmaestro/drivers/IOSDriver\n*L\n49#1:574,7\n49#1:581\n49#1:582\n49#1:583,4\n197#1:588\n197#1:589,3\n*E\n"})
public final class IOSDriver
implements Driver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IOSDevice iosDevice;
    @NotNull
    private final Insights insights;
    @NotNull
    private final Metrics metricsProvider;
    @NotNull
    private final Metrics metrics;
    @Nullable
    private String appId;
    private boolean proxySet;
    @NotNull
    public static final String NAME = "iOS Simulator";
    private static final Logger LOGGER = LoggerFactory.getLogger(IOSDevice.class);
    private static final int ELEMENT_TYPE_CHECKBOX = 12;
    private static final int ELEMENT_TYPE_SWITCH = 40;
    private static final int ELEMENT_TYPE_TOGGLE = 41;
    private static final int WARNING_MAX_DEPTH = 61;
    @NotNull
    private static final Set<Integer> CHECKABLE_ELEMENTS;
    private static final long SCREEN_SETTLE_TIMEOUT_MS = 3000L;

    /*
     * WARNING - void declaration
     */
    public IOSDriver(@NotNull IOSDevice iosDevice, @NotNull Insights insights, @NotNull Metrics metricsProvider) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map;
        Map $this$filterValues$iv;
        Intrinsics.checkNotNullParameter((Object)iosDevice, (String)"iosDevice");
        Intrinsics.checkNotNullParameter((Object)insights, (String)"insights");
        Intrinsics.checkNotNullParameter((Object)metricsProvider, (String)"metricsProvider");
        this.iosDevice = iosDevice;
        this.insights = insights;
        this.metricsProvider = metricsProvider;
        Object object = new Pair[]{TuplesKt.to((Object)"platform", (Object)"ios"), TuplesKt.to((Object)"deviceId", (Object)this.iosDevice.getDeviceId())};
        object = MapsKt.mapOf((Pair[])object);
        Metrics metrics = this.metricsProvider.withPrefix("maestro.driver");
        IOSDriver iOSDriver = this;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = map = (Map)result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map2;
            boolean bl2 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNull(v);
            String string = (String)v;
            map.put(k, string);
        }
        map = destination$iv$iv;
        iOSDriver.metrics = metrics.withTags(map);
    }

    public /* synthetic */ IOSDriver(IOSDevice iOSDevice, Insights insights, Metrics metrics, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            insights = (Insights)NoopInsights.INSTANCE;
        }
        if ((n & 4) != 0) {
            metrics = MetricsProvider.INSTANCE.getInstance();
        }
        this(iOSDevice, insights, metrics);
    }

    @Override
    @NotNull
    public String name() {
        return (String)Metrics.measured$default((Metrics)this.metrics, (String)"name", null, (Function0)name.1.INSTANCE, (int)2, null);
    }

    @Override
    public void open() {
        Metrics.measured$default((Metrics)this.metrics, (String)"open", null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$getIosDevice$p(this.this$0).open();
            }
        }), (int)2, null);
    }

    @Override
    public void close() {
        Metrics.measured$default((Metrics)this.metrics, (String)"close", null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (IOSDriver.access$getProxySet$p(this.this$0)) {
                    this.this$0.resetProxy();
                }
                IOSDriver.access$getIosDevice$p(this.this$0).close();
                IOSDriver.access$setAppId$p(this.this$0, null);
            }
        }), (int)2, null);
    }

    @Override
    @NotNull
    public DeviceInfo deviceInfo() {
        return (DeviceInfo)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"deviceInfo")), (Function0)new Function0<DeviceInfo>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DeviceInfo invoke() {
                return (DeviceInfo)IOSDriver.access$runDeviceCall(this.this$0, "deviceInfo", (Function0)new Function0<DeviceInfo>(this.this$0){
                    final /* synthetic */ IOSDriver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final DeviceInfo invoke() {
                        return DeviceInfoKt.toCommonDeviceInfo(IOSDriver.access$getIosDevice$p(this.this$0).deviceInfo());
                    }
                });
            }
        });
    }

    @Override
    public void launchApp(@NotNull String appId, @NotNull Map<String, ? extends Object> launchArguments, @Nullable UUID sessionId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"launchApp"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, appId, launchArguments, sessionId){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ String $appId;
            final /* synthetic */ Map<String, Object> $launchArguments;
            final /* synthetic */ UUID $sessionId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                this.$launchArguments = $launchArguments;
                this.$sessionId = $sessionId;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$getOrThrow$iv;
                Object it;
                void $this$onSuccess$iv;
                Result result = IOSDriver.access$getIosDevice$p(this.this$0).launch(this.$appId, this.$launchArguments, this.$sessionId);
                Object object = this.this$0;
                String string = this.$appId;
                boolean $i$f$onSuccess = false;
                if ($this$onSuccess$iv instanceof Ok) {
                    it = (Unit)((Ok)$this$onSuccess$iv).getValue();
                    boolean bl = false;
                    IOSDriver.access$setAppId$p((IOSDriver)object, string);
                }
                object = this.$appId;
                boolean $i$f$getOrThrow = false;
                void var4_6 = $this$getOrThrow$iv;
                if (!(var4_6 instanceof Ok)) {
                    if (var4_6 instanceof Err) {
                        it = (Throwable)((Err)$this$getOrThrow$iv).getError();
                        boolean bl = false;
                        throw (Throwable)new MaestroException.UnableToLaunchApp("Unable to launch app " + (String)object + ' ' + ((Throwable)it).getMessage());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ((Ok)$this$getOrThrow$iv).getValue();
            }
        });
    }

    @Override
    public void stopApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"stopApp"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Result<? extends Unit, ? extends Throwable>>(this, appId){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ String $appId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                super(0);
            }

            @NotNull
            public final Result<Unit, Throwable> invoke() {
                return IOSDriver.access$getIosDevice$p(this.this$0).stop(this.$appId);
            }
        });
    }

    @Override
    public void killApp(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"killApp"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, appId){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ String $appId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                super(0);
            }

            public final void invoke() {
                this.this$0.stopApp(this.$appId);
            }
        });
    }

    @Override
    public void clearAppState(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"clearAppState"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, appId){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ String $appId;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$getIosDevice$p(this.this$0).clearAppState(this.$appId);
            }
        });
    }

    @Override
    public void clearKeychain() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"clearKeychain")), (Function0)new Function0<Unit>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Result $this$expect$iv = IOSDriver.access$getIosDevice$p(this.this$0).clearKeychain();
                boolean $i$f$expect = false;
                Result result = $this$expect$iv;
                if (!(result instanceof Ok)) {
                    if (result instanceof Err) {
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl = false;
                        String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                        throw new UnwrapException(string);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ((Ok)$this$expect$iv).getValue();
            }
        });
    }

    @Override
    public void tap(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"tap")), (Function0)new Function0<Unit>(this, point){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ Point $point;
            {
                this.this$0 = $receiver;
                this.$point = $point;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$runDeviceCall(this.this$0, "tap", (Function0)new Function0<Unit>(this.this$0, this.$point){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ Point $point;
                    {
                        this.this$0 = $receiver;
                        this.$point = $point;
                        super(0);
                    }

                    public final void invoke() {
                        IOSDriver.access$getIosDevice$p(this.this$0).tap(this.$point.getX(), this.$point.getY());
                    }
                });
            }
        });
    }

    @Override
    public void longPress(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"longPress")), (Function0)new Function0<Unit>(this, point){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ Point $point;
            {
                this.this$0 = $receiver;
                this.$point = $point;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$runDeviceCall(this.this$0, "longPress", (Function0)new Function0<Unit>(this.this$0, this.$point){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ Point $point;
                    {
                        this.this$0 = $receiver;
                        this.$point = $point;
                        super(0);
                    }

                    public final void invoke() {
                        IOSDriver.access$getIosDevice$p(this.this$0).longPress(this.$point.getX(), this.$point.getY(), 3000L);
                    }
                });
            }
        });
    }

    @Override
    public void pressKey(@NotNull KeyCode code) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"pressKey")), (Function0)new Function0<Unit>(this, code){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ KeyCode $code;
            {
                this.this$0 = $receiver;
                this.$code = $code;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KeyCode.BACKSPACE), (Object)"delete"), TuplesKt.to((Object)((Object)KeyCode.ENTER), (Object)"return")};
                Map keyCodeNameMap = MapsKt.mapOf((Pair[])pairArray);
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)KeyCode.HOME), (Object)"home"), TuplesKt.to((Object)((Object)KeyCode.LOCK), (Object)"lock")};
                Map buttonNameMap = MapsKt.mapOf((Pair[])pairArray2);
                return (Unit)IOSDriver.access$runDeviceCall(this.this$0, "pressKey", (Function0)new Function0<Unit>((Map<KeyCode, String>)keyCodeNameMap, this.$code, (Map<KeyCode, String>)buttonNameMap, this.this$0){
                    final /* synthetic */ Map<KeyCode, String> $keyCodeNameMap;
                    final /* synthetic */ KeyCode $code;
                    final /* synthetic */ Map<KeyCode, String> $buttonNameMap;
                    final /* synthetic */ IOSDriver this$0;
                    {
                        this.$keyCodeNameMap = $keyCodeNameMap;
                        this.$code = $code;
                        this.$buttonNameMap = $buttonNameMap;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Unit invoke() {
                        Unit unit;
                        String name2;
                        IOSDriver iOSDriver;
                        String string;
                        String string2 = this.$keyCodeNameMap.get((Object)((Object)this.$code));
                        if (string2 != null) {
                            string = string2;
                            iOSDriver = this.this$0;
                            name2 = string;
                            boolean bl = false;
                            IOSDriver.access$getIosDevice$p(iOSDriver).pressKey(name2);
                        }
                        String string3 = this.$buttonNameMap.get((Object)((Object)this.$code));
                        if (string3 != null) {
                            string = string3;
                            iOSDriver = this.this$0;
                            name2 = string;
                            boolean bl = false;
                            IOSDriver.access$getIosDevice$p(iOSDriver).pressButton(name2);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public TreeNode contentDescriptor(boolean excludeKeyboardElements) {
        return (TreeNode)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"contentDescriptor")), (Function0)new Function0<TreeNode>(this, excludeKeyboardElements){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ boolean $excludeKeyboardElements;
            {
                this.this$0 = $receiver;
                this.$excludeKeyboardElements = $excludeKeyboardElements;
                super(0);
            }

            @NotNull
            public final TreeNode invoke() {
                return (TreeNode)IOSDriver.access$runDeviceCall(this.this$0, "contentDescriptor", (Function0)new Function0<TreeNode>(this.this$0, this.$excludeKeyboardElements){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ boolean $excludeKeyboardElements;
                    {
                        this.this$0 = $receiver;
                        this.$excludeKeyboardElements = $excludeKeyboardElements;
                        super(0);
                    }

                    @NotNull
                    public final TreeNode invoke() {
                        return IOSDriver.access$viewHierarchy(this.this$0, this.$excludeKeyboardElements);
                    }
                });
            }
        });
    }

    private final TreeNode viewHierarchy(boolean excludeKeyboardElements) {
        LOGGER.info("Requesting view hierarchy of the screen");
        hierarchy.ViewHierarchy hierarchyResult = this.iosDevice.viewHierarchy(excludeKeyboardElements);
        LOGGER.info("Depth of the screen is " + hierarchyResult.getDepth());
        if (hierarchyResult.getDepth() > 61) {
            String message = "The view hierarchy has been calculated. The current depth of the hierarchy is " + hierarchyResult.getDepth() + ". This might affect the execution time of your test. If you are using React native, consider migrating to the new architecture where view flattening is available. For more information on the migration process, please visit: https://reactnative.dev/docs/new-architecture-intro";
            this.insights.report(new Insight(message, Insight.Level.INFO));
        } else {
            this.insights.report(new Insight("", Insight.Level.NONE));
        }
        AXElement hierarchy = hierarchyResult.getAxElement();
        return this.mapViewHierarchy(hierarchy);
    }

    /*
     * WARNING - void declaration
     */
    private final TreeNode mapViewHierarchy(AXElement element2) {
        void $this$mapTo$iv$iv;
        Object object;
        String string;
        String string2;
        String string3;
        Map map;
        Map attributes;
        block10: {
            block9: {
                CharSequence charSequence;
                attributes = new LinkedHashMap();
                attributes.put("accessibilityText", element2.getLabel());
                map = attributes;
                string3 = "title";
                String string4 = element2.getTitle();
                if (string4 == null) {
                    string4 = "";
                }
                string2 = string4;
                map.put(string3, string2);
                map = attributes;
                string3 = "value";
                String string5 = element2.getValue();
                if (string5 == null) {
                    string5 = "";
                }
                string2 = string5;
                map.put(string3, string2);
                map = attributes;
                string3 = "text";
                string = element2.getTitle();
                if (string == null) break block9;
                object = string;
                if (object.length() == 0) {
                    boolean bl = false;
                    charSequence = element2.getValue();
                } else {
                    charSequence = object;
                }
                if ((string = (String)charSequence) != null) break block10;
            }
            string = "";
        }
        string2 = string;
        map.put(string3, string2);
        map = attributes;
        string3 = "hintText";
        String string6 = element2.getPlaceholderValue();
        if (string6 == null) {
            string6 = "";
        }
        string2 = string6;
        map.put(string3, string2);
        attributes.put("resource-id", element2.getIdentifier());
        attributes.put("bounds", element2.getFrame().getBoundsString());
        attributes.put("enabled", String.valueOf(element2.getEnabled()));
        attributes.put("focused", String.valueOf(element2.getHasFocus()));
        attributes.put("selected", String.valueOf(element2.getSelected()));
        boolean checked2 = CHECKABLE_ELEMENTS.contains(element2.getElementType()) && Intrinsics.areEqual((Object)element2.getValue(), (Object)"1");
        attributes.put("checked", String.valueOf(checked2));
        Iterable $this$map$iv = element2.getChildren();
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AXElement aXElement = (AXElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapViewHierarchy((AXElement)it));
        }
        List children = (List)destination$iv$iv;
        boolean bl = element2.getEnabled();
        boolean bl2 = element2.getHasFocus();
        boolean bl3 = element2.getSelected();
        return new TreeNode(attributes, children, null, bl, bl2, checked2, bl3, 4, null);
    }

    @Override
    public boolean isUnicodeInputSupported() {
        return true;
    }

    @Override
    public void scrollVertical() {
        DeviceInfo deviceInfo2 = this.deviceInfo();
        int width = deviceInfo2.getWidthGrid();
        int height = deviceInfo2.getHeightGrid();
        this.swipe(new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.5, height)), new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.1, height)), 333L);
    }

    @Override
    public boolean isKeyboardVisible() {
        return (Boolean)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"isKeyboardVisible")), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)IOSDriver.access$runDeviceCall(this.this$0, "isKeyboardVisible", (Function0)new Function0<Boolean>(this.this$0){
                    final /* synthetic */ IOSDriver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return IOSDriver.access$getIosDevice$p(this.this$0).isKeyboardVisible();
                    }
                });
            }
        });
    }

    @Override
    public void swipe(@NotNull Point start, @NotNull Point end, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"swipe"), TuplesKt.to((Object)"durationMs", (Object)String.valueOf(durationMs))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, start, end, durationMs){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ Point $start;
            final /* synthetic */ Point $end;
            final /* synthetic */ long $durationMs;
            {
                this.this$0 = $receiver;
                this.$start = $start;
                this.$end = $end;
                this.$durationMs = $durationMs;
                super(0);
            }

            public final void invoke() {
                DeviceInfo deviceInfo2 = this.this$0.deviceInfo();
                Point startPoint = IOSDriverKt.access$coerceIn(this.$start, deviceInfo2.getWidthGrid(), deviceInfo2.getHeightGrid());
                Point endPoint = IOSDriverKt.access$coerceIn(this.$end, deviceInfo2.getWidthGrid(), deviceInfo2.getHeightGrid());
                IOSDriver.access$runDeviceCall(this.this$0, "swipe", (Function0)new Function0<Unit>(this.this$0, startPoint, endPoint, this.$durationMs){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ Point $startPoint;
                    final /* synthetic */ Point $endPoint;
                    final /* synthetic */ long $durationMs;
                    {
                        this.this$0 = $receiver;
                        this.$startPoint = $startPoint;
                        this.$endPoint = $endPoint;
                        this.$durationMs = $durationMs;
                        super(0);
                    }

                    public final void invoke() {
                        Driver.DefaultImpls.waitForAppToSettle-5RpGHs4$default(this.this$0, null, null, null, 4, null);
                        IOSDriver.access$getIosDevice$p(this.this$0).scroll((double)this.$startPoint.getX(), (double)this.$startPoint.getY(), (double)this.$endPoint.getX(), (double)this.$endPoint.getY(), (double)this.$durationMs / (double)1000);
                    }
                });
            }
        });
    }

    @Override
    public void swipe(@NotNull SwipeDirection swipeDirection, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)swipeDirection), (String)"swipeDirection");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"swipeWithDirection"), TuplesKt.to((Object)"direction", (Object)swipeDirection.name()), TuplesKt.to((Object)"durationMs", (Object)String.valueOf(durationMs))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, swipeDirection, durationMs){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ SwipeDirection $swipeDirection;
            final /* synthetic */ long $durationMs;
            {
                this.this$0 = $receiver;
                this.$swipeDirection = $swipeDirection;
                this.$durationMs = $durationMs;
                super(0);
            }

            public final void invoke() {
                DeviceInfo deviceInfo2 = this.this$0.deviceInfo();
                int width = deviceInfo2.getWidthGrid();
                int height = deviceInfo2.getHeightGrid();
                Point startPoint = null;
                Point endPoint = null;
                switch (swipe.WhenMappings.$EnumSwitchMapping$0[this.$swipeDirection.ordinal()]) {
                    case 1: {
                        startPoint = new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.9, height));
                        endPoint = new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.1, height));
                        break;
                    }
                    case 2: {
                        startPoint = new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.2, height));
                        endPoint = new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.9, height));
                        break;
                    }
                    case 3: {
                        startPoint = new Point(IOSDriverKt.access$asPercentOf(0.1, width), IOSDriverKt.access$asPercentOf(0.5, height));
                        endPoint = new Point(IOSDriverKt.access$asPercentOf(0.9, width), IOSDriverKt.access$asPercentOf(0.5, height));
                        break;
                    }
                    case 4: {
                        startPoint = new Point(IOSDriverKt.access$asPercentOf(0.9, width), IOSDriverKt.access$asPercentOf(0.5, height));
                        endPoint = new Point(IOSDriverKt.access$asPercentOf(0.1, width), IOSDriverKt.access$asPercentOf(0.5, height));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                this.this$0.swipe(startPoint, endPoint, this.$durationMs);
            }
        });
    }

    @Override
    public void swipe(@NotNull Point elementPoint, @NotNull SwipeDirection direction, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)elementPoint, (String)"elementPoint");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"swipeWithElementPoint"), TuplesKt.to((Object)"direction", (Object)direction.name()), TuplesKt.to((Object)"durationMs", (Object)String.valueOf(durationMs))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, direction, elementPoint, durationMs){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ SwipeDirection $direction;
            final /* synthetic */ Point $elementPoint;
            final /* synthetic */ long $durationMs;
            {
                this.this$0 = $receiver;
                this.$direction = $direction;
                this.$elementPoint = $elementPoint;
                this.$durationMs = $durationMs;
                super(0);
            }

            public final void invoke() {
                DeviceInfo deviceInfo2 = this.this$0.deviceInfo();
                int width = deviceInfo2.getWidthGrid();
                int height = deviceInfo2.getHeightGrid();
                switch (swipe.WhenMappings.$EnumSwitchMapping$0[this.$direction.ordinal()]) {
                    case 1: {
                        Point end = new Point(this.$elementPoint.getX(), IOSDriverKt.access$asPercentOf(0.1, height));
                        this.this$0.swipe(this.$elementPoint, end, this.$durationMs);
                        break;
                    }
                    case 2: {
                        Point end = new Point(this.$elementPoint.getX(), IOSDriverKt.access$asPercentOf(0.9, height));
                        this.this$0.swipe(this.$elementPoint, end, this.$durationMs);
                        break;
                    }
                    case 3: {
                        Point end = new Point(IOSDriverKt.access$asPercentOf(0.9, width), this.$elementPoint.getY());
                        this.this$0.swipe(this.$elementPoint, end, this.$durationMs);
                        break;
                    }
                    case 4: {
                        Point end = new Point(IOSDriverKt.access$asPercentOf(0.1, width), this.$elementPoint.getY());
                        this.this$0.swipe(this.$elementPoint, end, this.$durationMs);
                    }
                }
            }
        });
    }

    @Override
    public void backPress() {
    }

    @Override
    public void hideKeyboard() {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"hideKeyboard")), (Function0)new Function0<Unit>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DeviceInfo deviceInfo2 = this.this$0.deviceInfo();
                int width = deviceInfo2.getWidthGrid();
                int height = deviceInfo2.getHeightGrid();
                IOSDriver.access$dismissKeyboardIntroduction(this.this$0, deviceInfo2.getHeightGrid());
                if (IOSDriver.access$isKeyboardHidden(this.this$0)) {
                    return;
                }
                this.this$0.swipe(new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.5, height)), new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.47, height)), 50L);
                if (IOSDriver.access$isKeyboardHidden(this.this$0)) {
                    return;
                }
                this.this$0.swipe(new Point(IOSDriverKt.access$asPercentOf(0.5, width), IOSDriverKt.access$asPercentOf(0.5, height)), new Point(IOSDriverKt.access$asPercentOf(0.47, width), IOSDriverKt.access$asPercentOf(0.5, height)), 50L);
                Driver.DefaultImpls.waitForAppToSettle-5RpGHs4$default(this.this$0, null, null, null, 4, null);
            }
        });
    }

    private final boolean isKeyboardHidden() {
        Function1<List<TreeNode>, List<TreeNode>> filter = Filters.INSTANCE.idMatches(new Regex("delete"));
        TreeNode treeNode = (TreeNode)MaestroTimer.INSTANCE.withTimeout(2000L, (Function0)new Function0<TreeNode>(filter, this){
            final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $filter;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$filter = $filter;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TreeNode invoke() {
                return (TreeNode)CollectionsKt.firstOrNull((List)((List)this.$filter.invoke(Driver.DefaultImpls.contentDescriptor$default(this.this$0, false, 1, null).aggregate())));
            }
        });
        UiElement element2 = treeNode != null ? UiElement.Companion.toUiElementOrNull(treeNode) : null;
        return element2 == null;
    }

    private final void dismissKeyboardIntroduction(int heightPoints) {
        UiElement instructionText2;
        Regex fastTypingInstruction = new Regex("Speed up your typing by sliding your finger across the letters to compose a word.*");
        Function1<List<TreeNode>, List<TreeNode>> instructionTextFilter = Filters.INSTANCE.textMatches(fastTypingInstruction);
        TreeNode treeNode = (TreeNode)MaestroTimer.INSTANCE.withTimeout(2000L, (Function0)new Function0<TreeNode>(instructionTextFilter, this){
            final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $instructionTextFilter;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$instructionTextFilter = $instructionTextFilter;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TreeNode invoke() {
                return (TreeNode)CollectionsKt.firstOrNull((List)((List)this.$instructionTextFilter.invoke(Driver.DefaultImpls.contentDescriptor$default(this.this$0, false, 1, null).aggregate())));
            }
        });
        UiElement uiElement = instructionText2 = treeNode != null ? UiElement.Companion.toUiElementOrNull(treeNode) : null;
        if (instructionText2 != null) {
            int n = heightPoints / 2;
            int n2 = instructionText2.getBounds().center().getY();
            boolean bl = n <= n2 ? n2 <= heightPoints : false;
            if (bl) {
                UiElement continueElement2;
                Function1<List<TreeNode>, List<TreeNode>> continueElementFilter = Filters.INSTANCE.textMatches(new Regex("Continue"));
                TreeNode treeNode2 = (TreeNode)MaestroTimer.INSTANCE.withTimeout(2000L, (Function0)new Function0<TreeNode>(continueElementFilter, this, instructionText2){
                    final /* synthetic */ Function1<List<TreeNode>, List<TreeNode>> $continueElementFilter;
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ UiElement $instructionText;
                    {
                        this.$continueElementFilter = $continueElementFilter;
                        this.this$0 = $receiver;
                        this.$instructionText = $instructionText;
                        super(0);
                    }

                    @Nullable
                    public final TreeNode invoke() {
                        Object v0;
                        block1: {
                            Iterable iterable = (Iterable)this.$continueElementFilter.invoke(Driver.DefaultImpls.contentDescriptor$default(this.this$0, false, 1, null).aggregate());
                            UiElement uiElement = this.$instructionText;
                            Iterable iterable2 = iterable;
                            for (T t : iterable2) {
                                TreeNode it = (TreeNode)t;
                                boolean bl = false;
                                if (!(UiElement.Companion.toUiElement(it).getBounds().center().getY() > uiElement.getBounds().center().getY())) continue;
                                v0 = t;
                                break block1;
                            }
                            v0 = null;
                        }
                        return v0;
                    }
                });
                UiElement uiElement2 = continueElement2 = treeNode2 != null ? UiElement.Companion.toUiElementOrNull(treeNode2) : null;
                if (continueElement2 != null && continueElement2.getBounds().center().getY() > instructionText2.getBounds().center().getY()) {
                    this.tap(continueElement2.getBounds().center());
                }
            }
        }
    }

    @Override
    public void takeScreenshot(@NotNull Sink out, boolean compressed) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"takeScreenshot")), (Function0)new Function0<Unit>(this, out, compressed){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ Sink $out;
            final /* synthetic */ boolean $compressed;
            {
                this.this$0 = $receiver;
                this.$out = $out;
                this.$compressed = $compressed;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$runDeviceCall(this.this$0, "takeScreenshot", (Function0)new Function0<Unit>(this.this$0, this.$out, this.$compressed){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ Sink $out;
                    final /* synthetic */ boolean $compressed;
                    {
                        this.this$0 = $receiver;
                        this.$out = $out;
                        this.$compressed = $compressed;
                        super(0);
                    }

                    public final void invoke() {
                        IOSDriver.access$getIosDevice$p(this.this$0).takeScreenshot(this.$out, this.$compressed);
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public ScreenRecording startScreenRecording(@NotNull Sink out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return (ScreenRecording)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"startScreenRecording")), (Function0)new Function0<startScreenRecording.1>(this, out){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ Sink $out;
            {
                this.this$0 = $receiver;
                this.$out = $out;
                super(0);
            }

            @NotNull
            public final startScreenRecording.1 invoke() {
                Result $this$expect$iv = IOSDriver.access$getIosDevice$p(this.this$0).startScreenRecording(this.$out);
                boolean $i$f$expect = false;
                Result result = $this$expect$iv;
                if (!(result instanceof Ok)) {
                    if (result instanceof Err) {
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl = false;
                        String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                        throw new UnwrapException(string);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                IOSScreenRecording iosScreenRecording = (IOSScreenRecording)((Ok)$this$expect$iv).getValue();
                return new ScreenRecording(iosScreenRecording){
                    final /* synthetic */ IOSScreenRecording $iosScreenRecording;
                    {
                        this.$iosScreenRecording = $iosScreenRecording;
                    }

                    public void close() {
                        this.$iosScreenRecording.close();
                    }
                };
            }
        });
    }

    @Override
    public void inputText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"inputText")), (Function0)new Function0<Unit>(this, text){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$runDeviceCall(this.this$0, "inputText", (Function0)new Function0<Unit>(this.this$0, this.$text){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ String $text;
                    {
                        this.this$0 = $receiver;
                        this.$text = $text;
                        super(0);
                    }

                    public final void invoke() {
                        IOSDriver.access$getIosDevice$p(this.this$0).input(this.$text);
                    }
                });
            }
        });
    }

    @Override
    public void openLink(@NotNull String link, @Nullable String appId, boolean autoVerify, boolean browser) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"openLink"), TuplesKt.to((Object)"appId", (Object)String.valueOf(appId)), TuplesKt.to((Object)"autoVerify", (Object)String.valueOf(autoVerify)), TuplesKt.to((Object)"browser", (Object)String.valueOf(browser))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, link){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ String $link;
            {
                this.this$0 = $receiver;
                this.$link = $link;
                super(0);
            }

            public final void invoke() {
                Result $this$expect$iv = IOSDriver.access$getIosDevice$p(this.this$0).openLink(this.$link);
                boolean $i$f$expect = false;
                Result result = $this$expect$iv;
                if (!(result instanceof Ok)) {
                    if (result instanceof Err) {
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl = false;
                        String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                        throw new UnwrapException(string);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ((Ok)$this$expect$iv).getValue();
            }
        });
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"setLocation")), (Function0)new Function0<Unit>(this, latitude, longitude){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ double $latitude;
            final /* synthetic */ double $longitude;
            {
                this.this$0 = $receiver;
                this.$latitude = $latitude;
                this.$longitude = $longitude;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$runDeviceCall(this.this$0, "setLocation", (Function0)new Function0<Unit>(this.this$0, this.$latitude, this.$longitude){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ double $latitude;
                    final /* synthetic */ double $longitude;
                    {
                        this.this$0 = $receiver;
                        this.$latitude = $latitude;
                        this.$longitude = $longitude;
                        super(0);
                    }

                    public final void invoke() {
                        Result $this$expect$iv = IOSDriver.access$getIosDevice$p(this.this$0).setLocation(this.$latitude, this.$longitude);
                        boolean $i$f$expect = false;
                        Result result = $this$expect$iv;
                        if (!(result instanceof Ok)) {
                            if (result instanceof Err) {
                                StringBuilder stringBuilder = new StringBuilder();
                                boolean bl = false;
                                String string = stringBuilder.append(Unit.INSTANCE).append(' ').append(((Err)$this$expect$iv).getError()).toString();
                                throw new UnwrapException(string);
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        ((Ok)$this$expect$iv).getValue();
                    }
                });
            }
        });
    }

    @Override
    public void eraseText(int charactersToErase) {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"eraseText")), (Function0)new Function0<Unit>(this, charactersToErase){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ int $charactersToErase;
            {
                this.this$0 = $receiver;
                this.$charactersToErase = $charactersToErase;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$runDeviceCall(this.this$0, "eraseText", (Function0)new Function0<Unit>(this.this$0, this.$charactersToErase){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ int $charactersToErase;
                    {
                        this.this$0 = $receiver;
                        this.$charactersToErase = $charactersToErase;
                        super(0);
                    }

                    public final void invoke() {
                        IOSDriver.access$getIosDevice$p(this.this$0).eraseText(this.$charactersToErase);
                    }
                });
            }
        });
    }

    @Override
    public void setProxy(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"setProxy")), (Function0)new Function0<Unit>(host, port, this){
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$host = $host;
                this.$port = $port;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                XCRunnerCLIUtils.INSTANCE.setProxy(this.$host, this.$port);
                IOSDriver.access$setProxySet$p(this.this$0, true);
            }
        });
    }

    @Override
    public void resetProxy() {
        XCRunnerCLIUtils.INSTANCE.resetProxy();
    }

    @Override
    public boolean isShutdown() {
        return (Boolean)this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"isShutdown")), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return IOSDriver.access$getIosDevice$p(this.this$0).isShutdown();
            }
        });
    }

    @Override
    public boolean waitUntilScreenIsStatic(long timeoutMs) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"waitUntilScreenIsStatic"), TuplesKt.to((Object)"timeoutMs", (Object)String.valueOf(timeoutMs))};
        return (Boolean)this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Boolean>(timeoutMs, this){
            final /* synthetic */ long $timeoutMs;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$timeoutMs = $timeoutMs;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return MaestroTimer.retryUntilTrue$default((MaestroTimer)MaestroTimer.INSTANCE, (long)this.$timeoutMs, null, null, (Function0)((Function0)new Function0<Boolean>(this.this$0){
                    final /* synthetic */ IOSDriver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        boolean isScreenStatic2 = IOSDriver.access$isScreenStatic(this.this$0);
                        IOSDriver.access$getLOGGER$cp().info("screen static = " + isScreenStatic2);
                        return isScreenStatic2;
                    }
                }), (int)6, null);
            }
        });
    }

    @Override
    @Nullable
    public TreeNode waitForAppToSettle-5RpGHs4(@Nullable TreeNode initialHierarchy, @Nullable String appId, @Nullable Integer timeoutMs) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"waitForAppToSettle"), TuplesKt.to((Object)"appId", (Object)String.valueOf(appId)), TuplesKt.to((Object)"timeoutMs", (Object)String.valueOf(timeoutMs))};
        ViewHierarchy viewHierarchy = (ViewHierarchy)this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<ViewHierarchy>(this, initialHierarchy, timeoutMs){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ TreeNode $initialHierarchy;
            final /* synthetic */ Integer $timeoutMs;
            {
                this.this$0 = $receiver;
                this.$initialHierarchy = $initialHierarchy;
                this.$timeoutMs = $timeoutMs;
                super(0);
            }

            @Nullable
            public final TreeNode invoke-F9mIFpk() {
                IOSDriver.access$getLOGGER$cp().info("Waiting for animation to end with timeout 3000");
                boolean didFinishOnTime = this.this$0.waitUntilScreenIsStatic(3000L);
                return didFinishOnTime ? null : ScreenshotUtils.Companion.waitForAppToSettle-OpTFbEc(this.$initialHierarchy, this.this$0, this.$timeoutMs);
            }
        });
        return viewHierarchy != null ? viewHierarchy.unbox-impl() : null;
    }

    @Override
    @NotNull
    public List<Capability> capabilities() {
        return CollectionsKt.emptyList();
    }

    @Override
    public void setPermissions(@NotNull String appId, @NotNull Map<String, String> permissions) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"setPermissions"), TuplesKt.to((Object)"appId", (Object)appId)};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(this, appId, permissions){
            final /* synthetic */ IOSDriver this$0;
            final /* synthetic */ String $appId;
            final /* synthetic */ Map<String, String> $permissions;
            {
                this.this$0 = $receiver;
                this.$appId = $appId;
                this.$permissions = $permissions;
                super(0);
            }

            public final void invoke() {
                IOSDriver.access$runDeviceCall(this.this$0, "setPermissions", (Function0)new Function0<Unit>(this.this$0, this.$appId, this.$permissions){
                    final /* synthetic */ IOSDriver this$0;
                    final /* synthetic */ String $appId;
                    final /* synthetic */ Map<String, String> $permissions;
                    {
                        this.this$0 = $receiver;
                        this.$appId = $appId;
                        this.$permissions = $permissions;
                        super(0);
                    }

                    public final void invoke() {
                        IOSDriver.access$getIosDevice$p(this.this$0).setPermissions(this.$appId, this.$permissions);
                    }
                });
            }
        });
    }

    @Override
    public void addMedia(@NotNull List<? extends File> mediaFiles) {
        Intrinsics.checkNotNullParameter(mediaFiles, (String)"mediaFiles");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"addMedia"), TuplesKt.to((Object)"mediaFilesCount", (Object)String.valueOf(mediaFiles.size()))};
        this.metrics.measured("operation", MapsKt.mapOf((Pair[])pairArray), (Function0)new Function0<Unit>(mediaFiles, this){
            final /* synthetic */ List<File> $mediaFiles;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$mediaFiles = $mediaFiles;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                IOSDriver.access$getLOGGER$cp().info("[Start] Adding media files");
                Iterable iterable = this.$mediaFiles;
                IOSDriver iOSDriver = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    IOSDriver.access$addMediaToDevice(iOSDriver, it);
                }
                IOSDriver.access$getLOGGER$cp().info("[Done] Adding media files");
            }
        });
    }

    @Override
    public boolean isAirplaneModeEnabled() {
        LOGGER.warn("Airplane mode is not available on iOS simulators");
        return false;
    }

    @Override
    public void setAirplaneMode(boolean enabled2) {
        LOGGER.warn("Airplane mode is not available on iOS simulators");
    }

    private final void addMediaToDevice(File mediaFile) {
        this.metrics.measured("operation", MapsKt.mapOf((Pair)TuplesKt.to((Object)"command", (Object)"addMediaToDevice")), (Function0)new Function0<Unit>(mediaFile, this){
            final /* synthetic */ File $mediaFile;
            final /* synthetic */ IOSDriver this$0;
            {
                this.$mediaFile = $mediaFile;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MediaExt mediaExt;
                NamedSource namedSource;
                block2: {
                    String string = this.$mediaFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mediaFile.name");
                    Source source = Okio.source((File)this.$mediaFile);
                    String string2 = FilesKt.getExtension((File)this.$mediaFile);
                    String string3 = this.$mediaFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mediaFile.path");
                    namedSource = new NamedSource(string, source, string2, string3);
                    MediaExt[] $this$firstOrNull$iv = MediaExt.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        MediaExt element$iv;
                        MediaExt mediaExt2 = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)mediaExt2.getExtName(), (Object)namedSource.getExtension())) continue;
                        mediaExt = element$iv;
                        break block2;
                    }
                    mediaExt = null;
                }
                if (mediaExt == null) {
                    throw new IllegalArgumentException("Extension ." + namedSource.getExtension() + " is not yet supported for add media");
                }
                IOSDriver.access$getIosDevice$p(this.this$0).addMedia(namedSource.getPath());
            }
        });
    }

    private final boolean isScreenStatic() {
        return (Boolean)this.runDeviceCall("isScreenStatic", (Function0)new Function0<Boolean>(this){
            final /* synthetic */ IOSDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return IOSDriver.access$getIosDevice$p(this.this$0).isScreenStatic();
            }
        });
    }

    private final <T> T runDeviceCall(String callName, Function0<? extends T> call) {
        Object object;
        try {
            object = call.invoke();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            LOGGER.error("Got socket timeout processing " + callName + " command", (Throwable)socketTimeoutException);
            throw socketTimeoutException;
        }
        catch (XCUITestServerError.BadRequest badRequest) {
            LOGGER.error("Bad request for " + callName + ", reason: " + badRequest.getErrorResponse());
            String string = badRequest.getError().getErrorMessage();
            throw new MaestroException.UnableToProcessCommand(string, callName);
        }
        catch (IOSDeviceErrors.AppCrash appCrashException) {
            throw new MaestroException.AppCrash(appCrashException.getErrorMessage());
        }
        return (T)object;
    }

    public static final /* synthetic */ IOSDevice access$getIosDevice$p(IOSDriver $this) {
        return $this.iosDevice;
    }

    public static final /* synthetic */ boolean access$getProxySet$p(IOSDriver $this) {
        return $this.proxySet;
    }

    public static final /* synthetic */ void access$setAppId$p(IOSDriver $this, String string) {
        $this.appId = string;
    }

    public static final /* synthetic */ Object access$runDeviceCall(IOSDriver $this, String callName, Function0 call) {
        return $this.runDeviceCall(callName, call);
    }

    public static final /* synthetic */ TreeNode access$viewHierarchy(IOSDriver $this, boolean excludeKeyboardElements) {
        return $this.viewHierarchy(excludeKeyboardElements);
    }

    public static final /* synthetic */ void access$dismissKeyboardIntroduction(IOSDriver $this, int heightPoints) {
        $this.dismissKeyboardIntroduction(heightPoints);
    }

    public static final /* synthetic */ boolean access$isKeyboardHidden(IOSDriver $this) {
        return $this.isKeyboardHidden();
    }

    public static final /* synthetic */ void access$setProxySet$p(IOSDriver $this, boolean bl) {
        $this.proxySet = bl;
    }

    public static final /* synthetic */ boolean access$isScreenStatic(IOSDriver $this) {
        return $this.isScreenStatic();
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ void access$addMediaToDevice(IOSDriver $this, File mediaFile) {
        $this.addMediaToDevice(mediaFile);
    }

    static {
        Object[] objectArray = new Integer[]{12, 40, 41};
        CHECKABLE_ELEMENTS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmaestro/drivers/IOSDriver$Companion;", "", "()V", "CHECKABLE_ELEMENTS", "", "", "ELEMENT_TYPE_CHECKBOX", "ELEMENT_TYPE_SWITCH", "ELEMENT_TYPE_TOGGLE", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "NAME", "", "SCREEN_SETTLE_TIMEOUT_MS", "", "WARNING_MAX_DEPTH", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

