/*
 * Decompiled with CFR 0.152.
 */
package maestro.mockserver;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import maestro.mockserver.Auth;
import maestro.mockserver.GetEventsResponse;
import maestro.mockserver.MockEvent;
import maestro.mockserver.MockInteractor;
import maestro.utils.HttpClient;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmaestro/mockserver/MockInteractor;", "", "()V", "client", "Lokhttp3/OkHttpClient;", "getCachedAuthToken", "", "getMockEvents", "", "Lmaestro/mockserver/MockEvent;", "getProjectId", "Ljava/util/UUID;", "Companion", "maestro-client"})
public final class MockInteractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client = HttpClient.build-OPOXi9g$default((HttpClient)HttpClient.INSTANCE, (String)"MockInteractor", (long)0L, (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES), null, null, (List)CollectionsKt.listOf((Object)Protocol.HTTP_1_1), null, (int)178, null);
    @NotNull
    private static final Lazy<String> API_URL$delegate = LazyKt.lazy((Function0)Companion.API_URL.2.INSTANCE);
    @NotNull
    private static final Lazy<Path> cachedAuthTokenFile$delegate = LazyKt.lazy((Function0)Companion.cachedAuthTokenFile.2.INSTANCE);
    private static final ObjectMapper JSON = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Nullable
    public final String getCachedAuthToken() {
        Object object = System.getProperty("MAESTRO_CLOUD_API_KEY");
        if (!(object == null || object.length() == 0)) {
            return System.getProperty("MAESTRO_CLOUD_API_KEY");
        }
        Path path = MockInteractor.Companion.getCachedAuthTokenFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cachedAuthTokenFile");
        object = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path path2 = MockInteractor.Companion.getCachedAuthTokenFile();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"cachedAuthTokenFile");
        object = path2;
        linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path path3 = MockInteractor.Companion.getCachedAuthTokenFile();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"cachedAuthTokenFile");
        return PathsKt.readText$default((Path)path3, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final UUID getProjectId() {
        Request request;
        String string = this.getCachedAuthToken();
        if (string == null) {
            return null;
        }
        String authToken = string;
        try {
            request = new Request.Builder().get().header("Authorization", "Bearer " + authToken).url(MockInteractor.Companion.getAPI_URL() + "/auth").build();
        }
        catch (IllegalArgumentException e) {
            String string2 = e.getMessage();
            boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Unexpected char", (boolean)false, (int)2, null) : false;
            if (bl) {
                return null;
            }
            throw e;
        }
        Request request2 = request;
        Response response = this.client.newCall(request2).execute();
        if (response.code() >= 400) {
            throw new IllegalStateException("Invalid token. Please run `maestro logout` and then `maestro login` to retrieve a valid token.".toString());
        }
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            try {
                ResponseBody responseBody = response.body();
                Auth auth = (Auth)JSON.readValue((byte[])(responseBody != null ? responseBody.bytes() : null), Auth.class);
                UUID uUID = auth.getTeamId();
                return uUID;
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException(("Could not retrieve project id: " + e.getMessage()).toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<MockEvent> getMockEvents() {
        String authToken = this.getCachedAuthToken();
        Request request = new Request.Builder().get().header("Authorization", "Bearer " + authToken).url(MockInteractor.Companion.getAPI_URL() + "/mms-events").build();
        Request request2 = request;
        Response response = this.client.newCall(request2).execute();
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            try {
                ResponseBody responseBody = response.body();
                GetEventsResponse response2 = (GetEventsResponse)JSON.readValue((byte[])(responseBody != null ? responseBody.bytes() : null), GetEventsResponse.class);
                List<MockEvent> list = response2.getEvents();
                return list;
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException(("Could not retrieve mock events: " + e.getMessage()).toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lmaestro/mockserver/MockInteractor$Companion;", "", "()V", "API_URL", "", "kotlin.jvm.PlatformType", "getAPI_URL", "()Ljava/lang/String;", "API_URL$delegate", "Lkotlin/Lazy;", "JSON", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "cachedAuthTokenFile", "Ljava/nio/file/Path;", "getCachedAuthTokenFile", "()Ljava/nio/file/Path;", "cachedAuthTokenFile$delegate", "maestro-client"})
    public static final class Companion {
        private Companion() {
        }

        private final String getAPI_URL() {
            Lazy lazy = API_URL$delegate;
            return (String)lazy.getValue();
        }

        private final Path getCachedAuthTokenFile() {
            Lazy lazy = cachedAuthTokenFile$delegate;
            return (Path)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

