/*
 * Decompiled with CFR 0.152.
 */
package maestro.utils;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmaestro/utils/BlockingStreamObserver;", "T", "Lio/grpc/stub/StreamObserver;", "()V", "error", "", "result", "Ljava/lang/Object;", "semaphore", "Ljava/util/concurrent/Semaphore;", "awaitResult", "()Ljava/lang/Object;", "onCompleted", "", "onError", "t", "onNext", "value", "(Ljava/lang/Object;)V", "maestro-client"})
@SourceDebugExtension(value={"SMAP\nBlockingStreamObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockingStreamObserver.kt\nmaestro/utils/BlockingStreamObserver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class BlockingStreamObserver<T>
implements StreamObserver<T> {
    @NotNull
    private final Semaphore semaphore = new Semaphore(0);
    @Nullable
    private T result;
    @Nullable
    private Throwable error;

    public void onNext(T value) {
        this.result = value;
    }

    public void onError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.error = t;
        this.semaphore.release();
    }

    public void onCompleted() {
        this.semaphore.release();
    }

    public final T awaitResult() {
        if (!this.semaphore.tryAcquire(10L, TimeUnit.MINUTES)) {
            throw new TimeoutException("Timeout waiting for Stream to pass Error or Completed message");
        }
        Throwable throwable = this.error;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
        T t = this.result;
        if (t == null) {
            throw new IllegalStateException("Result is missing");
        }
        return t;
    }
}

