/*
 * Decompiled with CFR 0.152.
 */
package maestro.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import maestro.Platform;
import maestro.utils.LocaleValidationAndroidCountryException;
import maestro.utils.LocaleValidationAndroidLanguageException;
import maestro.utils.LocaleValidationIosException;
import maestro.utils.LocaleValidationNotSupportedPlatformException;
import maestro.utils.LocaleValidationWrongLocaleFormatException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0016"}, d2={"Lmaestro/utils/LocaleUtils;", "", "()V", "ANDROID_SUPPORTED_COUNTRIES", "", "Lkotlin/Pair;", "", "getANDROID_SUPPORTED_COUNTRIES", "()Ljava/util/List;", "ANDROID_SUPPORTED_LANGUAGES", "getANDROID_SUPPORTED_LANGUAGES", "IOS_SUPPORTED_LOCALES", "getIOS_SUPPORTED_LOCALES", "findIOSLocale", "language", "country", "parseLocaleParams", "deviceLocale", "platform", "Lmaestro/Platform;", "validateLocale", "", "maestro-client"})
@SourceDebugExtension(value={"SMAP\nLocaleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocaleUtils.kt\nmaestro/utils/LocaleUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1549#2:218\n1620#2,3:219\n1549#2:222\n1620#2,3:223\n*S KotlinDebug\n*F\n+ 1 LocaleUtils.kt\nmaestro/utils/LocaleUtils\n*L\n206#1:218\n206#1:219,3\n210#1:222\n210#1:223,3\n*E\n"})
public final class LocaleUtils {
    @NotNull
    public static final LocaleUtils INSTANCE = new LocaleUtils();
    @NotNull
    private static final List<Pair<String, String>> ANDROID_SUPPORTED_LANGUAGES;
    @NotNull
    private static final List<Pair<String, String>> ANDROID_SUPPORTED_COUNTRIES;
    @NotNull
    private static final List<Pair<String, String>> IOS_SUPPORTED_LOCALES;

    private LocaleUtils() {
    }

    @NotNull
    public final List<Pair<String, String>> getANDROID_SUPPORTED_LANGUAGES() {
        return ANDROID_SUPPORTED_LANGUAGES;
    }

    @NotNull
    public final List<Pair<String, String>> getANDROID_SUPPORTED_COUNTRIES() {
        return ANDROID_SUPPORTED_COUNTRIES;
    }

    @NotNull
    public final List<Pair<String, String>> getIOS_SUPPORTED_LOCALES() {
        return IOS_SUPPORTED_LOCALES;
    }

    @Nullable
    public final String findIOSLocale(@NotNull String language, @NotNull String country) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        Regex searchedPair = new Regex(language + "[_-]" + country);
        for (Pair<String, String> pair : IOS_SUPPORTED_LOCALES) {
            if (!searchedPair.matches((CharSequence)pair.getFirst())) continue;
            return (String)pair.getFirst();
        }
        return null;
    }

    @NotNull
    public final Pair<String, String> parseLocaleParams(@NotNull String deviceLocale, @NotNull Platform platform) {
        Object language;
        Intrinsics.checkNotNullParameter((Object)deviceLocale, (String)"deviceLocale");
        Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
        String[] stringArray = new String[]{"_"};
        List parts = StringsKt.split$default((CharSequence)deviceLocale, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 2) {
            language = (String[])parts.get(0);
            String country = (String)parts.get(1);
            this.validateLocale((String)language, country, platform);
            return new Pair(language, (Object)country);
        }
        language = new String[]{"-"};
        parts = StringsKt.split$default((CharSequence)deviceLocale, (String[])language, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 2) {
            language = (String)parts.get(0);
            String country = (String)parts.get(1);
            this.validateLocale((String)language, country, platform);
            return new Pair(language, (Object)country);
        }
        throw new LocaleValidationWrongLocaleFormatException();
    }

    private final void validateLocale(String language, String country, Platform platform) {
        switch (WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
            case 1: {
                if (this.findIOSLocale(language, country) != null) break;
                throw new LocaleValidationIosException();
            }
            case 2: {
                Pair it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = ANDROID_SUPPORTED_LANGUAGES;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getFirst());
                }
                if (!((List)destination$iv$iv).contains(language)) {
                    throw new LocaleValidationAndroidLanguageException(language);
                }
                $this$map$iv = ANDROID_SUPPORTED_COUNTRIES;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getFirst());
                }
                if (((List)destination$iv$iv).contains(country)) break;
                throw new LocaleValidationAndroidCountryException(country);
            }
            default: {
                throw new LocaleValidationNotSupportedPlatformException();
            }
        }
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"ar", (Object)"Arabic"), TuplesKt.to((Object)"bg", (Object)"Bulgarian"), TuplesKt.to((Object)"ca", (Object)"Catalan"), TuplesKt.to((Object)"zh", (Object)"Chinese"), TuplesKt.to((Object)"hr", (Object)"Croatian"), TuplesKt.to((Object)"cs", (Object)"Czech"), TuplesKt.to((Object)"da", (Object)"Danish"), TuplesKt.to((Object)"nl", (Object)"Dutch"), TuplesKt.to((Object)"en", (Object)"English"), TuplesKt.to((Object)"fi", (Object)"Finnish"), TuplesKt.to((Object)"fr", (Object)"French"), TuplesKt.to((Object)"de", (Object)"German"), TuplesKt.to((Object)"el", (Object)"Greek"), TuplesKt.to((Object)"he", (Object)"Hebrew"), TuplesKt.to((Object)"hi", (Object)"Hindi"), TuplesKt.to((Object)"hu", (Object)"Hungarian"), TuplesKt.to((Object)"id", (Object)"Indonesian"), TuplesKt.to((Object)"it", (Object)"Italian"), TuplesKt.to((Object)"ja", (Object)"Japanese"), TuplesKt.to((Object)"ko", (Object)"Korean"), TuplesKt.to((Object)"lv", (Object)"Latvian"), TuplesKt.to((Object)"lt", (Object)"Lithuanian"), TuplesKt.to((Object)"nb", (Object)"Norwegian-Bokmol"), TuplesKt.to((Object)"pl", (Object)"Polish"), TuplesKt.to((Object)"pt", (Object)"Portuguese"), TuplesKt.to((Object)"ro", (Object)"Romanian"), TuplesKt.to((Object)"ru", (Object)"Russian"), TuplesKt.to((Object)"sr", (Object)"Serbian"), TuplesKt.to((Object)"sk", (Object)"Slovak"), TuplesKt.to((Object)"sl", (Object)"Slovenian"), TuplesKt.to((Object)"es", (Object)"Spanish"), TuplesKt.to((Object)"sv", (Object)"Swedish"), TuplesKt.to((Object)"tl", (Object)"Tagalog"), TuplesKt.to((Object)"th", (Object)"Thai"), TuplesKt.to((Object)"tr", (Object)"Turkish"), TuplesKt.to((Object)"uk", (Object)"Ukrainian"), TuplesKt.to((Object)"vi", (Object)"Vietnamese")};
        ANDROID_SUPPORTED_LANGUAGES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"AU", (Object)"Australia"), TuplesKt.to((Object)"AT", (Object)"Austria"), TuplesKt.to((Object)"BE", (Object)"Belgium"), TuplesKt.to((Object)"BR", (Object)"Brazil"), TuplesKt.to((Object)"GB", (Object)"Britain"), TuplesKt.to((Object)"BG", (Object)"Bulgaria"), TuplesKt.to((Object)"CA", (Object)"Canada"), TuplesKt.to((Object)"HR", (Object)"Croatia"), TuplesKt.to((Object)"CZ", (Object)"Czech Republic"), TuplesKt.to((Object)"DK", (Object)"Denmark"), TuplesKt.to((Object)"EG", (Object)"Egypt"), TuplesKt.to((Object)"FI", (Object)"Finland"), TuplesKt.to((Object)"FR", (Object)"France"), TuplesKt.to((Object)"DE", (Object)"Germany"), TuplesKt.to((Object)"GR", (Object)"Greece"), TuplesKt.to((Object)"HK", (Object)"Hong-Kong"), TuplesKt.to((Object)"HU", (Object)"Hungary"), TuplesKt.to((Object)"IN", (Object)"India"), TuplesKt.to((Object)"ID", (Object)"Indonesia"), TuplesKt.to((Object)"IE", (Object)"Ireland"), TuplesKt.to((Object)"IL", (Object)"Israel"), TuplesKt.to((Object)"IT", (Object)"Italy"), TuplesKt.to((Object)"JP", (Object)"Japan"), TuplesKt.to((Object)"KR", (Object)"Korea"), TuplesKt.to((Object)"LV", (Object)"Latvia"), TuplesKt.to((Object)"LI", (Object)"Liechtenstein"), TuplesKt.to((Object)"LT", (Object)"Lithuania"), TuplesKt.to((Object)"ES", (Object)"Mexico"), TuplesKt.to((Object)"NL", (Object)"Netherlands"), TuplesKt.to((Object)"NZ", (Object)"New Zealand"), TuplesKt.to((Object)"NO", (Object)"Norway"), TuplesKt.to((Object)"PH", (Object)"Philippines"), TuplesKt.to((Object)"PL", (Object)"Poland"), TuplesKt.to((Object)"PT", (Object)"Portugal"), TuplesKt.to((Object)"CN", (Object)"PRC"), TuplesKt.to((Object)"RO", (Object)"Romania"), TuplesKt.to((Object)"RU", (Object)"Russia"), TuplesKt.to((Object)"RS", (Object)"Serbia"), TuplesKt.to((Object)"SG", (Object)"Singapore"), TuplesKt.to((Object)"SK", (Object)"Slovakia"), TuplesKt.to((Object)"SI", (Object)"Slovenia"), TuplesKt.to((Object)"ES", (Object)"Spain"), TuplesKt.to((Object)"SE", (Object)"Sweden"), TuplesKt.to((Object)"CH", (Object)"Switzerland"), TuplesKt.to((Object)"TW", (Object)"Taiwan"), TuplesKt.to((Object)"TH", (Object)"Thailand"), TuplesKt.to((Object)"TR", (Object)"Turkey"), TuplesKt.to((Object)"UA", (Object)"Ukraine"), TuplesKt.to((Object)"US", (Object)"US"), TuplesKt.to((Object)"US", (Object)"USA"), TuplesKt.to((Object)"VN", (Object)"Vietnam"), TuplesKt.to((Object)"ZA", (Object)"Zimbabwe")};
        ANDROID_SUPPORTED_COUNTRIES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"en_AU", (Object)"Australia"), TuplesKt.to((Object)"nl_BE", (Object)"Belgium (Dutch)"), TuplesKt.to((Object)"fr_BE", (Object)"Belgium (French)"), TuplesKt.to((Object)"ms_BN", (Object)"Brunei Darussalam"), TuplesKt.to((Object)"en_CA", (Object)"Canada (English)"), TuplesKt.to((Object)"fr_CA", (Object)"Canada (French)"), TuplesKt.to((Object)"cs_CZ", (Object)"Czech Republic"), TuplesKt.to((Object)"fi_FI", (Object)"Finland"), TuplesKt.to((Object)"de_DE", (Object)"Germany"), TuplesKt.to((Object)"el_GR", (Object)"Greece"), TuplesKt.to((Object)"hu_HU", (Object)"Hungary"), TuplesKt.to((Object)"hi_IN", (Object)"India"), TuplesKt.to((Object)"id_ID", (Object)"Indonesia"), TuplesKt.to((Object)"he_IL", (Object)"Israel"), TuplesKt.to((Object)"it_IT", (Object)"Italy"), TuplesKt.to((Object)"ja_JP", (Object)"Japan"), TuplesKt.to((Object)"ms_MY", (Object)"Malaysia"), TuplesKt.to((Object)"nl_NL", (Object)"Netherlands"), TuplesKt.to((Object)"en_NZ", (Object)"New Zealand"), TuplesKt.to((Object)"nb_NO", (Object)"Norway"), TuplesKt.to((Object)"tl_PH", (Object)"Philippines"), TuplesKt.to((Object)"pl_PL", (Object)"Poland"), TuplesKt.to((Object)"zh_CN", (Object)"PRC"), TuplesKt.to((Object)"ro_RO", (Object)"Romania"), TuplesKt.to((Object)"ru_RU", (Object)"Russia"), TuplesKt.to((Object)"en_SG", (Object)"Singapore"), TuplesKt.to((Object)"sk_SK", (Object)"Slovakia"), TuplesKt.to((Object)"ko_KR", (Object)"Korea"), TuplesKt.to((Object)"sv_SE", (Object)"Sweden"), TuplesKt.to((Object)"zh_TW", (Object)"Taiwan"), TuplesKt.to((Object)"th_TH", (Object)"Thailand"), TuplesKt.to((Object)"tr_TR", (Object)"Turkey"), TuplesKt.to((Object)"en_GB", (Object)"UK"), TuplesKt.to((Object)"uk_UA", (Object)"Ukraine"), TuplesKt.to((Object)"es_US", (Object)"USA (Spanish)"), TuplesKt.to((Object)"en_US", (Object)"USA (English)"), TuplesKt.to((Object)"vi_VN", (Object)"Vietnam"), TuplesKt.to((Object)"pt-BR", (Object)"Brazil"), TuplesKt.to((Object)"zh-Hans", (Object)"China (Simplified)"), TuplesKt.to((Object)"zh-Hant", (Object)"China (Traditional)"), TuplesKt.to((Object)"zh-HK", (Object)"Hong Kong"), TuplesKt.to((Object)"en-IN", (Object)"India (English)"), TuplesKt.to((Object)"en-IE", (Object)"Ireland"), TuplesKt.to((Object)"es-419", (Object)"Latin America"), TuplesKt.to((Object)"es-MX", (Object)"Mexico"), TuplesKt.to((Object)"en-ZA", (Object)"South Africa"), TuplesKt.to((Object)"es_ES", (Object)"Spain"), TuplesKt.to((Object)"fr_FR", (Object)"France")};
        IOS_SUPPORTED_LOCALES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.IOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.ANDROID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

