/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lutil/CommandLineUtils;", "", "()V", "isWindows", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "nullFile", "Ljava/io/File;", "runCommand", "Ljava/lang/Process;", "parts", "", "", "waitForCompletion", "outputFile", "params", "", "maestro-ios-driver"})
@SourceDebugExtension(value={"SMAP\nCommandLineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLineUtils.kt\nutil/CommandLineUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,54:1\n37#2,2:55\n37#2,2:57\n*S KotlinDebug\n*F\n+ 1 CommandLineUtils.kt\nutil/CommandLineUtils\n*L\n21#1:55,2\n25#1:57,2\n*E\n"})
public final class CommandLineUtils {
    @NotNull
    public static final CommandLineUtils INSTANCE = new CommandLineUtils();
    private static final boolean isWindows;
    @NotNull
    private static final File nullFile;
    private static final Logger logger;

    private CommandLineUtils() {
    }

    @NotNull
    public final Process runCommand(@NotNull List<String> parts, boolean waitForCompletion, @Nullable File outputFile, @NotNull Map<String, String> params) {
        ProcessBuilder processBuilder;
        String[] stringArray;
        Collection thisCollection$iv;
        boolean $i$f$toTypedArray;
        Collection $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        logger.info("Running command line operation: " + parts);
        if (outputFile != null) {
            $this$toTypedArray$iv = parts;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            processBuilder = new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length)).redirectOutput(outputFile).redirectError(ProcessBuilder.Redirect.PIPE);
        } else {
            $this$toTypedArray$iv = parts;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            processBuilder = new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length)).redirectOutput(nullFile).redirectError(nullFile);
        }
        ProcessBuilder processBuilder2 = processBuilder;
        processBuilder2.environment().putAll(params);
        Process process = processBuilder2.start();
        if (waitForCompletion) {
            if (!process.waitFor(5L, TimeUnit.MINUTES)) {
                throw new TimeoutException();
            }
            if (process.exitValue() != 0) {
                InputStream inputStream = process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
                String processOutput = Okio.buffer((Source)Okio.source((InputStream)inputStream)).readUtf8();
                logger.error("Process failed with exit code " + process.exitValue());
                logger.error(processOutput);
                throw new IllegalStateException(processOutput);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
        return process;
    }

    public static /* synthetic */ Process runCommand$default(CommandLineUtils commandLineUtils, List list, boolean bl, File file, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        return commandLineUtils.runCommand(list, bl, file, map);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        isWindows = StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null);
        nullFile = new File(isWindows ? "NUL" : "/dev/null");
        logger = LoggerFactory.getLogger(CommandLineUtils.class);
    }
}

