/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import maestro.utils.MaestroTimer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.CommandLineUtils;
import util.LocalSimulatorUtils;
import util.SimctlList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002MNB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0016\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*J\u0016\u0010(\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u001eJ\u0018\u0010+\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J0\u0010,\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u000e\b\u0002\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010.\u001a\u0004\u0018\u00010\u0005J\u000e\u0010/\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005J\u000e\u00104\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0018\u00105\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0016\u00106\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0005J\u0016\u00108\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005J\u001e\u0010:\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<J \u0010>\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u0005H\u0002J*\u0010@\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050BJ,\u0010C\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050BH\u0002J\u000e\u0010D\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020F2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020FJ\u0016\u0010I\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0010\u0010J\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u0005H\u0002J\u0016\u0010K\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010L\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lutil/LocalSimulatorUtils;", "", "()V", "allPermissions", "", "", "homedir", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "simctlPermissions", "addMedia", "", "deviceId", "path", "addTrustedCertificate", "certificate", "Ljava/io/File;", "allowValueForPermission", "permission", "awaitLaunch", "awaitShutdown", "timeoutMs", "", "bootSimulator", "clearAppState", "bundleId", "clearKeychain", "copyDirectoryRecursively", "source", "Ljava/nio/file/Path;", "target", "deleteFolderRecursively", "", "folder", "denyValueForPermission", "ensureRunning", "ensureStopped", "getAppBinaryDirectory", "getApplicationDataDirectory", "install", "stream", "Ljava/io/InputStream;", "isAppRunning", "launch", "launchArguments", "sessionId", "launchSimulator", "list", "Lutil/SimctlList;", "openURL", "url", "reboot", "reinstallApp", "setDeviceLanguage", "language", "setDeviceLocale", "locale", "setLocation", "latitude", "", "longitude", "setLocationPermission", "value", "setPermissions", "permissions", "", "setSimctlPermissions", "shutdownSimulator", "startScreenRecording", "Lutil/LocalSimulatorUtils$ScreenRecording;", "stopScreenRecording", "screenRecording", "terminate", "translatePermissionValue", "uninstall", "xcodePath", "ScreenRecording", "SimctlError", "maestro-ios-driver"})
@SourceDebugExtension(value={"SMAP\nLocalSimulatorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalSimulatorUtils.kt\nutil/LocalSimulatorUtils\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,693:1\n56#2:694\n49#2:695\n1#3:696\n13309#4,2:697\n1855#5,2:699\n1271#5,2:712\n1285#5,4:714\n526#6:701\n511#6,6:702\n125#7:708\n152#7,3:709\n215#7,2:718\n*S KotlinDebug\n*F\n+ 1 LocalSimulatorUtils.kt\nutil/LocalSimulatorUtils\n*L\n52#1:694\n52#1:695\n232#1:697,2\n423#1:699,2\n473#1:712,2\n473#1:714,4\n434#1:701\n434#1:702,6\n435#1:708\n435#1:709,3\n488#1:718,2\n*E\n"})
public final class LocalSimulatorUtils {
    @NotNull
    public static final LocalSimulatorUtils INSTANCE = new LocalSimulatorUtils();
    private static final String homedir = System.getProperty("user.home");
    private static final Logger logger = LoggerFactory.getLogger(LocalSimulatorUtils.class);
    @NotNull
    private static final List<String> allPermissions;
    @NotNull
    private static final List<String> simctlPermissions;

    private LocalSimulatorUtils() {
    }

    @NotNull
    public final SimctlList list() {
        Object[] objectArray = new String[]{"xcrun", "simctl", "list", "-j"};
        List command = CollectionsKt.listOf((Object[])objectArray);
        Process process = new ProcessBuilder(command).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        String json = new String(byArray, Charsets.UTF_8);
        ObjectMapper $this$readValue$iv = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (SimctlList)$this$readValue$iv.readValue(json, (TypeReference)new TypeReference<SimctlList>(){});
    }

    public final void awaitLaunch(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Boolean bl = (Boolean)MaestroTimer.INSTANCE.withTimeout(60000L, (Function0)new Function0<Boolean>(deviceId){
            final /* synthetic */ String $deviceId;
            {
                this.$deviceId = $deviceId;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                Object v0;
                block1: {
                    Iterable iterable = CollectionsKt.flatten((Iterable)LocalSimulatorUtils.INSTANCE.list().getDevices().values());
                    String string = this.$deviceId;
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        SimctlList.Device it = (SimctlList.Device)t;
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.getUdid(), (String)string, (boolean)true)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                SimctlList.Device device = v0;
                return Intrinsics.areEqual((Object)(device != null ? device.getState() : null), (Object)"Booted") ? Boolean.valueOf(true) : null;
            }
        });
        if (bl == null) {
            throw new SimctlError("Device " + deviceId + " did not boot in time");
        }
        bl.booleanValue();
    }

    public final void awaitShutdown(@NotNull String deviceId, long timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Boolean bl = (Boolean)MaestroTimer.INSTANCE.withTimeout(timeoutMs, (Function0)new Function0<Boolean>(deviceId){
            final /* synthetic */ String $deviceId;
            {
                this.$deviceId = $deviceId;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                Object v0;
                block1: {
                    Iterable iterable = CollectionsKt.flatten((Iterable)LocalSimulatorUtils.INSTANCE.list().getDevices().values());
                    String string = this.$deviceId;
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        SimctlList.Device it = (SimctlList.Device)t;
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.getUdid(), (String)string, (boolean)true)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                SimctlList.Device device = v0;
                return Intrinsics.areEqual((Object)(device != null ? device.getState() : null), (Object)"Shutdown") ? Boolean.valueOf(true) : null;
            }
        });
        if (bl == null) {
            throw new SimctlError("Device " + deviceId + " did not shutdown in time");
        }
        bl.booleanValue();
    }

    public static /* synthetic */ void awaitShutdown$default(LocalSimulatorUtils localSimulatorUtils, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 60000L;
        }
        localSimulatorUtils.awaitShutdown(string, l);
    }

    private final String xcodePath() {
        Object[] objectArray = new String[]{"xcode-select", "-p"};
        Process process = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        String string = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.inputStream.bufferedReader().readLine()");
        return string;
    }

    public final void bootSimulator(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Object[] objectArray = new String[]{"xcrun", "simctl", "boot", deviceId};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), true, null, null, 12, null);
        this.awaitLaunch(deviceId);
    }

    public final void shutdownSimulator(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Object[] objectArray = new String[]{"xcrun", "simctl", "shutdown", deviceId};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), true, null, null, 12, null);
        LocalSimulatorUtils.awaitShutdown$default(this, deviceId, 0L, 2, null);
    }

    public final void launchSimulator(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        String simulatorPath = this.xcodePath() + "/Applications/Simulator.app";
        Exception exceptionToThrow = null;
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            try {
                Object[] objectArray = new String[]{"open", "-a", simulatorPath, "--args", "-CurrentDeviceUDID", deviceId};
                CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
                return;
            }
            catch (Exception e) {
                exceptionToThrow = e;
                Thread.sleep(100L);
            }
        }
        Exception exception = exceptionToThrow;
        if (exception != null) {
            Exception it = exception;
            boolean bl = false;
            throw it;
        }
    }

    public final void reboot(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        this.shutdownSimulator(deviceId);
        this.bootSimulator(deviceId);
    }

    public final void addTrustedCertificate(@NotNull String deviceId, @NotNull File certificate) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Object[] objectArray = new String[]{"xcrun", "simctl", "keychain", deviceId, "add-root-cert", certificate.getAbsolutePath()};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), true, null, null, 12, null);
        this.reboot(deviceId);
    }

    public final void terminate(@NotNull String deviceId, @NotNull String bundleId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        Object[] objectArray = new String[]{"xcrun", "simctl", "terminate", deviceId, bundleId};
        new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).start().waitFor();
    }

    private final boolean isAppRunning(String deviceId, String bundleId) {
        Object[] objectArray = new String[]{"xcrun", "simctl", "spawn", deviceId, "launchctl", "list"};
        Process process = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        objectArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        return StringsKt.contains$default((CharSequence)((Object)StringsKt.trimEnd((CharSequence)new String((byte[])objectArray, Charsets.UTF_8))).toString(), (CharSequence)bundleId, (boolean)false, (int)2, null);
    }

    private final void ensureStopped(String deviceId, String bundleId) {
        if ((Unit)MaestroTimer.INSTANCE.withTimeout(10000L, (Function0)new Function0<Unit>(deviceId, bundleId){
            final /* synthetic */ String $deviceId;
            final /* synthetic */ String $bundleId;
            {
                this.$deviceId = $deviceId;
                this.$bundleId = $bundleId;
                super(0);
            }

            public final void invoke() {
                while (LocalSimulatorUtils.access$isAppRunning(LocalSimulatorUtils.INSTANCE, this.$deviceId, this.$bundleId)) {
                    Thread.sleep(1000L);
                }
            }
        }) == null) {
            throw new SimctlError("App " + bundleId + " did not stop in time");
        }
    }

    private final void ensureRunning(String deviceId, String bundleId) {
        if ((Unit)MaestroTimer.INSTANCE.withTimeout(10000L, (Function0)new Function0<Unit>(deviceId, bundleId){
            final /* synthetic */ String $deviceId;
            final /* synthetic */ String $bundleId;
            {
                this.$deviceId = $deviceId;
                this.$bundleId = $bundleId;
                super(0);
            }

            public final void invoke() {
                while (!LocalSimulatorUtils.access$isAppRunning(LocalSimulatorUtils.INSTANCE, this.$deviceId, this.$bundleId)) {
                    Thread.sleep(1000L);
                }
                return;
            }
        }) == null) {
            throw new SimctlError("App " + bundleId + " did not start in time");
        }
    }

    private final void copyDirectoryRecursively(Path source, Path target) {
        Files.walk(source, new FileVisitOption[0]).forEach(arg_0 -> LocalSimulatorUtils.copyDirectoryRecursively$lambda$2((Function1)new Function1<Path, Unit>(target, source){
            final /* synthetic */ Path $target;
            final /* synthetic */ Path $source;
            {
                this.$target = $target;
                this.$source = $source;
                super(1);
            }

            public final void invoke(Path path) {
                Path targetPath = this.$target.resolve(((Object)this.$source.relativize(path)).toString());
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                } else {
                    Files.copy(path, targetPath, new CopyOption[0]);
                }
            }
        }, arg_0));
    }

    private final boolean deleteFolderRecursively(File folder) {
        block2: {
            if (!folder.isDirectory()) break block2;
            File[] fileArray = folder.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File child = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    INSTANCE.deleteFolderRecursively(child);
                }
            }
        }
        return folder.delete();
    }

    private final void reinstallApp(String deviceId, String bundleId) {
        Path path = Paths.get(this.getAppBinaryDirectory(deviceId, bundleId), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path pathToBinary = path;
        if (!Files.isDirectory(pathToBinary, new LinkOption[0])) {
            throw new SimctlError("Could not find app binary for bundle " + bundleId + " at " + pathToBinary);
        }
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(...)");
        Path tmpDir = path2;
        Path tmpBundlePath = tmpDir.resolve(bundleId + '-' + System.currentTimeMillis() + ".app");
        logger.info("Copying app binary from " + pathToBinary + " to " + tmpBundlePath);
        Files.copy(pathToBinary, tmpBundlePath, new CopyOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)tmpBundlePath, (String)"tmpBundlePath");
        this.copyDirectoryRecursively(pathToBinary, tmpBundlePath);
        logger.info("Reinstalling and launching " + bundleId);
        this.uninstall(deviceId, bundleId);
        this.install(deviceId, tmpBundlePath);
        File file = tmpBundlePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpBundlePath.toFile()");
        this.deleteFolderRecursively(file);
        logger.info("App " + bundleId + " reinstalled and launched");
    }

    public final void clearAppState(@NotNull String deviceId, @NotNull String bundleId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        logger.info("Clearing app " + bundleId + " state");
        this.terminate(deviceId, bundleId);
        this.ensureStopped(deviceId, bundleId);
        this.reinstallApp(deviceId, bundleId);
    }

    private final String getAppBinaryDirectory(String deviceId, String bundleId) {
        Object[] objectArray = new String[]{"xcrun", "simctl", "get_app_container", deviceId, bundleId};
        Process process = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        objectArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        return ((Object)StringsKt.trimEnd((CharSequence)new String((byte[])objectArray, Charsets.UTF_8))).toString();
    }

    private final String getApplicationDataDirectory(String deviceId, String bundleId) {
        Object[] objectArray = new String[]{"xcrun", "simctl", "get_app_container", deviceId, bundleId, "data"};
        Process process = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        objectArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        return ((Object)StringsKt.trimEnd((CharSequence)new String((byte[])objectArray, Charsets.UTF_8))).toString();
    }

    public final void launch(@NotNull String deviceId, @NotNull String bundleId, @NotNull List<String> launchArguments, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        Intrinsics.checkNotNullParameter(launchArguments, (String)"launchArguments");
        String string = sessionId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Object[] objectArray = new String[]{"xcrun", "simctl", "spawn", deviceId, "launchctl", "setenv", "MAESTRO_SESSION_ID", sessionId};
            CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
        }
        Object[] objectArray = new String[]{"xcrun", "simctl", "launch", deviceId, bundleId};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)launchArguments), false, null, null, 14, null);
    }

    public static /* synthetic */ void launch$default(LocalSimulatorUtils localSimulatorUtils, String string, String string2, List list, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        localSimulatorUtils.launch(string, string2, list, string3);
    }

    public final void setLocation(@NotNull String deviceId, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Object[] objectArray = new String[]{"xcrun", "simctl", "location", deviceId, "set", "" + latitude + ',' + longitude};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    public final void openURL(@NotNull String deviceId, @NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Object[] objectArray = new String[]{"xcrun", "simctl", "openurl", deviceId, url2};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    public final void uninstall(@NotNull String deviceId, @NotNull String bundleId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
        Object[] objectArray = new String[]{"xcrun", "simctl", "uninstall", deviceId, bundleId};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    public final void addMedia(@NotNull String deviceId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = new String[]{"xcrun", "simctl", "addmedia", deviceId, path};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    public final void clearKeychain(@NotNull String deviceId) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Object[] objectArray2 = new String[]{"xcrun", "simctl", "spawn", deviceId, "launchctl", "stop", "com.apple.securityd"};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray2), false, null, null, 14, null);
        String keychainFolder = homedir + "/Library/Developer/CoreSimulator/Devices/" + deviceId + "/data/Library/Keychains";
        if (new File(keychainFolder).exists()) {
            objectArray = new String[]{"rm", "-rf", keychainFolder};
            CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
        } else {
            logger.info("Keychain folder " + keychainFolder + " does not exist, skipping rm");
        }
        objectArray = new String[]{"xcrun", "simctl", "spawn", deviceId, "launchctl", "start", "com.apple.securityd"};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPermissions(@NotNull String deviceId, @NotNull String bundleId, @NotNull Map<String, String> permissions) {
        void $this$mapTo$iv$iv;
        Object[] $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Iterator iterator;
        Object $this$forEach$iv;
        Map permissionsMap;
        block19: {
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Intrinsics.checkNotNullParameter((Object)bundleId, (String)"bundleId");
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            permissionsMap = MapsKt.toMutableMap(permissions);
            if (!permissionsMap.containsKey("all")) break block19;
            String value = (String)permissionsMap.remove("all");
            $this$forEach$iv = allPermissions;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                String it2 = (String)element$iv;
                boolean bl = false;
                String string = value;
                if (string == null) throw new IllegalArgumentException("Permission 'all' can be set to 'allow', 'deny' or 'unset', not '" + value + '\'');
                int n = -1;
                switch (string.hashCode()) {
                    case 92906313: {
                        if (string.equals("allow")) {
                            n = 1;
                        }
                        break;
                    }
                    case 3079692: {
                        if (string.equals("deny")) {
                            n = 2;
                        }
                        break;
                    }
                    case 111442729: {
                        if (string.equals("unset")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        permissionsMap.putIfAbsent(it2, INSTANCE.allowValueForPermission(it2));
                        break;
                    }
                    case 2: {
                        permissionsMap.putIfAbsent(it2, INSTANCE.denyValueForPermission(it2));
                        break;
                    }
                    case 3: {
                        permissionsMap.putIfAbsent(it2, "unset");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Permission 'all' can be set to 'allow', 'deny' or 'unset', not '" + value + '\'');
                    }
                }
            }
        }
        $this$forEach$iv = permissionsMap;
        boolean $i$f$filter = false;
        iterator = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!allPermissions.contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((String)it.getKey() + '=' + INSTANCE.translatePermissionValue((String)it.getValue()));
        }
        String permissionsArgument = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        if (((CharSequence)permissionsArgument).length() > 0) {
            try {
                $this$map$iv = new String[]{homedir + "/.maestro/deps/applesimutils", "--byId", deviceId, "--bundle", bundleId, "--setPermissions", permissionsArgument};
                CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])$this$map$iv), false, null, null, 14, null);
            }
            catch (Exception e) {
                Object[] objectArray = new String[]{"applesimutils", "--byId", deviceId, "--bundle", bundleId, "--setPermissions", permissionsArgument};
                CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
            }
        }
        this.setSimctlPermissions(deviceId, bundleId, permissions);
    }

    /*
     * WARNING - void declaration
     */
    private final void setSimctlPermissions(String deviceId, String bundleId, Map<String, String> permissions) {
        void $this$forEach$iv;
        Map permissionsMap;
        block15: {
            permissionsMap = MapsKt.toMutableMap(permissions);
            String string = (String)permissionsMap.remove("all");
            if (string == null) break block15;
            String value = string;
            boolean bl = false;
            Iterable $this$associateWith$iv = simctlPermissions;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String newValue;
                String string2;
                String string3 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl2 = false;
                switch (value) {
                    case "allow": {
                        void permission;
                        string2 = INSTANCE.allowValueForPermission((String)permission);
                        break;
                    }
                    case "deny": {
                        void permission;
                        string2 = INSTANCE.denyValueForPermission((String)permission);
                        break;
                    }
                    case "unset": {
                        string2 = "unset";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Permission 'all' can be set to 'allow', 'deny', or 'unset', not '" + value + '\'');
                    }
                }
                String string4 = newValue = string2;
                map.put(t, string4);
            }
            Map transformedPermissions = result$iv;
            permissionsMap.putAll(transformedPermissions);
        }
        Map map = permissionsMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (!simctlPermissions.contains(it.getKey()) || !Intrinsics.areEqual((Object)((String)it.getKey()), (Object)"location")) continue;
            INSTANCE.setLocationPermission(deviceId, bundleId, (String)it.getValue());
        }
    }

    private final void setLocationPermission(String deviceId, String bundleId, String value) {
        switch (value) {
            case "always": {
                Object[] objectArray = new String[]{"xcrun", "simctl", "privacy", deviceId, "grant", "location-always", bundleId};
                CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
                break;
            }
            case "inuse": {
                Object[] objectArray = new String[]{"xcrun", "simctl", "privacy", deviceId, "grant", "location", bundleId};
                CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
                break;
            }
            case "never": {
                Object[] objectArray = new String[]{"xcrun", "simctl", "privacy", deviceId, "revoke", "location-always", bundleId};
                CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
                break;
            }
            case "unset": {
                Object[] objectArray = new String[]{"xcrun", "simctl", "privacy", deviceId, "reset", "location-always", bundleId};
                CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong argument value '" + value + "' was provided for 'location' permission");
            }
        }
    }

    private final String translatePermissionValue(String value) {
        String string = value;
        return Intrinsics.areEqual((Object)string, (Object)"allow") ? "YES" : (Intrinsics.areEqual((Object)string, (Object)"deny") ? "NO" : value);
    }

    private final String allowValueForPermission(String permission) {
        return Intrinsics.areEqual((Object)permission, (Object)"location") ? "always" : "YES";
    }

    private final String denyValueForPermission(String permission) {
        return Intrinsics.areEqual((Object)permission, (Object)"location") ? "never" : "NO";
    }

    public final void install(@NotNull String deviceId, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = new String[]{"xcrun", "simctl", "install", deviceId, ((Object)path.toAbsolutePath()).toString()};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    public final void install(@NotNull String deviceId, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path temp = path;
        File extractDir = temp.toFile();
        ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.ZIP).extract(stream, extractDir);
        Intrinsics.checkNotNullExpressionValue((Object)extractDir, (String)"extractDir");
        File app2 = (File)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)extractDir, null, (int)1, null)), (Function1)install.app.1.INSTANCE));
        Object[] objectArray = new String[]{"xcrun", "simctl", "install", deviceId, app2.getAbsolutePath()};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    @NotNull
    public final ScreenRecording startScreenRecording(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path tempDir = path;
        InputStream inputStream = LocalSimulatorUtils.class.getResourceAsStream("/screenrecord.sh");
        if (inputStream != null) {
            File recording = new File(tempDir.toFile(), "screenrecording.mov");
            Object[] objectArray = new String[3];
            objectArray[0] = "bash";
            objectArray[1] = "-c";
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            objectArray[2] = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            ProcessBuilder processBuilder = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray));
            Map<String, String> environment = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(environment, (String)"environment");
            environment.put("DEVICE_ID", deviceId);
            environment.put("RECORDING_PATH", recording.getPath());
            Process recordingProcess = processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE).start();
            Intrinsics.checkNotNullExpressionValue((Object)recordingProcess, (String)"recordingProcess");
            return new ScreenRecording(recordingProcess, recording);
        }
        throw new IllegalStateException("screenrecord.sh file not found");
    }

    public final void setDeviceLanguage(@NotNull String deviceId, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object[] objectArray = new String[]{"xcrun", "simctl", "spawn", deviceId, "defaults", "write", ".GlobalPreferences.plist", "AppleLanguages", '(' + language + ')'};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    public final void setDeviceLocale(@NotNull String deviceId, @NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Object[] objectArray = new String[]{"xcrun", "simctl", "spawn", deviceId, "defaults", "write", ".GlobalPreferences.plist", "AppleLocale", "-string", locale};
        CommandLineUtils.runCommand$default(CommandLineUtils.INSTANCE, CollectionsKt.listOf((Object[])objectArray), false, null, null, 14, null);
    }

    @NotNull
    public final File stopScreenRecording(@NotNull ScreenRecording screenRecording) {
        Intrinsics.checkNotNullParameter((Object)screenRecording, (String)"screenRecording");
        screenRecording.getProcess().getOutputStream().close();
        screenRecording.getProcess().waitFor();
        return screenRecording.getFile();
    }

    private static final void copyDirectoryRecursively$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isAppRunning(LocalSimulatorUtils $this, String deviceId, String bundleId) {
        return $this.isAppRunning(deviceId, bundleId);
    }

    static {
        Object[] objectArray = new String[]{"calendar", "camera", "contacts", "faceid", "homekit", "medialibrary", "microphone", "motion", "photos", "reminders", "siri", "speech", "userTracking"};
        allPermissions = CollectionsKt.listOf((Object[])objectArray);
        simctlPermissions = CollectionsKt.listOf((Object)"location");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lutil/LocalSimulatorUtils$ScreenRecording;", "", "process", "Ljava/lang/Process;", "file", "Ljava/io/File;", "(Ljava/lang/Process;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getProcess", "()Ljava/lang/Process;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "maestro-ios-driver"})
    public static final class ScreenRecording {
        @NotNull
        private final Process process;
        @NotNull
        private final File file;

        public ScreenRecording(@NotNull Process process, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.process = process;
            this.file = file;
        }

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final Process component1() {
            return this.process;
        }

        @NotNull
        public final File component2() {
            return this.file;
        }

        @NotNull
        public final ScreenRecording copy(@NotNull Process process, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new ScreenRecording(process, file);
        }

        public static /* synthetic */ ScreenRecording copy$default(ScreenRecording screenRecording, Process process, File file, int n, Object object) {
            if ((n & 1) != 0) {
                process = screenRecording.process;
            }
            if ((n & 2) != 0) {
                file = screenRecording.file;
            }
            return screenRecording.copy(process, file);
        }

        @NotNull
        public String toString() {
            return "ScreenRecording(process=" + this.process + ", file=" + this.file + ')';
        }

        public int hashCode() {
            int result2 = this.process.hashCode();
            result2 = result2 * 31 + this.file.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScreenRecording)) {
                return false;
            }
            ScreenRecording screenRecording = (ScreenRecording)other;
            if (!Intrinsics.areEqual((Object)this.process, (Object)screenRecording.process)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)screenRecording.file);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lutil/LocalSimulatorUtils$SimctlError;", "", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "maestro-ios-driver"})
    public static final class SimctlError
    extends Throwable {
        @NotNull
        private final String message;

        public SimctlError(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
            this.message = message;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final SimctlError copy(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new SimctlError(message);
        }

        public static /* synthetic */ SimctlError copy$default(SimctlError simctlError, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = simctlError.message;
            }
            return simctlError.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "SimctlError(message=" + this.message + ')';
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimctlError)) {
                return false;
            }
            SimctlError simctlError = (SimctlError)other;
            return Intrinsics.areEqual((Object)this.message, (Object)simctlError.message);
        }
    }
}

